/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.ms;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.base.ms.MsPohopMapper;
import cn.smarthse.modules.health.entity.base.ms.MsPohop;
import cn.smarthse.modules.health.entity.base.ms.MsPohopUploadFile;
import cn.smarthse.modules.health.enums.sys.RemindWorkTypeEnum;
import cn.smarthse.modules.health.service.base.ms.IMsPohopService;
import cn.smarthse.modules.health.service.base.ms.IMsPohopUploadFileService;
import cn.smarthse.modules.health.service.base.ms.INoticeUpdateReminderService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class MsPohopServiceImpl
extends BaseServiceImpl<MsPohopMapper, MsPohop>
implements IMsPohopService {
    @Autowired
    IMsPohopUploadFileService msPohopUploadFileServiceImpl;
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    MsPohopMapper msPohopMapper;
    @Autowired
    INoticeUpdateReminderService noticeUpdateReminderService;

    public PageInfo<MsPohop> getMsPohopListByGridParam(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<MsPohop> list = this.msPohopMapper.selectMsPohopListByCid(gparam.getCid());
        return new PageInfo(list);
    }

    public List<MsPohop> getMsPohopList(Long cid) {
        List<MsPohop> list = this.msPohopMapper.selectMsPohopListByCid(cid);
        return list;
    }

    @Transactional(readOnly=false)
    public void addMsPohop(Long cid, Long staffid, MsPohop msPohop) {
        if ((msPohop = this.add(msPohop, staffid, cid)).getFileIds() != null && msPohop.getFileIds().length > 0) {
            for (Long fileId : msPohop.getFileIds()) {
                MsPohopUploadFile msPohopUploadFile = new MsPohopUploadFile();
                msPohopUploadFile.setPohopId(msPohop.getId());
                msPohopUploadFile.setFileId(fileId);
                this.msPohopUploadFileServiceImpl.add((Object)msPohopUploadFile, staffid, cid);
            }
        }
        this.noticeUpdateReminderService.addReminder(msPohop.getId(), RemindWorkTypeEnum.CZGC.getValue(), cid, staffid);
    }

    @Transactional(readOnly=false)
    public void updateMsPohop(Long cid, Long staffid, MsPohop msPohop) {
        this.update(msPohop, staffid);
        this.msPohopUploadFileServiceImpl.editFile(msPohop, cid, staffid);
        this.noticeUpdateReminderService.addReminder(msPohop.getId(), RemindWorkTypeEnum.CZGC.getValue(), cid, staffid);
    }

    public List<MsPohop> getMsPohopListByCid(Long cid, Integer year) {
        return null;
    }

    @Transactional(readOnly=false)
    public void delWithHis(MsPohop msPohop, Long staffid, Long cid) {
        this.update(msPohop, staffid);
    }

    public List<MsPohop> getMsInfoHasFileList(Long cid) {
        Example example = new Example(MsPohop.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)cid);
        List<MsPohop> list = this.getListByExample(example);
        for (MsPohop mp : list) {
            mp.setFiles(this.msPohopUploadFileServiceImpl.getByPohopId(mp.getId()));
        }
        return list;
    }

    public PageInfo<MsPohop> getMsPohopListByGridParamAndKeyWord(JqGridParam param, String keyword) {
        if (param == null || param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<MsPohop> list = this.msPohopMapper.selectMsPohopListByCidAndKeyWord(param.getCid(), keyword);
        return new PageInfo(list);
    }

    public List<MsPohop> getLiteArchiveData(MsPohop param) {
        List<MsPohop> liteArchiveData = ((MsPohopMapper)this.dao).getLiteArchiveData(param);
        return liteArchiveData;
    }
}

