/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.ms;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.ms.MsOtherMapper;
import cn.smarthse.modules.health.entity.base.ms.MsOther;
import cn.smarthse.modules.health.enums.sys.RemindWorkTypeEnum;
import cn.smarthse.modules.health.service.base.ms.IMsOtherService;
import cn.smarthse.modules.health.service.base.ms.INoticeUpdateReminderService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class MsOtherServiceImpl
extends BaseServiceImpl<MsOtherMapper, MsOther>
implements IMsOtherService {
    @Autowired
    MsOtherMapper msOtherMapper;
    @Autowired
    INoticeUpdateReminderService noticeUpdateReminderService;

    public PageInfo<MsOther> getMsOtherListByGridParam(JqGridParam param) {
        if (param == null || param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        MsOther example = new MsOther();
        example.setCid(param.getCid());
        example.setIsValid(Boolean.valueOf(true));
        List list = this.msOtherMapper.select(example);
        return new PageInfo(list);
    }

    public List<MsOther> getMsOtherListByCid(Long cid) {
        MsOther example = new MsOther();
        example.setCid(cid);
        example.setIsValid(Boolean.valueOf(true));
        List list = this.msOtherMapper.select(example);
        return list;
    }

    @Transactional(readOnly=false)
    public void deleteWithHis(MsOther info, Long staffid, Long cid) {
        info.setIsValid(Boolean.valueOf(false));
        this.update(info, staffid);
    }

    @Transactional(readOnly=false)
    public MsOther addWithHis(MsOther info, Long staffid, Long cid) {
        info = this.add(info, staffid, cid);
        this.noticeUpdateReminderService.addReminder(info.getId(), RemindWorkTypeEnum.OTHER.getValue(), cid, staffid);
        return info;
    }

    @Transactional(readOnly=false)
    public void updateWithHis(MsOther info, Long staffid, Long cid) {
        this.update(info, staffid);
        this.noticeUpdateReminderService.addReminder(info.getId(), RemindWorkTypeEnum.OTHER.getValue(), cid, staffid);
    }

    public PageInfo<MsOther> getMsOtherListByGridParamAndKeyWord(JqGridParam param, String keyword) {
        if (param == null || param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Example example = new Example(MsOther.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cid", (Object)param.getCid()).andLike("infoName", "%" + keyword + "%");
        List list = this.getListByExample(example);
        return new PageInfo(list);
    }
}

