/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.ms;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.base.ms.MsInfoUploadFileMapper;
import cn.smarthse.modules.health.entity.base.ms.MsInfo;
import cn.smarthse.modules.health.entity.base.ms.MsInfoUploadFile;
import cn.smarthse.modules.health.enums.sys.RemindWorkTypeEnum;
import cn.smarthse.modules.health.service.base.ms.IMsInfoUploadFileService;
import cn.smarthse.modules.health.service.base.ms.INoticeUpdateReminderService;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class MsInfoUploadFileServiceImpl
extends BaseServiceImpl<MsInfoUploadFileMapper, MsInfoUploadFile>
implements IMsInfoUploadFileService {
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    MsInfoUploadFileMapper msInfoUploadFileMapper;
    @Autowired
    INoticeUpdateReminderService noticeUpdateReminderService;

    public List<MsInfo> setMsInfoUploadFileIdAndName(List<MsInfo> list, Long cid) {
        for (MsInfo msInfo : list) {
            ArrayList<Long> fileIdList = new ArrayList<Long>();
            ArrayList<String> fileNameList = new ArrayList<String>();
            Example example = new Example(MsInfoUploadFile.class);
            Example.Criteria c = example.createCriteria();
            c.andEqualTo("cid", (Object)cid).andEqualTo("infoId", (Object)msInfo.getId()).andEqualTo("isValid", (Object)Global.TRUE);
            example.setOrderByClause("id asc");
            List fileList = this.getListByExample(example);
            for (MsInfoUploadFile msInfoUploadFile : fileList) {
                SysFileModel sysFile;
                if (msInfoUploadFile.getFileId() != null && (sysFile = this.sysFileServiceImpl.getFileById(msInfoUploadFile.getFileId())) != null) {
                    fileIdList.add(msInfoUploadFile.getFileId());
                    fileNameList.add(sysFile.getFileName());
                }
                msInfo.setUpdateBy(msInfoUploadFile.getUpdateBy());
                msInfo.setUpdateDate(msInfoUploadFile.getUpdateDate());
            }
            msInfo.setFileIds(fileIdList);
            msInfo.setFileNames(fileNameList);
        }
        return list;
    }

    public List<MsInfoUploadFile> getByInfoIdAndFileId(Long cid, Long id, Long fileId) {
        Example example = new Example(MsInfoUploadFile.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("infoId", (Object)id).andEqualTo("fileId", (Object)fileId).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<MsInfoUploadFile> list = this.getListByExample(example);
        return list;
    }

    public boolean getExistsByInfoIdAndFileId(Long cid, Long id, Long fileId) {
        boolean isFile = this.msInfoUploadFileMapper.selectExists(cid, id, fileId);
        return isFile;
    }

    @Transactional(readOnly=false)
    public void addFile(Long id, Long[] fileId2, Long cid, Long staffid) {
        for (int i = 0; i < fileId2.length; ++i) {
            boolean isFile = this.getExistsByInfoIdAndFileId(cid, id, fileId2[i]);
            if (isFile) continue;
            MsInfoUploadFile msInfoUploadFile = new MsInfoUploadFile();
            msInfoUploadFile.setInfoId(id);
            msInfoUploadFile.setFileId(fileId2[i]);
            this.add(msInfoUploadFile, staffid, cid);
        }
        this.noticeUpdateReminderService.addReminder(id, RemindWorkTypeEnum.GZZD.getValue(), cid, staffid);
    }

    public List<MsInfo> setMsInfoUploadFileIdAndName(List<MsInfo> list, Long cid, Integer year) {
        for (MsInfo msInfo : list) {
            ArrayList<Long> fileIdList = new ArrayList<Long>();
            ArrayList<String> fileNameList = new ArrayList<String>();
            Example example = new Example(MsInfoUploadFile.class);
            Example.Criteria c = example.createCriteria();
            if (year < 2014) {
                c.andEqualTo("cid", (Object)cid).andEqualTo("infoId", (Object)msInfo.getId()).andEqualTo("isValid", (Object)Global.TRUE).andLessThan("createDate", (Object)"2014-01-01");
            } else {
                String date1 = year.toString() + "-01-01";
                String date2 = year.toString() + "-12-31";
                c.andEqualTo("cid", (Object)cid).andEqualTo("infoId", (Object)msInfo.getId()).andEqualTo("isValid", (Object)Global.TRUE).andBetween("createDate", (Object)date1, (Object)date2);
            }
            example.setOrderByClause("id asc");
            List fileList = this.getListByExample(example);
            for (MsInfoUploadFile msInfoUploadFile : fileList) {
                if (msInfoUploadFile.getFileId() != null) {
                    fileIdList.add(msInfoUploadFile.getFileId());
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(msInfoUploadFile.getFileId());
                    fileNameList.add(sysFile.getFileName());
                }
                msInfo.setUpdateBy(msInfoUploadFile.getUpdateBy());
                msInfo.setUpdateDate(msInfoUploadFile.getUpdateDate());
            }
            msInfo.setFileIds(fileIdList);
            msInfo.setFileNames(fileNameList);
        }
        return list;
    }

    public List<MsInfoUploadFile> getByInfoId(Long cid, Long id) {
        Example example = new Example(MsInfoUploadFile.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("infoId", (Object)id).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<MsInfoUploadFile> list = this.getListByExample(example);
        return list;
    }
}

