/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.ms;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.compliance.entity.ComplianceCompanyItemdata;
import cn.smarthse.modules.health.dao.base.ms.MsInfoMapper;
import cn.smarthse.modules.health.entity.base.ms.MsInfo;
import cn.smarthse.modules.health.service.base.ms.IMsInfoService;
import cn.smarthse.modules.health.service.base.ms.IMsInfoUploadFileService;
import cn.smarthse.modules.health.vo.base.historyBasic.BasicEntityContentSearch;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class MsInfoServiceImpl
extends BaseServiceImpl<MsInfoMapper, MsInfo>
implements IMsInfoService {
    @Autowired
    IMsInfoUploadFileService iMsInfoUploadFileServiceImpl;
    @Autowired
    MsInfoMapper msInfoMapper;
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    RedisClient redisClient;

    public PageInfo<MsInfo> getMsInfoListByGridParam(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        Example example = new Example(MsInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List list = this.getListByExample(example);
        if (gparam.getCid() != null) {
            list = this.iMsInfoUploadFileServiceImpl.setMsInfoUploadFileIdAndName(list, gparam.getCid());
        }
        return new PageInfo(list);
    }

    public List<MsInfo> getMsInfoList(Long cid) {
        Example example = new Example(MsInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List list = this.getListByExample(example);
        if (cid != null) {
            list = this.iMsInfoUploadFileServiceImpl.setMsInfoUploadFileIdAndName(list, cid);
        }
        return list;
    }

    public List<MsInfo> getMsInfoListByCid(Long cid, Integer year) {
        Example example = new Example(MsInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<MsInfo> list = this.getListByExample(example);
        for (MsInfo msInfo : list) {
            ArrayList<BasicEntityContentSearch> searchList = new ArrayList<BasicEntityContentSearch>();
            BasicEntityContentSearch ser = new BasicEntityContentSearch();
            ser.setKey("infoId");
            ser.setValue((Object)msInfo.getId());
            searchList.add(ser);
            ArrayList fileIdList = new ArrayList();
            ArrayList fileNameList = new ArrayList();
            msInfo.setFileIds(fileIdList);
            msInfo.setFileNames(fileNameList);
        }
        return list;
    }

    public List<MsInfo> getMsInfoArchiveListByCid(Long cid, Integer year) {
        Example example = new Example(MsInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<MsInfo> list = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MsInfo msInfo = (MsInfo)iterator.next();
                ArrayList<BasicEntityContentSearch> searchList = new ArrayList<BasicEntityContentSearch>();
                BasicEntityContentSearch ser = new BasicEntityContentSearch();
                ser.setKey("infoId");
                ser.setValue((Object)msInfo.getId());
                searchList.add(ser);
                ArrayList fileIdList = new ArrayList();
                ArrayList fileNameList = new ArrayList();
                if (CollectionUtils.isEmpty(fileIdList)) {
                    iterator.remove();
                    continue;
                }
                List sysFileModelList = this.sysFileServiceImpl.getListByIds(fileIdList);
                msInfo.setFileIds(fileIdList);
                if (!CollectionUtils.isNotEmpty((Collection)sysFileModelList)) continue;
                List stringList = sysFileModelList.stream().map(SysFileModel::getFileName).collect(Collectors.toList());
                msInfo.setFileNames(stringList);
            }
        }
        return list;
    }

    public int getMsInfoCountHasFile(Long cid) {
        int num = 0;
        Example example = new Example(MsInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List list = this.getListByExample(example);
        for (MsInfo info : list) {
            List fileList = this.iMsInfoUploadFileServiceImpl.getByInfoId(cid, info.getId());
            if (fileList == null || fileList.size() <= 0) continue;
            ++num;
        }
        return num;
    }

    public PageInfo<MsInfo> getMsInfoListByGridParamAndKeyWord(JqGridParam param, String keyword) {
        if (param == null || param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Example example = new Example(MsInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andLike("infoName", "%" + keyword + "%");
        example.setOrderByClause("id asc");
        List list = this.getListByExample(example);
        if (param.getCid() != null) {
            list = this.iMsInfoUploadFileServiceImpl.setMsInfoUploadFileIdAndName(list, param.getCid());
        }
        return new PageInfo(list);
    }

    public List<MsInfo> getLiteArhiveData(MsInfo msinfo) {
        return ((MsInfoMapper)this.dao).getLiteArhiveData(msinfo);
    }

    public List<MsInfo> getUploadCount(List<Long> cidList) {
        return ((MsInfoMapper)this.dao).getUploadCount(cidList);
    }

    public List<ComplianceCompanyItemdata> getInstitutionInfo(Long cid, Map<String, Object> param) {
        ArrayList<ComplianceCompanyItemdata> list = new ArrayList<ComplianceCompanyItemdata>();
        if (cid == null) {
            return list;
        }
        List msInfos = (List)this.redisClient.get("IMsInfoService", "getMsInfo", 259200L, () -> {
            Example example = new Example(MsInfo.class);
            example.setOrderByClause("id asc");
            return this.getListByExample(example);
        });
        Set collect = ((MsInfoMapper)this.dao).getUploadInfoId(Collections.singletonList(cid)).stream().filter(Objects::nonNull).map(MsInfo::getInfoName).collect(Collectors.toSet());
        for (MsInfo msInfo : msInfos) {
            if (collect.contains(msInfo.getInfoName())) {
                list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName(msInfo.getInfoName()).setResultData("\u6709\u6570\u636e"));
                continue;
            }
            list.add(new ComplianceCompanyItemdata().setCid(cid).setFieldName(msInfo.getInfoName()).setResultData("\u65e0\u6570\u636e"));
        }
        return list;
    }
}

