/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.ms;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.base.ms.MsEmergencyUploadFileMapper;
import cn.smarthse.modules.health.entity.base.ms.MsEmergencyPlan;
import cn.smarthse.modules.health.entity.base.ms.MsEmergencyUploadFile;
import cn.smarthse.modules.health.service.base.ms.IMsEmergencyUploadFileService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class MsEmergencyUploadFileServiceImpl
extends BaseServiceImpl<MsEmergencyUploadFileMapper, MsEmergencyUploadFile>
implements IMsEmergencyUploadFileService {
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    MsEmergencyUploadFileMapper msEmergencyUploadFileMapper;

    public List<MsEmergencyUploadFile> getByEmergencyId(Long id) {
        Example example = new Example(MsEmergencyUploadFile.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("emergencyId", (Object)id).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<MsEmergencyUploadFile> list = this.getListByExample(example);
        return list;
    }

    public List<MsEmergencyPlan> setMsEmergencyUploadFileIdAndName(List<MsEmergencyPlan> list, Long cid) {
        for (MsEmergencyPlan msEmergencyPlan : list) {
            SysFileModel sysFile;
            if (msEmergencyPlan.getFileId() == null || (sysFile = this.sysFileServiceImpl.getFileById(msEmergencyPlan.getFileId())) == null) continue;
            msEmergencyPlan.setFileId(sysFile.getId());
            msEmergencyPlan.setFileName(sysFile.getFileName());
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void editFile(MsEmergencyPlan msEmergencyPlan, Long cid, Long staffid) {
        List<MsEmergencyUploadFile> list = this.getByEmergencyId(msEmergencyPlan.getId());
        for (MsEmergencyUploadFile msEmergencyUploadFile : list) {
            msEmergencyUploadFile.setIsValid(Boolean.valueOf(false));
            this.update(msEmergencyUploadFile, staffid);
        }
        if (msEmergencyPlan.getFileIds() != null && msEmergencyPlan.getFileIds().length > 0) {
            for (Long fileId : msEmergencyPlan.getFileIds()) {
                MsEmergencyUploadFile msEmergencyUploadFile = new MsEmergencyUploadFile();
                msEmergencyUploadFile.setEmergencyId(msEmergencyPlan.getId());
                msEmergencyUploadFile.setFileId(fileId);
                this.add(msEmergencyUploadFile, staffid, cid);
            }
        }
    }
}

