/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.ms;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.base.ms.MsEmergencyPlanMapper;
import cn.smarthse.modules.health.entity.base.ms.MsEmergencyPlan;
import cn.smarthse.modules.health.entity.base.ms.MsEmergencyUploadFile;
import cn.smarthse.modules.health.enums.msemergencyplan.MsEmergencyPlanTypeEnum;
import cn.smarthse.modules.health.enums.sys.RemindWorkTypeEnum;
import cn.smarthse.modules.health.service.base.ms.IMsEmergencyPlanService;
import cn.smarthse.modules.health.service.base.ms.IMsEmergencyUploadFileService;
import cn.smarthse.modules.health.service.base.ms.INoticeUpdateReminderService;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class MsEmergencyPlanServiceImpl
extends BaseServiceImpl<MsEmergencyPlanMapper, MsEmergencyPlan>
implements IMsEmergencyPlanService {
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    IMsEmergencyUploadFileService msEmergencyUploadFileServiceImpl;
    @Autowired
    INoticeUpdateReminderService noticeUpdateReminderService;
    @Autowired
    MsEmergencyPlanMapper msEmergencyPlanMapper;

    public PageInfo<MsEmergencyPlan> getMsEmergencyPlanListByGridParam(JqGridParam gparam) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<MsEmergencyPlan> list = this.msEmergencyPlanMapper.selectMsEmergencyPlanListByCid(gparam.getCid());
        for (MsEmergencyPlan msEmergencyPlan : list) {
            String[] emergencyTypes;
            Object typeName = "";
            for (String emergencyType : emergencyTypes = msEmergencyPlan.getEmergencyType().split(",")) {
                typeName = (String)typeName + MsEmergencyPlanTypeEnum.getName((Integer)Integer.valueOf(emergencyType)) + ",";
            }
            typeName = ((String)typeName).substring(0, ((String)typeName).length() - 1);
            msEmergencyPlan.setTypeName((String)typeName);
        }
        return new PageInfo(list);
    }

    public List<MsEmergencyPlan> getMsEmergencyPlanList(Long cid) {
        List list = this.msEmergencyPlanMapper.selectMsEmergencyPlanListByCid(cid);
        list = this.msEmergencyUploadFileServiceImpl.setMsEmergencyUploadFileIdAndName(list, cid);
        for (MsEmergencyPlan msEmergencyPlan : list) {
            String[] emergencyTypes;
            Object typeName = "";
            for (String emergencyType : emergencyTypes = msEmergencyPlan.getEmergencyType().split(",")) {
                typeName = (String)typeName + MsEmergencyPlanTypeEnum.getName((Integer)Integer.valueOf(emergencyType)) + ",";
            }
            typeName = ((String)typeName).substring(0, ((String)typeName).length() - 1);
            msEmergencyPlan.setTypeName((String)typeName);
        }
        return list;
    }

    public List<MsEmergencyPlan> listMsEmergencyPlanList(Long cid) {
        List<MsEmergencyPlan> list = this.msEmergencyPlanMapper.selectMsEmergencyPlanListByCid(cid);
        return list;
    }

    public List<MsEmergencyPlan> listMsEmergencyPlanLists(List<Long> cids) {
        List<MsEmergencyPlan> list = this.msEmergencyPlanMapper.selectMsEmergencyPlanListByCids(cids);
        return list;
    }

    @Transactional(readOnly=false)
    public void addMsEmergencyPlan(Long cid, Long staffid, MsEmergencyPlan msEmergencyPlan) {
        if ((msEmergencyPlan = this.add(msEmergencyPlan, staffid, cid)).getFileIds() != null && msEmergencyPlan.getFileIds().length > 0) {
            for (Long fileId : msEmergencyPlan.getFileIds()) {
                MsEmergencyUploadFile msEmergencyUploadFile = new MsEmergencyUploadFile();
                msEmergencyUploadFile.setEmergencyId(msEmergencyPlan.getId());
                msEmergencyUploadFile.setFileId(fileId);
                this.msEmergencyUploadFileServiceImpl.add((Object)msEmergencyUploadFile, staffid, cid);
            }
        }
        this.noticeUpdateReminderService.addReminder(msEmergencyPlan.getId(), RemindWorkTypeEnum.YJYA.getValue(), cid, staffid);
    }

    @Transactional(readOnly=false)
    public void updateMsEmergencyPlan(Long cid, Long staffid, MsEmergencyPlan msEmergencyPlan) {
        this.update(msEmergencyPlan, staffid);
        this.msEmergencyUploadFileServiceImpl.editFile(msEmergencyPlan, cid, staffid);
        this.noticeUpdateReminderService.addReminder(msEmergencyPlan.getId(), RemindWorkTypeEnum.YJYA.getValue(), cid, staffid);
    }

    public List<MsEmergencyPlan> getMsEmergencyPlanListByCid(Long cid, Integer year) {
        List<MsEmergencyPlan> list = ((MsEmergencyPlanMapper)this.dao).selectMsEmergencyPlanListByCidAndUpdataYear(cid, year);
        for (MsEmergencyPlan msEmergencyPlan : list) {
            String[] emergencyTypes;
            List msEmergencyUploadFiles = this.msEmergencyUploadFileServiceImpl.getByEmergencyId(msEmergencyPlan.getId());
            if (CollectionUtils.isNotEmpty((Collection)msEmergencyUploadFiles)) {
                Set fileIdSet = msEmergencyUploadFiles.stream().map(MsEmergencyUploadFile::getFileId).collect(Collectors.toSet());
                String fileIdStr = StringUtils.join(fileIdSet, (String)",");
                msEmergencyPlan.setFileIdsStr(fileIdStr);
            }
            Object typeName = "";
            for (String emergencyType : emergencyTypes = msEmergencyPlan.getEmergencyType().split(",")) {
                typeName = (String)typeName + MsEmergencyPlanTypeEnum.getName((Integer)Integer.valueOf(emergencyType)) + ",";
            }
            typeName = ((String)typeName).substring(0, ((String)typeName).length() - 1);
            msEmergencyPlan.setTypeName((String)typeName);
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void deleWithHis(MsEmergencyPlan msEmergencyPlan, Long staffid, Long cid) {
        this.update(msEmergencyPlan, staffid);
    }

    public PageInfo<MsEmergencyPlan> getMsEmergencyPlanListByGridParamAndKeyWord(JqGridParam param, String keyword) {
        if (param == null || param.getCid() == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<MsEmergencyPlan> list = this.msEmergencyPlanMapper.selectMsEmergencyPlanListByCidAndKeyWord(param.getCid(), keyword);
        for (MsEmergencyPlan msEmergencyPlan : list) {
            String[] emergencyTypes;
            Object typeName = "";
            for (String emergencyType : emergencyTypes = msEmergencyPlan.getEmergencyType().split(",")) {
                typeName = (String)typeName + MsEmergencyPlanTypeEnum.getName((Integer)Integer.valueOf(emergencyType)) + ",";
            }
            typeName = ((String)typeName).substring(0, ((String)typeName).length() - 1);
            msEmergencyPlan.setTypeName((String)typeName);
        }
        return new PageInfo(list);
    }
}

