/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.material;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.material.PmcMaterialWorkroleMapper;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialWorkrole;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialWorkroleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class PmcMaterialWorkroleServiceImpl
extends BaseServiceImpl<PmcMaterialWorkroleMapper, PmcMaterialWorkrole>
implements IPmcMaterialWorkroleService {
    @Autowired
    PmcMaterialWorkroleMapper pmcMaterialWorkroleMapper;
    @Autowired
    IWorkRoleInfoService workRoleService;

    @Transactional(readOnly=false)
    public void adds(String[] userworkids, Long cid, Long staffId, Long usageId) {
        if (userworkids != null) {
            PmcMaterialWorkrole workrole = new PmcMaterialWorkrole();
            workrole.setMaterialUsageId(usageId);
            int length = userworkids.length;
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    workrole.setWorkroleId(Long.valueOf(userworkids[i]));
                    this.add(workrole, staffId, cid);
                    workrole.setId(null);
                }
            }
        }
    }

    public List<PmcMaterialWorkrole> getListByUsageId(Long usageId) {
        if (null == usageId) {
            return null;
        }
        return this.pmcMaterialWorkroleMapper.selectListByUsageId(usageId);
    }

    public String getUseWorkNames(Long materialId) {
        List<Long> useWorkIds = ((PmcMaterialWorkroleMapper)this.dao).getUseWorkIdsByMatterId(materialId);
        String result = this.getWorkNamesByWorkIds(useWorkIds);
        return result;
    }

    private String getWorkNamesByWorkIds(List<Long> useWorkIds) {
        if (useWorkIds == null) {
            return null;
        }
        Object result = "";
        for (Long workId : useWorkIds) {
            String workName = this.workRoleService.getWorkNameIncludeOrgName(workId);
            if (StringUtils.isEmpty((CharSequence)workName)) continue;
            result = (String)result + workName + ",";
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }

    public String getUseWorkNamesByUseId(Long useId) {
        List<Long> useWorkIds = ((PmcMaterialWorkroleMapper)this.dao).getUseWorkIdsByUseId(useId);
        String result = this.getWorkNamesByWorkIds(useWorkIds);
        return result;
    }
}

