/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.material;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.material.PmcMaterialUseInfoMapper;
import cn.smarthse.modules.health.entity.base.material.PmcCompanyMaterial;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialUseInfo;
import cn.smarthse.modules.health.enums.material.ProductTypeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.material.IPmcCompanyMaterialService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialUseInfoAreaService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialUseInfoService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialWorkroleService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class PmcMaterialUseInfoServiceImpl
extends BaseServiceImpl<PmcMaterialUseInfoMapper, PmcMaterialUseInfo>
implements IPmcMaterialUseInfoService {
    @Autowired
    PmcMaterialUseInfoMapper pmcMaterialUseInfoMapper;
    @Autowired
    IPmcCompanyMaterialService materialService;
    @Autowired
    IPmcMaterialUseInfoAreaService userInfoAreaService;
    @Autowired
    ICompanyOrganizationService orgService;
    @Autowired
    private IPmcMaterialWorkroleService pmcMaterialWorkroleService;

    public BigDecimal getUsageTotal(Long materialId) {
        if (materialId == null) {
            return new BigDecimal(0);
        }
        PmcCompanyMaterial material = (PmcCompanyMaterial)this.materialService.getById(materialId);
        if (material == null) {
            return new BigDecimal(0);
        }
        BigDecimal materialUseAmount = material.getMaterialUseAmount();
        if (materialUseAmount != null) {
            return materialUseAmount;
        }
        BigDecimal usageTotal = this.pmcMaterialUseInfoMapper.getUsageTotalByMaterialId(materialId);
        if (usageTotal == null) {
            return new BigDecimal(0);
        }
        return usageTotal;
    }

    public PageInfo<PmcMaterialUseInfo> getUseInfoItemList(JqGridParam gparam, Long materialId) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        PmcCompanyMaterial material = (PmcCompanyMaterial)this.materialService.getById(materialId);
        if (material == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PmcMaterialUseInfo> list = this.pmcMaterialUseInfoMapper.selectUseInfoByMatterId(gparam.getCid(), materialId);
        this.setUseInfos(list);
        if (("" + ProductTypeEnum.intermediateProducts.getValue()).equals(material.getMaterialType())) {
            for (PmcMaterialUseInfo u : list) {
                u.setTpProductionCompany("\u2014");
                u.setTpSupplierCompany("\u2014");
            }
        }
        PageInfo returnPageInfo = new PageInfo(list);
        return returnPageInfo;
    }

    private void setUseInfos(List<PmcMaterialUseInfo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (PmcMaterialUseInfo l : list) {
            l.setUserInfoAreaStr(this.userInfoAreaService.getUseInfoAreaStrByUseId(l.getId()));
            if (l.getUseorgId() != null) {
                l.setUseAreaName(this.orgService.getOrgNameById(l.getUseorgId()));
            }
            l.setWorkNames(this.pmcMaterialWorkroleService.getUseWorkNamesByUseId(l.getId()));
        }
    }

    public PmcMaterialUseInfo getUseInfoById(Long id) {
        PmcMaterialUseInfo useInfo = this.pmcMaterialUseInfoMapper.selectUseInfoById(id);
        if (useInfo == null) {
            return useInfo;
        }
        useInfo.setUserInfoAreas(this.userInfoAreaService.getUseInfoAreaListByUseId(id));
        return useInfo;
    }

    @Transactional(readOnly=false)
    public void del(Long id, Long staffId) {
        PmcMaterialUseInfo use = new PmcMaterialUseInfo();
        use.setId(id);
        use.setIsValid(Global.FALSE);
        this.update(use, staffId);
    }

    public List<PmcMaterialUseInfo> getUseInfoList(Long cid, Long materialId) {
        return this.pmcMaterialUseInfoMapper.selectUseInfoByMatterId(cid, materialId);
    }

    @Transactional(readOnly=false)
    public void updateUseAreaInfo(PmcMaterialUseInfo useInfo, Long staffId, Long cid) {
        this.userInfoAreaService.updateUseAreaInfo(useInfo, staffId, cid);
    }

    @Transactional(readOnly=false)
    public void addUseAreaInfo(PmcMaterialUseInfo useInfo, Long staffId, Long cid) {
        this.userInfoAreaService.addUseAreaInfo(useInfo, staffId, cid);
    }

    public String getUseOrgNames(Long materialId) {
        List<Long> useOrgIds = ((PmcMaterialUseInfoMapper)this.dao).getUseOrgIdsByMatterId(materialId);
        if (useOrgIds == null) {
            return null;
        }
        Object result = "";
        for (Long orgId : useOrgIds) {
            String orgName = this.orgService.getOrgNameById(orgId);
            if (StringUtils.isEmpty((CharSequence)orgName)) continue;
            result = (String)result + orgName + ",";
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }
}

