/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.material;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.material.PmcMaterialUseInfoAreaMapper;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialUseInfo;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialUseInfoArea;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialUseInfoAreaService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class PmcMaterialUseInfoAreaServiceImpl
extends BaseServiceImpl<PmcMaterialUseInfoAreaMapper, PmcMaterialUseInfoArea>
implements IPmcMaterialUseInfoAreaService {
    private final String splitor = ",";

    public List<PmcMaterialUseInfoArea> getUseInfoAreaListByMaterId(Long materialId) {
        if (materialId == null) {
            return null;
        }
        return ((PmcMaterialUseInfoAreaMapper)this.dao).getByMaterId(materialId);
    }

    public List<PmcMaterialUseInfoArea> getUseInfoAreaListByUseId(Long useId) {
        if (useId == null) {
            return null;
        }
        Example example = new Example(PmcMaterialUseInfoArea.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("useInfoId", (Object)useId);
        return ((PmcMaterialUseInfoAreaMapper)this.dao).selectByExample(example);
    }

    public String getUseInfoAreaStrByMaterId(Long materialId) {
        List<PmcMaterialUseInfoArea> list = this.getUseInfoAreaListByMaterId(materialId);
        return this.getAreasByList(list);
    }

    public String getUseInfoAreaStrByUseId(Long useId) {
        List<PmcMaterialUseInfoArea> list = this.getUseInfoAreaListByUseId(useId);
        return this.getAreasByList(list);
    }

    private String getAreasByList(List<PmcMaterialUseInfoArea> list) {
        Object result = "";
        if (list == null || list.isEmpty()) {
            return result;
        }
        ArrayList<String> existsArea = new ArrayList<String>();
        for (PmcMaterialUseInfoArea l : list) {
            String areaName = l.getUseAddr();
            if (StringUtils.isBlank((String)areaName) || existsArea.contains(areaName)) continue;
            existsArea.add(areaName);
            result = (String)result + areaName + ",";
        }
        if (((String)result).length() > 1) {
            return ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }

    @Transactional(readOnly=false)
    public void updateUseAreaInfo(PmcMaterialUseInfo useInfo, Long staffId, Long cid) {
        if (useInfo == null) {
            return;
        }
        this.deleteByUseId(useInfo.getId());
        this.addUseAreaInfo(useInfo, staffId, cid);
    }

    @Transactional(readOnly=false)
    public void addUseAreaInfo(PmcMaterialUseInfo useInfo, Long staffId, Long cid) {
        if (useInfo == null) {
            return;
        }
        List areas = useInfo.getUserInfoAreas();
        if (areas == null || areas.isEmpty()) {
            return;
        }
        for (PmcMaterialUseInfoArea area : areas) {
            if (area.getUseAreaId() == null) continue;
            area.setUseInfoId(useInfo.getId());
            this.add(area, staffId, cid);
        }
    }

    private void deleteByUseId(Long useId) {
        if (useId == null) {
            return;
        }
        Example example = new Example(PmcMaterialUseInfoArea.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("useInfoId", (Object)useId);
        ((PmcMaterialUseInfoAreaMapper)this.dao).deleteByExample(example);
    }
}

