/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.material;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.base.material.PmcMaterialStoreInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.material.PmcCompanyMaterial;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialStoreInfo;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.material.IPmcCompanyMaterialService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialStoreInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PmcMaterialStoreInfoServiceImpl
extends BaseServiceImpl<PmcMaterialStoreInfoMapper, PmcMaterialStoreInfo>
implements IPmcMaterialStoreInfoService {
    @Autowired
    PmcMaterialStoreInfoMapper pmcMaterialStoreInfoMapper;
    @Autowired
    private ICompanyAreaService companyAreaService;
    @Autowired
    IPmcCompanyMaterialService materialService;

    public BigDecimal getMaxStoreTotalByMaterialId(Long materialId) {
        if (materialId == null) {
            return new BigDecimal(0);
        }
        PmcCompanyMaterial material = (PmcCompanyMaterial)this.materialService.getById(materialId);
        if (material == null) {
            return new BigDecimal(0);
        }
        BigDecimal materialStoreAmount = material.getMaterialStoreAmount();
        if (materialStoreAmount != null) {
            return materialStoreAmount;
        }
        BigDecimal storeTotal = this.pmcMaterialStoreInfoMapper.getMaxStoreTotalByMaterialId(materialId);
        if (storeTotal == null) {
            return new BigDecimal(0);
        }
        return storeTotal;
    }

    public PageInfo<PmcMaterialStoreInfo> getStoreInfoItemList(JqGridParam gparam, Long materialId) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        Example example = new Example(PmcMaterialStoreInfo.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)gparam.getCid()).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("companyMaterialId", (Object)materialId);
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                if (sField.getSearchOper().equals(JqGridParam.operType.eq)) {
                    c.andEqualTo(sField.getSearchField(), (Object)sField.getSearchValue());
                    continue;
                }
                if (!sField.getSearchOper().equals(JqGridParam.operType.like)) continue;
                c.andLike(sField.getSearchField(), String.format("%%s%", sField.getSearchValue()));
            }
        }
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            example.setOrderByClause(gparam.getSidx() + " " + gparam.getSord());
        } else {
            example.setOrderByClause("update_date desc");
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List list = this.getListByExample(example);
        for (PmcMaterialStoreInfo info : list) {
            if (info.getUseAreaId() == null) continue;
            CompanyArea area = (CompanyArea)this.companyAreaService.getById(info.getUseAreaId());
            String areaName = this.companyAreaService.getTreePathNameByAreaId(info.getUseAreaId());
            if (area == null) continue;
            if (info.getUseAddr() != null && !"".equals(info.getUseAddr())) {
                info.setUseAddr(areaName + area.getAreaName() + ">" + info.getUseAddr());
                continue;
            }
            info.setUseAddr(areaName + area.getAreaName());
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void del(Long id, Long staffid) {
        PmcMaterialStoreInfo store = new PmcMaterialStoreInfo();
        store.setId(id);
        store.setIsValid(Global.FALSE);
        this.update(store, staffid);
    }
}

