/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.material;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.base.material.PmcMaterialProduceInfoMapper;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialProduceInfo;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialProduceInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class PmcMaterialProduceInfoServiceImpl
extends BaseServiceImpl<PmcMaterialProduceInfoMapper, PmcMaterialProduceInfo>
implements IPmcMaterialProduceInfoService {
    @Autowired
    PmcMaterialProduceInfoMapper pmcMaterialProduceInfoMapper;
    @Autowired
    ICompanyOrganizationService orgService;

    public BigDecimal getProduceCountTotal(Long productId) {
        if (productId == null) {
            return new BigDecimal(0);
        }
        BigDecimal usageTotal = this.pmcMaterialProduceInfoMapper.getProduceCountTotal(productId);
        if (usageTotal == null) {
            return new BigDecimal(0);
        }
        return usageTotal;
    }

    public PageInfo<PmcMaterialProduceInfo> getProduceInfoItemList(JqGridParam gparam, Long materialId) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        PmcMaterialProduceInfo prodice = new PmcMaterialProduceInfo();
        prodice.setCid(gparam.getCid());
        prodice.setCompanyMaterialId(materialId);
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            prodice.setOrder(gparam.getSidx() + " " + gparam.getSord());
        } else {
            prodice.setOrder("update_date desc");
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<PmcMaterialProduceInfo> list = this.pmcMaterialProduceInfoMapper.selectListByMaterialId(prodice);
        if (list == null) {
            return new PageInfo(list);
        }
        for (PmcMaterialProduceInfo l : list) {
            if (l.getProduceOrgid() == null) continue;
            l.setProduceOrgName(this.orgService.getOrgNameById(l.getProduceOrgid()));
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void del(Long id, Long staffId) {
        PmcMaterialProduceInfo produce = new PmcMaterialProduceInfo();
        produce.setId(id);
        produce.setIsValid(Global.FALSE);
        this.update(produce, staffId);
    }
}

