/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.material;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.material.PmcMaterialHarmMapper;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialHarm;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialHarmService;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PmcMaterialHarmServiceImpl
extends BaseServiceImpl<PmcMaterialHarmMapper, PmcMaterialHarm>
implements IPmcMaterialHarmService {
    @Autowired
    PmcMaterialHarmMapper pmcMaterialHarmMapper;

    @Transactional(readOnly=false)
    public void adds(String[] harmfactorid, Long materialId, Long staffId, Long cid) {
        if (ArrayUtils.isNotEmpty((Object[])harmfactorid)) {
            LinkedList<PmcMaterialHarm> harmList = new LinkedList<PmcMaterialHarm>();
            for (String harmId : harmfactorid) {
                PmcMaterialHarm harm = new PmcMaterialHarm();
                harm.setCompanyMaterialId(materialId);
                harm.setHarmId(Long.valueOf(harmId));
                harm.setId(Long.valueOf(this.idworker.nextId()));
                harm.setCid(cid);
                harm.setCreateBy(staffId);
                harm.setCreateDate(new Date());
                harmList.add(harm);
            }
            ((PmcMaterialHarmMapper)this.dao).batchInsertPmcMaterialHarm(harmList);
        }
    }

    public List<PmcMaterialHarm> getListByMaterialId(Long materialId) {
        if (null == materialId) {
            return null;
        }
        return this.pmcMaterialHarmMapper.selectListByMaterialId(materialId);
    }

    public List<PmcMaterialHarm> getListByMaterialIds(List<Long> materialIds) {
        if (null == materialIds || materialIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.pmcMaterialHarmMapper.selectListByMaterialIds(materialIds);
    }

    @Transactional(readOnly=false)
    public void delList(Long materialId, Long staffId) {
        List<PmcMaterialHarm> harmList = this.getListByMaterialId(materialId);
        for (PmcMaterialHarm harm : harmList) {
            this.delete(harm, staffId);
        }
    }

    public void deleteHarm(Long cid, Long loginStaffId) {
        PmcMaterialHarm info = new PmcMaterialHarm();
        info.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(info, loginStaffId);
        Example example = new Example(PmcMaterialHarm.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        ((PmcMaterialHarmMapper)this.dao).updateByExampleSelective(info, example);
    }
}

