/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.material;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.base.material.PmcCompanyMaterialMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.material.PmcCompanyMaterial;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialEhs;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialProduceInfo;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialStoreInfo;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialUseInfo;
import cn.smarthse.modules.health.entity.base.material.vo.MaterialImportVo;
import cn.smarthse.modules.health.entity.base.material.vo.MatterItemVO;
import cn.smarthse.modules.health.entity.base.material.vo.PmcMaterialHarmVO;
import cn.smarthse.modules.health.entity.base.material.vo.QueryMatterParam;
import cn.smarthse.modules.health.enums.material.MaterialTypeEnum;
import cn.smarthse.modules.health.enums.material.MaterialTypeIsZjProjEnum;
import cn.smarthse.modules.health.enums.material.ProductTypeEnum;
import cn.smarthse.modules.health.enums.material.ShapeStateEnum;
import cn.smarthse.modules.health.enums.material.UnitOfMeasurementEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.material.IPmcCompanyMaterialService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialEhsService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialHarmService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialProduceInfoService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialStoreInfoService;
import cn.smarthse.modules.health.service.base.material.IPmcMaterialUseInfoService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class PmcCompanyMaterialServiceImpl
extends BaseServiceImpl<PmcCompanyMaterialMapper, PmcCompanyMaterial>
implements IPmcCompanyMaterialService {
    @Autowired
    private IPmcMaterialUseInfoService pmcMaterialUseInfoService;
    @Autowired
    private IPmcMaterialProduceInfoService pmcMaterialProduceInfoService;
    @Autowired
    private IPmcMaterialStoreInfoService pmcMaterialStoreInfoService;
    @Autowired
    private IPmcMaterialEhsService pmcMaterialEhsService;
    @Autowired
    private IPmcMaterialHarmService pmcMaterialHarmService;
    @DubboReference
    private ISysFileProvideService fileService;
    @Autowired
    private ISysCoreWorkModuleCorrelationService coreWorkCorrelationService;
    @Autowired
    private ICompanyAreaService areaService;
    @Autowired
    private ICompanyOrganizationService orgService;
    @Autowired
    private IOccupationalRiskFactorsService riskService;
    @Autowired
    private IWorkRoleInfoService workService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService occupationalRiskFactorsService;
    @Autowired
    private DataSourceTransactionManager txManager;
    private final int meterial = 1;
    private final int product = 2;

    public PageInfo<MatterItemVO> getMatterItemList(JqGridParam gparam) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        QueryMatterParam param = new QueryMatterParam();
        param.setCid(gparam.getCid());
        if (gparam.getYears() != null && !gparam.getYears().equals("")) {
            param.setYears(gparam.getYears());
        }
        this.search(gparam, param);
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return this.getMatterItemPageInfo(param);
    }

    public PageInfo<MatterItemVO> getMatterItemListIsZjProj(JqGridParam gparam) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        QueryMatterParam param = new QueryMatterParam();
        param.setCid(gparam.getCid());
        if (gparam.getYears() != null && !gparam.getYears().equals("")) {
            param.setYears(gparam.getYears());
        }
        this.searchIsZjProj(gparam, param);
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        PageInfo pageInfo = new PageInfo(((PmcCompanyMaterialMapper)this.dao).selectMatterItemListIsZjProj(param));
        return pageInfo;
    }

    public List<MatterItemVO> getListByCid(QueryMatterParam param) {
        if (null == param) {
            return null;
        }
        List<MatterItemVO> list = ((PmcCompanyMaterialMapper)this.dao).selectMatterItemList(param);
        this.setOtherInfos(list);
        return list;
    }

    public List<MatterItemVO> getListByCidIsZjProj(QueryMatterParam param) {
        if (null == param) {
            return null;
        }
        if (param.getYears() == null) {
            param.setYears(DateUtils.getYear());
        }
        List<MatterItemVO> list = ((PmcCompanyMaterialMapper)this.dao).selectMatterItemListIsZjProj(param);
        this.setOtherInfos(list);
        return list;
    }

    private void setOtherInfos(List<MatterItemVO> list) {
        if (list == null) {
            return;
        }
        for (MatterItemVO vo : list) {
            List partnersfileList;
            List sectagfileList;
            this.setProductOrgs(vo);
            vo.setUsesum(this.pmcMaterialUseInfoService.getUsageTotal(vo.getId()));
            vo.setMaxstoresum(this.pmcMaterialStoreInfoService.getMaxStoreTotalByMaterialId(vo.getId()));
            List safetyfileList = this.fileService.getListByIds(vo.getSafetyfileId());
            if (safetyfileList != null && !safetyfileList.isEmpty()) {
                StringBuffer safetyFiles = new StringBuffer();
                for (Object s : safetyfileList) {
                    safetyFiles.append(s.getFileName()).append(",");
                }
                if (safetyFiles.length() > 0) {
                    safetyFiles.deleteCharAt(safetyFiles.lastIndexOf(","));
                }
                vo.setSafetyfile(safetyFiles.toString());
            }
            if ((sectagfileList = this.fileService.getListByIds(vo.getSectagfileId())) != null && !sectagfileList.isEmpty()) {
                Object s;
                StringBuffer sectagfiles = new StringBuffer();
                s = sectagfileList.iterator();
                while (s.hasNext()) {
                    SysFileModel s2 = (SysFileModel)s.next();
                    sectagfiles.append(s2.getFileName()).append(",");
                }
                if (sectagfiles.length() > 0) {
                    sectagfiles.deleteCharAt(sectagfiles.lastIndexOf(","));
                }
                vo.setSectagfile(sectagfiles.toString());
            }
            if ((partnersfileList = this.fileService.getListByIds(vo.getPartnersfileId())) == null || partnersfileList.isEmpty()) continue;
            StringBuffer partnersfiles = new StringBuffer();
            for (SysFileModel s : partnersfileList) {
                partnersfiles.append(s.getFileName()).append(",");
            }
            if (partnersfiles.length() > 0) {
                partnersfiles.deleteCharAt(partnersfiles.lastIndexOf(","));
            }
            vo.setPartnersfile(partnersfiles.toString());
        }
    }

    private void setProductOrgs(MatterItemVO vo) {
        String productOrgIds = vo.getProduceOrgids();
        List orgIds = StringUtils.parseToLongList((String)productOrgIds, (String)",");
        if (orgIds == null) {
            return;
        }
        Object result = "";
        for (Long orgId : orgIds) {
            String orgName = this.orgService.getOrgNameById(orgId);
            if (StringUtils.isEmpty((CharSequence)orgName)) continue;
            result = (String)result + orgName + ",";
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
            vo.setProduceorg((String)result);
        }
    }

    private PageInfo<MatterItemVO> getMatterItemPageInfo(QueryMatterParam param) {
        PageInfo pageInfo = new PageInfo(((PmcCompanyMaterialMapper)this.dao).selectMatterItemList(param));
        this.setOtherInfos(pageInfo.getList());
        return pageInfo;
    }

    public List<MatterItemVO> getAllMatterItemVO() {
        QueryMatterParam param = new QueryMatterParam();
        param.setOrder("id");
        return ((PmcCompanyMaterialMapper)this.dao).selectMatterItemList(param);
    }

    public PageInfo<MatterItemVO> getProductItemList(JqGridParam gparam) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        QueryMatterParam param = new QueryMatterParam();
        param.setCid(gparam.getCid());
        if (gparam.getYears() != null && !gparam.getYears().equals("")) {
            param.setYears(gparam.getYears());
        }
        this.search(gparam, param);
        param.setSearchType(Integer.valueOf(2));
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        return this.getMatterItemPageInfo(param);
    }

    private void search(JqGridParam gparam, QueryMatterParam param) {
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                if ("keyword".equals(sField.getSearchField())) {
                    if ("".equals(sField.getSearchValue())) continue;
                    param.setKeyword(sField.getSearchValue());
                    continue;
                }
                if ("mtype".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    param.setMtype(Integer.valueOf(sField.getSearchValue()));
                    continue;
                }
                if ("mstate".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    param.setMstate(Integer.valueOf(sField.getSearchValue()));
                    continue;
                }
                if ("useorgid".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    param.setUseorgid(Long.valueOf(sField.getSearchValue()));
                    continue;
                }
                if ("produceorgid".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    param.setProduceorgid(Long.valueOf(sField.getSearchValue()));
                    continue;
                }
                if ("isharm".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    param.setIsharm(Integer.valueOf(sField.getSearchValue()));
                    continue;
                }
                if ("ishazard".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    param.setIshazard(Integer.valueOf(sField.getSearchValue()));
                    continue;
                }
                if (!"selectIds".equals(sField.getSearchField()) || !StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                List selectIdList = CommonUtil.str2LongList((String)sField.getSearchValue());
                param.setExcldeIds(selectIdList);
            }
        }
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            param.setOrder(gparam.getSidx() + " " + gparam.getSord());
        } else {
            param.setOrder("createdate desc");
        }
    }

    private void searchIsZjProj(JqGridParam gparam, QueryMatterParam param) {
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                if (!"keyword".equals(sField.getSearchField()) || "".equals(sField.getSearchValue())) continue;
                param.setKeyword(sField.getSearchValue());
            }
        }
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            param.setOrder(gparam.getSidx() + " " + gparam.getSord());
        } else {
            param.setOrder("create_date desc");
        }
    }

    @Transactional(readOnly=false)
    public void del(Long id, Long staffId) {
        PmcCompanyMaterial material = new PmcCompanyMaterial();
        material.setId(id);
        material.setIsValid(Global.FALSE);
        this.update(material, staffId);
    }

    @Deprecated
    public ResponseData<List<MaterialImportVo>> importMatter(String ossfile) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        HSSFSheet sheet = wb.getSheetAt(0);
        ResponseData<List<MaterialImportVo>> data = this.parsefromExcel(sheet);
        wb.close();
        return data;
    }

    public ResponseData<List<MaterialImportVo>> importMatterIsActualizeAndIsSharingSystem(String ossfile) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        HSSFSheet sheet = wb.getSheetAt(0);
        ResponseData<List<MaterialImportVo>> data = this.parseFromExcelIsActualizeAndIsSharingSystem(sheet);
        wb.close();
        return data;
    }

    public ResponseData<List<MaterialImportVo>> importMatterIsZjProj(String ossfile, String year) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        HSSFSheet sheet = wb.getSheetAt(0);
        ResponseData<List<MaterialImportVo>> data = this.parseFromExcelIsZjProj(sheet, year);
        wb.close();
        return data;
    }

    private boolean isALLCellIsEmpty(Row row, int cellCount) {
        boolean isEmty = true;
        for (int i = 0; i < cellCount; ++i) {
            Cell cell = row.getCell(i);
            cell.setCellType(CellType.STRING);
            if (cell == null || cell.getCellType() == CellType.BLANK || "".equals(cell.getStringCellValue().trim())) continue;
            isEmty = false;
            break;
        }
        return isEmty;
    }

    private boolean isRequiredIsEmpty(Cell cell, List<String> errorContentList, int rowIndex, int colIndex) {
        boolean isEmpty = false;
        if (cell == null || cell.getCellType() == CellType.BLANK) {
            if (colIndex == 0) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u7269\u6599\u7c7b\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            } else if (colIndex == 1) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u7269\u6599\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            } else if (colIndex == 2) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u4ea7\u751f\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            }
        }
        return isEmpty;
    }

    private boolean isRequiredIsEmptyIsActualizeAndIsSharingSystem(Cell cell, List<String> errorContentList, int rowIndex, int colIndex) {
        boolean isEmpty = false;
        if (cell == null || cell.getCellType() == CellType.BLANK) {
            if (colIndex == 0) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u7269\u6599\u7c7b\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            } else if (colIndex == 1) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u7269\u6599\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            } else if (colIndex == 2) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5355\u4f4d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            } else if (colIndex == 3) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5e74\u4f7f\u7528\u91cf/\u5e74\u4ea7\u91cf\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            }
        }
        return isEmpty;
    }

    private boolean isRequiredIsEmptyIsZjProj(Cell cell, List<String> errorContentList, int rowIndex, int colIndex) {
        boolean isEmpty = false;
        if (cell == null || cell.getCellType() == CellType.BLANK) {
            if (colIndex == 0) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u7269\u6599\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            } else if (colIndex == 1) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u7269\u6599\u7528\u9014\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            } else if (colIndex == 2) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u4ea7\u91cf/\u7528\u91cf\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            } else if (colIndex == 3) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8ba1\u91cf\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                isEmpty = true;
            }
        }
        return isEmpty;
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated
    private ResponseData<List<MaterialImportVo>> parsefromExcel(HSSFSheet sheet) {
        rowIndex = 0;
        data = new ResponseData();
        list = new ArrayList<MaterialImportVo>();
        hasError = false;
        errorContentList = new ArrayList<String>();
        harmMap = this.occupationalRiskFactorsService.getAllNameAndIdMap();
        iter = sheet.rowIterator();
        while (iter.hasNext()) {
            row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            improtVo = new MaterialImportVo();
            material = new PmcCompanyMaterial();
            useInfo = new PmcMaterialUseInfo();
            pmcStoreInfo = new PmcMaterialStoreInfo();
            pmcProduceInfo = new PmcMaterialProduceInfo();
            cellCount = 7;
            colIndex = 0;
            rowIsEmpty = this.isALLCellIsEmpty(row, cellCount);
            if (rowIsEmpty) break;
            for (i = 0; i < cellCount; ++i) {
                cell = row.getCell(i);
                if (this.isRequiredIsEmpty(cell, errorContentList, rowIndex, i)) {
                    hasError = true;
                    continue;
                }
                if (cell == null) continue;
                switch (i) {
                    case 0: {
                        materialType = null;
                        try {
                            type = cell.getStringCellValue().trim();
                            materialType = type.equals("\u539f\u6599") != false || type.equals("\u8f85\u6599") != false ? String.valueOf(MaterialTypeEnum.getValue((String)type)) : String.valueOf(ProductTypeEnum.getValue((String)type));
                            if (materialType == null || "".equals(materialType)) {
                                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u7269\u6599\u7c7b\u522b\u4e0d\u5b58\u5728");
                                hasError = true;
                            }
                            ** GOTO lbl43
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u7269\u6599\u7c7b\u522b\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                        }
                        break;
lbl43:
                        // 1 sources

                        material.setMaterialType(materialType);
                        break;
                    }
                    case 1: {
                        this.getMaterialName(cell, errorContentList, rowIndex, i, material, hasError);
                        break;
                    }
                    case 2: {
                        try {
                            isHarm = cell.getStringCellValue().trim();
                            if ("\u662f".equals(isHarm)) {
                                material.setIsHarm(Global.TRUE);
                                break;
                            }
                            if (!"\u5426".equals(isHarm)) break;
                            material.setIsHarm(Global.FALSE);
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u662f\u5426\u4ea7\u751f\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                        }
                        break;
                    }
                    case 3: {
                        harmNames = null;
                        sb = new StringBuffer();
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK && ArrayUtils.isNotEmpty((Object[])(harmNamesArr = StringUtils.splitByWholeSeparator((String)(harmNames = cell.getStringCellValue().trim()), (String)"\uff1b")))) {
                                for (Object harmsNametr : harmNamesArr) {
                                    if (!harmMap.containsKey(harmsNametr)) {
                                        errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + "," + (String)harmsNametr + "\u5371\u5bb3\u56e0\u7d20\u4e0d\u5b58\u5728");
                                        hasError = true;
                                        continue;
                                    }
                                    sb.append((String)harmMap.get(harmsNametr) + ",");
                                    harmNames = sb.toString();
                                }
                            }
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5371\u5bb3\u56e0\u7d20\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                            break;
                        }
                        material.setHarmNames(harmNames);
                        break;
                    }
                    case 4: {
                        if (cell != null && cell.getCellType() != CellType.BLANK) {
                            try {
                                unit = cell.getStringCellValue().trim();
                                unit = unit.replace("(", "\uff08").replace(")", "\uff09");
                                unitInt = UnitOfMeasurementEnum.getValue((String)unit);
                                if (unitInt == null) {
                                    errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u5355\u4f4d\u4e0d\u5b58\u5728");
                                    hasError = true;
                                    break;
                                }
                                material.setMaterialUnit(Byte.valueOf(unitInt.byteValue()));
                                pmcStoreInfo.setMaterialUnit(Long.valueOf(unitInt.longValue()));
                            }
                            catch (Exception e) {
                                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u5355\u4f4d\u683c\u5f0f\u4e0d\u5bf9");
                                hasError = true;
                            }
                            break;
                        }
                        material.setMaterialUnit(null);
                        pmcStoreInfo.setMaterialUnit(null);
                        break;
                    }
                    case 5: {
                        specification = null;
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK) {
                                specification = cell.toString();
                            }
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ",\u89c4\u683c/\u578b\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                            break;
                        }
                        material.setSpecification(specification);
                        break;
                    }
                    case 6: {
                        materialState = null;
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK) {
                                state = cell.getStringCellValue().trim();
                                materialState = state != null && state != "" ? Byte.valueOf(ShapeStateEnum.getValue((String)state).byteValue()) : null;
                            }
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u7269\u8d28\u72b6\u6001\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                            break;
                        }
                        material.setMaterialState(materialState);
                        break;
                    }
                }
                ++colIndex;
            }
            if (hasError.booleanValue()) continue;
            improtVo.setPmcMaterial(material);
            if (!material.getMaterialType().equals("1") && !material.getMaterialType().equals("2")) {
                improtVo.setPmcProduceInfo(pmcProduceInfo);
            }
            list.add(improtVo);
        }
        if (hasError.booleanValue()) {
            data.setState(ResponseStateEnum.warning);
            errorBuffer = new StringBuffer();
            for (String errorStr : errorContentList) {
                errorBuffer.append(errorStr).append("<br/>");
            }
            data.setContent(errorBuffer.toString());
        } else {
            data.setResult(list);
            data.setState(ResponseStateEnum.success);
        }
        return data;
    }

    private ResponseData<List<MaterialImportVo>> parseFromExcelIsActualizeAndIsSharingSystem(HSSFSheet sheet) {
        ResponseData data = new ResponseData();
        int rowIndex = 0;
        ArrayList<MaterialImportVo> list = new ArrayList<MaterialImportVo>();
        Boolean hasError = false;
        ArrayList<String> errorContentList = new ArrayList<String>();
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            MaterialImportVo improtVo = new MaterialImportVo();
            PmcCompanyMaterial material = new PmcCompanyMaterial();
            PmcMaterialUseInfo useInfo = new PmcMaterialUseInfo();
            PmcMaterialStoreInfo pmcStoreInfo = new PmcMaterialStoreInfo();
            PmcMaterialProduceInfo pmcProduceInfo = new PmcMaterialProduceInfo();
            int cellCount = 11;
            boolean rowIsEmpty = this.isALLCellIsEmpty(row, cellCount);
            if (rowIsEmpty) break;
            block30: for (int i = 0; i < cellCount; ++i) {
                Cell cell = row.getCell(i);
                if (this.isRequiredIsEmptyIsActualizeAndIsSharingSystem(cell, errorContentList, rowIndex, i)) {
                    hasError = true;
                    continue;
                }
                if (cell == null) continue;
                switch (i) {
                    case 0: {
                        this.getMaterialTypeInfo(cell, errorContentList, rowIndex, i, material, hasError);
                        continue block30;
                    }
                    case 1: {
                        this.getMaterialName(cell, errorContentList, rowIndex, i, material, hasError);
                        continue block30;
                    }
                    case 2: {
                        this.getMaterialUnit(cell, errorContentList, rowIndex, i, material, hasError, pmcStoreInfo);
                        continue block30;
                    }
                    case 3: {
                        BigDecimal usageYear;
                        try {
                            String year = cell.toString();
                            usageYear = new BigDecimal(year);
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u5e74\u4f7f\u7528\u91cf/\u5e74\u4ea7\u91cf\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                            continue block30;
                        }
                        material.setMaterialUseAmount(usageYear);
                        useInfo.setUsageYear(usageYear);
                        pmcProduceInfo.setProduceCount(usageYear);
                        continue block30;
                    }
                    case 4: {
                        String specification;
                        try {
                            specification = cell.toString();
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ",\u89c4\u683c/\u578b\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                            continue block30;
                        }
                        material.setSpecification(specification);
                        continue block30;
                    }
                    case 5: {
                        BigDecimal maxStore;
                        try {
                            if (StringUtils.isEmpty((CharSequence)cell.toString())) continue block30;
                            maxStore = new BigDecimal(cell.toString());
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u6700\u5927\u50a8\u91cf\u4e0d\u5bf9");
                            hasError = true;
                            continue block30;
                        }
                        material.setMaterialStoreAmount(maxStore);
                        pmcStoreInfo.setMaxStore(maxStore);
                        continue block30;
                    }
                    case 6: {
                        String materialNick;
                        try {
                            materialNick = cell.toString();
                        }
                        catch (Exception e2) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u522b\u540d\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                            continue block30;
                        }
                        material.setMaterialNick(materialNick);
                        continue block30;
                    }
                    case 7: {
                        String casNo;
                        try {
                            casNo = cell.toString();
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u5316\u5b66\u6587\u6458\u53f7\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                            continue block30;
                        }
                        material.setCasNo(casNo);
                        continue block30;
                    }
                    case 8: {
                        Byte materialState;
                        try {
                            String state = cell.getStringCellValue().trim();
                            materialState = state != null && state != "" ? Byte.valueOf(ShapeStateEnum.getValue((String)state).byteValue()) : null;
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u7269\u8d28\u72b6\u6001\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                            continue block30;
                        }
                        material.setMaterialState(materialState);
                        continue block30;
                    }
                    case 9: {
                        try {
                            String isHazard = cell.getStringCellValue().trim();
                            if ("\u662f".equals(isHazard)) {
                                material.setIsHazard(Global.TRUE);
                                continue block30;
                            }
                            if (!"\u5426".equals(isHazard)) continue block30;
                            material.setIsHazard(Global.FALSE);
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u662f\u5426\u5371\u9669\u5316\u5b66\u54c1\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                        }
                        continue block30;
                    }
                    case 10: {
                        try {
                            String isHarm = cell.getStringCellValue().trim();
                            if ("\u662f".equals(isHarm)) {
                                material.setIsHarm(Global.TRUE);
                                continue block30;
                            }
                            if (!"\u5426".equals(isHarm)) continue block30;
                            material.setIsHarm(Global.FALSE);
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u662f\u5426\u4ea7\u751f\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                        }
                        continue block30;
                    }
                }
            }
            if (hasError.booleanValue()) continue;
            improtVo.setPmcMaterial(material);
            if (!material.getMaterialType().equals("1") && !material.getMaterialType().equals("2")) {
                improtVo.setPmcProduceInfo(pmcProduceInfo);
            }
            list.add(improtVo);
        }
        if (hasError.booleanValue()) {
            data.setState(ResponseStateEnum.warning);
            StringBuffer errorBuffer = new StringBuffer();
            for (String errorStr : errorContentList) {
                errorBuffer.append(errorStr).append("<br/>");
            }
            data.setContent(errorBuffer.toString());
        } else {
            data.setResult(list);
            data.setState(ResponseStateEnum.success);
        }
        return data;
    }

    /*
     * Unable to fully structure code
     */
    private ResponseData<List<MaterialImportVo>> parseFromExcelIsZjProj(HSSFSheet sheet, String year) {
        data = new ResponseData();
        rowIndex = 0;
        list = new ArrayList<MaterialImportVo>();
        hasError = false;
        errorContentList = new ArrayList<String>();
        iter = sheet.rowIterator();
        while (iter.hasNext()) {
            row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            improtVo = new MaterialImportVo();
            material = new PmcCompanyMaterial();
            if (year == null) {
                year = String.valueOf(LocalDate.now().getYear());
            }
            material.setDataYear(Integer.valueOf(year));
            cellCount = 4;
            rowIsEmpty = this.isALLCellIsEmpty(row, cellCount);
            if (rowIsEmpty) break;
            block13: for (i = 0; i < cellCount; ++i) {
                cell = row.getCell(i);
                if (this.isRequiredIsEmptyIsZjProj(cell, errorContentList, rowIndex, i)) {
                    hasError = true;
                    continue;
                }
                if (cell == null) continue;
                switch (i) {
                    case 0: {
                        this.getMaterialName(cell, errorContentList, rowIndex, i, material, hasError);
                        continue block13;
                    }
                    case 1: {
                        materialType = null;
                        try {
                            type = cell.getStringCellValue().trim();
                            if (type.equals("\u539f\u6599") || type.equals("\u8f85\u6599") || type.equals("\u4ea7\u54c1")) {
                                materialType = String.valueOf(MaterialTypeIsZjProjEnum.getValue((String)type));
                            }
                            if (materialType == null || "".equals(materialType)) {
                                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u7269\u6599\u7c7b\u522b\u4e0d\u5b58\u5728");
                                hasError = true;
                            }
                            ** GOTO lbl45
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u7269\u6599\u7c7b\u522b\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                        }
                        continue block13;
lbl45:
                        // 1 sources

                        material.setMaterialType(materialType);
                        continue block13;
                    }
                    case 2: {
                        try {
                            yearNum = cell.toString();
                            consumptionOrOutput = new BigDecimal(yearNum);
                        }
                        catch (Exception e) {
                            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i) + ", \u5e74\u4f7f\u7528\u91cf/\u5e74\u4ea7\u91cf\u683c\u5f0f\u4e0d\u5bf9");
                            hasError = true;
                            continue block13;
                        }
                        material.setConsumptionOrOutput(consumptionOrOutput);
                        continue block13;
                    }
                    case 3: {
                        if (cell != null && cell.getCellType() != CellType.BLANK) {
                            try {
                                unit = cell.getStringCellValue().trim();
                                unit = unit.replace("(", "\uff08").replace(")", "\uff09");
                                unitInt = UnitOfMeasurementEnum.getValue((String)unit);
                                material.setMaterialUnit(Byte.valueOf(unitInt.byteValue()));
                            }
                            catch (Exception var18_21) {}
                            continue block13;
                        }
                        material.setMaterialUnit(null);
                        continue block13;
                    }
                }
            }
            if (hasError.booleanValue()) continue;
            improtVo.setPmcMaterial(material);
            list.add(improtVo);
        }
        if (hasError.booleanValue()) {
            data.setState(ResponseStateEnum.warning);
            errorBuffer = new StringBuffer();
            for (String errorStr : errorContentList) {
                errorBuffer.append(errorStr).append("<br/>");
            }
            data.setContent(errorBuffer.toString());
        } else {
            data.setResult(list);
            data.setState(ResponseStateEnum.success);
        }
        return data;
    }

    private void getMaterialTypeInfo(Cell cell, List<String> errorContentList, int rowIndex, int celIndex, PmcCompanyMaterial material, Boolean hasError) {
        String materialType = null;
        try {
            String type = cell.getStringCellValue().trim();
            materialType = type.equals("\u539f\u6599") || type.equals("\u8f85\u6599") ? String.valueOf(MaterialTypeEnum.getValue((String)type)) : String.valueOf(ProductTypeEnum.getValue((String)type));
            if (materialType == null || "".equals(materialType)) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(celIndex) + ", \u7269\u6599\u7c7b\u522b\u683c\u5f0f\u4e0d\u5bf9");
                hasError = true;
                return;
            }
        }
        catch (Exception e) {
            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(celIndex) + ", \u7269\u6599\u7c7b\u522b\u683c\u5f0f\u4e0d\u5bf9");
            hasError = true;
            return;
        }
        material.setMaterialType(materialType);
    }

    private void getMaterialName(Cell cell, List<String> errorContentList, int rowIndex, int celIndex, PmcCompanyMaterial material, Boolean hasError) {
        String name;
        try {
            name = cell.toString();
            Boolean isScientific = this.getScientific(name);
            if (isScientific.booleanValue()) {
                BigDecimal db = new BigDecimal(name);
                name = db.toPlainString();
            }
        }
        catch (Exception e2) {
            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(celIndex) + ", \u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            hasError = true;
            return;
        }
        material.setMaterialName(name);
    }

    private void getMaterialUnit(Cell cell, List<String> errorContentList, int rowIndex, int celIndex, PmcCompanyMaterial material, Boolean hasError, PmcMaterialStoreInfo pmcStoreInfo) {
        try {
            String unit = cell.getStringCellValue().trim();
            unit = unit.replace("(", "\uff08").replace(")", "\uff09");
            Integer unitInt = UnitOfMeasurementEnum.getValue((String)unit);
            if (unitInt == null) {
                errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(celIndex) + ", \u5355\u4f4d\u4e0d\u5b58\u5728");
                hasError = true;
                return;
            }
            material.setMaterialUnit(Byte.valueOf(unitInt.byteValue()));
            pmcStoreInfo.setMaterialUnit(Long.valueOf(unitInt.longValue()));
        }
        catch (Exception e) {
            errorContentList.add("\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(celIndex) + ", \u5355\u4f4d\u683c\u5f0f\u4e0d\u5bf9");
            hasError = true;
        }
    }

    public static Set<String> splitHarm(String harmData, String spliter) {
        String regex = "\u3001(?=[^()]*\\))";
        String replaceStr = "______";
        String temp = harmData.replaceAll(regex, replaceStr);
        Object[] harmStrArr = StringUtils.split((String)temp, (String)spliter);
        if (ArrayUtils.isNotEmpty((Object[])harmStrArr)) {
            HashSet<String> harmSet = new HashSet<String>();
            for (Object harmStr : harmStrArr) {
                harmStr = ((String)harmStr).replaceAll(replaceStr, spliter);
                harmSet.add((String)harmStr);
            }
            return harmSet;
        }
        return Collections.emptySet();
    }

    private String getExcelColName(int index) {
        if (++index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private Date getExcelDate(int days) {
        Calendar c3 = Calendar.getInstance();
        c3.set(1900, 0, -1);
        c3.add(5, days);
        return c3.getTime();
    }

    private boolean getScientific(String input) {
        String regx = "[+-]?[0-9]+.[0-9]+[Ee][+-]?\\d+";
        Pattern pattern = Pattern.compile(regx);
        return pattern.matcher(input).matches();
    }

    @Transactional(readOnly=false)
    public ResponseData<List<MaterialImportVo>> importAdd(List<MaterialImportVo> list, Long cid, Long loginStaffId) {
        ResponseData data = new ResponseData(ResponseStateEnum.success);
        if (list.size() > 0) {
            for (MaterialImportVo vo : list) {
                PmcCompanyMaterial matetial = vo.getPmcMaterial();
                matetial.setId(null);
                matetial = this.add(matetial, loginStaffId, cid);
                if (!Objects.equals("true", this.isSharingSystem) && !Objects.equals("true", this.isActualize)) continue;
                Long matterId = matetial.getId();
                PmcMaterialStoreInfo storeInfo = vo.getPmcStoreInfo();
                if (storeInfo != null && storeInfo.getMaxStore() != null) {
                    storeInfo.setId(null);
                    storeInfo.setCompanyMaterialId(matterId);
                    storeInfo.setUseAreaId(Long.valueOf(0L));
                    this.pmcMaterialStoreInfoService.add((Object)storeInfo, loginStaffId, cid);
                }
                if (vo.getPmcUseInfo() != null) {
                    PmcMaterialUseInfo useInfo = vo.getPmcUseInfo();
                    useInfo.setId(null);
                    useInfo.setCompanyMaterialId(matterId);
                    useInfo.setUseorgId(Long.valueOf(0L));
                    useInfo.setUseAreaId(Long.valueOf(0L));
                    useInfo.setTpSupplierCompanyId(Long.valueOf(0L));
                    useInfo.setTpProductionCompanyId(Long.valueOf(0L));
                    this.pmcMaterialUseInfoService.add((Object)useInfo, loginStaffId, cid);
                    continue;
                }
                if (vo.getPmcProduceInfo() == null) continue;
                PmcMaterialProduceInfo produceInfo = vo.getPmcProduceInfo();
                produceInfo.setId(null);
                produceInfo.setCompanyMaterialId(matterId);
                produceInfo.setProduceAreaId(Long.valueOf(0L));
                produceInfo.setProduceOrgid(Long.valueOf(0L));
                this.pmcMaterialProduceInfoService.add((Object)produceInfo, loginStaffId, cid);
            }
            data.setResult(list);
        } else {
            data.setContent("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            data.setState(ResponseStateEnum.fail);
        }
        return data;
    }

    public Integer getMatterNumByCid(Long cid) {
        Example example = new Example(PmcCompanyMaterial.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE).andCondition("material_type in (1,2)");
        return ((PmcCompanyMaterialMapper)this.dao).selectCountByExample(example);
    }

    public Integer getProductNumByCid(Long cid) {
        Example example = new Example(PmcCompanyMaterial.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE).andCondition("material_type in (3,4,5)");
        return ((PmcCompanyMaterialMapper)this.dao).selectCountByExample(example);
    }

    @Transactional(readOnly=false)
    public void deleteMaterialByCid(Long cid, Long staffid) {
        PmcCompanyMaterial info = new PmcCompanyMaterial();
        info.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(info, staffid);
        Example example = new Example(PmcCompanyMaterial.class);
        example.createCriteria().andEqualTo("cid", (Object)cid);
        ((PmcCompanyMaterialMapper)this.dao).updateByExampleSelective(info, example);
    }

    @Transactional(readOnly=false)
    public void deleteMaterial(Long cid, Long staffid, String type) {
        PmcCompanyMaterial info = new PmcCompanyMaterial();
        info.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(info, staffid);
        Example example = new Example(PmcCompanyMaterial.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        if (Objects.equals("isMaterial", type)) {
            criteria.andCondition("material_type in (1,2)");
        } else if (Objects.equals("isProduct", type)) {
            criteria.andCondition("material_type in (3,4,5)");
        }
        ((PmcCompanyMaterialMapper)this.dao).updateByExampleSelective(info, example);
    }

    @Transactional(readOnly=false)
    public void deleteMaterialByYear(Long cid, String year, Long staffId) {
        ((PmcCompanyMaterialMapper)this.dao).deleteMaterialByYear(cid, year, staffId);
    }

    @Transactional(readOnly=false)
    public void deleteProduct(Long cid, Long staffid) {
        PmcCompanyMaterial info = new PmcCompanyMaterial();
        info.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(info, staffid);
        Example example = new Example(PmcCompanyMaterial.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE).andCondition("material_type in (3,4,5)");
        ((PmcCompanyMaterialMapper)this.dao).updateByExampleSelective(info, example);
    }

    public Integer getNumByCid(Long cid) {
        Example example = new Example(PmcCompanyMaterial.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        return ((PmcCompanyMaterialMapper)this.dao).selectCountByExample(example);
    }

    public List<MatterItemVO> getMatterList(Long cid) {
        QueryMatterParam param = new QueryMatterParam();
        param.setCid(cid);
        param.setOrder("createdate desc");
        param.setIsharm(Integer.valueOf(1));
        List<MatterItemVO> list = ((PmcCompanyMaterialMapper)this.dao).selectMatterItemList(param);
        for (MatterItemVO vo : list) {
            List useList = this.pmcMaterialUseInfoService.getUseInfoList(cid, vo.getId());
            vo.setUseList(useList);
        }
        return list;
    }

    public List<MatterItemVO> getProductList(Long cid, Integer type) {
        QueryMatterParam param = new QueryMatterParam();
        param.setCid(cid);
        param.setSearchType(Integer.valueOf(2));
        param.setIsharm(Integer.valueOf(1));
        if (type == 1) {
            param.setMtype(ProductTypeEnum.intermediateProducts.getValue());
        } else if (type == 2) {
            param.setMtypes("666");
        }
        param.setOrder("createdate desc");
        List<MatterItemVO> list = ((PmcCompanyMaterialMapper)this.dao).selectMatterItemList(param);
        if (type == 1) {
            for (MatterItemVO vo : list) {
                List useList = this.pmcMaterialUseInfoService.getUseInfoList(cid, vo.getId());
                vo.setUseList(useList);
            }
        }
        return list;
    }

    @Transactional(readOnly=false)
    public PmcCompanyMaterial saveCompanyMaterialInfo(PmcCompanyMaterial material, Long loginStaffId, Long cid) {
        if (material == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        if (material.getId() == null) {
            if ((material = super.add(material, loginStaffId, cid)) == null) {
                return new PmcCompanyMaterial();
            }
            PmcMaterialEhs ehs = new PmcMaterialEhs();
            ehs.setCid(cid);
            ehs.setCompanyMaterialId(material.getId());
            this.pmcMaterialEhsService.add((Object)ehs, loginStaffId, cid);
        }
        return material;
    }

    @Transactional(readOnly=false)
    public PmcCompanyMaterial saveCompanyMaterialInfoIsZjProj(PmcCompanyMaterial material, Long loginStaffId, Long cid) {
        if (material == null || loginStaffId == null || cid == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        if (material.getId() == null && (material = super.add(material, loginStaffId, cid)) == null) {
            return new PmcCompanyMaterial();
        }
        return material;
    }

    @Transactional(readOnly=false)
    public void updateCompanyMaterialEhsInfo(PmcMaterialEhs materialEhs, Long materialId, Long loginStaffId, Long cid, String[] harmfactorid, Boolean isharm, Boolean ishazard) {
        if (null != materialEhs.getId()) {
            this.pmcMaterialEhsService.update((Object)materialEhs, loginStaffId);
        } else {
            materialEhs.setCompanyMaterialId(materialId);
            this.pmcMaterialEhsService.add((Object)materialEhs, loginStaffId, cid);
        }
        PmcCompanyMaterial material = new PmcCompanyMaterial();
        material.setId(materialId);
        material.setIsHarm(isharm);
        material.setIsHazard(ishazard);
        super.update(material, loginStaffId);
        this.pmcMaterialHarmService.adds(harmfactorid, materialId, loginStaffId, cid);
        if (!isharm.booleanValue()) {
            this.pmcMaterialHarmService.delList(materialId, loginStaffId);
        }
        this.updateHarmFactorManagerTodolistInfo(materialId, loginStaffId, cid);
    }

    @Transactional(readOnly=false)
    public void updateHarmFactorManagerTodolistInfo(Long materialId, Long loginStaffId, Long cid) {
        if (materialId == null || loginStaffId == null || cid == null) {
            return;
        }
        List list = this.pmcMaterialUseInfoService.getUseInfoList(cid, materialId);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (PmcMaterialUseInfo u : list) {
            CompanyArea area;
            if (u == null || u.getUseAreaId() == null || (area = (CompanyArea)this.areaService.getById(u.getUseAreaId())) == null) continue;
            this.coreWorkCorrelationService.addHarmFactorManagerTodolistInfo(CoreWorkEnum.companyArea, area.getId(), area.getAreaName() + "\u533a\u57df", loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void clearImportInfoByIdAndColumn(Long companyMaterialId, String column) {
        if (companyMaterialId == null) {
            return;
        }
        PmcCompanyMaterial material = (PmcCompanyMaterial)((PmcCompanyMaterialMapper)this.dao).selectByPrimaryKey(companyMaterialId);
        if (material == null) {
            return;
        }
        if ("materialStoreAmount".equals(column)) {
            material.setMaterialStoreAmount(null);
        } else if ("materialUseAmount".equals(column)) {
            material.setMaterialUseAmount(null);
        } else {
            return;
        }
        ((PmcCompanyMaterialMapper)this.dao).updateByPrimaryKey(material);
    }

    public List<String> getHighHarms(Long cid, Integer harmType, int meterialType) {
        if (cid == null || harmType == null) {
            return null;
        }
        List<Integer> meterialTypes = this.getMeterialTypes(meterialType);
        if (meterialTypes == null || meterialTypes.isEmpty()) {
            return null;
        }
        List<PmcMaterialHarmVO> harms = ((PmcCompanyMaterialMapper)this.dao).getHighHarms(cid, meterialTypes, harmType);
        List<String> results = this.getHarms(harms, harmType);
        return results;
    }

    public MatterItemVO selectMatterItemById(Long cid, Long id) {
        if (id == null || cid == null) {
            return null;
        }
        MatterItemVO vo = ((PmcCompanyMaterialMapper)this.dao).selectMatterItemById(id);
        if (vo == null) {
            return vo;
        }
        List useList = this.pmcMaterialUseInfoService.getUseInfoList(cid, vo.getId());
        vo.setUseList(useList);
        return vo;
    }

    public PageInfo<MatterItemVO> getMatterYearData(JqGridParam param) {
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        QueryMatterParam matter = new QueryMatterParam();
        matter.setCid(param.getCid());
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<MatterItemVO> matters = ((PmcCompanyMaterialMapper)this.dao).selectYearList(matter);
        String year = String.valueOf(LocalDate.now().getYear());
        boolean thisYear = matters.stream().anyMatch(i -> i.getYears().equals(year));
        if (!thisYear) {
            MatterItemVO view = new MatterItemVO();
            view.setYears(year);
            matters.add(view);
        }
        return new PageInfo(matters);
    }

    private List<String> getHarms(List<PmcMaterialHarmVO> harms, Integer harmType) {
        ArrayList<String> results = new ArrayList<String>();
        if (harms == null || harms.isEmpty()) {
            return results;
        }
        for (PmcMaterialHarmVO h : harms) {
            String harmName = h.getHarmName();
            if (harmType == 1) {
                String sameHarmName;
                if (StringUtils.isNotEmpty((String)harmName) && !results.contains(harmName)) {
                    results.add(harmName);
                }
                if (!StringUtils.isNotEmpty((String)(sameHarmName = h.getSameHarmName())) || results.contains(sameHarmName)) continue;
                results.add(sameHarmName);
                continue;
            }
            this.setHarmType2Name(h.getMaterialName(), results);
            this.setHarmType2Name(h.getHarmName(), results);
        }
        return results;
    }

    private void setHarmType2Name(String name, List<String> results) {
        if (StringUtils.isEmpty((CharSequence)name) || results.contains(name)) {
            return;
        }
        if ("\u77f3\u68c9".equals(name) || "\u77f3\u68c9\u7c89\u5c18".equals(name) || "\u77f3\u68c9\u7ea4\u7ef4".equals(name) || name.indexOf("\u77fd\u5c18") >= 0) {
            results.add(name);
        }
    }

    private List<Integer> getMeterialTypes(int meterialType) {
        ArrayList<Integer> meterialTypes = new ArrayList<Integer>();
        if (meterialType == 1) {
            MaterialTypeEnum[] types;
            for (MaterialTypeEnum t : types = MaterialTypeEnum.values()) {
                meterialTypes.add(t.getValue());
            }
            return meterialTypes;
        }
        if (meterialType == 2) {
            ProductTypeEnum[] types;
            for (ProductTypeEnum t : types = ProductTypeEnum.values()) {
                meterialTypes.add(t.getValue());
            }
            return meterialTypes;
        }
        return null;
    }

    @Deprecated
    @Transactional(readOnly=false)
    public void synMatter(Integer lastDate) {
        Date date = new Date();
        this.logger.info("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u62f7\u8d1d\u5f00\u59cb\u3011\u2014\u2014>{}", (Object)date);
        Integer count = ((PmcCompanyMaterialMapper)this.dao).selectCounts(lastDate);
        this.logger.info("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u62f7\u8d1d\u3011\u2014\u2014>{}\u5e74\u5171\u6709{}\u6761\u6570\u636e", (Object)lastDate, (Object)count);
        if (count == null || count == 0) {
            return;
        }
        int pageSize = 1000;
        int pages = (int)Math.ceil((double)count.intValue() / 1000.0);
        this.logger.info("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u62f7\u3011\u2014\u2014>\u5171{}\u6279", (Object)pages);
        for (int i = 1; i <= pages; ++i) {
            List<PmcCompanyMaterial> result = ((PmcCompanyMaterialMapper)this.dao).synMatterLastDate(lastDate, i, pageSize);
            if (CollectionUtils.isNotEmpty(result)) {
                result.stream().forEach(item -> {
                    item.setId(Long.valueOf(this.idworker.nextId()));
                    item.setCreateDate(date);
                });
            }
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                ((PmcCompanyMaterialMapper)this.dao).insertBatch(result);
                this.txManager.commit(status);
            }
            catch (Exception e) {
                this.txManager.rollback(status);
                e.printStackTrace();
                this.logger.error("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u62f7\u8d1d\u51fa\u9519\u3011\u2014\u2014>\u7b2c{}\u6279", (Object)i);
            }
            this.logger.info("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u62f7\u8d1d\u6210\u529f\u3011\u2014\u2014>\u7b2c{}\u6279", (Object)i);
        }
        this.logger.info("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u5168\u90e8\u62f7\u8d1d\u6210\u529f\u3011\u2014\u2014>lastDate:{}", (Object)lastDate);
    }

    @Transactional
    public Boolean synMatter2(Integer lastDate, Integer newDate) {
        Date date = new Date();
        this.logger.info("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u62f7\u8d1d\u5f00\u59cb\u3011\u2014\u2014>{}", (Object)DateUtils.getDateTime());
        Integer count = ((PmcCompanyMaterialMapper)this.dao).selectCounts(lastDate);
        this.logger.info("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u62f7\u8d1d\u3011\u2014\u2014>{}\u5e74\u5171\u6709{}\u6761\u6570\u636e", (Object)lastDate, (Object)count);
        if (count == null || count == 0) {
            return Boolean.TRUE;
        }
        List<PmcCompanyMaterial> result = ((PmcCompanyMaterialMapper)this.dao).synMatterLastDate(lastDate, null, null);
        if (CollectionUtils.isEmpty(result)) {
            return Boolean.FALSE;
        }
        int i = this.batchUpdateOrInsert(result, PmcCompanyMaterialMapper.class, (item, d) -> {
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setCreateDate(date);
            item.setUpdateDate(date);
            item.setDataYear(newDate);
            return d.insertSelective(item);
        });
        this.logger.info("\u3010\u4e3b\u8981\u7269\u6599\u4fe1\u606f\u62f7\u8d1d\u6210\u529f\u3011\u2014\u2014>lastDate:{}\u5e74\uff0c\u9700\u88ab\u62f7\u8d1d{}\u6761\u6570\u636e,\u5b9e\u9645\u88ab\u62f7\u8d1d{}\u6761\u6570\u636e", new Object[]{lastDate, count, i});
        return i == count ? Boolean.TRUE : Boolean.FALSE;
    }
}

