/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.device;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.device.DeviceTypeMapper;
import cn.smarthse.modules.health.entity.base.device.DeviceType;
import cn.smarthse.modules.health.service.base.device.IDeviceTypeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class DeviceTypeServiceImpl
extends BaseServiceImpl<DeviceTypeMapper, DeviceType>
implements IDeviceTypeService {
    @Autowired
    DeviceTypeMapper deviceTypeMapper;

    public List<DeviceType> getByCid(long cid) {
        return this.deviceTypeMapper.selectByCid(cid);
    }

    @Transactional(readOnly=false)
    public void del(String ids, Long staffId) {
        String[] arry = ids.split(",");
        DeviceType type = new DeviceType();
        type.setIsValid(Global.FALSE);
        if (arry.length > 1) {
            int legth = arry.length;
            for (int i = 0; i < legth; ++i) {
                type.setId(Long.valueOf(arry[i]));
                this.update(type, staffId);
            }
        } else if (arry.length == 1) {
            type.setId(Long.valueOf(arry[0]));
            this.update(type, staffId);
        }
    }

    public Map<String, DeviceType> getCompanyDeviceType(Long cid) {
        Example example = new Example(DeviceType.class);
        example.createCriteria().andEqualTo("cid", (Object)0).andEqualTo("isValid", (Object)true);
        if (cid != null) {
            example.or().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        }
        List typeList = this.getListByExample(example);
        HashMap<String, DeviceType> type = new HashMap<String, DeviceType>();
        for (DeviceType de : typeList) {
            type.put(de.getTypeName().toString(), de);
        }
        return type;
    }

    private List<DeviceType> getListForOccDisease(Long cid, Long id) {
        Example example = new Example(DeviceType.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("pid", (Object)id).andEqualTo("isValid", (Object)true);
        example.or().andIsNull("cid").andEqualTo("pid", (Object)id).andEqualTo("isValid", (Object)true);
        example.or().andEqualTo("cid", (Object)0).andEqualTo("pid", (Object)id).andEqualTo("isValid", (Object)true);
        List list = ((DeviceTypeMapper)this.dao).selectByExample(example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<DeviceType> sList = new ArrayList<DeviceType>();
        for (DeviceType d : list) {
            List<DeviceType> subList = this.getListForOccDisease(cid, d.getId());
            if (subList == null || subList.isEmpty()) continue;
            sList.addAll(subList);
        }
        list.addAll(sList);
        return list;
    }

    public List<DeviceType> getListForOccDisease(Long cid) {
        ArrayList<DeviceType> list = new ArrayList<DeviceType>();
        DeviceType occDisType = (DeviceType)this.getById(Constants.OCC_DISEASE_DEVICE_TYPE);
        if (occDisType == null) {
            return null;
        }
        list.add(occDisType);
        list.addAll(this.getListForOccDisease(cid, occDisType.getId()));
        return list;
    }

    public List<Long> getChildrenTypeIdsByPid(Long pid, Long cid) {
        if (pid == null || cid == null) {
            return null;
        }
        ArrayList<Long> allChildrenIds = new ArrayList<Long>();
        allChildrenIds.add(pid);
        ArrayList<Long> pids = new ArrayList<Long>();
        pids.add(pid);
        this.getChildrenTypeIdsByPid(pids, cid, allChildrenIds);
        return allChildrenIds;
    }

    private void getChildrenTypeIdsByPid(List<Long> pids, Long cid, List<Long> allChildrenIds) {
        if (pids == null || pids.isEmpty()) {
            return;
        }
        List<Long> childrenIds = ((DeviceTypeMapper)this.dao).getChildrenTypeIdsByPid(pids, cid);
        if (childrenIds == null || childrenIds.isEmpty()) {
            return;
        }
        allChildrenIds.addAll(childrenIds);
        this.getChildrenTypeIdsByPid(childrenIds, cid, allChildrenIds);
    }
}

