/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.device;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.base.device.DeviceMaintenanceMapper;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintainNum;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenance;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenanceVo;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenanceWorkItemVo;
import cn.smarthse.modules.health.entity.base.device.DeviceNoMaintainIgnore;
import cn.smarthse.modules.health.entity.base.device.NoMaintainDeviceVo;
import cn.smarthse.modules.health.entity.datascope.DataScope;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearSyncSO;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceService;
import cn.smarthse.modules.health.service.base.device.IDeviceNoMaintainIgnoreService;
import cn.smarthse.modules.health.service.base.device.IDeviceTypeService;
import cn.smarthse.modules.health.service.base.impl.device.DeviceMaintenanceFenceServiceImpl;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.summary.BaseSummaryService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.vo.base.DeptDeviceMaintainNum;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.summary.DeviceMaintenanceSummaryVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class DeviceMaintenanceServiceImpl
extends BaseServiceImpl<DeviceMaintenanceMapper, DeviceMaintenance>
implements IDeviceMaintenanceService,
BaseSummaryService {
    @Autowired
    DeviceMaintenanceMapper deviceMaintenanceMapper;
    @Autowired
    DeviceMaintenanceFenceServiceImpl deviceMaintenanceFenceServiceImpl;
    @Autowired
    IPlanYearDetailService iPlanYearDetailService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    private IDeviceTypeService deviceTypeService;
    @Autowired
    private IDeviceNoMaintainIgnoreService ignoreService;
    @Autowired
    ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;

    public PageInfo<DeviceMaintenance> getItemList(JqGridParam param, Boolean saveState) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        DeviceMaintenance maint = new DeviceMaintenance();
        maint.setCid(param.getCid());
        maint.setSaveState(saveState);
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            maint.setOrder(param.getSidx() + " " + param.getSord());
        } else {
            maint.setOrder("update_date desc");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("deviceMaintenance", "device_maintenance");
        List<DeviceMaintenance> list = this.deviceMaintenanceMapper.selectListByCid(maint);
        if (list == null || list.isEmpty()) {
            return new PageInfo(list);
        }
        for (DeviceMaintenance l : list) {
            if (l.getAcceptor() == null) continue;
            l.setAcceptorName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(l.getAcceptor()));
        }
        return new PageInfo(list);
    }

    private List<DeviceMaintenance> getList(DeviceMaintenance maint) {
        return this.deviceMaintenanceMapper.selectListByCid(maint);
    }

    public PageInfo<DeviceMaintenance> getItemList(JqGridParam param, Boolean saveState, Integer mainteYear) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        DeviceMaintenance maint = new DeviceMaintenance();
        maint.setCid(param.getCid());
        maint.setSaveState(saveState);
        maint.setMainteYear(mainteYear);
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            maint.setOrder(param.getSidx() + " " + param.getSord());
        } else {
            maint.setOrder("update_date desc");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DataScopeHelper.startDataScope("deviceMaintenance", "device_maintenance");
        List<DeviceMaintenance> list = this.getList(maint);
        if (list == null || list.isEmpty()) {
            return new PageInfo(list);
        }
        for (DeviceMaintenance l : list) {
            if (l.getAcceptor() == null) continue;
            l.setAcceptorName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(l.getAcceptor()));
        }
        return new PageInfo(list);
    }

    public List<DeviceMaintenance> getList(Long cid, Boolean saveState) {
        DeviceMaintenance maint = new DeviceMaintenance();
        maint.setCid(cid);
        maint.setSaveState(saveState);
        DataScopeHelper.startDataScope("deviceMaintenance", "device_maintenance");
        return this.deviceMaintenanceMapper.selectListByCid(maint);
    }

    private Integer getYearNum(Long cid) {
        Date time = ((DeviceMaintenanceMapper)this.dao).selectMaxMainteTimeByCid(cid);
        Date distanceDate = DateUtils.getDistanceDate((Date)time, (int)1, (int)1);
        Date tipDate = DateUtils.getDistanceDate((Date)distanceDate, (int)5, (int)-1);
        if (tipDate != null && tipDate.getTime() <= new Date().getTime()) {
            return 1;
        }
        return 0;
    }

    private Integer getProceNum(Long cid) {
        Example example = new Example(DeviceMaintenance.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("saveState", (Object)Global.FALSE);
        return ((DeviceMaintenanceMapper)this.dao).selectCountByExample(example);
    }

    private Integer getCompleteNum(Long cid) {
        Example example = new Example(DeviceMaintenance.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("saveState", (Object)Global.TRUE);
        return ((DeviceMaintenanceMapper)this.dao).selectCountByExample(example);
    }

    public DeviceMaintenanceWorkItemVo DeviceMaintenanceWorkItem(Long cid) {
        DeviceMaintenanceWorkItemVo item = new DeviceMaintenanceWorkItemVo();
        Integer yearNum = this.getYearNum(cid);
        item.setYearNum(yearNum);
        DataScopeHelper.startDataScope("deviceMaintenance", "device_maintenance");
        DataScope dataScope = DataScopeHelper.getDataScope();
        Integer proceNum = this.getProceNum(cid);
        item.setProceNum(proceNum);
        DataScopeHelper.setDataScope(dataScope);
        Integer completeNum = this.getCompleteNum(cid);
        item.setCompleteNum(completeNum);
        return item;
    }

    private Integer getMaintenanceNum(String beginDateStr, String endDateStr, Long cid, Boolean saveState) {
        Example example = new Example(DeviceMaintenance.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andBetween("mainteTime", (Object)beginDateStr, (Object)endDateStr).andEqualTo("saveState", (Object)saveState);
        return ((DeviceMaintenanceMapper)this.dao).selectCountByExample(example);
    }

    public BaseSummaryVO getSummaryData(Long cid, String year) {
        if (null == year || "".equals(year)) {
            return null;
        }
        String beginDateStr = year + "-01-01 00:00:00";
        String endDateStr = year + "-12-31 23:59:59";
        DeviceMaintenanceSummaryVo vo = new DeviceMaintenanceSummaryVo();
        Integer proceNum = this.getMaintenanceNum(beginDateStr, endDateStr, cid, Global.FALSE);
        vo.setProceNum(proceNum);
        Integer completeNum = this.getMaintenanceNum(beginDateStr, endDateStr, cid, Global.TRUE);
        vo.setCompleteNum(completeNum);
        Integer fenceDeviceNum = this.deviceMaintenanceFenceServiceImpl.getCountFenceDeviceNum(cid, year);
        vo.setFenceDeviceNum(fenceDeviceNum);
        return vo;
    }

    @Transactional(readOnly=false)
    public Long syncAddPlanYearByBL(PlanYearSyncSO detail) {
        DeviceMaintenance maint = new DeviceMaintenance();
        maint.setCid(detail.getCid());
        maint.setMainteReason(detail.getBusinessName());
        maint.setAcceptor(detail.getManagerId());
        maint.setRemark(detail.getBusinessContent());
        maint.setMainteTime(detail.getBusinessPlantime());
        maint.setOrgId(detail.getOrgId().toString());
        maint = this.add(maint, detail.getCreatorBy(), detail.getCid());
        if (null != maint.getId()) {
            this.sysCoreWorkModuleCorrelationService.businessStartPlan(CoreWorkEnum.protectionEquipmentMaintenance, maint.getId(), detail.getTipCreateBy(), detail.getCid(), detail.getBusinessName(), detail.getDetailId());
            return maint.getId();
        }
        return null;
    }

    public PageInfo<DeviceMaintenance> getMaintenanceList(JqGridParam gparam, DeviceMaintenanceVo param) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            param.setOrder(gparam.getSidx() + " " + gparam.getSord());
        } else {
            param.setOrder("update_date desc");
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<DeviceMaintenance> list = this.deviceMaintenanceMapper.selectMaintenanceList(param);
        if (list == null || list.isEmpty()) {
            return new PageInfo(list);
        }
        for (DeviceMaintenance l : list) {
            if (l.getAcceptor() == null) continue;
            l.setAcceptorName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(l.getAcceptor()));
        }
        return new PageInfo(list);
    }

    public PageInfo<NoMaintainDeviceVo> getNoMaintainDeviceList(JqGridParam jqGridParam, String deviceName, Long useAreaId, Long cid) {
        LocalDate now = LocalDate.now();
        LocalDateTime dateTime = DateUtil.getLocalDateTime((int)now.getYear(), (int)now.getMonthValue(), (int)1, (int)0, (int)0, (int)0);
        Date date = DateUtil.getDate((LocalDateTime)dateTime);
        List typeIds = this.deviceTypeService.getChildrenTypeIdsByPid(Long.valueOf(1L), cid);
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<NoMaintainDeviceVo> list = ((DeviceMaintenanceMapper)this.dao).getNoMaintainDeviceList(deviceName, useAreaId, date, cid, typeIds);
        return new PageInfo(list);
    }

    public PageInfo<NoMaintainDeviceVo> getMaintainDeviceList(JqGridParam jqGridParam, String deviceName, Long useAreaId, Long cid, Byte ifIgnore) {
        LocalDate now = LocalDate.now();
        LocalDateTime dateTime = DateUtil.getLocalDateTime((int)now.getYear(), (int)now.getMonthValue(), (int)1, (int)0, (int)0, (int)0);
        Date date = DateUtil.getDate((LocalDateTime)dateTime);
        List typeIds = this.deviceTypeService.getChildrenTypeIdsByPid(Long.valueOf(1L), cid);
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        if (ifIgnore == 0) {
            List<NoMaintainDeviceVo> list = ((DeviceMaintenanceMapper)this.dao).getNoMaintainDeviceList(deviceName, useAreaId, date, cid, typeIds);
            return new PageInfo(list);
        }
        List<NoMaintainDeviceVo> list = ((DeviceMaintenanceMapper)this.dao).getMaintainDeviceList(deviceName, useAreaId, date, cid, typeIds);
        if (CollectionUtil.isNotEmpty(list)) {
            for (NoMaintainDeviceVo noMaintainDeviceVo : list) {
                noMaintainDeviceVo.setOperatorName(SpringEncryptUtils.decrypt((String)noMaintainDeviceVo.getOperatorName()));
            }
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void ignoreDevice(Long deviceId, Long loginUserId) {
        DeviceNoMaintainIgnore ignore = new DeviceNoMaintainIgnore();
        ignore.setDeviceId(deviceId);
        ignore.setCreateDate(new Date());
        ignore.setOperator(loginUserId);
        this.ignoreService.add((Object)ignore);
    }

    @Transactional(readOnly=false)
    public void ignoreDevices(List<Long> deviceIds, Long loginUserId) {
        if (deviceIds == null || deviceIds.isEmpty()) {
            return;
        }
        deviceIds.forEach(deviceId -> {
            DeviceNoMaintainIgnore ignore = new DeviceNoMaintainIgnore();
            ignore.setDeviceId(deviceId);
            ignore.setCreateDate(new Date());
            ignore.setOperator(loginUserId);
            this.ignoreService.add((Object)ignore);
        });
    }

    @Transactional(readOnly=false)
    public void recoverDevice(Long id) {
        DeviceNoMaintainIgnore ignore = new DeviceNoMaintainIgnore();
        ignore.setId(id);
        ignore.setCreateDate(new Date());
        ignore.setIsValid(Byte.valueOf((byte)0));
        this.ignoreService.update((Object)ignore);
    }

    public PageInfo<DeptDeviceMaintainNum> countDeviceMaintainByDept(int pageNum, int pageSize, List<Long> deptIds, Date startDate, Date endDate, Long cid) {
        List<DeviceMaintainNum> list = ((DeviceMaintenanceMapper)this.dao).selectDeviceMaintainNum(null, deptIds, null, null, null, null, null, startDate, endDate, cid, this.deviceTypeService.getChildrenTypeIdsByPid(Long.valueOf(1L), cid));
        DeptDeviceMaintainNum allDept = new DeptDeviceMaintainNum();
        allDept.setDeptId("0");
        allDept.setDeptName("\u5168\u5382");
        List<DeptDeviceMaintainNum> deptList = this.parseDept(list, allDept);
        deptList.sort(Comparator.comparingInt(item -> item.getMaintainDeviceNum() / item.getDeviceNum()));
        ArrayList<DeptDeviceMaintainNum> resList = new ArrayList<DeptDeviceMaintainNum>();
        if (deptIds == null) {
            resList.add(allDept);
        }
        resList.addAll(deptList);
        return PageUtil.getPageInfo(resList, (int)pageNum, (int)pageSize);
    }

    public PageInfo<DeviceMaintainNum> countDeviceMaintainNum(int pageNum, int pageSize, Long deptId, Long typeId, String deviceName, String deviceNo, String deviceModel, Long managerId, Date startDate, Date endDate, Long cid) {
        List<DeviceMaintainNum> list = ((DeviceMaintenanceMapper)this.dao).selectDeviceMaintainNum(deptId, null, typeId, deviceName, deviceNo, deviceModel, managerId, startDate, endDate, cid, this.deviceTypeService.getChildrenTypeIdsByPid(Long.valueOf(1L), cid));
        Long months = DateUtil.caculateMonths((LocalDate)DateUtil.getFromDate((Date)startDate).toLocalDate(), (LocalDate)DateUtil.getFromDate((Date)endDate).toLocalDate());
        int num = months.intValue() + 1;
        list.sort(Comparator.comparingInt(item -> item.getMaintainNum() / num));
        list.forEach(item -> item.setShouldMaintainNum(Integer.valueOf(num)));
        return PageUtil.getPageInfo(list, (int)pageNum, (int)pageSize);
    }

    private List<DeptDeviceMaintainNum> parseDept(List<DeviceMaintainNum> deviceList, DeptDeviceMaintainNum allDept) {
        allDept.setDeviceNum(Integer.valueOf(0));
        allDept.setMaintainDeviceNum(Integer.valueOf(0));
        ArrayList<DeptDeviceMaintainNum> deptList = new ArrayList<DeptDeviceMaintainNum>();
        DeptDeviceMaintainNum dept = null;
        HashMap<String, DeptDeviceMaintainNum> map = new HashMap<String, DeptDeviceMaintainNum>();
        for (DeviceMaintainNum item : deviceList) {
            Integer maintainNum = item.getMaintainNum().equals(0) ? 0 : 1;
            allDept.setDeviceNum(Integer.valueOf(allDept.getDeviceNum() + 1));
            allDept.setMaintainDeviceNum(Integer.valueOf(allDept.getMaintainDeviceNum() + maintainNum));
            if (item.getUseareaname() == null || "".equals(item.getUseareaname())) continue;
            for (int i = 0; i < item.getUseareaname().split(",").length; ++i) {
                String area = item.getUseareaname().split(",")[i];
                if (map.containsKey(area)) {
                    dept = (DeptDeviceMaintainNum)map.get(area);
                    dept.setDeviceNum(Integer.valueOf(dept.getDeviceNum() + 1));
                    dept.setMaintainDeviceNum(Integer.valueOf(dept.getMaintainDeviceNum() + maintainNum));
                } else {
                    dept = new DeptDeviceMaintainNum();
                    dept.setDeptId(item.getUseAreaId().split(",")[i]);
                    dept.setDeptName(area);
                    dept.setDeviceNum(Integer.valueOf(1));
                    dept.setMaintainDeviceNum(maintainNum);
                }
                map.put(area, dept);
            }
        }
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            deptList.add((DeptDeviceMaintainNum)iter.next().getValue());
        }
        return deptList;
    }
}

