/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.device;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.dao.base.device.DeviceMaintenanceFenceViewMapper;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenanceFenceView;
import cn.smarthse.modules.health.entity.base.device.DeviceType;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.device.IDeviceInfoService;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceFenceViewService;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceFireService;
import cn.smarthse.modules.health.service.base.device.IDeviceTypeService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class DeviceMaintenanceFenceViewServiceImpl
extends BaseServiceImpl<DeviceMaintenanceFenceViewMapper, DeviceMaintenanceFenceView>
implements IDeviceMaintenanceFenceViewService {
    @Autowired
    DeviceMaintenanceFenceViewMapper deviceMaintenanceFenceViewMapper;
    @Autowired
    IDeviceMaintenanceFireService deviceMaintenanceFireService;
    @Autowired
    IDeviceInfoService deviceInfoService;
    @Autowired
    ICompanyOrganizationService orgService;
    @Autowired
    IStaffInfoService staffInfoService;
    @Autowired
    IDeviceTypeService deviceTypeService;

    public List<DeviceMaintenanceFenceView> getListByCid(Long cid, String year) {
        if (null == year || "".equals(year)) {
            return null;
        }
        String beginDateStr = year + "-01-01 00:00:00";
        String endDateStr = year + "-12-31 23:59:59";
        Date date = DateUtils.parseDate((Object)endDateStr);
        Example example = new Example(DeviceMaintenanceFenceView.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andBetween("mainteTime", (Object)beginDateStr, (Object)endDateStr);
        List list = this.deviceMaintenanceFenceViewMapper.selectByExample(example);
        List<Long> occTypeIdList = this.getOccTypes(cid);
        ArrayList<DeviceMaintenanceFenceView> result = new ArrayList<DeviceMaintenanceFenceView>();
        for (DeviceMaintenanceFenceView dmfv : list) {
            DeviceMaintenanceFenceView dv;
            if (dmfv == null || (dv = this.getDeviceHistoryInfos(dmfv, date, occTypeIdList)) == null) continue;
            result.add(dv);
        }
        return result;
    }

    private List<Long> getOccTypes(Long cid) {
        ArrayList<Long> typeIdList = new ArrayList<Long>();
        List typeList = this.deviceTypeService.getListForOccDisease(cid);
        if (typeList == null || typeList.isEmpty()) {
            return typeIdList;
        }
        for (DeviceType dt : typeList) {
            typeIdList.add(dt.getId());
        }
        return typeIdList;
    }

    private DeviceMaintenanceFenceView getDeviceHistoryInfos(DeviceMaintenanceFenceView l, Date date, List<Long> occTypeIdList) {
        return null;
    }

    private DeviceMaintenanceFenceView createDeviceFenceView(DeviceMaintenanceFenceView l) {
        DeviceMaintenanceFenceView v = new DeviceMaintenanceFenceView();
        v.setMainteTime(l.getMainteTime());
        v.setCid(l.getCid());
        v.setFileIds(l.getFileIds());
        v.setFilenames(l.getFilenames());
        v.setMainteReason(l.getMainteReason());
        v.setDeviceId(l.getDeviceId());
        return v;
    }
}

