/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.device;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.base.device.DeviceMaintenanceFenceMapper;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenanceFence;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceFenceService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class DeviceMaintenanceFenceServiceImpl
extends BaseServiceImpl<DeviceMaintenanceFenceMapper, DeviceMaintenanceFence>
implements IDeviceMaintenanceFenceService {
    @Autowired
    DeviceMaintenanceFenceMapper deviceMaintenanceFenceMapper;
    @Autowired
    ICompanyOrganizationService orgService;

    public PageInfo<DeviceMaintenanceFence> getItemList(JqGridParam param, Long maintId) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        DeviceMaintenanceFence maint = new DeviceMaintenanceFence();
        maint.setCid(param.getCid());
        maint.setMaintenanceId(maintId);
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            maint.setOrder(param.getSidx() + " " + param.getSord());
        } else {
            maint.setOrder("update_date desc");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<DeviceMaintenanceFence> list = this.deviceMaintenanceFenceMapper.selectListByMaintenanceId(maint);
        if (list == null || list.isEmpty()) {
            return new PageInfo(list);
        }
        for (DeviceMaintenanceFence l : list) {
            if (l.getUseAreaId() == null) continue;
            String orgName = this.getOrgName(l.getUseAreaId());
            l.setUseareaname(orgName.substring(0, orgName.length() - 1));
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void adds(String ids, String miantId, Long cid, Long staffId) {
        if (ids != null) {
            String[] deviceIds = ids.split(",");
            DeviceMaintenanceFence fence = new DeviceMaintenanceFence();
            fence.setMaintenanceId(Long.valueOf(miantId));
            int length = deviceIds.length;
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    DeviceMaintenanceFence deviceFence = this.getByMintId(miantId, deviceIds[i]);
                    if (deviceFence == null) {
                        fence.setDeviceId(Long.valueOf(deviceIds[i]));
                        this.add(fence, staffId, cid);
                    }
                    fence.setId(null);
                }
            }
        }
    }

    private DeviceMaintenanceFence getByMintId(String miantId, String deviceId) {
        Example example = new Example(DeviceMaintenanceFence.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("maintenanceId", (Object)miantId).andEqualTo("deviceId", (Object)deviceId);
        List list = this.deviceMaintenanceFenceMapper.selectByExample(example);
        if (list.size() > 0) {
            return (DeviceMaintenanceFence)list.get(0);
        }
        return null;
    }

    public DeviceMaintenanceFence getFencDeviceById(Long id) {
        if (null == id) {
            return null;
        }
        DeviceMaintenanceFence data = this.deviceMaintenanceFenceMapper.selectFenceDeviceById(id);
        if (data != null && data.getUseAreaId() != null) {
            String orgName = this.getOrgName(data.getUseAreaId());
            data.setUseareaname(orgName.substring(0, orgName.length() - 1));
        }
        return data;
    }

    public Integer getCountFenceDeviceNum(Long cid, String year) {
        if (null == year || "".equals(year)) {
            return null;
        }
        String beginDateStr = year + "-01-01 00:00:00";
        String endDateStr = year + "-12-31 23:59:59";
        return this.deviceMaintenanceFenceMapper.selectCountFenceDeviceNum(cid.toString(), beginDateStr, endDateStr);
    }

    private String getOrgName(String userAreaIds) {
        String[] userAreaIdArr;
        Object orgName = "";
        for (String userAreaId : userAreaIdArr = userAreaIds.split(",")) {
            String orgNameById = this.orgService.getOrgNameById(Long.valueOf(userAreaId));
            orgName = orgNameById + "," + (String)orgName;
        }
        return orgName;
    }
}

