/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.device;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.utils.JqgridSearchUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.base.device.DeviceListViewMapper;
import cn.smarthse.modules.health.entity.base.device.DeviceInfo;
import cn.smarthse.modules.health.entity.base.device.DeviceListView;
import cn.smarthse.modules.health.entity.base.device.DeviceType;
import cn.smarthse.modules.health.enums.device.DeviceStateEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.device.IDeviceListViewService;
import cn.smarthse.modules.health.service.base.device.IDeviceTypeService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.vo.base.historyBasic.BasicEntityContentSearch;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class DeviceListViewServiceImpl
extends BaseServiceImpl<DeviceListViewMapper, DeviceListView>
implements IDeviceListViewService {
    @Autowired
    DeviceListViewMapper deviceListViewMapper;
    @Autowired
    ICompanyAreaService areaService;
    @Autowired
    IDeviceTypeService deviceTypeService;
    @Autowired
    ICompanyOrganizationService orgService;
    @Autowired
    IWorkRoleInfoService workRoleService;
    @Autowired
    IStaffInfoService staffInfoService;
    private final Long devicefhTypeId = 1L;
    @Autowired
    IOccupationalRiskFactorsService riskService;

    public PageInfo<DeviceListView> getDeviceInfoItemList(JqGridParam param) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        DeviceListView device = new DeviceListView();
        device.setCid(param.getCid());
        if (param.getYears() != null && !param.getYears().equals("")) {
            device.setYears(param.getYears());
        }
        this.search(param, device);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<DeviceListView> devices = this.deviceListViewMapper.selectList(device);
        this.setInstallAreaFullName(devices);
        return new PageInfo(devices);
    }

    public PageInfo<DeviceListView> getDeviceInfoItemListNotType(JqGridParam param, Long notTypeId) {
        if (param.getCid() == null || param.getCid() == 0L || notTypeId == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Example example = new Example(DeviceListView.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)param.getCid()).andNotEqualTo("typeId", (Object)notTypeId).andEqualTo("isValid", (Object)true).andNotEqualTo("isDevicefh", (Object)true);
        JqgridSearchUtil.addAndCriteriaAll(criteria, param);
        return new PageInfo(((DeviceListViewMapper)this.dao).selectByExample(example));
    }

    private void search(JqGridParam gparam, DeviceListView device) {
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                List<Long> allTypeIds;
                if ("keyword".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    device.setKeyword(sField.getSearchValue());
                    continue;
                }
                if ("typeId".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    device.setTypeId(Long.valueOf(sField.getSearchValue()));
                    continue;
                }
                if ("useAreaId".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    device.setUseAreaId(sField.getSearchValue());
                    continue;
                }
                if ("deviceState".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    device.setDeviceState(Byte.valueOf(sField.getSearchValue()));
                    continue;
                }
                if ("isDevicefh".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    allTypeIds = this.getAllTypeIds(1L, device.getCid());
                    if (sField.getSearchValue().equals("1")) {
                        device.setChildrenTypeIds(allTypeIds);
                        continue;
                    }
                    device.setExcludeTypeIds(allTypeIds);
                    continue;
                }
                if ("isSpecial".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    Boolean isSpecial = null;
                    isSpecial = sField.getSearchValue().equals("1") ? Global.TRUE : Global.FALSE;
                    device.setIsSpecial(isSpecial);
                    continue;
                }
                if ("isRadiation".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    Boolean isRadiation = null;
                    isRadiation = sField.getSearchValue().equals("1") ? Global.TRUE : Global.FALSE;
                    device.setIsRadiation(isRadiation);
                    continue;
                }
                if ("isHarm".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    Boolean isHarm = null;
                    isHarm = sField.getSearchValue().equals("1") ? Global.TRUE : Global.FALSE;
                    device.setIsHarm(isHarm);
                    continue;
                }
                if ("onlyCommonly".equals(sField.getSearchField())) {
                    device.setOnlyCommonly(Boolean.valueOf(true));
                    continue;
                }
                if ("typePid".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    allTypeIds = this.getAllTypeIds(Long.valueOf(sField.getSearchValue()), device.getCid());
                    device.setChildrenTypeIds(allTypeIds);
                    continue;
                }
                if ("orgIds".equals(sField.getSearchField())) {
                    if (!StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                    device.setUseOrgIds(StringUtils.parseToLongList((String)sField.getSearchValue()));
                    continue;
                }
                if (!"managerIds".equals(sField.getSearchField()) || !StringUtils.isNotEmpty((String)sField.getSearchValue())) continue;
                device.setManagerIds(StringUtils.parseToLongList((String)sField.getSearchValue()));
            }
        }
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            device.setOrder(gparam.getSidx() + " " + gparam.getSord());
        } else {
            device.setOrder("create_date desc");
        }
    }

    private List<Long> getAllTypeIds(Long pid, Long cid) {
        List allTypeIds = this.deviceTypeService.getChildrenTypeIdsByPid(pid, cid);
        return allTypeIds;
    }

    public List<DeviceListView> getGeneralDeviceList(Long cid) {
        DeviceListView device = new DeviceListView();
        device.setCid(cid);
        device.setOrder("update_date desc");
        List<DeviceListView> devices = this.deviceListViewMapper.selectGeneralList(device);
        this.setInstallAreaFullName(devices);
        return devices;
    }

    public List<DeviceListView> getProtectionDeviceList(Long cid) {
        DeviceListView device = new DeviceListView();
        device.setCid(cid);
        device.setOrder("update_date desc");
        List<DeviceListView> devices = this.deviceListViewMapper.selectProtectionList(device);
        this.setInstallAreaFullName(devices);
        return devices;
    }

    public List<DeviceListView> getListByCid(Long cid) {
        DeviceListView device = new DeviceListView();
        device.setCid(cid);
        device.setOrder("update_date desc");
        List<DeviceListView> devices = this.deviceListViewMapper.selectList(device);
        this.setInstallAreaFullName(devices);
        return devices;
    }

    private void setInstallAreaFullName(List<DeviceListView> devices) {
        if (devices == null) {
            return;
        }
        for (DeviceListView d : devices) {
            d.setStrId("" + d.getId());
            d.setWorkrolenames(this.getWorkNamesByWorkIds(d.getWorkIds(), ","));
            d.setInstallAreaFullName(this.areaService.getAreaFullName(d.getInstallAreaId()));
            if (d.getManagerid() == null) continue;
            d.setManagerName(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(d.getManagerid()));
        }
    }

    private String getWorkNamesByWorkIds(String workIds, String splitor) {
        List workIdArray = StringUtils.parseToLongList((String)workIds, (String)splitor);
        if (workIdArray == null || workIdArray.isEmpty()) {
            return "";
        }
        ArrayList<String> workNames = new ArrayList<String>();
        Object result = "";
        for (Long id : workIdArray) {
            String name = this.workRoleService.getWorkNameIncludeOrgName(id);
            if (StringUtils.isEmpty((CharSequence)name) || workNames.contains(name)) continue;
            workNames.add(name);
            result = (String)result + name + splitor;
        }
        int len = ((String)result).length();
        if (len > 0) {
            result = ((String)result).substring(0, len - 1);
        }
        return result;
    }

    public PageInfo<DeviceListView> getDeviceProtectionItemList(JqGridParam param) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        DeviceListView device = new DeviceListView();
        device.setCid(param.getCid());
        this.search(param, device);
        List<DeviceListView> list = this.deviceListViewMapper.selectList(device);
        if (list == null || list.isEmpty()) {
            return new PageInfo(list);
        }
        return new PageInfo(list);
    }

    public List<DeviceListView> getDeviceInfoList(Long cid) {
        DeviceListView device = new DeviceListView();
        device.setCid(cid);
        device.setIsValid(Global.TRUE);
        return this.deviceListViewMapper.selectList(device);
    }

    public List<DeviceListView> getDeviceList(Long cid, String year) {
        try {
            return this.getHistoryDeviceInfoList(cid, year);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<DeviceListView> selectDeviceListByYear(Long cid, Integer year) {
        if (cid == null || year == null) {
            Collections.emptyList();
        }
        return ((DeviceListViewMapper)this.dao).selectDeviceListByYear(cid, year);
    }

    public List<DeviceListView> getHistoryDeviceList(Long cid, String year) {
        String dateStr = year + "-12-31 23:59:59";
        Date date = DateUtils.parseDate((Object)dateStr);
        List<Long> allTypeIds = this.getAllTypeIds(this.devicefhTypeId, cid);
        ArrayList<DeviceListView> results = new ArrayList<DeviceListView>();
        return results;
    }

    private List<DeviceListView> getHistoryDeviceInfoList(Long cid, String year) {
        String dateStr = year + "-12-31 23:59:59";
        Date date = DateUtils.parseDate((Object)dateStr);
        List<Long> allTypeIds = this.getAllTypeIds(this.devicefhTypeId, cid);
        ArrayList<DeviceListView> results = new ArrayList<DeviceListView>();
        return results;
    }

    private DeviceListView convertDeviceToView(DeviceInfo d, Date date, Long cid) {
        DeviceListView view = new DeviceListView();
        view.setDeviceName(d.getDeviceName());
        view.setDeviceNo(d.getDeviceNo());
        view.setDeviceModel(d.getDeviceModel());
        view.setUseareaname(this.getUseareanam(d.getUseAreaId(), date));
        view.setWorkrolenames(this.getWorkRoleNames(d.getId(), cid, date));
        view.setHarmNames(this.getHarmNames(d.getId(), cid, date));
        view.setPurpose(d.getPurpose());
        view.setInstaller(d.getInstaller());
        view.setSupplier(d.getSupplier());
        view.setManufacturer(d.getManufacturer());
        view.setAcceptTime(d.getAcceptTime());
        return view;
    }

    private String getHarmNames(Long deviceId, Long cid, Date date) {
        String harmNames = "";
        ArrayList<BasicEntityContentSearch> search = new ArrayList<BasicEntityContentSearch>();
        BasicEntityContentSearch s = new BasicEntityContentSearch();
        s.setKey("deviceId");
        s.setValue((Object)deviceId);
        search.add(s);
        if (harmNames.length() > 1) {
            harmNames = harmNames.substring(0, harmNames.length() - 1);
        }
        return harmNames;
    }

    private String getWorkRoleNames(Long deviceId, Long cid, Date date) {
        String workRoleNames = "";
        ArrayList<BasicEntityContentSearch> search = new ArrayList<BasicEntityContentSearch>();
        BasicEntityContentSearch s = new BasicEntityContentSearch();
        s.setKey("deviceId");
        s.setValue((Object)deviceId);
        search.add(s);
        if (workRoleNames.length() > 1) {
            workRoleNames = workRoleNames.substring(0, workRoleNames.length() - 1);
        }
        return workRoleNames;
    }

    private String getUseareanam(Long useAreaId, Date date) {
        return this.orgService.getHistoryOrgNameByOrgIdAndYear(useAreaId, date);
    }

    private boolean isScraped(Long deviceState, Date scrapTime, String year) {
        Date date = DateUtils.parseDate((Object)(year + "-01-01 00:00:00"));
        if (deviceState == null || deviceState.intValue() != DeviceStateEnum.scrapped.getValue().intValue()) {
            return false;
        }
        if (scrapTime == null) {
            return true;
        }
        return date == null || date.getTime() > scrapTime.getTime();
    }

    private boolean isScraped(Byte deviceState, Date scrapTime, Date date) {
        if (deviceState == null || deviceState.intValue() != DeviceStateEnum.scrapped.getValue().intValue()) {
            return true;
        }
        if (scrapTime == null) {
            return false;
        }
        return date != null && date.getTime() < scrapTime.getTime();
    }

    public List<DeviceListView> getDeviceByIsHarmList(Long cid, String year) {
        try {
            return this.getHistoryDeviceInfoByIsHarmList(cid, year);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Long> getOccTypes(Long cid) {
        ArrayList<Long> typeIdList = new ArrayList<Long>();
        List typeList = this.deviceTypeService.getListForOccDisease(cid);
        if (typeList == null || typeList.isEmpty()) {
            return typeIdList;
        }
        for (DeviceType dt : typeList) {
            typeIdList.add(dt.getId());
        }
        return typeIdList;
    }

    private List<DeviceListView> getHistoryDeviceInfoByIsHarmList(Long cid, String year) {
        String dateStr = year + "-12-31 23:59:59";
        Date date = DateUtils.parseDate((Object)dateStr);
        ArrayList<DeviceListView> results = new ArrayList<DeviceListView>();
        return results;
    }

    public List<DeviceListView> getHistoryDeviceByIsHarmList(Long cid, String year) {
        String dateStr = year + "-12-31 23:59:59";
        Date date = DateUtils.parseDate((Object)dateStr);
        ArrayList<DeviceListView> results = new ArrayList<DeviceListView>();
        return results;
    }

    public List<DeviceListView> getDeviceByWorkId(Long cid, Long workId) {
        DeviceListView device = new DeviceListView();
        device.setCid(cid);
        List<Long> allTypeIds = this.getAllTypeIds(this.devicefhTypeId, cid);
        device.setChildrenTypeIds(allTypeIds);
        device.setWorkIds(workId.toString());
        device.setIsValid(Global.TRUE);
        return this.deviceListViewMapper.selectList(device);
    }

    public int getDeviceNumByTypePid(Long cid, Long typePid) {
        DeviceListView device = new DeviceListView();
        device.setCid(cid);
        List<Long> allTypeIds = this.getAllTypeIds(typePid, cid);
        device.setChildrenTypeIds(allTypeIds);
        List<DeviceListView> devices = this.deviceListViewMapper.selectList(device);
        return devices == null ? 0 : devices.size();
    }

    public PageInfo<DeviceListView> getDeviceYearData(JqGridParam param) {
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        DeviceListView device = new DeviceListView();
        device.setCid(param.getCid());
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<DeviceListView> devices = this.deviceListViewMapper.selectYearList(device);
        String year = String.valueOf(LocalDate.now().getYear());
        boolean thisYear = devices.stream().anyMatch(i -> i.getYears().equals(year));
        if (!thisYear) {
            DeviceListView view = new DeviceListView();
            view.setYears(year);
            devices.add(view);
        }
        return new PageInfo(devices);
    }
}

