/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.device;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.dao.base.device.DeviceInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.device.DeviceHarmfactor;
import cn.smarthse.modules.health.entity.base.device.DeviceInfo;
import cn.smarthse.modules.health.entity.base.device.DeviceSpecial;
import cn.smarthse.modules.health.entity.base.device.DeviceType;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.enums.device.DeviceStateEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.device.IDeviceHarmfactorService;
import cn.smarthse.modules.health.service.base.device.IDeviceInfoService;
import cn.smarthse.modules.health.service.base.device.IDeviceListViewService;
import cn.smarthse.modules.health.service.base.device.IDeviceSpecialService;
import cn.smarthse.modules.health.service.base.device.IDeviceTypeService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class DeviceInfoServiceImpl
extends BaseServiceImpl<DeviceInfoMapper, DeviceInfo>
implements IDeviceInfoService {
    @Autowired
    DeviceInfoMapper deviceInfoMapper;
    @Autowired
    IDeviceTypeService deviceTypeService;
    @Autowired
    private IDeviceHarmfactorService deviceHarmfactorService;
    @Autowired
    private IOccupationalRiskFactorsService factorsService;
    @Autowired
    private IDeviceSpecialService deviceSpecialService;
    @Autowired
    private ISysCoreWorkModuleCorrelationService coreWorkCorrelationService;
    @Autowired
    private ICompanyAreaService areaService;
    @Autowired
    private IDeviceListViewService deviceListViewService;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService occupationalRiskFactorsService;

    @Transactional(readOnly=false)
    public List<ResponseData<Object>> getDeviceInfoFromExcel2(String ossfile, Long cid, Long loginStaffId) {
        ArrayList<ResponseData<Object>> list = new ArrayList<ResponseData<Object>>();
        HSSFWorkbook wb = null;
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception e) {
            throw new HealthException("\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165\uff01");
        }
        HSSFSheet sheet = wb.getSheetAt(0);
        HSSFSheet sheet2 = wb.getSheetAt(1);
        ResponseData<Object> data = this.parseDeviceInfromExcel(sheet, cid, loginStaffId);
        list.add(data);
        ResponseData<Object> data2 = this.parseDeviceInfromExcel2(sheet2, cid, loginStaffId);
        list.add(data2);
        try {
            wb.close();
        }
        catch (IOException e) {
            throw new HealthException("\u5bfc\u5165\u5f02\u5e38\uff0c\u6587\u4ef6\u5173\u95ed\u5931\u8d25\u3002");
        }
        return list;
    }

    @Transactional(readOnly=false)
    public ResponseData<Object> getDeviceInfoFromExcel(String ossfile, Long cid, Long loginStaffId) {
        HSSFWorkbook wb = null;
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception e) {
            throw new HealthException("\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u5bfc\u5165\uff01");
        }
        HSSFSheet sheet = wb.getSheetAt(0);
        ResponseData<Object> data = this.parseDeviceInfromExcel(sheet, cid, loginStaffId);
        try {
            wb.close();
        }
        catch (IOException e) {
            throw new HealthException("\u5bfc\u5165\u5f02\u5e38\uff0c\u6587\u4ef6\u5173\u95ed\u5931\u8d25\u3002");
        }
        return data;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public ResponseData<Object> parseDeviceInfromExcel(HSSFSheet sheet, Long cid, Long loginStaffId) {
        rowIndex = 0;
        data = new ResponseData();
        type = this.deviceTypeService.getCompanyDeviceType(cid);
        workRoleInfos = this.workRoleInfoService.getWorkRoleInfosByCidAndSearch(cid, "", null);
        workRoles = new HashMap<K, V>();
        workRoleInfos.forEach((Consumer<WorkRoleInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$parseDeviceInfromExcel$0(java.util.Map cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo ), (Lcn/smarthse/modules/health/entity/base/workinfo/WorkRoleInfo;)V)(workRoles));
        harmMap = this.occupationalRiskFactorsService.getAllNameAndIdMap();
        StaffInfos = this.staffInfoService.getStaffInfosByOrgId(cid, null, "");
        StaffRealNames = new ArrayList<E>();
        StaffInfos.forEach((Consumer<StaffInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$parseDeviceInfromExcel$1(java.util.List cn.smarthse.modules.health.entity.base.staff.StaffInfo ), (Lcn/smarthse/modules/health/entity/base/staff/StaffInfo;)V)(StaffRealNames));
        hasError = false;
        errorContentList = new ArrayList<CallSite>();
        list = new ArrayList<DeviceInfo>();
        iter = sheet.rowIterator();
        while (iter.hasNext()) {
            row = (Row)iter.next();
            if (++rowIndex == 1 || !this.thisRowRequireIsNotBlank(row) && this.thisRowNotRequireIsBlank(row) || row.getCell(0) == null && row.getCell(1) == null && row.getCell(2) == null) continue;
            device = new DeviceInfo();
            device.setIsHarm(Global.FALSE);
            device.setIsDevicefh(Boolean.valueOf(false));
            device.setTypeId(Long.valueOf(2L));
            cellCount = 9;
            colIndex = 0;
            block37: for (i = 0; i < cellCount; ++i) {
                cell = row.getCell(i);
                if (cell != null && i != 5 && cell.getCellType() != CellType.BLANK) {
                    cell.setCellType(CellType.STRING);
                }
                ++colIndex;
                if (cell == null || cell.getCellType() == CellType.BLANK) {
                    switch (i) {
                        case 1: {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8bbe\u5907\u7f16\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                            break;
                        }
                        case 2: {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8bbe\u5907\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                            break;
                        }
                        case 3: {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u4f7f\u7528\u5c97\u4f4d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                            break;
                        }
                        case 4: {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u751f\u4ea7\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                            break;
                        }
                        case 5: {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u9a8c\u6536\u65e5\u671f\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                            break;
                        }
                        case 6: {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",\u72b6\u6001\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                            break;
                        }
                        case 7: {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",\u662f\u5426\u653e\u5c04\u8bbe\u5907\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                        }
                    }
                    continue;
                }
                switch (i) {
                    case 0: {
                        ID = null;
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK && StringUtils.isNotEmpty((String)cell.getStringCellValue().trim()) && ((deviceInfo = (DeviceInfo)this.getById(ID = Long.valueOf(cell.getStringCellValue().trim()))) == null || !deviceInfo.getIsValid().booleanValue())) {
                                errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", ID\u4e0d\u5b58\u5728"));
                                hasError = true;
                            }
                            ** GOTO lbl81
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", ID\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                        }
                        continue block37;
lbl81:
                        // 1 sources

                        device.setId(ID);
                        continue block37;
                    }
                    case 1: {
                        try {
                            deviceNo = cell.getStringCellValue().trim();
                            if (deviceNo != null && !"".equals(deviceNo) && device.getId() == null && (info = this.getDeviceByNo(deviceNo, cid)) != null) {
                                errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",\u8bbe\u5907\u7f16\u53f7\u5df2\u5b58\u5728"));
                                hasError = true;
                            }
                            ** GOTO lbl97
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8bbe\u5907\u7f16\u53f7\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                        }
                        continue block37;
lbl97:
                        // 1 sources

                        device.setDeviceNo(deviceNo);
                        continue block37;
                    }
                    case 2: {
                        try {
                            name = cell.getStringCellValue().trim();
                        }
                        catch (Exception e2) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8bbe\u5907\u8bbe\u65bd\u540d\u79f0\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block37;
                        }
                        device.setDeviceName(name);
                        continue block37;
                    }
                    case 3: {
                        workrolenames = null;
                        stringBuffer = new StringBuffer();
                        try {
                            workrolenames = cell.getStringCellValue().trim();
                            workrolenames = workrolenames.replaceAll("\uff0c", ",");
                            split = workrolenames.split(",");
                            for (j = 0; j < split.length; ++j) {
                                if (!workRoles.containsValue(split[j])) {
                                    errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + "," + split[j] + "\u4f7f\u7528\u5c97\u4f4d\u4e0d\u5b58\u5728"));
                                    hasError = true;
                                    continue;
                                }
                                for (Map.Entry<K, V> m : workRoles.entrySet()) {
                                    if (!((String)m.getValue()).equals(split[j])) continue;
                                    stringBuffer.append(String.valueOf(m.getKey()) + ",");
                                }
                            }
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u4f7f\u7528\u5c97\u4f4d\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block37;
                        }
                        device.setWorkrolenames(stringBuffer.toString());
                        continue block37;
                    }
                    case 4: {
                        try {
                            manufacturer = cell.getStringCellValue().trim();
                        }
                        catch (Exception e2) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block37;
                        }
                        device.setManufacturer(manufacturer);
                        continue block37;
                    }
                    case 5: {
                        DeviceInfoServiceImpl.dateHandle(cell);
                        if (cell.getCellType() == CellType.BLANK) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u9a8c\u6536\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block37;
                        }
                        device.setAcceptTime(cell.getDateCellValue());
                        continue block37;
                    }
                    case 6: {
                        deviceStateName = null;
                        try {
                            deviceStateName = cell.getStringCellValue().trim();
                            if (deviceStateName.equals("\u6b63\u5e38")) {
                                device.setDeviceState(Long.valueOf(DeviceStateEnum.normal.getValue().intValue()));
                                continue block37;
                            }
                            if (deviceStateName.equals("\u6545\u969c")) {
                                device.setDeviceState(Long.valueOf(DeviceStateEnum.malfunction.getValue().intValue()));
                                continue block37;
                            }
                            if (deviceStateName.equals("\u7ef4\u4fee")) {
                                device.setDeviceState(Long.valueOf(DeviceStateEnum.Maintenance.getValue().intValue()));
                                continue block37;
                            }
                            if (deviceStateName.equals("\u62a5\u5e9f")) {
                                device.setDeviceState(Long.valueOf(DeviceStateEnum.scrapped.getValue().intValue()));
                                continue block37;
                            }
                            if (!deviceStateName.equals("\u5176\u4ed6")) continue block37;
                            device.setDeviceState(Long.valueOf(DeviceStateEnum.other.getValue().intValue()));
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u72b6\u6001\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                        }
                        continue block37;
                    }
                    case 7: {
                        isRadiation = null;
                        try {
                            isRadiation = cell.getStringCellValue().trim();
                            if (isRadiation.equals("\u662f")) {
                                device.setIsRadiation(Global.TRUE);
                                continue block37;
                            }
                            if (!isRadiation.equals("\u5426")) continue block37;
                            device.setIsRadiation(Global.FALSE);
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u662f\u5426\u653e\u5c04\u8bbe\u5907\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                        }
                        continue block37;
                    }
                    case 8: {
                        harmNames = null;
                        sb = new StringBuffer();
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK) {
                                device.setIsHarm(Global.TRUE);
                                harmNames = cell.getStringCellValue().trim();
                                split = harmNames.split("\uff1b");
                                for (k = 0; k < split.length; ++k) {
                                    if (!harmMap.containsKey(split[k])) {
                                        errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + "," + split[k] + "\u5371\u5bb3\u56e0\u7d20\u4e0d\u5b58\u5728"));
                                        hasError = true;
                                        continue;
                                    }
                                    sb.append((String)harmMap.get(split[k]) + "\uff1b");
                                    harmNames = sb.toString();
                                }
                            }
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u5371\u5bb3\u56e0\u7d20\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block37;
                        }
                        device.setHarmNames(harmNames);
                        continue block37;
                    }
                }
            }
            if (hasError) continue;
            list.add(device);
        }
        if (hasError) {
            data.setState(ResponseStateEnum.warning);
            errorBuffer = new StringBuffer();
            for (String errorStr : errorContentList) {
                errorBuffer.append(errorStr).append("<br/>");
            }
            data.setContent(errorBuffer.toString());
        } else {
            data.setResult(list);
            data.setState(ResponseStateEnum.success);
        }
        return data;
    }

    private static void dateHandle(Cell cell) {
        String dateStr;
        if (cell.getCellType() == CellType.BLANK && StringUtils.isNotEmpty((String)(dateStr = cell.getStringCellValue()))) {
            Date date = DateUtils.parseDate((Object)dateStr.trim());
            if (date == null) {
                cell.setCellType(CellType.BLANK);
            } else {
                Integer year = date.getYear();
                if (year > 9999) {
                    cell.setCellType(CellType.BLANK);
                } else {
                    cell.setCellValue(date);
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public ResponseData<Object> parseDeviceInfromExcel2(HSSFSheet sheet, Long cid, Long loginStaffId) {
        rowIndex = 0;
        data = new ResponseData();
        type = this.deviceTypeService.getCompanyDeviceType(cid);
        workRoleInfos = this.workRoleInfoService.getWorkRoleInfosByCidAndSearch(cid, "", null);
        workRoles = new HashMap<K, V>();
        workRoleInfos.forEach((Consumer<WorkRoleInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$parseDeviceInfromExcel2$2(java.util.Map cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo ), (Lcn/smarthse/modules/health/entity/base/workinfo/WorkRoleInfo;)V)(workRoles));
        StaffInfos = this.staffInfoService.getStaffInfosByOrgId(cid, null, "");
        StaffRealNames = new ArrayList<E>();
        StaffInfos.forEach((Consumer<StaffInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$parseDeviceInfromExcel2$3(java.util.List cn.smarthse.modules.health.entity.base.staff.StaffInfo ), (Lcn/smarthse/modules/health/entity/base/staff/StaffInfo;)V)(StaffRealNames));
        hasError = false;
        errorContentList = new ArrayList<CallSite>();
        list = new ArrayList<DeviceInfo>();
        iter = sheet.rowIterator();
        while (iter.hasNext()) {
            row = (Row)iter.next();
            if (++rowIndex == 1 || !this.thisRowRequireIsNotBlank(row) && this.thisRowNotRequireIsBlank(row) || row.getCell(0) == null && row.getCell(1) == null && row.getCell(2) == null) continue;
            device = new DeviceInfo();
            device.setIsHarm(Global.FALSE);
            device.setIsRadiation(Global.FALSE);
            cellCount = 10;
            colIndex = 0;
            block36: for (i = 0; i < cellCount; ++i) {
                cell = row.getCell(i);
                if (cell != null && i != 8) {
                    cell.setCellType(CellType.STRING);
                }
                ++colIndex;
                if (cell == null || cell.getCellType() == CellType.BLANK) {
                    switch (i) {
                        case 2: {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8bbe\u5907\u8bbe\u65bd\u7c7b\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                            break;
                        }
                        case 3: {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8bbe\u5907\u8bbe\u65bd\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                            break;
                        }
                        case 5: {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u4f7f\u7528\u5c97\u4f4d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a"));
                            hasError = true;
                        }
                    }
                    continue;
                }
                switch (i) {
                    case 0: {
                        ID = null;
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK && StringUtils.isNotEmpty((String)cell.getStringCellValue().trim()) && ((deviceInfo = (DeviceInfo)this.getById(ID = Long.valueOf(cell.getStringCellValue().trim()))) == null || !deviceInfo.getIsValid().booleanValue())) {
                                errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", ID\u4e0d\u5b58\u5728"));
                                hasError = true;
                            }
                            ** GOTO lbl59
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", ID\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                        }
                        continue block36;
lbl59:
                        // 1 sources

                        device.setId(ID);
                        continue block36;
                    }
                    case 1: {
                        deviceNo = null;
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK && (deviceNo = cell.getStringCellValue().trim()) != null && !"".equals(deviceNo) && device.getId() == null && (info = this.getDeviceByNo(deviceNo, cid)) != null) {
                                errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",\u8bbe\u5907\u7f16\u53f7\u5df2\u5b58\u5728"));
                                hasError = true;
                            }
                            ** GOTO lbl75
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8bbe\u5907\u7f16\u53f7\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                        }
                        continue block36;
lbl75:
                        // 1 sources

                        device.setDeviceNo(deviceNo);
                        continue block36;
                    }
                    case 2: {
                        deviceType = null;
                        typeId = null;
                        try {
                            deviceType = cell.getStringCellValue().trim();
                            typ = (DeviceType)type.get(deviceType);
                            if (typ == null) {
                                entity = new DeviceType();
                                entity.setPid(Long.valueOf(2L));
                                entity.setTypeName(deviceType);
                                typ = (DeviceType)this.deviceTypeService.add((Object)entity, loginStaffId, cid);
                                type.put(deviceType, typ);
                                device.setIsDevicefh(Global.FALSE);
                            }
                            if (typ.getPid().equals(1L)) {
                                device.setIsDevicefh(Global.TRUE);
                            } else {
                                device.setIsDevicefh(Global.FALSE);
                            }
                            typeId = typ.getId();
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8bbe\u5907\u8bbe\u65bd\u7c7b\u578b\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block36;
                        }
                        device.setTypeId(typeId);
                        continue block36;
                    }
                    case 3: {
                        try {
                            name = cell.getStringCellValue().trim();
                        }
                        catch (Exception e2) {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u8bbe\u5907\u8bbe\u65bd\u540d\u79f0\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block36;
                        }
                        device.setDeviceName(name);
                        continue block36;
                    }
                    case 4: {
                        deviceModel = null;
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK) {
                                deviceModel = cell.getStringCellValue().trim();
                            }
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ",\u578b\u53f7\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block36;
                        }
                        device.setDeviceModel(deviceModel);
                        continue block36;
                    }
                    case 5: {
                        if (!StringUtils.isNotEmpty((String)cell.getStringCellValue().trim())) continue block36;
                        workrolenames = null;
                        stringBuffer = new StringBuffer();
                        try {
                            workrolenames = cell.getStringCellValue().trim();
                            workrolenames = workrolenames.replaceAll("\uff0c", ",");
                            split = workrolenames.split(",");
                            for (j = 0; j < split.length; ++j) {
                                if (!workRoles.containsValue(split[j])) {
                                    errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + "," + split[j] + "\u4f7f\u7528\u5c97\u4f4d\u4e0d\u5b58\u5728"));
                                    hasError = true;
                                    continue;
                                }
                                for (Map.Entry<K, V> m : workRoles.entrySet()) {
                                    if (!((String)m.getValue()).equals(split[j])) continue;
                                    stringBuffer.append(String.valueOf(m.getKey()) + ",");
                                }
                            }
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u4f7f\u7528\u5c97\u4f4d\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block36;
                        }
                        device.setWorkrolenames(stringBuffer.toString());
                        continue block36;
                    }
                    case 6: {
                        manufacturer = null;
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK) {
                                manufacturer = cell.getStringCellValue().trim();
                            }
                        }
                        catch (Exception e2) {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block36;
                        }
                        device.setManufacturer(manufacturer);
                        continue block36;
                    }
                    case 7: {
                        installer = null;
                        try {
                            if (cell != null && cell.getCellType() != CellType.BLANK) {
                                installer = cell.getStringCellValue().trim();
                            }
                        }
                        catch (Exception e2) {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block36;
                        }
                        device.setInstaller(installer);
                        continue block36;
                    }
                    case 8: {
                        DeviceInfoServiceImpl.dateHandle(cell);
                        if (cell.getCellType() == CellType.BLANK) {
                            errorContentList.add((CallSite)("\u8868\u4e00,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u9a8c\u6536\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                            continue block36;
                        }
                        device.setAcceptTime(cell.getDateCellValue());
                        continue block36;
                    }
                    case 9: {
                        deviceStateName = null;
                        try {
                            if (cell == null || cell.getCellType() == CellType.BLANK) continue block36;
                            deviceStateName = cell.getStringCellValue().trim();
                            if (deviceStateName.equals("\u6b63\u5e38")) {
                                device.setDeviceState(Long.valueOf(DeviceStateEnum.normal.getValue().intValue()));
                                continue block36;
                            }
                            if (deviceStateName.equals("\u6545\u969c")) {
                                device.setDeviceState(Long.valueOf(DeviceStateEnum.malfunction.getValue().intValue()));
                                continue block36;
                            }
                            if (deviceStateName.equals("\u7ef4\u4fee")) {
                                device.setDeviceState(Long.valueOf(DeviceStateEnum.Maintenance.getValue().intValue()));
                                continue block36;
                            }
                            if (deviceStateName.equals("\u62a5\u5e9f")) {
                                device.setDeviceState(Long.valueOf(DeviceStateEnum.scrapped.getValue().intValue()));
                                continue block36;
                            }
                            if (!deviceStateName.equals("\u5176\u4ed6")) continue block36;
                            device.setDeviceState(Long.valueOf(DeviceStateEnum.other.getValue().intValue()));
                        }
                        catch (Exception e) {
                            errorContentList.add((CallSite)("\u8868\u4e8c,\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(colIndex) + ", \u72b6\u6001\u683c\u5f0f\u4e0d\u5bf9"));
                            hasError = true;
                        }
                        continue block36;
                    }
                }
            }
            if (hasError) continue;
            list.add(device);
        }
        if (hasError) {
            data.setState(ResponseStateEnum.warning);
            errorBuffer = new StringBuffer();
            for (String errorStr : errorContentList) {
                errorBuffer.append(errorStr).append("<br/>");
            }
            data.setContent(errorBuffer.toString());
        } else {
            data.setResult(list);
            data.setState(ResponseStateEnum.success);
        }
        return data;
    }

    private boolean thisRowNotRequireIsBlank(Row row) {
        boolean flag = false;
        for (int i = 4; i <= 11; ++i) {
            if (row.getCell(i) != null && !StringUtils.isEmpty((CharSequence)row.getCell(i).getStringCellValue())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean thisRowRequireIsNotBlank(Row row) {
        boolean flag = false;
        for (int i = 0; i <= 3; ++i) {
            if (row.getCell(i) == null || !StringUtils.isNotEmpty((String)row.getCell(i).getStringCellValue())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private DeviceInfo getDeviceByNo(String no, Long cid) {
        Example example = new Example(DeviceInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("deviceNo", (Object)no).andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        if (list.size() > 0) {
            return (DeviceInfo)list.get(0);
        }
        return null;
    }

    @Transactional(readOnly=false)
    public ResponseData<List<DeviceInfo>> adds(List<DeviceInfo> list, Long cid, Long loginStaffId) {
        ResponseData data = new ResponseData(ResponseStateEnum.success);
        if (list.size() > 0) {
            for (DeviceInfo device : list) {
                device.setUpdateDate(new Date());
                if (device.getId() != null && !"".equals(device.getId())) {
                    super.setUpdateInfo(device, loginStaffId);
                    Example example = new Example(DeviceInfo.class);
                    example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("id", (Object)device.getId()).andEqualTo("isValid", (Object)true);
                    ((DeviceInfoMapper)this.dao).updateByExampleSelective(device, example);
                    continue;
                }
                device.setId(null);
                device.setId(this.add(device, loginStaffId, cid).getId());
            }
            data.setResult(list);
            data.setContent("\u5bfc\u5165\u6210\u529f\uff01\u589e\u52a0\u8bbe\u5907\u6570\u91cf\uff1a" + list.size());
        } else {
            data.setContent("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            data.setState(ResponseStateEnum.fail);
        }
        return data;
    }

    private void deleteByDeviceNo(String deviceNo, Long cid, Long staffid) {
        if (StringUtils.isEmpty((CharSequence)deviceNo)) {
            return;
        }
        DeviceInfo device = new DeviceInfo();
        device.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(device, staffid);
        Example example = new Example(DeviceInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("deviceNo", (Object)deviceNo);
        ((DeviceInfoMapper)this.dao).updateByExampleSelective(device, example);
    }

    public Integer getDeviceListNum(Long cid) {
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setCid(cid);
        deviceInfo.setIsValid(Global.TRUE);
        return ((DeviceInfoMapper)this.dao).selectCount(deviceInfo);
    }

    @Transactional(readOnly=false)
    public void deleteDeviceByCid(Long cid, Long staffid) {
        DeviceInfo device = new DeviceInfo();
        device.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(device, staffid);
        Example example = new Example(DeviceInfo.class);
        example.createCriteria().andEqualTo("cid", (Object)cid);
        ((DeviceInfoMapper)this.dao).updateByExampleSelective(device, example);
    }

    public List<DeviceInfo> getDeviceListOccDisease(Long cid) {
        List typeList = this.deviceTypeService.getListForOccDisease(cid);
        ArrayList<Long> typeIdList = new ArrayList<Long>();
        for (DeviceType dt : typeList) {
            typeIdList.add(dt.getId());
        }
        if (typeIdList.isEmpty()) {
            return null;
        }
        Example example = new Example(DeviceInfo.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid).andIn("typeId", typeIdList);
        return ((DeviceInfoMapper)this.dao).selectByExample(example);
    }

    @Transactional
    public Integer addDeviceBatch(String deviceIds, Long deviceType, Long loginStaffId) {
        if (StringUtils.isEmpty((CharSequence)deviceIds)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u9700\u8981\u6dfb\u52a0\u7684\u8bbe\u5907");
        }
        String[] ids = deviceIds.split(",");
        if (ids == null || ids.length == 0) {
            throw new HealthException("\u8bf7\u9009\u62e9\u9700\u8981\u6dfb\u52a0\u7684\u8bbe\u5907");
        }
        if (deviceType == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        DeviceType type = (DeviceType)this.deviceTypeService.getById(deviceType);
        if (type == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        boolean isDevicefh = false;
        if (Constants.OCC_DISEASE_DEVICE_TYPE.equals(type.getPid())) {
            isDevicefh = true;
        }
        Integer count = 0;
        for (String id : ids) {
            if (!StringUtils.isNumber((String)id)) continue;
            DeviceInfo d = new DeviceInfo();
            d.setId(Long.valueOf(id));
            d.setTypeId(deviceType);
            d.setIsDevicefh(Boolean.valueOf(isDevicefh));
            if (isDevicefh) {
                d.setPurpose(type.getTypeName().replace("\u8bbe\u65bd", ""));
            }
            super.update(d, loginStaffId);
            Integer n = count;
            count = count + 1;
        }
        return count;
    }

    @Transactional
    public Integer addDeviceHarmFactor(String deviceIds, String harmFactors, Long loginStaffId, Long cid) {
        if (StringUtils.isEmpty((CharSequence)harmFactors)) {
            throw new HealthException("\u8bf7\u9009\u62e9\uff1a\u5371\u5bb3\u56e0\u7d20");
        }
        if (StringUtils.isEmpty((CharSequence)deviceIds)) {
            throw new HealthException("\u8bf7\u9009\u62e9\uff1a\u9700\u7f16\u8f91\u7684\u8bbe\u5907\u8bbe\u65bd");
        }
        if (loginStaffId == null || cid == null) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        ArrayList deviceHarmfactorList = new ArrayList();
        String[] dIds = deviceIds.split(",");
        String[] hIds = harmFactors.split(",");
        ArrayList<Long> dIdList = new ArrayList<Long>();
        for (String dId : dIds) {
            if (!StringUtils.isNumber((String)dId)) continue;
            Long id = Long.valueOf(dId);
            dIdList.add(id);
            deviceHarmfactorList.addAll(this.deviceHarmfactorService.getListByDeviceId(id));
            DeviceInfo device = new DeviceInfo();
            device.setId(id);
            device.setIsHarm(Boolean.valueOf(true));
            super.update(device, loginStaffId);
        }
        Integer count = 0;
        for (String hId : hIds) {
            if (!StringUtils.isNumber((String)hId)) continue;
            Long harmId = Long.valueOf(hId);
            for (Long dId : dIdList) {
                OccupationalRiskFactors factor;
                boolean hasDeviceHarmfactor = false;
                for (DeviceHarmfactor dhf : deviceHarmfactorList) {
                    if (!dId.equals(dhf.getDeviceId()) || !harmId.equals(dhf.getHarmId())) continue;
                    hasDeviceHarmfactor = true;
                    break;
                }
                if (hasDeviceHarmfactor || (factor = (OccupationalRiskFactors)this.factorsService.getById(harmId)) == null) continue;
                DeviceHarmfactor entity = new DeviceHarmfactor();
                entity.setDeviceId(dId);
                entity.setHarmId(harmId);
                entity.setHarmName(factor.getNameCh());
                this.deviceHarmfactorService.add((Object)entity, loginStaffId, cid);
                Integer n = count;
                count = count + 1;
            }
        }
        return count;
    }

    @Transactional(readOnly=false)
    public void saveInfo(DeviceInfo device, Long staffId, Long cid) {
        CompanyArea area;
        if (device.getId() != null) {
            this.update(device, staffId);
        } else {
            this.add(device, staffId, cid);
        }
        DeviceSpecial special = device.getSpecial();
        if (special == null) {
            return;
        }
        special.setDeviceId(device.getId());
        this.deviceSpecialService.saveInfo(device.getSpecial(), staffId, cid);
        device = (DeviceInfo)super.getById(device.getId());
        if (device != null && StringUtils.isLong((String)device.getInstallPosition()) && (area = (CompanyArea)this.areaService.getById(Long.valueOf(device.getInstallPosition()))) != null) {
            this.coreWorkCorrelationService.addHarmFactorManagerTodolistInfo(CoreWorkEnum.companyArea, area.getId(), area.getAreaName() + "\u533a\u57df", staffId, cid);
        }
    }

    private Date parseToDate(Cell cell) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.parse(this.parseCell(cell));
    }

    private String parseCell(Cell cell) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        double value = cell.getNumericCellValue();
        Date date = DateUtil.getJavaDate((double)value);
        if (date == null || "".equals(date)) {
            return "";
        }
        return sdf.format(date);
    }

    private static /* synthetic */ void lambda$parseDeviceInfromExcel2$3(List StaffRealNames, StaffInfo item) {
        if (item != null && item.getStaffBasicInfo() != null) {
            StaffRealNames.add(item.getStaffBasicInfo().getRealName());
        }
    }

    private static /* synthetic */ void lambda$parseDeviceInfromExcel2$2(Map workRoles, WorkRoleInfo item) {
        String orgName = item.getOrgName() == null ? "" : item.getOrgName();
        workRoles.put(item.getId(), item.getWorkName() + "/" + orgName);
    }

    private static /* synthetic */ void lambda$parseDeviceInfromExcel$1(List StaffRealNames, StaffInfo item) {
        if (item != null && item.getStaffBasicInfo() != null) {
            StaffRealNames.add(item.getStaffBasicInfo().getRealName());
        }
    }

    private static /* synthetic */ void lambda$parseDeviceInfromExcel$0(Map workRoles, WorkRoleInfo item) {
        String orgName = item.getOrgName() == null ? "" : item.getOrgName();
        workRoles.put(item.getId(), item.getWorkName() + "/" + orgName);
    }
}

