/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.company;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.company.CompanySoftMapper;
import cn.smarthse.modules.health.entity.base.company.CompanySoft;
import cn.smarthse.modules.health.service.base.company.ICompanySoftService;
import cn.smarthse.modules.platform.model.CorpSoftModel;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanySoftServiceImpl
extends BaseServiceImpl<CompanySoftMapper, CompanySoft>
implements ICompanySoftService {
    public CompanySoft getByCId(Long cid) {
        Example example = new Example(CompanySoft.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        return (CompanySoft)this.getOneByExample(example);
    }

    public CompanySoft getByplatformCid(Long corpId) {
        Example example = new Example(CompanySoft.class);
        example.createCriteria().andEqualTo("platformCid", (Object)corpId).andEqualTo("isValid", (Object)Global.TRUE);
        return (CompanySoft)this.getOneByExample(example);
    }

    @Transactional(readOnly=false)
    public CompanySoft addCompanySoftByPlatform(Long cid, Long corpId, CorpSoftModel corpSoft) {
        CompanySoft csoft = new CompanySoft();
        csoft.setCid(cid);
        csoft.setPlatformCid(corpId);
        csoft.setPlatformSoftId(corpSoft.getCorpSoftId());
        csoft.setCreateDate(new Date());
        csoft.setUpdateDate(new Date());
        csoft.setIsValid(Global.TRUE);
        csoft.setSoftEndDate(corpSoft.getEdate());
        csoft.setSoftStartDate(corpSoft.getSdate());
        csoft.setSoftVersion(corpSoft.getSoftVersionName());
        csoft.setSoftVersionCode(corpSoft.getSoftVersion());
        this.add(csoft);
        return csoft;
    }

    @Transactional(readOnly=false)
    public void updateCompanySoftByPlatform(CompanySoft companySoft, CorpSoftModel softmodel) {
        companySoft.setSoftEndDate(softmodel.getEdate());
        companySoft.setSoftStartDate(softmodel.getSdate());
        companySoft.setSoftVersion(softmodel.getSoftVersionName());
        companySoft.setSoftVersionCode(softmodel.getSoftVersion());
        companySoft.setUpdateDate(new Date());
        ((CompanySoftMapper)this.dao).updateByPrimaryKeySelective(companySoft);
        this.delFromMemoryCache(companySoft.getId());
    }
}

