/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.company;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.dao.base.company.CompanyReportInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanyReportInfoServiceImpl
extends BaseServiceImpl<CompanyReportInfoMapper, CompanyReportInfo>
implements CompanyReportInfoService {
    @Autowired
    private ICompanyFunctionalOrganizationService functionalOrganizationService;
    @Autowired
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @DubboReference
    IBusinessDataUpdateRefreshService businessDataUpdateRefreshService;
    @Autowired
    private ILiteArchiveUpdateService archiveUpdateService;

    public CompanyReportInfo getCompanyReportInfoByCid(Long cid) {
        Example e = new Example(CompanyReportInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        List listByExample = this.getListByExample(e);
        if (CollUtil.isNotEmpty(listByExample)) {
            if (listByExample.size() > 1) {
                this.logger.error("\u8be5\u4f01\u4e1a\u5b58\u5728\u591a\u4e2acompanyReport\u6570\u636e\uff0ccid:{}", (Object)cid);
            }
            return (CompanyReportInfo)listByExample.get(0);
        }
        return null;
    }

    public List<CompanyReportInfo> getCompanyReportInfoByCidList(List<Long> cidList) {
        Example e = new Example(CompanyReportInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andIn("cid", cidList);
        List<CompanyReportInfo> listByExample = this.getListByExample(e);
        return listByExample;
    }

    public List<CompanyReportInfo> getCompanyReportInfoByCids(List<Long> cids) {
        Example e = new Example(CompanyReportInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andIn("cid", cids);
        List companyReportInfos = ((CompanyReportInfoMapper)this.dao).selectByExample(e);
        if (CollectionUtils.isNotEmpty((Collection)companyReportInfos)) {
            for (CompanyReportInfo companyReportInfo : companyReportInfos) {
                WandaDeclare wandaDeclareInfo;
                if (companyReportInfo.getStaffCount() != null || (wandaDeclareInfo = this.phcPhysicalCheckService.getLastOneWandaDeclareByCid(companyReportInfo.getCid())) == null || wandaDeclareInfo.getStaffNum() == null) continue;
                companyReportInfo.setStaffCount(Long.valueOf(wandaDeclareInfo.getStaffNum()));
            }
        }
        return companyReportInfos;
    }

    public List<CompanyReportInfo> listCompanyReportInfoHarmCountIsZero() {
        Example e = new Example(CompanyReportInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("harmStaffCount", (Object)0);
        List<CompanyReportInfo> oneByExample = this.getListByExample(e);
        return oneByExample;
    }

    @Transactional(readOnly=false)
    public CompanyReportInfo updateCompanyReportInfo(CompanyReportInfo reportInfo, Long staffId, Long cid) {
        reportInfo.setCid(cid);
        if (reportInfo.getId() != null) {
            this.updateByPrimaryKey(reportInfo, staffId);
        } else {
            CompanyReportInfo companyReportInfoByCid = this.getCompanyReportInfoByCid(cid);
            if (companyReportInfoByCid != null && companyReportInfoByCid.getId() != null) {
                reportInfo.setId(companyReportInfoByCid.getId());
                reportInfo.setDataUpdateDate(companyReportInfoByCid.getDataUpdateDate());
                reportInfo.setHarmStaffCount(companyReportInfoByCid.getHarmStaffCount());
                this.updateByPrimaryKey(reportInfo, staffId);
            }
        }
        return reportInfo;
    }

    @Transactional(readOnly=false)
    public CompanyReportInfo addCompanyReportInfo(CompanyReportInfo reportInfo, Long staffId, Long cid, String loginUserType) {
        if (cid == null) {
            return null;
        }
        reportInfo.setCid(cid);
        reportInfo.setIsValid(Boolean.valueOf(true));
        CompanyReportInfo companyReportInfo = this.getCompanyReportInfoByCid(cid);
        if (companyReportInfo != null && companyReportInfo.getId() != null) {
            reportInfo.setId(companyReportInfo.getId());
            reportInfo.setDataUpdateDate(companyReportInfo.getDataUpdateDate());
            reportInfo.setHarmStaffCount(companyReportInfo.getHarmStaffCount());
            if (StringUtils.isBlank((CharSequence)loginUserType) || !"1".equals(loginUserType)) {
                if (reportInfo.getLegalCardType() == null) {
                    reportInfo.setLegalCardType(companyReportInfo.getLegalCardType());
                }
                if (reportInfo.getLegalCardId() == null) {
                    reportInfo.setLegalCardId(companyReportInfo.getLegalCardId());
                }
            }
            this.updateCompanyReportInfo(reportInfo, staffId, cid);
            if (!(Objects.equals(reportInfo.getManageOrg(), companyReportInfo.getManageOrg()) && Objects.equals(reportInfo.getStaffCount(), companyReportInfo.getStaffCount()) && Objects.equals(reportInfo.getManageOrgFiles(), companyReportInfo.getManageOrgFiles()))) {
                this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03});
            }
        } else {
            reportInfo.setId(null);
            this.add(reportInfo, staffId, cid);
            this.businessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE03});
        }
        this.archiveUpdateService.refreshArchive(cid, "202");
        return reportInfo;
    }

    public Integer getCompanyReportInfoStaffCount(Long cid) {
        Example e = new Example(CompanyReportInfo.class);
        e.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("cid", (Object)cid);
        CompanyReportInfo companyReportInfo = (CompanyReportInfo)this.getOneByExample(e);
        if (companyReportInfo != null) {
            if (companyReportInfo.getStaffCount() != null) {
                return Math.toIntExact(companyReportInfo.getStaffCount());
            }
            WandaDeclare wandaDeclare = this.phcPhysicalCheckService.getLastOneWandaDeclareByCid(cid);
            if (wandaDeclare != null && StringUtils.isNotBlank((CharSequence)wandaDeclare.getStaffNum())) {
                return Integer.valueOf(wandaDeclare.getStaffNum());
            }
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public CompanyReportInfo addCompanyReportInfoNoVerificationRequired(CompanyReportInfo reportInfo, Long staffId, Long cid) {
        if (cid == null) {
            return null;
        }
        reportInfo.setCid(cid);
        reportInfo.setIsValid(Boolean.valueOf(true));
        reportInfo.setId(null);
        this.add(reportInfo, staffId, cid);
        return reportInfo;
    }
}

