/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.company;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.framework.service.datascope.DataScopeHelper;
import cn.smarthse.common.framework.service.datascope.DataScopeUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.base.company.CompanyOrganizationMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.enums.datascope.DataScopeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanyOrganizationServiceImpl
extends BaseServiceImpl<CompanyOrganizationMapper, CompanyOrganization>
implements ICompanyOrganizationService {
    @Autowired
    CompanyOrganizationMapper companyOrganizationMapper;
    @Autowired
    private IWorkRoleInfoService workRoleInfoService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;

    public List<CompanyOrganization> getListByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        Example example = new Example(CompanyOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        DataScopeHelper.startDataScope("company.org");
        if (DataScopeHelper.getDataScope() != null) {
            DataScopeHelper.getDataScope().setCreateBy("id");
            DataScopeHelper.getDataScope().setOrgColumnAlias("id");
        }
        List list = ((CompanyOrganizationMapper)this.dao).selectByExample(example);
        ArrayList<CompanyOrganization> finalList = new ArrayList<CompanyOrganization>();
        HashMap<Byte, List> map = new HashMap<Byte, List>();
        for (CompanyOrganization co : list) {
            if (co == null) continue;
            if (co.getOrderNum() == null) {
                co.setOrderNum(Integer.valueOf(1));
            }
            map.computeIfAbsent(co.getLevel(), k -> new ArrayList());
            ((List)map.get(co.getLevel())).add(co);
        }
        for (Byte level : map.keySet()) {
            finalList.addAll((Collection)map.get(level));
        }
        return finalList;
    }

    public List<CompanyOrganization> getListByCidAndOrgId(Long cid, Long orgId) {
        if (cid == null) {
            return null;
        }
        Example example = new Example(CompanyOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        if (orgId != null) {
            criteria.andEqualTo("id", (Object)orgId);
        }
        return ((CompanyOrganizationMapper)this.dao).selectByExample(example);
    }

    private CompanyOrganization setAttendInfo(CompanyOrganization parentOrganization, CompanyOrganization entity) {
        if (parentOrganization != null) {
            Byte level = (byte)(parentOrganization.getLevel() == null ? 1 : parentOrganization.getLevel() + 1);
            entity.setLevel(level);
            String treePath = StringUtils.isEmpty((CharSequence)parentOrganization.getTreePath()) ? "" + parentOrganization.getId() : parentOrganization.getTreePath() + "," + parentOrganization.getId();
            entity.setTreePath(treePath);
        } else {
            entity.setLevel(Byte.valueOf((byte)1));
            entity.setTreePath(null);
        }
        return entity;
    }

    private List<CompanyOrganization> getListByParentId(Long pid) {
        if (pid == null) {
            return Collections.emptyList();
        }
        Example example = new Example(CompanyOrganization.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andLike("treePath", "%" + pid + "%");
        return ((CompanyOrganizationMapper)this.dao).selectByExample(example);
    }

    @Override
    @Transactional(readOnly=false)
    public CompanyOrganization add(CompanyOrganization entity, Long loginStaffId, Long cid) {
        if (cid == null) {
            throw new HealthException(ErrorEnum.CID_EMPTY);
        }
        if (loginStaffId == null) {
            throw new HealthException(ErrorEnum.LOGIN_STAFF_ID_EMPTY);
        }
        if (entity == null || StringUtils.isEmpty((CharSequence)entity.getOrganizationName())) {
            throw new HealthException(ErrorEnum.ORGANIZATION_NAME_EMPTY);
        }
        this.setTreePathInfo(entity);
        Example example = new Example(CompanyOrganization.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("pid", (Object)entity.getPid()).andEqualTo("organizationName", (Object)entity.getOrganizationName().trim()).andEqualTo("level", (Object)entity.getLevel());
        List list = ((CompanyOrganizationMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            return new CompanyOrganization();
        }
        CompanyOrganization org = super.add(entity, loginStaffId, cid);
        return org;
    }

    public List<CompanyOrganization> getListByName(String organizationName, Long cid) {
        if (StringUtils.isEmpty((CharSequence)(organizationName = organizationName.trim())) || cid == null) {
            return Collections.emptyList();
        }
        CompanyOrganization entity = new CompanyOrganization();
        entity.setOrganizationName(organizationName);
        entity.setCid(cid);
        entity.setIsValid(Boolean.valueOf(true));
        return ((CompanyOrganizationMapper)this.dao).select(entity);
    }

    public List<CompanyOrganization> getListByNameList(List<String> orgNameList, Long cid) {
        if (cid == null || CollectionUtils.isEmpty(orgNameList)) {
            return Collections.emptyList();
        }
        Example example = new Example(CompanyOrganization.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andIn("organizationName", orgNameList).andEqualTo("isValid", (Object)true);
        return ((CompanyOrganizationMapper)this.dao).selectByExample(example);
    }

    private void setTreePathInfo(CompanyOrganization entity) {
        if (entity.getPid() != null) {
            CompanyOrganization parentOrganization = (CompanyOrganization)this.getById(entity.getPid());
            entity = this.setAttendInfo(parentOrganization, entity);
        } else {
            entity.setLevel(Byte.valueOf((byte)1));
            entity.setTreePath(null);
        }
    }

    @Transactional(readOnly=false)
    public CompanyOrganization updateOrganizationTreePath(Long newPid, Long id, Long loginStaffId) {
        if (newPid == null || id == null || loginStaffId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        CompanyOrganization oldOrg = (CompanyOrganization)super.getById(id);
        if (oldOrg == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        if (newPid.equals(oldOrg.getCid())) {
            newPid = null;
        }
        if (oldOrg.getPid() == null ? newPid == null : oldOrg.getPid().equals(newPid)) {
            return oldOrg;
        }
        oldOrg.setPid(newPid);
        this.setTreePathInfo(oldOrg);
        this.updateChildrenTreePath(oldOrg, loginStaffId);
        super.updateByPrimaryKey(oldOrg, loginStaffId);
        return oldOrg;
    }

    private void updateChildrenTreePath(CompanyOrganization entity, Long loginStaffId) {
        List<CompanyOrganization> children = this.getListByParentId(entity.getId());
        if (children.size() > 0) {
            String childTreePath = null;
            for (CompanyOrganization o : children) {
                if (!o.getPid().equals(entity.getId())) continue;
                childTreePath = o.getTreePath();
                break;
            }
            if (StringUtils.isEmpty(childTreePath)) {
                throw new HealthException(ErrorEnum.defaultError);
            }
            this.updateChildOrganizationTreePath(children, entity);
            for (CompanyOrganization organ : children) {
                super.updateByPrimaryKey(organ, loginStaffId);
            }
        }
    }

    private void updateChildOrganizationTreePath(List<CompanyOrganization> children, CompanyOrganization parentOrganization) {
        for (CompanyOrganization organ : children) {
            if (!parentOrganization.getId().equals(organ.getPid())) continue;
            organ = this.setAttendInfo(parentOrganization, organ);
            this.updateChildOrganizationTreePath(children, organ);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void update(CompanyOrganization entity, Long loginStaffId) {
        ValidateUtil.valid((Object)entity, (String)"edit");
        super.update(entity, loginStaffId);
    }

    @Transactional(readOnly=false)
    public void deleteOrgByCid(Long cid, Long staffid) {
        CompanyOrganization org = new CompanyOrganization();
        org.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(org, staffid);
        Example example = new Example(CompanyOrganization.class);
        example.createCriteria().andEqualTo("cid", (Object)cid);
        ((CompanyOrganizationMapper)this.dao).updateByExampleSelective(org, example);
    }

    @Override
    @Transactional
    public void delete(CompanyOrganization entity, Long loginStaffId) {
        if (entity == null || entity.getId() == null) {
            return;
        }
        if ((entity = (CompanyOrganization)super.getById(entity.getId())) == null) {
            return;
        }
        Example example = new Example(CompanyOrganization.class);
        CompanyOrganization org = new CompanyOrganization();
        org.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(org, loginStaffId);
        example.createCriteria().andEqualTo("id", (Object)entity.getId()).andEqualTo("isValid", (Object)true);
        example.or().andEqualTo("cid", (Object)entity.getCid()).andEqualTo("isValid", (Object)true).andLike("treePath", "%" + entity.getId() + "%");
        ((CompanyOrganizationMapper)this.dao).updateByExampleSelective(org, example);
    }

    public int getCountByCid(Long cid) {
        if (cid == null) {
            return 0;
        }
        CompanyOrganization entity = new CompanyOrganization();
        entity.setCid(cid);
        entity.setIsValid(Boolean.valueOf(true));
        return ((CompanyOrganizationMapper)this.dao).selectCount(entity);
    }

    public List<CompanyOrganization> getAllChildrenCompanyOrganizationsByPid(Long pid, Long cid) {
        return this.getgetAllChildrenCompanyOrganizationsByPid(new ArrayList<CompanyOrganization>(), pid, cid);
    }

    private List<CompanyOrganization> getgetAllChildrenCompanyOrganizationsByPid(List<CompanyOrganization> resultList, Long pid, Long cid) {
        List<CompanyOrganization> list = this.companyOrganizationMapper.getChildrenCompanyOrganizationsByPid(pid, cid);
        resultList.addAll(list);
        for (CompanyOrganization co : list) {
            List<CompanyOrganization> childList = this.getgetAllChildrenCompanyOrganizationsByPid(resultList, co.getId(), cid);
            if (childList.size() != 0) continue;
            return resultList;
        }
        return resultList;
    }

    public String getOrgNameById(Long id) {
        if (id == null || id == 0L) {
            return "";
        }
        CompanyOrganization org = this.companyOrganizationMapper.getOrgaizationById(id, new Date().getTime());
        if (org != null && StringUtils.isNotEmpty((CharSequence)org.getOrganizationName())) {
            if (!org.getIsValid().booleanValue()) {
                return "(\u5df2\u5220\u9664)" + org.getOrganizationName();
            }
            return org.getOrganizationName();
        }
        return "";
    }

    public String getHistoryOrgNameByOrgIdAndYear(Long orgId, Date year) {
        if (orgId == null || year == null) {
            return "";
        }
        return "";
    }

    @Transactional(readOnly=false)
    public CompanyOrganization addCompanyOrganization(CompanyOrganization org) {
        if (org.getLevel() == null) {
            org.setLevel(Byte.valueOf((byte)1));
        }
        ((CompanyOrganizationMapper)this.dao).insertSelective(org);
        return org;
    }

    public List<CompanyOrganization> getChildrenListByCidAndOrgPid(Long cid, String orgPid, String orgName, Long loginStaffId) {
        if (cid == null) {
            return null;
        }
        Example example = new Example(CompanyOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        if (StringUtils.isNotBlank((CharSequence)orgName)) {
            criteria.andLike("organizationName", "%" + orgName + "%");
        }
        if (DataScopeUtils.getDataScope("company.org", "" + loginStaffId) != null && DataScopeUtils.getDataScope("company.org", "" + loginStaffId) == DataScopeEnum.DEPARTMENT.getCode() && StringUtils.isNotEmpty((CharSequence)orgPid)) {
            ArrayList<CompanyOrganization> list = new ArrayList<CompanyOrganization>();
            list.add((CompanyOrganization)this.getById(Long.valueOf(orgPid)));
            List<CompanyOrganization> allChildrenCompanyOrganizationsByPid = this.getAllChildrenCompanyOrganizationsByPid(Long.valueOf(orgPid), cid);
            if (StringUtils.isNotBlank((CharSequence)orgName) && CollectionUtils.isNotEmpty(allChildrenCompanyOrganizationsByPid)) {
                ArrayList<CompanyOrganization> filterList = new ArrayList<CompanyOrganization>();
                for (CompanyOrganization companyOrganization : allChildrenCompanyOrganizationsByPid) {
                    if (companyOrganization.getOrganizationName().indexOf(orgName) <= -1) continue;
                    filterList.add(companyOrganization);
                }
                list.addAll(filterList);
                return list;
            }
            list.addAll(allChildrenCompanyOrganizationsByPid);
            return list;
        }
        DataScopeHelper.startDataScope("company.org");
        if (DataScopeHelper.getDataScope() != null) {
            DataScopeHelper.getDataScope().setCreateBy("id");
            DataScopeHelper.getDataScope().setOrgColumnAlias("id");
        }
        List list = ((CompanyOrganizationMapper)this.dao).selectByExample(example);
        ArrayList<CompanyOrganization> finalList = new ArrayList<CompanyOrganization>();
        HashMap map = new HashMap();
        for (CompanyOrganization co : list) {
            if (map.get(co.getLevel()) == null) {
                map.put(co.getLevel(), new ArrayList());
            }
            ((List)map.get(co.getLevel())).add(co);
        }
        for (Byte level : map.keySet()) {
            finalList.addAll((Collection)map.get(level));
        }
        return finalList;
    }

    public CompanyOrganization getCompanyOrganizationByNameAndLevel(String organizationName, Byte level, Long cid) {
        if (StringUtils.isEmpty((CharSequence)organizationName) || cid == null || level == null || level == 0) {
            return null;
        }
        CompanyOrganization entity = new CompanyOrganization();
        entity.setOrganizationName(organizationName.trim());
        entity.setCid(cid);
        entity.setLevel(level);
        entity.setIsValid(Boolean.valueOf(true));
        List list = ((CompanyOrganizationMapper)this.dao).select(entity);
        if (list != null && list.size() > 0) {
            return (CompanyOrganization)list.get(0);
        }
        return null;
    }

    public CompanyOrganization getCompanyOrganizationByNameAndTreePath(String organizationName, String treePath, Long cid) {
        if (StringUtils.isEmpty((CharSequence)organizationName) || cid == null) {
            return null;
        }
        Example e = new Example(CompanyOrganization.class);
        Example.Criteria c = e.createCriteria().andEqualTo("organizationName", (Object)organizationName.trim()).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        if (StringUtils.isBlank((CharSequence)treePath)) {
            c.andIsNull("treePath");
        } else {
            c.andEqualTo("treePath", (Object)treePath);
        }
        List companyOrganizations = ((CompanyOrganizationMapper)this.dao).selectByExample(e);
        if (companyOrganizations != null && companyOrganizations.size() > 0) {
            return (CompanyOrganization)companyOrganizations.get(0);
        }
        return null;
    }

    public List<CompanyOrganization> getChildrenOrgListByCidAndOrgPid(Long cid, Long orgPid, Long loginStaffId) {
        if (cid == null) {
            return null;
        }
        CompanyOrganization org = new CompanyOrganization();
        org.setCid(cid);
        org.setPid(orgPid);
        List<CompanyOrganization> list = ((CompanyOrganizationMapper)this.dao).selectDeptList(org);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public void getCompanyOrganizationDataFromExcel(String ossfile, Long cid, Long loginStaffId) {
        HSSFWorkbook wb = null;
        try {
            wb = new HSSFWorkbook(ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception sheet) {
        }
        finally {
            if (wb != null) {
                try {
                    HSSFSheet sheet = wb.getSheetAt(0);
                    int rowIndex = 0;
                    ArrayList<CompanyOrganization> totalList = new ArrayList<CompanyOrganization>();
                    Iterator iter = sheet.rowIterator();
                    while (iter.hasNext()) {
                        Row row = (Row)iter.next();
                        if (++rowIndex == 1 || rowIndex == 2 || row.getCell(0) == null) continue;
                        row.getCell(0).setCellType(CellType.STRING);
                        if (StringUtils.isEmpty((CharSequence)row.getCell(0).getStringCellValue())) continue;
                        this.packList(row.getCell(0).getStringCellValue(), cid, totalList);
                    }
                    this.batchSaveOrUpdate(totalList, loginStaffId);
                    wb.close();
                }
                catch (IOException sheet) {}
            }
        }
    }

    private List<CompanyOrganization> packList(String deps, Long cid, List<CompanyOrganization> totalList) {
        String[] depNames = deps.split("-");
        Long pid = null;
        for (int i = 0; i < depNames.length; ++i) {
            String dep = depNames[i];
            Byte level = (byte)(i + 1);
            CompanyOrganization dbOrg = this.getByNameLevelPid(dep, level, pid, cid);
            if (dbOrg == null) {
                Long finalPid = pid;
                dbOrg = totalList.stream().filter(d -> d.getOrganizationName().equals(dep) && d.getLevel().equals(level) && Objects.equals(d.getPid(), finalPid)).findFirst().orElse(null);
            }
            if (dbOrg == null) {
                dbOrg = new CompanyOrganization();
                dbOrg.setPid(pid);
                dbOrg.setId(Long.valueOf(this.idworker.nextId()));
                dbOrg.setLevel(level);
                dbOrg.setOrganizationName(dep);
                dbOrg.setCid(cid);
                dbOrg.setCid(cid);
                totalList.add(dbOrg);
            }
            pid = dbOrg.getId();
        }
        return totalList;
    }

    public void batchSaveOrUpdate(List<CompanyOrganization> rowData, Long loginStaffId) {
        this.batchUpdateOrInsert(rowData, CompanyOrganizationMapper.class, (item, mapper) -> {
            item.setUpdateBy(loginStaffId);
            item.setCreateBy(loginStaffId);
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setIsValid(Boolean.valueOf(true));
            return mapper.saveOrUpdate((CompanyOrganization)item);
        });
    }

    private CompanyOrganization getByNameLevelPid(String orgName, Byte level, Long pid, Long cid) {
        List list;
        CompanyOrganization entity = new CompanyOrganization();
        entity.setOrganizationName(orgName.trim());
        entity.setCid(cid);
        entity.setLevel(level);
        entity.setIsValid(Boolean.valueOf(true));
        if (pid != null) {
            entity.setPid(pid);
        }
        if ((list = ((CompanyOrganizationMapper)this.dao).select(entity)) != null && list.size() > 0) {
            return (CompanyOrganization)list.get(0);
        }
        return null;
    }

    private List<CompanyOrganization> getNeedSaveOrg(String deps, Long cid) {
        String[] depNames = deps.split("-");
        ArrayList<CompanyOrganization> needSaveDeps = new ArrayList<CompanyOrganization>();
        for (int a = 0; a < depNames.length; ++a) {
            CompanyOrganization nCor;
            CompanyOrganization cor;
            String dep = depNames[a];
            Byte level = (byte)(a + 1);
            if (needSaveDeps.size() > 0) {
                if (((CompanyOrganization)needSaveDeps.get(a - 1)).getId() != null) {
                    cor = this.getCompanyOrganizationByNameAndLevel(dep, level, cid);
                    if (cor != null) {
                        needSaveDeps.add(cor);
                        continue;
                    }
                    nCor = new CompanyOrganization();
                    nCor.setLevel(level);
                    nCor.setOrganizationName(dep);
                    nCor.setCid(cid);
                    needSaveDeps.add(nCor);
                    continue;
                }
                CompanyOrganization nCor2 = new CompanyOrganization();
                nCor2.setLevel(level);
                nCor2.setOrganizationName(dep);
                nCor2.setCid(cid);
                needSaveDeps.add(nCor2);
                continue;
            }
            cor = this.getCompanyOrganizationByNameAndLevel(dep, level, cid);
            if (cor != null) {
                needSaveDeps.add(cor);
                continue;
            }
            nCor = new CompanyOrganization();
            nCor.setLevel(level);
            nCor.setOrganizationName(dep);
            nCor.setCid(cid);
            needSaveDeps.add(nCor);
        }
        return needSaveDeps;
    }

    @Transactional(readOnly=false)
    public void saveOrgsBylevles(List<CompanyOrganization> needSaveCom, Long loginStaffId, Long cid) {
        for (int i = 0; i < needSaveCom.size(); ++i) {
            if (i == 0) {
                if (needSaveCom.get(0).getId() != null) continue;
                this.add(needSaveCom.get(0), loginStaffId, cid);
                continue;
            }
            if (needSaveCom.get(i).getId() != null) continue;
            needSaveCom.get(i).setPid(needSaveCom.get(i - 1).getId());
            String treePath = StringUtils.isEmpty((CharSequence)needSaveCom.get(i - 1).getTreePath()) ? "" + needSaveCom.get(i - 1).getId() : needSaveCom.get(i - 1).getTreePath() + "," + needSaveCom.get(i - 1).getId();
            needSaveCom.get(i).setTreePath(treePath);
            this.add(needSaveCom.get(i), loginStaffId, cid);
        }
    }

    @Transactional(readOnly=false)
    public void updateOrgSubmit(CompanyOrganization organization, Long loginStaffId) {
        if (organization.getId() != null) {
            CompanyOrganization oldOrg = (CompanyOrganization)this.getById(organization.getId());
            if (organization.getPid() != null && !organization.getPid().equals(0L)) {
                CompanyOrganization pOrg = (CompanyOrganization)this.getById(organization.getPid());
                if (pOrg.getLevel() == null) {
                    pOrg.setLevel(Byte.valueOf((byte)1));
                }
                if (pOrg.getTreePath() == null) {
                    pOrg.setTreePath("");
                }
                if (!organization.getPid().equals(organization.getId()) && !pOrg.getTreePath().contains("" + organization.getId())) {
                    organization.setLevel(Byte.valueOf((byte)(pOrg.getLevel() + 1)));
                    organization.setTreePath(StringUtils.isEmpty((CharSequence)pOrg.getTreePath()) ? "" + pOrg.getId() : pOrg.getTreePath() + "," + pOrg.getId());
                } else {
                    organization.setLevel(oldOrg.getLevel());
                    organization.setTreePath(oldOrg.getTreePath());
                    organization.setPid(oldOrg.getPid());
                }
                if (StringUtils.isEmpty((CharSequence)organization.getOrganizationName())) {
                    organization.setOrganizationName(oldOrg.getOrganizationName());
                }
                this.update(organization, loginStaffId);
                if (organization.getPid() != null && !organization.getPid().equals(oldOrg.getPid())) {
                    List<CompanyOrganization> children = this.getListByParentId(organization.getId());
                    this.updateChildOrganizationTreePath(children, organization);
                    for (CompanyOrganization organ : children) {
                        super.updateByPrimaryKey(organ, loginStaffId);
                    }
                }
            } else {
                oldOrg.setPid(null);
                oldOrg.setTreePath(null);
                if (StringUtils.isEmpty((CharSequence)organization.getOrganizationName())) {
                    organization.setOrganizationName(oldOrg.getOrganizationName());
                }
                oldOrg.setOrganizationName(organization.getOrganizationName());
                oldOrg.setLevel(Byte.valueOf((byte)1));
                super.updateByPrimaryKey(oldOrg, loginStaffId);
            }
        }
    }

    @Transactional(readOnly=false)
    public void updateChildenOrderSubmit(String ids, Long loginStaffId) {
        String[] orgIds = ids.split(",");
        for (int i = 1; i <= orgIds.length; ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)orgIds[i - 1])) continue;
            CompanyOrganization org = new CompanyOrganization();
            org.setId(Long.valueOf(orgIds[i - 1]));
            org.setOrderNum(Integer.valueOf(i));
            super.update(org, loginStaffId);
        }
    }

    public Boolean isExistOrgName(CompanyOrganization entity) {
        Example example = new Example(CompanyOrganization.class);
        example.createCriteria().andEqualTo("cid", (Object)entity.getCid()).andEqualTo("isValid", (Object)true).andEqualTo("organizationName", (Object)entity.getOrganizationName().trim()).andEqualTo("level", (Object)entity.getLevel()).andNotEqualTo("id", (Object)entity.getId());
        List list = ((CompanyOrganizationMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    public Byte getDataPerByLoginStaffId(String permissionCode, String loginStaffId) {
        return DataScopeUtils.getDataScope(permissionCode, loginStaffId);
    }

    public CompanyOrganization companyOrganizationService(Long cid, String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Example example = new Example(CompanyOrganization.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("code", (Object)code.trim());
        List list = ((CompanyOrganizationMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            return (CompanyOrganization)list.get(0);
        }
        return null;
    }

    public CompanyOrganization addCompanyOrganizationByCode(Long cid, String name, String code) {
        return null;
    }

    public List<CompanyOrganization> getAllCompanyOrganizations(Long cid) {
        Example example = new Example(CompanyOrganization.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        example.selectProperties(new String[]{"id", "cid", "pid", "organizationName", "level", "treePath"});
        return ((CompanyOrganizationMapper)this.dao).selectByExample(example);
    }

    public Map<Long, Integer> getAllDeptStaffNum(Long cid) {
        List<CompanyOrganization> staffNumList = this.companyOrganizationMapper.getStaffNumByCid(cid);
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        if (staffNumList == null || staffNumList.isEmpty()) {
            return result;
        }
        for (CompanyOrganization l : staffNumList) {
            result.put(l.getId(), l.getStaffCount());
        }
        return result;
    }

    public Map<Long, Long> getAllPidDept(Long cid) {
        List<Long> pids = this.companyOrganizationMapper.getAllPidByCid(cid);
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        if (pids == null || pids.isEmpty()) {
            return result;
        }
        for (Long l : pids) {
            result.put(l, l);
        }
        return result;
    }

    @Transactional(readOnly=false)
    public int addOrgList(List<CompanyOrganization> orgList) {
        this.companyOrganizationMapper.insertBatch(orgList);
        return orgList.size();
    }

    public List<CompanyOrganization> getAllCompanyOrganizationsHasCode(Long cid) {
        Example example = new Example(CompanyOrganization.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andIsNotNull("code").andEqualTo("isValid", (Object)true);
        return ((CompanyOrganizationMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void upateCompanyOrganizationIncludeNull(CompanyOrganization co) {
        Example example = new Example(CompanyOrganization.class);
        ((CompanyOrganizationMapper)this.dao).updateByPrimaryKey(co);
    }

    public List<CompanyOrganization> getListByCidHuadong(Long cid) {
        if (cid == null) {
            return null;
        }
        DataScopeHelper.startDataScope("company.org");
        if (DataScopeHelper.getDataScope() != null) {
            DataScopeHelper.getDataScope().setCreateBy("id");
            DataScopeHelper.getDataScope().setOrgColumnAlias("id");
        }
        List<CompanyOrganization> list = ((CompanyOrganizationMapper)this.dao).getListByCidHuadong(cid);
        ArrayList<CompanyOrganization> finalList = new ArrayList<CompanyOrganization>();
        HashMap map = new HashMap();
        for (CompanyOrganization co : list) {
            if (map.get(co.getLevel()) == null) {
                map.put(co.getLevel(), new ArrayList());
            }
            ((List)map.get(co.getLevel())).add(co);
        }
        final ArrayList<Comparator<CompanyOrganization>> comparators = new ArrayList<Comparator<CompanyOrganization>>();
        comparators.add(new Comparator<CompanyOrganization>(){

            @Override
            public int compare(CompanyOrganization o1, CompanyOrganization o2) {
                return o1.getOrderNum() - o2.getOrderNum();
            }
        });
        comparators.add(new Comparator<CompanyOrganization>(){

            @Override
            public int compare(CompanyOrganization o1, CompanyOrganization o2) {
                return Collator.getInstance(Locale.CHINESE).compare(o1.getOrganizationName(), o2.getOrganizationName());
            }
        });
        Collections.sort(list, new Comparator<CompanyOrganization>(){

            @Override
            public int compare(CompanyOrganization o1, CompanyOrganization o2) {
                for (Comparator comparator : comparators) {
                    if (comparator.compare(o1, o2) > 0) {
                        return 1;
                    }
                    if (comparator.compare(o1, o2) >= 0) continue;
                    return -1;
                }
                return 0;
            }
        });
        for (Byte level : map.keySet()) {
            Collections.sort((List)map.get(level), new Comparator<CompanyOrganization>(){

                @Override
                public int compare(CompanyOrganization o1, CompanyOrganization o2) {
                    for (Comparator comparator : comparators) {
                        if (comparator.compare(o1, o2) > 0) {
                            return 1;
                        }
                        if (comparator.compare(o1, o2) >= 0) continue;
                        return -1;
                    }
                    return 0;
                }
            });
            finalList.addAll((Collection)map.get(level));
        }
        return finalList;
    }

    public Map<String, CompanyOrganization> getAllCompanyOrganizationByCids(Set<Long> cidSet) {
        HashMap<String, CompanyOrganization> companyOrganizationHashMap = new HashMap<String, CompanyOrganization>();
        Example example = new Example(CompanyOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(cidSet)) {
            criteria.andIn("cid", cidSet);
        }
        criteria.andEqualTo("isValid", (Object)true);
        List companyOrganizationList = this.getListByExample(example);
        if (CollectionUtils.isEmpty(companyOrganizationList)) {
            return companyOrganizationHashMap;
        }
        for (CompanyOrganization companyOrganization : companyOrganizationList) {
            String comOrgKey = companyOrganization.getCid() + "-" + companyOrganization.getOrganizationName();
            companyOrganization.setNewAdd(Boolean.valueOf(false));
            companyOrganizationHashMap.put(comOrgKey, companyOrganization);
        }
        return companyOrganizationHashMap;
    }

    public List<CompanyOrganization> getOrgAndStaffList(Long trainId, Long orgId, String staffName, Long cid, Byte sortBy) {
        List staffWorkRoleList;
        if (cid == null) {
            return null;
        }
        StopWatch sw = new StopWatch("\u52b3\u52a8\u8005\u57f9\u8bad\u767b\u8bb0\u4eba\u5458\u67e5\u8be2");
        DebugUtils.error((String)"[{}]\uff0c\u5f00\u59cb\u6267\u884c\u3002", (Object[])new Object[]{sw.getId()});
        ArrayList<CompanyOrganization> result = new ArrayList<CompanyOrganization>();
        if (orgId == null || orgId == 0L) {
            sw.start("\u67e5\u8be2\u6ca1\u6709\u90e8\u95e8/\u5c97\u4f4d\u7684\u4eba\u5458");
            List<CompanyOrganization> orgList = ((CompanyOrganizationMapper)this.dao).getStaffWithNoDept(cid, trainId, SpringEncryptUtils.encrypt((String)staffName), sortBy);
            sw.stop();
            DebugUtils.error((String)"[{}]\uff0corgList.size()={}\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), orgList.size(), sw.getLastTaskTimeMillis()});
            sw.start("\u52a0\u89e3\u5bc6\u8f6c\u6362staffName");
            int staffWorkRoleListSize = 0;
            for (CompanyOrganization companyOrganization : orgList) {
                staffWorkRoleList = companyOrganization.getStaffWorkRoleList();
                staffWorkRoleListSize += staffWorkRoleList.size();
                if (!CollectionUtils.isNotEmpty((Collection)staffWorkRoleList)) continue;
                for (StaffWorkRole staffWorkRole : staffWorkRoleList) {
                    staffWorkRole.setStaffName(SpringEncryptUtils.decrypt((String)staffWorkRole.getStaffName()));
                }
            }
            sw.stop();
            DebugUtils.error((String)"[{}]\uff0cstaffWorkRoleListSize={}\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), staffWorkRoleListSize, sw.getLastTaskTimeMillis()});
            sw.start("\u5904\u7406\u672c\u5c97\u4f4d\u5165\u804c\u65f6\u95f4\u201c-\u201d");
            orgList.stream().map(CompanyOrganization::getStaffWorkRoleList).filter(CollUtil::isNotEmpty).flatMap(Collection::stream).filter(s -> StrUtil.isBlank((CharSequence)s.getCurrentJobBeginTime())).forEach(s -> s.setCurrentJobBeginTime("-"));
            sw.stop();
            DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
            result.addAll(orgList);
        }
        if (!Objects.equals(orgId, 0L)) {
            sw.start("\u67e5\u8be2\u90e8\u95e8\u4fe1\u606f");
            List<CompanyOrganization> companyOrgList = this.getListByCidAndOrgId(cid, orgId);
            sw.stop();
            DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
            if (CollectionUtils.isNotEmpty(companyOrgList)) {
                companyOrgList.removeAll(Collections.singleton(null));
                if (companyOrgList.size() > 0) {
                    Map<Long, CompanyOrganization> organizationMap = companyOrgList.stream().collect(Collectors.toMap(CompanyOrganization::getId, e -> e));
                    sw.start("\u6839\u636e\u90e8\u95e8id\u548ccid\u67e5\u8be2\u5458\u5de5\u59d3\u540d");
                    for (CompanyOrganization companyOrganization : companyOrgList) {
                        staffWorkRoleList = this.staffWorkRoleService.getChooseStaff(companyOrganization.getId(), cid, trainId, staffName, sortBy);
                        companyOrganization.getStaffWorkRoleList().addAll(staffWorkRoleList);
                    }
                    sw.stop();
                    DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
                    sw.start("\u6784\u5efa\u4e0a\u4e0b\u7ea7\u90e8\u95e8\u6811\u7ed3\u6784");
                    if (orgId == null) {
                        companyOrgList = this.toTreeList(organizationMap);
                    }
                    sw.stop();
                    DebugUtils.error((String)"[{}]\uff0c\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getLastTaskName(), sw.getLastTaskTimeMillis()});
                }
            }
            result.addAll(companyOrgList);
        }
        DebugUtils.error((String)sw.prettyPrint(), (Object[])new Object[0]);
        DebugUtils.error((String)"[{}]\uff0c\u6267\u884c\u7ed3\u675f\uff0c\u603b\u8017\u65f6::{}ms\u3002", (Object[])new Object[]{sw.getId(), sw.getTotalTimeMillis()});
        return result;
    }

    public List<CompanyOrganization> getByCid(Long cid) {
        return ((CompanyOrganizationMapper)this.dao).getByCid(cid);
    }

    public List<StaffWorkRole> getStaffBySearch(Long trainId, Long orgId, String staffName, Long cid, Byte sortBy) {
        if (cid == null) {
            return null;
        }
        return this.staffWorkRoleService.getChooseStaff(orgId, cid, trainId, staffName, sortBy);
    }

    private List<CompanyOrganization> searchCompanyOrg(List<CompanyOrganization> companyOrgList, String keyWord) {
        ArrayList<CompanyOrganization> exists = new ArrayList<CompanyOrganization>();
        for (CompanyOrganization organization : companyOrgList) {
            Boolean matched = this.matchOrgName(organization, keyWord);
            if (!matched.booleanValue() && !organization.getOrganizationName().contains(keyWord)) continue;
            exists.add(organization);
        }
        return exists;
    }

    private Boolean matchOrgName(CompanyOrganization organization, String keyWord) {
        List children = organization.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            if (!organization.getOrganizationName().contains(keyWord)) {
                return false;
            }
            return true;
        }
        ArrayList<CompanyOrganization> exists = new ArrayList<CompanyOrganization>();
        for (CompanyOrganization child : children) {
            Boolean matched = this.matchOrgName(child, keyWord);
            if (!matched.booleanValue()) continue;
            exists.add(child);
        }
        organization.setChildren(null);
        if (CollectionUtils.isNotEmpty(exists)) {
            organization.setChildren(exists);
            return true;
        }
        return false;
    }

    private List<CompanyOrganization> toTreeList(Map<Long, CompanyOrganization> map) {
        ArrayList<CompanyOrganization> list = new ArrayList<CompanyOrganization>(map.values());
        ArrayList<CompanyOrganization> result = new ArrayList<CompanyOrganization>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (CompanyOrganization organization : list) {
                if (organization.getLevel() == 1) {
                    result.add(organization);
                    continue;
                }
                CompanyOrganization parent = map.get(organization.getPid());
                if (parent == null) continue;
                parent.getChildren().add(organization);
            }
        }
        return result;
    }
}

