/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.company;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.base.company.CompanyFunctionalOrganizationMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMemberLog;
import cn.smarthse.modules.health.entity.base.company.CompanyReportInfo;
import cn.smarthse.modules.health.enums.company.FunOrgTypeEnum;
import cn.smarthse.modules.health.service.base.company.CompanyReportInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberLogService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.vo.base.company.CompanyFunOrgVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanyFunctionalOrganizationServiceImpl
extends BaseServiceImpl<CompanyFunctionalOrganizationMapper, CompanyFunctionalOrganization>
implements ICompanyFunctionalOrganizationService {
    @DubboReference
    private ISysFileProvideService fileServcie;
    @Autowired
    private ICompanyFunctionalOrganizationMemberService memberService;
    @Autowired
    private CompanyReportInfoService companyReportInfoService;
    @Autowired
    private ICompanyFunctionalOrganizationMemberLogService logService;

    @Transactional(readOnly=false)
    public List<CompanyFunctionalOrganization> getListByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        Example example = new Example(CompanyFunctionalOrganization.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("organization_type asc");
        List<CompanyFunctionalOrganization> list = ((CompanyFunctionalOrganizationMapper)this.dao).selectByExample(example);
        if (list == null || list.size() == 0) {
            list = this.addDefaultFunOrg(cid, null, null);
        }
        return list;
    }

    @Override
    @Transactional(readOnly=false)
    public CompanyFunctionalOrganization add(CompanyFunctionalOrganization entity, Long loginStaffId, Long cid) {
        ValidateUtil.valid((Object)entity, (String)"add");
        CompanyFunctionalOrganization resultEntity = super.add(entity, loginStaffId, cid);
        return resultEntity;
    }

    @Override
    @Transactional(readOnly=false)
    public void update(CompanyFunctionalOrganization entity, Long loginStaffId) {
        ValidateUtil.valid((Object)entity, (String)"edit");
        if (entity.getDirector() == null) {
            entity.setDirector(Constants.NONE_LONG);
        }
        super.update(entity, loginStaffId);
    }

    @Transactional
    public CompanyFunctionalOrganization save(CompanyFunctionalOrganization entity, Long loginStaffId, Long cid) {
        if (entity.getDirector() == null || Constants.NONE_LONG.equals(entity.getDirector())) {
            entity.setDirector(Constants.NONE_LONG);
        }
        if (entity.getId() == null) {
            entity.setOrganizationType(FunOrgTypeEnum.custom.getCode());
            entity = this.add(entity, loginStaffId, cid);
        } else {
            this.update(entity, loginStaffId);
        }
        return entity;
    }

    @Transactional(readOnly=false)
    public List<CompanyFunctionalOrganization> addDefaultFunOrg(Long cid, String hseDirectorName, String hseDirectorTel) {
        ArrayList<CompanyFunctionalOrganization> funOrgList = new ArrayList<CompanyFunctionalOrganization>();
        for (FunOrgTypeEnum type : FunOrgTypeEnum.getValues()) {
            if (type.getCode().equals(FunOrgTypeEnum.custom.getCode())) continue;
            CompanyFunctionalOrganization funOrg = new CompanyFunctionalOrganization();
            funOrg.setCid(cid);
            if (FunOrgTypeEnum.occupationHealth.getCode().equals(type.getCode())) {
                if (StringUtils.isNotBlank((CharSequence)hseDirectorName)) {
                    funOrg.setDirectorName(hseDirectorName);
                }
                if (StringUtils.isNotBlank((CharSequence)hseDirectorTel)) {
                    if (hseDirectorTel.length() < 32) {
                        funOrg.setTelephone(hseDirectorTel);
                    } else {
                        funOrg.setTelephone(hseDirectorTel.substring(0, 32));
                    }
                }
            }
            funOrg.setOrganizationType(type.getCode());
            funOrg.setOrganizationName(type.getName());
            ValidateUtil.valid((Object)funOrg, (String)"add");
            funOrg = super.add(funOrg, null, cid);
            funOrgList.add(funOrg);
        }
        return funOrgList;
    }

    @Override
    public CompanyFunctionalOrganization getById(Long id) {
        CompanyFunctionalOrganization funOrg = (CompanyFunctionalOrganization)super.getById(id);
        if (funOrg == null) {
            return null;
        }
        funOrg.setEstablishFileList(this.fileServcie.getListByIds(funOrg.getEstablishFile()));
        return funOrg;
    }

    public void deleteFunOrgByCid(Long cid, Long loginStaffId) {
        CompanyFunctionalOrganization funOrg = new CompanyFunctionalOrganization();
        funOrg.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(funOrg, loginStaffId);
        Example example = new Example(CompanyArea.class);
        example.createCriteria().andEqualTo("cid", (Object)cid);
        ((CompanyFunctionalOrganizationMapper)this.dao).updateByExampleSelective(funOrg, example);
    }

    @Transactional
    public CompanyFunctionalOrganization getFunOrgEHS(Long cid) {
        CompanyFunctionalOrganization funOrg;
        if (cid == null) {
            return null;
        }
        CompanyFunctionalOrganization record = new CompanyFunctionalOrganization();
        record.setIsValid(Boolean.valueOf(true));
        record.setCid(cid);
        record.setOrganizationType(FunOrgTypeEnum.occupationHealth.getCode());
        List list = ((CompanyFunctionalOrganizationMapper)this.dao).select(record);
        CompanyFunctionalOrganization companyFunctionalOrganization = funOrg = list == null || list.isEmpty() ? null : (CompanyFunctionalOrganization)list.get(0);
        if (funOrg != null) {
            funOrg.setEstablishFileList(this.fileServcie.getListByIds(funOrg.getEstablishFile()));
            funOrg.setArchitectureDiagramFiles(this.fileServcie.getListByIds(funOrg.getArchitectureDiagram()));
            funOrg.setMainPersonAsFirstleaderProvefilesList(this.fileServcie.getListByIds(funOrg.getMainPersonAsFirstleaderProvefiles()));
        } else {
            CompanyReportInfo info = this.companyReportInfoService.getCompanyReportInfoByCid(cid);
            if (info != null && StringUtils.isNotBlank((CharSequence)info.getManageOrgFiles())) {
                funOrg = new CompanyFunctionalOrganization();
                funOrg.setId(Long.valueOf(this.idworker.nextId()));
                funOrg.setCid(cid);
                funOrg.setOrganizationType(FunOrgTypeEnum.occupationHealth.getCode());
                funOrg.setEstablishFile(info.getManageOrgFiles());
                funOrg.setEstablishFileList(this.fileServcie.getListByIds(funOrg.getEstablishFile()));
                funOrg.setCreateDate(new Date());
                ((CompanyFunctionalOrganizationMapper)this.dao).insertSelective(funOrg);
            }
        }
        return funOrg;
    }

    public CompanyFunctionalOrganization getFunOrgEHS(Long cid, int year) {
        if (year == 0) {
            return null;
        }
        CompanyFunctionalOrganization funorg = this.getFunOrgEHS(cid);
        if (funorg == null) {
            return null;
        }
        return funorg;
    }

    @Transactional
    public CompanyFunOrgVo getEHSBasicInfo(Long cid) {
        CompanyFunOrgVo vo = new CompanyFunOrgVo();
        CompanyFunctionalOrganization funOrg = this.getFunOrgEHS(cid);
        if (funOrg == null) {
            return vo;
        }
        vo.setId(funOrg.getId());
        vo.setName(funOrg.getOrganizationName());
        vo.setLeaderOrganizationName(funOrg.getLeaderOrganizationName());
        return vo;
    }

    @Transactional
    public CompanyFunctionalOrganization addHealthOrg(Long cid, Long loginStaffId) {
        CompanyFunctionalOrganization organization = new CompanyFunctionalOrganization();
        organization.setId(Long.valueOf(this.idworker.nextId()));
        organization.setOrganizationType(FunOrgTypeEnum.occupationHealth.getCode());
        organization.setOrganizationName(FunOrgTypeEnum.occupationHealth.getName());
        organization.setCreateDate(new Date());
        organization.setCreateBy(loginStaffId);
        ((CompanyFunctionalOrganizationMapper)this.dao).insertSelective(organization);
        return organization;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long editOrgBasic(CompanyFunctionalOrganization organization, Long loginStaffId) {
        Long funOrgId = organization.getId();
        CompanyFunctionalOrganization dbOrg = null;
        if (funOrgId == null) {
            Example example = new Example(CompanyFunctionalOrganization.class);
            example.createCriteria().andEqualTo("cid", (Object)organization.getCid()).andEqualTo("isValid", (Object)true);
            List organizations = ((CompanyFunctionalOrganizationMapper)this.dao).selectByExample(example);
            if (CollectionUtils.isNotEmpty((Collection)organizations)) {
                dbOrg = (CompanyFunctionalOrganization)organizations.get(0);
            }
        } else {
            dbOrg = (CompanyFunctionalOrganization)super.getById(funOrgId);
        }
        this.addBaseOperateRecords(organization, loginStaffId, dbOrg);
        if (dbOrg != null) {
            dbOrg.setLeaderOrganizationName(organization.getLeaderOrganizationName());
            dbOrg.setManageDepartment(organization.getManageDepartment());
            dbOrg.setMainPersonAsFirstleader(organization.getMainPersonAsFirstleader());
            dbOrg.setMainPersonAsFirstleaderProvefiles(organization.getMainPersonAsFirstleaderProvefiles());
            this.updateByPrimaryKey(dbOrg, loginStaffId);
            return dbOrg.getId();
        }
        this.add(organization, loginStaffId, organization.getCid());
        return organization.getId();
    }

    private void addBaseOperateRecords(CompanyFunctionalOrganization organization, Long loginStaffId, CompanyFunctionalOrganization dbOrg) {
        CompanyFunctionalOrganizationMemberLog memberLog = new CompanyFunctionalOrganizationMemberLog();
        memberLog.setCid(organization.getCid());
        memberLog.setIsBase(Boolean.valueOf(true));
        Object beforeChange = "";
        Object afterChange = "";
        if (StringUtils.isNotBlank((CharSequence)organization.getLeaderOrganizationName())) {
            afterChange = "\u9886\u5bfc\u673a\u6784\uff1a" + organization.getLeaderOrganizationName();
            beforeChange = dbOrg != null && StringUtils.isNotBlank((CharSequence)dbOrg.getLeaderOrganizationName()) ? "\u9886\u5bfc\u673a\u6784\uff1a" + dbOrg.getLeaderOrganizationName() : "\u9886\u5bfc\u673a\u6784\uff1a-";
        }
        if (StringUtils.isNotBlank((CharSequence)organization.getManageDepartment())) {
            afterChange = (String)afterChange + ("".equals(afterChange) ? "\u65e5\u5e38\u7ba1\u7406\u90e8\u95e8\uff1a" + organization.getManageDepartment() : "\uff0c\u65e5\u5e38\u7ba1\u7406\u90e8\u95e8\uff1a" + organization.getManageDepartment());
            beforeChange = dbOrg != null && StringUtils.isNotBlank((CharSequence)dbOrg.getManageDepartment()) ? (String)beforeChange + ("".equals(beforeChange) ? "\u65e5\u5e38\u7ba1\u7406\u90e8\u95e8\uff1a" + dbOrg.getManageDepartment() : "\uff0c\u65e5\u5e38\u7ba1\u7406\u90e8\u95e8\uff1a" + dbOrg.getManageDepartment()) : (String)beforeChange + ("".equals(beforeChange) ? "\u65e5\u5e38\u7ba1\u7406\u90e8\u95e8\uff1a-" : "\uff0c\u65e5\u5e38\u7ba1\u7406\u90e8\u95e8\uff1a-");
        }
        if (organization.getMainPersonAsFirstleader() != null) {
            afterChange = (String)afterChange + ("".equals(afterChange) ? "\u4e3b\u8981\u8d1f\u8d23\u4eba\u662f\u5426\u62c5\u4efb\u6700\u9ad8\u51b3\u7b56\u8005\uff1a" + this.booleanStr(organization.getMainPersonAsFirstleader()) : "\uff0c\u4e3b\u8981\u8d1f\u8d23\u4eba\u662f\u5426\u62c5\u4efb\u6700\u9ad8\u51b3\u7b56\u8005\uff1a" + this.booleanStr(organization.getMainPersonAsFirstleader()));
            beforeChange = dbOrg != null && dbOrg.getMainPersonAsFirstleader() != null ? (String)beforeChange + ("".equals(beforeChange) ? "\u4e3b\u8981\u8d1f\u8d23\u4eba\u662f\u5426\u62c5\u4efb\u6700\u9ad8\u51b3\u7b56\u8005\uff1a" + this.booleanStr(dbOrg.getMainPersonAsFirstleader()) : "\uff0c\u4e3b\u8981\u8d1f\u8d23\u4eba\u662f\u5426\u62c5\u4efb\u6700\u9ad8\u51b3\u7b56\u8005\uff1a" + this.booleanStr(dbOrg.getMainPersonAsFirstleader())) : (String)beforeChange + ("".equals(beforeChange) ? "\u4e3b\u8981\u8d1f\u8d23\u4eba\u662f\u5426\u62c5\u4efb\u6700\u9ad8\u51b3\u7b56\u8005\uff1a-" : "\uff0c\u4e3b\u8981\u8d1f\u8d23\u4eba\u662f\u5426\u62c5\u4efb\u6700\u9ad8\u51b3\u7b56\u8005\uff1a-");
        }
        if (StringUtils.isNotBlank((CharSequence)organization.getMainPersonAsFirstleaderProvefiles())) {
            afterChange = (String)afterChange + ("".equals(afterChange) ? "\u4f50\u8bc1\u6750\u6599\uff1a" + this.getFileName(Long.valueOf(organization.getMainPersonAsFirstleaderProvefiles())) : "\uff0c\u4f50\u8bc1\u6750\u6599\uff1a" + this.getFileName(Long.valueOf(organization.getMainPersonAsFirstleaderProvefiles())));
            beforeChange = dbOrg != null && StringUtils.isNotBlank((CharSequence)dbOrg.getMainPersonAsFirstleaderProvefiles()) ? (String)beforeChange + ("".equals(beforeChange) ? "\u4f50\u8bc1\u6750\u6599\uff1a" + this.getFileName(Long.valueOf(dbOrg.getMainPersonAsFirstleaderProvefiles())) : "\uff0c\u4f50\u8bc1\u6750\u6599\uff1a" + this.getFileName(Long.valueOf(dbOrg.getMainPersonAsFirstleaderProvefiles()))) : (String)beforeChange + ("".equals(beforeChange) ? "\u4f50\u8bc1\u6750\u6599\uff1a-" : "\uff0c\u4f50\u8bc1\u6750\u6599\uff1a-");
        }
        memberLog.setBeforeChange((String)beforeChange);
        memberLog.setAfterChange((String)afterChange);
        this.logService.batchAddLog(Collections.singletonList(memberLog), loginStaffId);
    }

    private String booleanStr(Boolean b) {
        if (b.booleanValue()) {
            return "\u662f";
        }
        return "\u5426";
    }

    @Transactional
    public void setEstablishFile(Long cid, String establishFile, String manageOrg, Long loginStaffId) {
        if (cid != null && StringUtils.isNotBlank((CharSequence)establishFile)) {
            Example example = new Example(CompanyFunctionalOrganization.class);
            example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("organizationType", (Object)FunOrgTypeEnum.occupationHealth.getCode());
            CompanyFunctionalOrganization organization = new CompanyFunctionalOrganization();
            organization.setEstablishFile(establishFile);
            ((CompanyFunctionalOrganizationMapper)this.dao).updateByExampleSelective(organization, example);
            List organizationList = ((CompanyFunctionalOrganizationMapper)this.dao).selectByExample(example);
            if (CollectionUtils.isEmpty((Collection)organizationList)) {
                return;
            }
            CompanyReportInfo info = this.companyReportInfoService.getCompanyReportInfoByCid(cid);
            if (info == null || !"2".equals(info.getManageOrg()) || !"2".equals(manageOrg)) {
                CompanyFunctionalOrganizationMemberLog memberLog = new CompanyFunctionalOrganizationMemberLog();
                memberLog.setCid(cid);
                memberLog.setIsBase(Boolean.valueOf(true));
                memberLog.setType(Byte.valueOf((byte)2));
                memberLog.setAfterChange("\u6210\u7acb\u6587\u4ef6\uff1a" + this.getFileName(Long.valueOf(establishFile)));
                if (info != null && StringUtils.isNotBlank((CharSequence)info.getManageOrgFiles())) {
                    memberLog.setBeforeChange("\u6210\u7acb\u6587\u4ef6\uff1a" + this.getFileName(Long.valueOf(info.getManageOrgFiles())));
                } else {
                    memberLog.setBeforeChange("\u6210\u7acb\u6587\u4ef6\uff1a-");
                }
                this.logService.batchAddLog(Collections.singletonList(memberLog), loginStaffId);
            }
        }
    }

    public List<CompanyFunctionalOrganization> getFuncOrgListByCidList(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        Example e = new Example(CompanyFunctionalOrganization.class);
        e.createCriteria().andIn("cid", cidList).andEqualTo("isValid", (Object)Boolean.TRUE);
        return ((CompanyFunctionalOrganizationMapper)this.dao).selectByExample(e);
    }

    private String getFileName(Long fileId) {
        SysFileModel file = this.fileServcie.getFileById(fileId);
        return file != null ? file.getFileName() : "-";
    }
}

