/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.company;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.compliance.vo.CertTrainStaffInfoVo;
import cn.smarthse.modules.health.dao.base.company.CompanyFunctionalOrganizationMemberMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMemberLog;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.SysParam;
import cn.smarthse.modules.health.enums.company.FunOrgMemberTypeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberLogService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysParamService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.vo.base.company.HealthManagementInfoVo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanyFunctionalOrganizationMemberServiceImpl
extends BaseServiceImpl<CompanyFunctionalOrganizationMemberMapper, CompanyFunctionalOrganizationMember>
implements ICompanyFunctionalOrganizationMemberService {
    @Autowired
    CompanyFunctionalOrganizationMemberMapper companyFunctionalOrganizationMemberMapper;
    @Autowired
    private IStaffInfoService staffInfoServcie;
    @Autowired
    private ISysParamService sysParamService;
    @DubboReference
    private ISysFileProvideService sysFileService;
    @Autowired
    private ICertificateFilesService certificateFilesService;
    @Autowired
    private ICompanyFunctionalOrganizationMemberLogService companyFunctionalOrganizationMemberLogService;

    @Override
    @Transactional(readOnly=false)
    public CompanyFunctionalOrganizationMember add(CompanyFunctionalOrganizationMember entity, Long loginStaffId, Long cid) {
        if (StringUtils.isNotBlank((CharSequence)entity.getStaffName()) && entity.getStaffId() == null) {
            entity.setStaffId(Constants.NONE_LONG);
        }
        ValidateUtil.valid((Object)entity, (String)"add");
        CompanyFunctionalOrganizationMember reult = super.add(entity, loginStaffId, cid);
        this.companyFunctionalOrganizationMemberMapper.updateCreateDateById(reult.getCreateDate(), reult.getId());
        return reult;
    }

    @Override
    @Transactional(readOnly=false)
    public void update(CompanyFunctionalOrganizationMember entity, Long loginStaffId) {
        if (StringUtils.isNotBlank((CharSequence)entity.getStaffName()) && entity.getStaffId() == null) {
            entity.setStaffId(Constants.NONE_LONG);
        }
        ValidateUtil.valid((Object)entity, (String)"edit");
        if (entity.getStaffId() == null) {
            entity.setStaffId(Constants.NONE_LONG);
        }
        super.update(entity, loginStaffId);
    }

    @Transactional
    public List<CompanyFunctionalOrganizationMember> getMemberListByFunOrgId(Long funOrgId) {
        if (funOrgId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        CompanyFunctionalOrganizationMember member = new CompanyFunctionalOrganizationMember();
        member.setCompanyFunctionalOrganizationId(funOrgId);
        member.setIsValid(Boolean.valueOf(true));
        List members = ((CompanyFunctionalOrganizationMemberMapper)this.dao).select(member);
        for (CompanyFunctionalOrganizationMember m : members) {
            this.checkAndUpdateMemberInfo(m);
            m.setEmployFileNames(this.getFileNames(m.getEmployFiles()));
            m.setOccHealthCertificateNames(this.getFileNames(m.getOccHealthCertificates()));
        }
        return members;
    }

    public List<CompanyFunctionalOrganizationMember> getComplianceMemberListByCidList(List<Long> cidList, Boolean isComplianceManager) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        CompanyFunctionalOrganizationMember param = new CompanyFunctionalOrganizationMember();
        param.setCidList(cidList);
        param.setIsComplianceManager(isComplianceManager);
        List<CompanyFunctionalOrganizationMember> memberList = ((CompanyFunctionalOrganizationMemberMapper)this.dao).getListByCid(param);
        if (CollUtil.isNotEmpty(memberList)) {
            memberList = new ArrayList<CompanyFunctionalOrganizationMember>(memberList.stream().filter(Objects::nonNull).filter(m -> m.getCid() != null && StrUtil.isNotBlank((CharSequence)m.getStaffName())).collect(Collectors.toMap(m -> m.getCid() + "_" + m.getStaffName() + "_" + m.getOrgStaffType(), m -> m, (existing, replacement) -> {
                if (existing.getUpdateDate() == null && replacement.getUpdateDate() == null) {
                    return existing;
                }
                if (existing.getUpdateDate() == null) {
                    return replacement;
                }
                if (replacement.getUpdateDate() == null) {
                    return existing;
                }
                return existing.getUpdateDate().after(replacement.getUpdateDate()) ? existing : replacement;
            })).values());
        }
        return memberList;
    }

    private String generateKey(Long cid, String staffName, String staffType) {
        return String.valueOf(cid != null ? cid : "null") + "_" + (staffName != null ? staffName : "null") + "_" + staffType;
    }

    private Integer getCertStatusForStaffType(String staffType, Integer leaderCert, Integer managerCert) {
        if ("1".equals(staffType)) {
            return leaderCert;
        }
        if ("2".equals(staffType)) {
            return managerCert;
        }
        return null;
    }

    private String getFileNames(List<SysFileModel> files) {
        Object names = "";
        if (files == null || files.isEmpty()) {
            return names;
        }
        for (SysFileModel file : files) {
            names = (String)names + file.getFileName() + " ";
        }
        return names;
    }

    @Transactional
    public PageInfo<CompanyFunctionalOrganizationMember> getMemberPageInfoByFunOrgId(Long funOrgId, JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyFunctionalOrganizationMember> list = this.getMemberListByFunOrgId(funOrgId);
        PageInfo pageInfo = new PageInfo(list);
        return pageInfo;
    }

    public Integer getMemberCountByFunOrgId(Long funOrgId) {
        if (funOrgId == null) {
            throw new HealthException("\u804c\u80fd\u673a\u6784ID\u4e22\u5931");
        }
        CompanyFunctionalOrganizationMember member = new CompanyFunctionalOrganizationMember();
        member.setCompanyFunctionalOrganizationId(funOrgId);
        return ((CompanyFunctionalOrganizationMemberMapper)this.dao).selectCount(member);
    }

    @Override
    @Transactional
    public CompanyFunctionalOrganizationMember getById(Long id) {
        CompanyFunctionalOrganizationMember member = (CompanyFunctionalOrganizationMember)super.getById(id);
        this.checkAndUpdateMemberInfo(member);
        return member;
    }

    @Transactional
    public void checkAndUpdateMemberInfo(CompanyFunctionalOrganizationMember member) {
        if (member == null) {
            return;
        }
        if (!StringUtils.isIdIsNull((Long)member.getStaffId())) {
            StaffInfo staffInfo = this.staffInfoServcie.getStaffInfoDetailById(member.getStaffId());
            if (staffInfo == null) {
                member.setStaffName(null);
                member.setStaffEducation(null);
                member.setStaffJobTitle(null);
                member.setStaffMajor(null);
                member.setStaffMobile(null);
                member.setStaffOrganization(null);
            } else {
                if (staffInfo.getStaffBasicInfo() == null) {
                    member.setStaffMajor(null);
                } else {
                    member.setStaffMajor(staffInfo.getStaffBasicInfo().getMajor());
                }
                if (staffInfo.getStaffBasicInfo() == null || staffInfo.getStaffBasicInfo().getEducation() == null) {
                    member.setStaffEducation(null);
                } else {
                    SysParam param = (SysParam)this.sysParamService.getById(staffInfo.getStaffBasicInfo().getEducation());
                    if (param != null) {
                        member.setStaffEducation(param.getParamValue());
                    } else {
                        member.setStaffEducation(null);
                    }
                }
                if (staffInfo.getStaffBasicInfo() == null) {
                    member.setStaffMobile(null);
                } else {
                    member.setStaffMobile(staffInfo.getStaffBasicInfo().getMobile());
                }
                if (staffInfo.getStaffBasicWork() == null || staffInfo.getStaffBasicWork().getCompanyOrganization() == null) {
                    member.setStaffOrganization(null);
                } else {
                    member.setStaffOrganization(staffInfo.getStaffBasicWork().getCompanyOrganization().getOrganizationName());
                }
            }
        }
        member.setEmployFiles(this.sysFileService.getListByIds(member.getEmployFile()));
        member.setOccHealthCertificates(this.sysFileService.getListByIds(member.getOccHealthCertificate()));
        if (!member.equals((CompanyFunctionalOrganizationMember)super.getById(member.getId()))) {
            super.updateByPrimaryKey(member, null);
        }
    }

    @Transactional
    public void deleteFunOrgMember(Long memberId, Long loginStaffId) {
        if (memberId == null || loginStaffId == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        CompanyFunctionalOrganizationMember member = (CompanyFunctionalOrganizationMember)super.getById(memberId);
        if (member != null) {
            super.delete(member, loginStaffId);
            List<CompanyFunctionalOrganizationMember> allMember = this.getMemberListByFunOrgId(member.getCompanyFunctionalOrganizationId());
            if (allMember == null || allMember.isEmpty()) {
                return;
            }
            ArrayList<CompanyFunctionalOrganizationMember> subMember = new ArrayList<CompanyFunctionalOrganizationMember>();
            for (CompanyFunctionalOrganizationMember entity : allMember) {
                if (!member.getId().equals(entity.getPid())) continue;
                subMember.add(entity);
                subMember.addAll(this.getSubMember(entity.getId(), allMember));
            }
            for (CompanyFunctionalOrganizationMember entity : subMember) {
                super.delete(entity, loginStaffId);
            }
        }
    }

    private List<CompanyFunctionalOrganizationMember> getSubMember(Long pid, List<CompanyFunctionalOrganizationMember> allMember) {
        ArrayList<CompanyFunctionalOrganizationMember> subMember = new ArrayList<CompanyFunctionalOrganizationMember>();
        for (CompanyFunctionalOrganizationMember entity : allMember) {
            if (!pid.equals(entity.getPid())) continue;
            subMember.add(entity);
            subMember.addAll(this.getSubMember(entity.getId(), allMember));
        }
        return subMember;
    }

    @Transactional(readOnly=false)
    public void updateById(CompanyFunctionalOrganizationMember member, Long loginStaffId) {
        member.setUpdateBy(loginStaffId);
        member.setUpdateDate(new Date());
        this.companyFunctionalOrganizationMemberMapper.updateById(member);
    }

    public CompanyFunctionalOrganizationMember getMemberByStaffId(Long staffId, Long funOrgId) {
        CompanyFunctionalOrganizationMember member = new CompanyFunctionalOrganizationMember();
        member.setCompanyFunctionalOrganizationId(funOrgId);
        member.setIsValid(Boolean.valueOf(true));
        member.setStaffId(staffId);
        List members = ((CompanyFunctionalOrganizationMemberMapper)this.dao).select(member);
        if (members != null && members.size() > 0) {
            return (CompanyFunctionalOrganizationMember)members.get(0);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateOrgStaff(CompanyFunctionalOrganizationMember member, Long loginStaffId) {
        if (member.getId() == null) {
            if (this.isExistMember(member)) {
                throw new RuntimeException("\u5df2\u5b58\u5728\u76f8\u540c\u4eba\u5458\u7c7b\u578b\u548c\u624b\u673a\u53f7\u7801\u7684\u4eba\u5458\u3002");
            }
            member.setId(Long.valueOf(this.idworker.nextId()));
            if (member.getOrgStaffType() != null) {
                member.setOrgStaffType(member.getOrgStaffType().trim());
            }
            member.setUpdateBy(loginStaffId);
            member.setUpdateDate(new Date());
            ((CompanyFunctionalOrganizationMemberMapper)this.dao).insertSelective(member);
            this.addOperateRecord(member, null, loginStaffId);
        } else {
            CompanyFunctionalOrganizationMember dbMember = (CompanyFunctionalOrganizationMember)super.getById(member.getId());
            if (dbMember == null) {
                throw new RuntimeException("\u4eba\u5458id\u9519\u8bef\u3002");
            }
            if ("1".equals(member.getOrgStaffType())) {
                member.setMemberType(null);
            }
            member.setUpdateDate(new Date());
            member.setUpdateBy(loginStaffId);
            ((CompanyFunctionalOrganizationMemberMapper)this.dao).updateMember(member);
            this.addOperateRecord(member, dbMember, loginStaffId);
        }
        return member.getId();
    }

    private boolean isExistMember(CompanyFunctionalOrganizationMember member) {
        if (member.getOrgStaffType() != null && member.getStaffMobile() != null) {
            if (StringUtils.isNotBlank((CharSequence)member.getOrgStaffType())) {
                List list = Arrays.stream(member.getOrgStaffType().split(",")).collect(Collectors.toList());
                member.setOrgStaffTypeList(list);
            }
            List<CompanyFunctionalOrganizationMember> memberList = ((CompanyFunctionalOrganizationMemberMapper)this.dao).getMemberByTypeAndMobile(member);
            return CollectionUtils.isNotEmpty(memberList);
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOperateRecord(CompanyFunctionalOrganizationMember newMember, CompanyFunctionalOrganizationMember oldMember, Long loginStaffId) {
        ArrayList<CompanyFunctionalOrganizationMemberLog> logList = new ArrayList<CompanyFunctionalOrganizationMemberLog>();
        if (oldMember == null) {
            CompanyFunctionalOrganizationMemberLog log = new CompanyFunctionalOrganizationMemberLog();
            log.setCid(newMember.getCid());
            log.setMemberId(newMember.getId());
            log.setStaffName(newMember.getStaffName());
            log.setType(Byte.valueOf((byte)1));
            logList.add(log);
        } else {
            CompanyFunctionalOrganizationMemberLog memberLog;
            CompanyFunctionalOrganizationMemberLog log = new CompanyFunctionalOrganizationMemberLog();
            log.setCid(oldMember.getCid());
            log.setMemberId(oldMember.getId());
            log.setStaffName(newMember.getStaffName());
            log.setType(Byte.valueOf((byte)2));
            if (StringUtils.isNotBlank((CharSequence)newMember.getStaffName()) && !newMember.getStaffName().equals(oldMember.getStaffName())) {
                memberLog = new CompanyFunctionalOrganizationMemberLog();
                BeanUtils.copyProperties((Object)log, (Object)memberLog);
                if (StringUtils.isNotBlank((CharSequence)oldMember.getStaffName())) {
                    memberLog.setBeforeChange(oldMember.getStaffName());
                }
                memberLog.setAfterChange(newMember.getStaffName());
                logList.add(memberLog);
            }
            if (StringUtils.isNotBlank((CharSequence)newMember.getStaffMobile()) && !newMember.getStaffMobile().equals(oldMember.getStaffMobile())) {
                memberLog = new CompanyFunctionalOrganizationMemberLog();
                BeanUtils.copyProperties((Object)log, (Object)memberLog);
                if (StringUtils.isNotBlank((CharSequence)oldMember.getStaffMobile())) {
                    memberLog.setBeforeChange(oldMember.getStaffMobile());
                }
                memberLog.setAfterChange(newMember.getStaffMobile());
                logList.add(memberLog);
            }
            if (newMember.getIsComplianceManager() != null && !newMember.getIsComplianceManager().equals(oldMember.getIsComplianceManager())) {
                memberLog = new CompanyFunctionalOrganizationMemberLog();
                BeanUtils.copyProperties((Object)log, (Object)memberLog);
                if (oldMember.getIsComplianceManager() != null) {
                    memberLog.setBeforeChange(oldMember.getIsComplianceManager() != false ? "\u662f" : "\u5426");
                }
                memberLog.setAfterChange(newMember.getIsComplianceManager() != false ? "\u662f" : "\u5426");
                logList.add(memberLog);
            }
            if (newMember.getMemberType() != null && !newMember.getMemberType().equals(oldMember.getMemberType())) {
                memberLog = new CompanyFunctionalOrganizationMemberLog();
                BeanUtils.copyProperties((Object)log, (Object)memberLog);
                if (oldMember.getMemberType() != null) {
                    memberLog.setBeforeChange(FunOrgMemberTypeEnum.getName((Byte)oldMember.getMemberType()));
                }
                memberLog.setAfterChange(FunOrgMemberTypeEnum.getName((Byte)newMember.getMemberType()));
                logList.add(memberLog);
            }
            if (StringUtils.isNotBlank((CharSequence)newMember.getOrgStaffType()) && !newMember.getOrgStaffType().equals(oldMember.getOrgStaffType())) {
                memberLog = new CompanyFunctionalOrganizationMemberLog();
                BeanUtils.copyProperties((Object)log, (Object)memberLog);
                memberLog.setBeforeChange(this.getOrgStaffType(oldMember.getOrgStaffType()));
                memberLog.setAfterChange(this.getOrgStaffType(newMember.getOrgStaffType()));
                logList.add(memberLog);
            }
        }
        this.companyFunctionalOrganizationMemberLogService.batchAddLog(logList, loginStaffId);
    }

    private String getOrgStaffType(String type) {
        Object str = "";
        if (StringUtils.isBlank((CharSequence)type)) {
            return str;
        }
        for (String s : type.split(",")) {
            if ("".equals(str)) {
                if ("1".equals(s)) {
                    str = "\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba";
                    continue;
                }
                if (!"2".equals(s)) continue;
                str = "\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458";
                continue;
            }
            if ("1".equals(s)) {
                str = (String)str + "\u3001\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba";
                continue;
            }
            if (!"2".equals(s)) continue;
            str = (String)str + "\u3001\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458";
        }
        return str;
    }

    public PageInfo<CompanyFunctionalOrganizationMemberLog> operateRecords(CompanyFunctionalOrganizationMemberLog search, JqGridParam page) {
        if (search.getIsBase() != null && search.getIsBase().booleanValue()) {
            search.setIsBase(Boolean.valueOf(true));
        } else {
            search.setIsBase(Boolean.valueOf(false));
        }
        PageInfo pageInfo = this.companyFunctionalOrganizationMemberLogService.getPageLog(search, page);
        return pageInfo;
    }

    public PageInfo<CompanyFunctionalOrganizationMember> getPageListByCid(Long cid, JqGridParam page) {
        CompanyFunctionalOrganizationMember search = new CompanyFunctionalOrganizationMember();
        search.setCid(cid);
        PageHelper.startPage((int)page.getPage(), (int)page.getRows());
        List<CompanyFunctionalOrganizationMember> memberList = ((CompanyFunctionalOrganizationMemberMapper)this.dao).getListByCid(search);
        if (CollectionUtils.isNotEmpty(memberList)) {
            for (CompanyFunctionalOrganizationMember member : memberList) {
                if ("1".equals(member.getOrgStaffType())) {
                    member.setManagerCert(Integer.valueOf(3));
                } else if ("2".equals(member.getOrgStaffType())) {
                    member.setLeaderCert(Integer.valueOf(3));
                }
                member.setEmployFiles(this.sysFileService.getListByIds(member.getEmployFile()));
            }
            return new PageInfo(memberList);
        }
        return new PageInfo();
    }

    public List<HealthManagementInfoVo> getListHealthManagementInfoVo(List<Long> cidList, Map<String, Object> param) {
        if (CollectionUtils.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((CompanyFunctionalOrganizationMemberMapper)this.dao).getListHealthManagementInfoVo(cidList);
    }

    @Transactional
    public void batchAddMember(List<CompanyFunctionalOrganizationMember> memberAddList, Long loginUserId) {
        if (CollectionUtils.isNotEmpty(memberAddList)) {
            Date date = new Date();
            this.batchUpdateOrInsert(memberAddList, CompanyFunctionalOrganizationMemberMapper.class, (e, mapper) -> {
                e.setCreateDate(date);
                e.setCreateBy(loginUserId);
                return mapper.insertSelective(e);
            }, 1000);
        }
    }

    @Transactional
    public void batchUpdateMember(List<CompanyFunctionalOrganizationMember> memberUpdateList, Long loginUserId) {
        if (CollectionUtils.isNotEmpty(memberUpdateList)) {
            Date date = new Date();
            this.batchUpdateOrInsert(memberUpdateList, CompanyFunctionalOrganizationMemberMapper.class, (e, mapper) -> {
                e.setUpdateDate(date);
                e.setUpdateBy(loginUserId);
                return mapper.updateByPrimaryKeySelective(e);
            }, 1000);
        }
    }

    public List<CertTrainStaffInfoVo> getCertStaffListByCid(Long cid, Boolean isComplianceManager) {
        if (cid == null) {
            throw new ServiceException("\u4f01\u4e1aid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        ArrayList<CertTrainStaffInfoVo> certStaffList = new ArrayList<CertTrainStaffInfoVo>();
        List<CompanyFunctionalOrganizationMember> memberList = this.getComplianceMemberListByCidList(ListUtil.toList((Object[])new Long[]{cid}), isComplianceManager);
        memberList.sort(Comparator.comparing(CompanyFunctionalOrganizationMember::getOrgStaffType, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(CompanyFunctionalOrganizationMember::getId));
        for (CompanyFunctionalOrganizationMember member : memberList) {
            String[] typeArray;
            String dataType;
            Integer dataSource;
            Integer leaderDataSource = member.getLeaderDataSource();
            Integer n = dataSource = leaderDataSource != null ? Convert.toInt((Object)leaderDataSource) : null;
            if (dataSource != null) {
                switch (Convert.toInt((Object)member.getLeaderDataSource())) {
                    case 1: 
                    case 2: 
                    case 4: {
                        dataType = "\u5176\u4ed6\u6765\u6e90";
                        break;
                    }
                    case 3: {
                        dataType = "\u6d59\u91cc\u536b\u4f01";
                        break;
                    }
                    case 5: {
                        dataType = "\u4e07\u8fbe\u4ed3-\u676d\u5dde\u57f9\u8bad";
                        break;
                    }
                    default: {
                        dataType = "-";
                        break;
                    }
                }
            } else {
                dataType = "-";
            }
            String statusName = "-";
            String orgStaffType = member.getOrgStaffType();
            if (isComplianceManager != null && isComplianceManager.booleanValue()) {
                boolean valid;
                boolean bl = valid = Objects.equals(member.getLeaderCert(), 1) || Objects.equals(member.getManagerCert(), 1);
                if (valid) {
                    statusName = this.getCertStatusName(1);
                }
                CertTrainStaffInfoVo c = new CertTrainStaffInfoVo().setCertType("3").setName(member.getStaffName()).setStaffType(this.getMemberTypeName(member.getMemberType())).setExpire(statusName).setDataType(dataType);
                certStaffList.add(c);
                continue;
            }
            if (!CharSequenceUtil.isNotBlank((CharSequence)orgStaffType)) continue;
            String[] stringArray = typeArray = orgStaffType.split(",");
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                String type;
                switch (type = stringArray[i]) {
                    case "1": {
                        statusName = this.getCertStatusName(member.getLeaderCert());
                        break;
                    }
                    case "2": {
                        statusName = this.getCertStatusName(member.getManagerCert());
                        break;
                    }
                }
                CertTrainStaffInfoVo c = new CertTrainStaffInfoVo().setCertType(type).setName(member.getStaffName()).setStaffType(this.getMemberTypeName(member.getMemberType())).setExpire(statusName).setDataType(dataType);
                certStaffList.add(c);
            }
        }
        return certStaffList;
    }

    private static boolean orgStaffTypeMatch(String orgStaffType, Object type) {
        if (CharSequenceUtil.isNotBlank((CharSequence)orgStaffType)) {
            Object[] array = orgStaffType.split(",");
            return ArrayUtil.indexOf((Object[])array, (Object)Convert.toStr((Object)type)) != -1;
        }
        return Boolean.FALSE;
    }

    public String getCertStatusName(Integer certStatus) {
        if (certStatus != null) {
            switch (certStatus) {
                case 0: {
                    return "\u65e0\u6548";
                }
                case 1: {
                    return "\u6709\u6548";
                }
                case 2: {
                    return "\u65e0\u8bc1\u4e66";
                }
                case 3: {
                    return "/";
                }
            }
            return "-";
        }
        return "-";
    }

    public CompanyFunctionalOrganizationMember getInfoById(Long memberId) {
        Example example = new Example(CompanyFunctionalOrganizationMember.class);
        example.createCriteria().andEqualTo("id", (Object)memberId).andEqualTo("isValid", (Object)true);
        List memberList = ((CompanyFunctionalOrganizationMemberMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)memberList)) {
            return (CompanyFunctionalOrganizationMember)memberList.get(0);
        }
        return null;
    }

    public CompanyFunctionalOrganizationMember getByStaffName(Long cid, String staffName) {
        return ((CompanyFunctionalOrganizationMemberMapper)this.dao).selectLaestData(cid, staffName);
    }

    @Transactional
    public void deleteOrgMember(Long memberId, Long loginStaffId) {
        CompanyFunctionalOrganizationMember dbMember = this.getInfoById(memberId);
        if (dbMember == null) {
            throw new RuntimeException("id\u4e3a" + memberId + "\u7684\u4eba\u5458\u4e0d\u5b58\u5728\u3002");
        }
        dbMember.setIsValid(Boolean.valueOf(false));
        dbMember.setUpdateBy(loginStaffId);
        dbMember.setUpdateDate(new Date());
        dbMember.setIsAutoGenerated(Byte.valueOf((byte)0));
        ((CompanyFunctionalOrganizationMemberMapper)this.dao).updateByPrimaryKeySelective(dbMember);
        CompanyFunctionalOrganizationMemberLog memberLog = new CompanyFunctionalOrganizationMemberLog();
        memberLog.setCid(dbMember.getCid());
        memberLog.setMemberId(dbMember.getId());
        memberLog.setStaffName(dbMember.getStaffName());
        memberLog.setType(Byte.valueOf((byte)3));
        this.companyFunctionalOrganizationMemberLogService.batchAddLog(Collections.singletonList(memberLog), loginStaffId);
    }

    private String getMemberTypeName(Byte memberType) {
        if (memberType == null) {
            return "";
        }
        switch (memberType) {
            case 1: {
                return "\u4e13\u804c";
            }
            case 2: {
                return "\u517c\u804c";
            }
        }
        return "";
    }

    public List<CompanyFunctionalOrganizationMember> selectCerType(Long cid, String staffName) {
        return ((CompanyFunctionalOrganizationMemberMapper)this.dao).selectCerType(cid, staffName);
    }
}

