/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.company;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.base.company.CompanyFunctionalOrganizationMemberCertMapper;
import cn.smarthse.modules.health.dao.base.company.CompanyFunctionalOrganizationMemberMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMemberCert;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationMemberCertService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(rollbackFor={Exception.class})
public class CompanyFunctionalOrganizationMemberCertServiceImpl
extends BaseServiceImpl<CompanyFunctionalOrganizationMemberCertMapper, CompanyFunctionalOrganizationMemberCert>
implements ICompanyFunctionalOrganizationMemberCertService {
    @Autowired
    private ICertificateFilesService certificateFilesService;
    @Autowired
    private CompanyFunctionalOrganizationMemberMapper memberMapper;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;

    public PageInfo<CompanyFunctionalOrganizationMemberCert> memberCertList(Long memberId, JqGridParam page) {
        PageHelper.startPage((int)page.getPage(), (int)page.getRows());
        List<CompanyFunctionalOrganizationMemberCert> certList = ((CompanyFunctionalOrganizationMemberCertMapper)this.dao).getMemberCertList(memberId);
        if (CollectionUtils.isEmpty(certList)) {
            return new PageInfo();
        }
        for (CompanyFunctionalOrganizationMemberCert memberCert : certList) {
            List files = this.certificateFilesService.getByCerid(memberCert.getCertId());
            memberCert.setFiles(files);
        }
        return new PageInfo(certList);
    }

    public void relateCert(Long cid, Long memberId, String certIds, Long loginUserId) {
        Example example = new Example(CompanyFunctionalOrganizationMemberCert.class);
        example.createCriteria().andEqualTo("id", (Object)memberId).andEqualTo("isValid", (Object)true);
        CompanyFunctionalOrganizationMember one = (CompanyFunctionalOrganizationMember)this.memberMapper.selectOneByExample(example);
        ArrayList<CompanyFunctionalOrganizationMemberCert> memberCertList = new ArrayList<CompanyFunctionalOrganizationMemberCert>();
        for (String certId : certIds.split(",")) {
            CompanyFunctionalOrganizationMemberCert memberCert = new CompanyFunctionalOrganizationMemberCert();
            memberCert.setCid(cid);
            memberCert.setMemberId(memberId);
            memberCert.setCertId(Long.valueOf(certId));
            memberCertList.add(memberCert);
        }
        String name = this.certificateStaffDetailService.checkCertStaffName(certIds);
        if (!one.getStaffName().equals(name)) {
            throw new HealthException("\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u6240\u9009\u5bf9\u5e94\u8bc1\u660e\u4eba\u59d3\u540d\u662f\u5426\u4e00\u81f4");
        }
        if (CollectionUtils.isNotEmpty(memberCertList)) {
            Date date = new Date();
            this.batchUpdateOrInsert(memberCertList, CompanyFunctionalOrganizationMemberCertMapper.class, (e, mapper) -> {
                e.setId(Long.valueOf(this.idworker.nextId()));
                e.setUpdateDate(date);
                e.setUpdateBy(loginUserId);
                return mapper.insertSelective(e);
            });
        }
        this.updateMember(memberId, loginUserId);
    }

    private void updateMember(Long memberId, Long loginUserId) {
        CompanyFunctionalOrganizationMember member = new CompanyFunctionalOrganizationMember();
        member.setId(memberId);
        member.setUpdateDate(new Date());
        member.setUpdateBy(loginUserId);
        this.memberMapper.updateByPrimaryKeySelective(member);
    }

    public Long deleteCert(Long id, Long loginStaffId) {
        CompanyFunctionalOrganizationMemberCert memberCert = ((CompanyFunctionalOrganizationMemberCertMapper)this.dao).getMemberId(id);
        if (memberCert == null) {
            throw new RuntimeException("\u53c2\u6570id\u9519\u8bef\u3002");
        }
        this.delete(memberCert, loginStaffId);
        this.updateMember(memberCert.getMemberId(), loginStaffId);
        return id;
    }

    public List<CompanyFunctionalOrganizationMemberCert> countByCerId(Long cerId) {
        Example example = new Example(CompanyFunctionalOrganizationMemberCert.class);
        example.createCriteria().andEqualTo("certId", (Object)cerId).andEqualTo("isValid", (Object)true);
        return ((CompanyFunctionalOrganizationMemberCertMapper)this.dao).selectByExample(example);
    }
}

