/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.company;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.dao.base.company.CompanyBaseInfoMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyBaseInfo;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyBaseInfoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class CompanyBaseInfoServiceImpl
extends BaseServiceImpl<CompanyBaseInfoMapper, CompanyBaseInfo>
implements ICompanyBaseInfoService {
    @Autowired
    ICompanyService companyService;
    @Autowired
    private DataSourceTransactionManager txManager;

    @Transactional
    public void copySuperviseFromDataCentre() {
        this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65---\u5f00\u59cb\u3011");
        this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65---\u5b8c\u6210\u3011");
    }

    private void commitOneBatch(int page, int pageSize) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            List counts = this.companyService.listSuperviseCompanyData(page, pageSize);
            ((CompanyBaseInfoMapper)this.dao).insertBatch(counts);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u51fa\u9519\u3011", (Throwable)e);
        }
    }

    public void copySuperviseFromDataCentre1() {
        this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65---\u5f00\u59cb\u3011");
        this.clearOld();
        this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65---\u6e05\u9664\u65e7\u6570\u636e\u5b8c\u6210\u3011");
        List companies = this.companyService.listSuperviseCompanyData();
        this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65---\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u4f01\u4e1a\u5b8c\u6210\u3011");
        if (companies == null || companies.isEmpty()) {
            return;
        }
        ArrayList<Object> infos = new ArrayList<CompanySuperviseModel>();
        ArrayList errors = new ArrayList();
        Date updateDate = new Date();
        this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65---\u5f00\u59cb\u8f6c\u6362\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\uff1a" + companies.size() + "\u6761\u3011");
        int i = 1;
        for (CompanySuperviseModel c : companies) {
            infos.add(c);
            if (infos.size() != 1000) continue;
            this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u5f00\u59cb\u7b2c\uff1a" + i + "\u6279\u3011");
            this.commitOne(infos);
            infos = new ArrayList();
            this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u7ed3\u675f\u7b2c\uff1a" + ++i + "\u6279\u3011");
        }
        if (infos.size() > 0) {
            this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u5f00\u59cb\u7b2c\uff1a" + i + "\u6279\u3011");
            this.commitOne(infos);
            this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u7ed3\u675f\u7b2c\uff1a" + i + "\u6279\u3011");
        }
        this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65---\u5b8c\u6210\u3011");
    }

    private void clearOld() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            Example example = new Example(CompanyBaseInfo.class);
            ((CompanyBaseInfoMapper)this.dao).deleteByExample(example);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u6e05\u9664\u65e7\u6570\u636e\u51fa\u9519\u3011", (Throwable)e);
        }
        this.logger.info("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65---\u6e05\u9664\u65e7\u6570\u636e\u5b8c\u6210\u3011");
    }

    private void clearOld1() {
        ((CompanyBaseInfoMapper)this.dao).clearAll();
    }

    private void commitOne(List<CompanySuperviseModel> counts) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            ((CompanyBaseInfoMapper)this.dao).insertBatch(counts);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            this.logger.error("\u3010\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u540c\u6b65\u51fa\u9519\u3011", (Throwable)e);
        }
    }
}

