/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl.company;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.HttpUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.common.util.number.NumberChangeToChinese;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.base.company.CompanyAreaMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.base.company.CompanyAreaBuildingInfo;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaBuildingInfoService;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.vo.base.company.AreaWorkInfo;
import cn.smarthse.modules.health.vo.base.company.AreaWorkInfoParseVo;
import cn.smarthse.modules.health.vo.base.company.AreaWorkInfoVo;
import cn.smarthse.util.common.excel.model.ExcelModel;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class CompanyAreaServiceImpl
extends BaseServiceImpl<CompanyAreaMapper, CompanyArea>
implements ICompanyAreaService {
    @Autowired
    CompanyAreaMapper companyAreaMapper;
    @Autowired
    private ICompanyAreaBuildingInfoService buildingServcie;
    @DubboReference
    private ISysFileProvideService fileServcie;
    @Resource(name="transactionManager")
    private DataSourceTransactionManager transactionManager;

    public List<CompanyArea> getListByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("sort asc");
        List list = ((CompanyAreaMapper)this.dao).selectByExample(example);
        for (CompanyArea area : list) {
            if (StringUtils.isEmpty((CharSequence)area.getTreePath())) continue;
            String[] treeIds = area.getTreePath().split(",");
            StringBuffer treePathName = new StringBuffer();
            block1: for (String treeId : treeIds) {
                if (!StringUtils.isLong((String)treeId)) continue;
                for (CompanyArea a : list) {
                    if (!a.getId().equals(Long.valueOf(treeId))) continue;
                    treePathName.append(a.getAreaName()).append("\uff1e");
                    continue block1;
                }
            }
            if (treePathName.length() <= 0) continue;
            area.setTreePathName(treePathName.toString());
        }
        return list;
    }

    public List<CompanyArea> getAreasHarm(Long cid) {
        List<CompanyArea> companyAreaList = this.getListByCid(cid);
        if (CollectionUtils.isNotEmpty(companyAreaList)) {
            for (CompanyArea companyArea : companyAreaList) {
            }
        }
        return null;
    }

    public List<CompanyArea> getRootListByCid(Long cid) {
        if (cid == null) {
            return Collections.emptyList();
        }
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andIsNull("pid");
        example.setOrderByClause("sort asc");
        List list = ((CompanyAreaMapper)this.dao).selectByExample(example);
        return list;
    }

    public List<CompanyArea> getChildListByPid(Long pid) {
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true);
        if (pid == null) {
            criteria.andIsNull("pid");
        } else {
            criteria.andEqualTo("pid", (Object)pid);
        }
        example.setOrderByClause("sort asc");
        return ((CompanyAreaMapper)this.dao).selectByExample(example);
    }

    public List<CompanyArea> getChildrenListByPid(Long pid) {
        if (pid == null) {
            return Collections.emptyList();
        }
        CompanyArea parent = this.getById(pid);
        Object treePath = "";
        treePath = StringUtils.isNotBlank((CharSequence)parent.getTreePath()) ? parent.getTreePath() + "," + pid : "" + pid;
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andLike("treePath", (String)treePath + ",%");
        example.or().andEqualTo("isValid", (Object)true).andEqualTo("treePath", treePath);
        example.setOrderByClause("create_date asc");
        List list = ((CompanyAreaMapper)this.dao).selectByExample(example);
        return list;
    }

    private CompanyArea setAttendInfo(CompanyArea parentArea, CompanyArea entity) {
        if (parentArea != null) {
            Byte level = (byte)(parentArea.getLevel() == null ? 1 : parentArea.getLevel() + 1);
            entity.setLevel(level);
            List child = parentArea.getChild();
            if (child != null && !child.isEmpty()) {
                if (child.size() == 1) {
                    ((CompanyArea)child.get(0)).setSort(Integer.valueOf(0));
                }
                child.sort(Comparator.comparing(CompanyArea::getSort));
                Integer sort = ((CompanyArea)child.get(child.size() - 1)).getSort();
                entity.setSort(Integer.valueOf(sort + 1));
            }
            String treePath = StringUtils.isEmpty((CharSequence)parentArea.getTreePath()) ? "" + parentArea.getId() : parentArea.getTreePath() + "," + parentArea.getId();
            entity.setTreePath(treePath);
        } else {
            entity.setLevel(Byte.valueOf((byte)1));
        }
        return entity;
    }

    @Override
    public CompanyArea getById(Long id) {
        CompanyArea area = (CompanyArea)super.getById(id);
        if (area != null && area.getIsValid() != null && !area.getIsValid().booleanValue()) {
            area.setAreaName("(\u5df2\u5220\u9664)" + area.getAreaName());
        }
        return area;
    }

    @Override
    @Transactional(readOnly=false)
    public CompanyArea add(CompanyArea entity, Long loginStaffId, Long cid) {
        CompanyArea companyArea;
        ValidateUtil.valid((Object)entity, (String)"add");
        if (this.hasName(entity.getPid(), cid, entity.getAreaName(), null)) {
            throw new HealthException("\u533a\u57df\u540d\u79f0\u91cd\u590d");
        }
        if (entity.getPid() != null) {
            companyArea = this.getById(entity.getPid());
            entity = this.setAttendInfo(companyArea, entity);
        } else {
            entity.setLevel(Byte.valueOf((byte)1));
        }
        entity.setSort(Integer.valueOf(this.getMinSortUnused(entity.getPid(), cid)));
        companyArea = super.add(entity, loginStaffId, cid);
        if (entity.getBuildingInfo() != null) {
            boolean hasTotalFlowNum;
            boolean hasFloorUp = entity.getBuildingInfo().getFloorUpNum() != null && entity.getBuildingInfo().getFloorUpNum() > 0;
            boolean hasFloorDown = entity.getBuildingInfo().getFloorBelowNum() != null && entity.getBuildingInfo().getFloorBelowNum() > 0;
            boolean bl = hasTotalFlowNum = entity.getBuildingInfo().getFloorTotalNum() != null && entity.getBuildingInfo().getFloorTotalNum() > 0;
            if (!hasFloorUp && !hasFloorDown && hasTotalFlowNum) {
                for (int i = 0; i < entity.getBuildingInfo().getFloorTotalNum(); ++i) {
                    this.addSubArea(companyArea, loginStaffId, cid, i + 1, false);
                }
            } else {
                int i;
                int totalFloorNum = 0;
                if (hasFloorUp) {
                    for (i = 0; i < entity.getBuildingInfo().getFloorUpNum(); ++i) {
                        this.addSubArea(companyArea, loginStaffId, cid, i + 1, false);
                    }
                    totalFloorNum += entity.getBuildingInfo().getFloorUpNum().intValue();
                }
                if (hasFloorDown) {
                    for (i = 0; i < entity.getBuildingInfo().getFloorBelowNum(); ++i) {
                        this.addSubArea(companyArea, loginStaffId, cid, i + 1, true);
                    }
                    totalFloorNum += entity.getBuildingInfo().getFloorBelowNum().intValue();
                }
                entity.getBuildingInfo().setFloorTotalNum(Integer.valueOf(totalFloorNum));
            }
            entity.getBuildingInfo().setCompanyAreaId(companyArea.getId());
            this.buildingServcie.add((Object)entity.getBuildingInfo(), loginStaffId, cid);
        }
        return companyArea;
    }

    private void addSubArea(CompanyArea parentArea, Long loginStaffId, Long cid, int level, boolean isDown) {
        CompanyArea subArea = new CompanyArea();
        String areaName = "";
        areaName = isDown ? "\u5730\u4e0b\u043f\u0440\u0435\u0434\u0441\u0442\u043e\u0438\u0442_\u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c\u5c42".replace("\u043f\u0440\u0435\u0434\u0441\u0442\u043e\u0438\u0442_\u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c", NumberChangeToChinese.getInstance().numberToChinese(level)) : "\u043f\u0440\u0435\u0434\u0441\u0442\u043e\u0438\u0442_\u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c\u5c42".replace("\u043f\u0440\u0435\u0434\u0441\u0442\u043e\u0438\u0442_\u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c", NumberChangeToChinese.getInstance().numberToChinese(level));
        subArea.setAreaName(areaName);
        subArea.setPid(parentArea.getId());
        subArea = this.setAttendInfo(parentArea, subArea);
        super.add(subArea, loginStaffId, cid);
        parentArea.getChild().add(subArea);
    }

    public List<CompanyArea> getWorkPlaceList(Long cid, JqGridParam param) {
        if (cid == null) {
            return null;
        }
        String name = null;
        if (param != null && param.getPostDatas() != null) {
            for (ParamSeachFieldVO vo : param.getPostDatas()) {
                if (!"areaName".equals(vo.getSearchField())) continue;
                name = StringEscapeUtils.unescapeHtml4((String)vo.getSearchValue());
                break;
            }
        }
        List<CompanyArea> workPlaceList = ((CompanyAreaMapper)this.dao).searchWorkPlace(cid, name, Constants.WORK_PLACE_LEVEL);
        return workPlaceList;
    }

    public PageInfo<CompanyArea> getWorkPlacePageInfo(Long cid, JqGridParam param) {
        if (cid == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyArea> workPlaceList = this.getWorkPlaceList(cid, param);
        PageInfo pageInfo = new PageInfo(workPlaceList);
        return pageInfo;
    }

    @Transactional(readOnly=false)
    public List<CompanyArea> importAreaByFileId(Long fileId, Long loginStaffId, Long cid) {
        if (fileId == null) {
            return Collections.emptyList();
        }
        SysFileModel file = this.fileServcie.getFileById(fileId);
        if (file == null) {
            throw new HealthException(ErrorEnum.FILE_EMPTY);
        }
        return this.importAreaByUrlPath(file.getOssUrl(), loginStaffId, cid);
    }

    private void checkImportArea(Map<String, ArrayList<ArrayList<String>>> contentMap) {
        if (contentMap == null) {
            throw new HealthException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        Iterator<Map.Entry<String, ArrayList<ArrayList<String>>>> iterator = contentMap.entrySet().iterator();
        StringBuffer errorStr = new StringBuffer();
        while (iterator.hasNext()) {
            ArrayList<ArrayList<String>> list = iterator.next().getValue();
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).isEmpty()) continue;
                int line = i + 2;
                if (list.get(i).size() < 3) {
                    errorStr.append("\u7b2c" + line + "\u884c\u5185\u5bb9\u6709\u5931").append("<br/>");
                    continue;
                }
                String branchFactoryName = list.get(i).get(0);
                String buildName = list.get(i).get(1);
                String level = list.get(i).get(2);
                if (StringUtils.isEmpty((CharSequence)branchFactoryName) && StringUtils.isEmpty((CharSequence)buildName) & StringUtils.isEmpty((CharSequence)level)) continue;
                if (StringUtils.isEmpty((CharSequence)branchFactoryName)) {
                    errorStr.append("\u7b2c" + line + "\u884c\u7b2c1\u5217(\u533a\u57df/\u5206\u5382)\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a").append("<br/>");
                }
                if (StringUtils.isEmpty((CharSequence)buildName)) {
                    errorStr.append("\u7b2c" + line + "\u884c\u7b2c2\u5217(\u5efa\uff08\u6784\uff09\u7b51\u7269\u540d\u79f0)\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a").append("<br/>");
                }
                if (StringUtils.isLong((String)level)) continue;
                errorStr.append("\u7b2c" + line + "\u884c\u7b2c3\u5217(\u5c42\u6570)\u5185\u5bb9\u6709\u8bef").append("<br/>");
            }
        }
        if (errorStr.length() > 0) {
            throw new HealthException(errorStr.toString());
        }
    }

    @Transactional(readOnly=false)
    public List<CompanyArea> importAreaByUrlPath(String fileUrlPath, Long loginStaffId, Long cid) {
        if (!HttpUtil.isUrlCurrent((String)fileUrlPath)) {
            throw new HealthException(ErrorEnum.OSS_URL_ERROR);
        }
        ArrayList<Integer> cellValidNumList = new ArrayList<Integer>();
        cellValidNumList.add(0);
        ArrayList<Integer> colValidNumList = new ArrayList<Integer>();
        colValidNumList.add(1);
        Map contentMap = null;
        try {
            contentMap = ExcelUtil.getInstance().getContentFromUrl(fileUrlPath, cellValidNumList, colValidNumList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkImportArea(contentMap);
        Iterator iterator = contentMap.entrySet().iterator();
        ArrayList<CompanyArea> idList = new ArrayList<CompanyArea>();
        while (iterator.hasNext()) {
            ArrayList list = (ArrayList)iterator.next().getValue();
            for (ArrayList l : list) {
                String branchFactoryName = (String)l.get(0);
                if (StringUtils.isEmpty((CharSequence)branchFactoryName)) continue;
                CompanyArea branchEntity = this.getAreaByName(branchFactoryName, cid);
                if (branchEntity == null) {
                    branchEntity = new CompanyArea();
                    branchEntity.setAreaName(branchFactoryName);
                    branchEntity = this.add(branchEntity, loginStaffId, cid);
                }
                CompanyArea area = new CompanyArea();
                area.setAreaName((String)l.get(1));
                area.setCid(cid);
                area.setPid(branchEntity.getId());
                CompanyAreaBuildingInfo buildInfo = new CompanyAreaBuildingInfo();
                if (l.size() > 2 && StringUtils.isNumber((String)((String)l.get(2)))) {
                    buildInfo.setFloorTotalNum(Integer.valueOf((String)l.get(2)));
                }
                area.setBuildingInfo(buildInfo);
                this.add(area, loginStaffId, cid);
                idList.add(area);
            }
        }
        return idList;
    }

    @Transactional(readOnly=false)
    public void importAreaByUrlPathV2_10(String fileUrlPath, Long loginStaffId, Long cid) {
        if (!HttpUtil.isUrlCurrent((String)fileUrlPath)) {
            throw new HealthException(ErrorEnum.OSS_URL_ERROR);
        }
        ArrayList<Integer> cellValidNumList = new ArrayList<Integer>();
        cellValidNumList.add(0);
        ArrayList<Integer> colValidNumList = new ArrayList<Integer>();
        colValidNumList.add(1);
        Map contentMap = null;
        try {
            contentMap = ExcelUtil.getInstance().getContentFromUrl(fileUrlPath, cellValidNumList, colValidNumList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator iterator = contentMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList list = (ArrayList)iterator.next().getValue();
            for (ArrayList l : list) {
                String branchFactoryName;
                Long pId = null;
                for (int i = 0; i < 4 && !StringUtils.isEmpty((CharSequence)(branchFactoryName = (String)l.get(i))); ++i) {
                    CompanyArea branchEntity = this.getAreaByNameAndPid(branchFactoryName, pId, cid);
                    if (branchEntity == null) {
                        branchEntity = new CompanyArea();
                        branchEntity.setAreaName(branchFactoryName);
                        branchEntity.setPid(pId);
                        branchEntity = this.add(branchEntity, loginStaffId, cid);
                    }
                    pId = branchEntity.getId();
                }
            }
        }
    }

    @Transactional(readOnly=false)
    public void importArea(ExcelModel excelModel, Long loginStaffId, Long cid) {
        for (SheetModel sheet : excelModel.getSheets()) {
            for (RowModel l : sheet.getRows()) {
                String branchFactoryName;
                Long pId = null;
                for (int i = 0; i < 4 && !StringUtils.isEmpty((CharSequence)(branchFactoryName = (String)l.get(i))); ++i) {
                    CompanyArea branchEntity = this.getAreaByNameAndPid(branchFactoryName, pId, cid);
                    if (branchEntity == null) {
                        branchEntity = new CompanyArea();
                        branchEntity.setAreaName(branchFactoryName);
                        branchEntity.setPid(pId);
                        branchEntity = this.add(branchEntity, loginStaffId, cid);
                    }
                    pId = branchEntity.getId();
                }
            }
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void update(CompanyArea entity, Long loginStaffId) {
        ValidateUtil.valid((Object)entity, (String)"edit");
        CompanyArea oldEntity = (CompanyArea)super.getById(entity.getId());
        if (oldEntity != null && !oldEntity.getAreaName().equals(entity.getAreaName()) && this.hasName(oldEntity.getPid(), oldEntity.getCid(), entity.getAreaName(), oldEntity.getId())) {
            throw new HealthException("\u533a\u57df\u540d\u79f0\u91cd\u590d");
        }
        super.update(entity, loginStaffId);
        entity = (CompanyArea)super.getById(entity.getId());
    }

    public Integer getBuildingNumByCid(Long cid) {
        if (cid == null) {
            return 0;
        }
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        CompanyArea param = new CompanyArea();
        param.setCid(cid);
        param.setIsValid(Boolean.valueOf(true));
        criteria.andEqualTo((Object)param).andEqualTo("level", (Object)Constants.BUILDING_LEVEL);
        return ((CompanyAreaMapper)this.dao).selectCountByExample(example);
    }

    public Integer getAreaNumByCid(Long cid) {
        if (cid == null) {
            return 0;
        }
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        CompanyArea param = new CompanyArea();
        param.setCid(cid);
        param.setIsValid(Boolean.valueOf(true));
        criteria.andEqualTo((Object)param).andGreaterThan("level", (Object)Constants.BUILDING_LEVEL);
        return ((CompanyAreaMapper)this.dao).selectCountByExample(example);
    }

    public PageInfo<CompanyArea> getBuildingPageInfoByCid(Long cid, int pageNum, int pageSize, boolean needBuildingInfo) {
        if (cid == null || pageNum < 1 || pageSize < 1) {
            return null;
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("level", (Object)Constants.BUILDING_LEVEL);
        List buildingList = ((CompanyAreaMapper)this.dao).selectByExample(example);
        if (needBuildingInfo) {
            List allBuildingInfo = this.buildingServcie.getAllCompanyAreaBuildingInfoByCid(cid);
            block0: for (CompanyArea building : buildingList) {
                for (CompanyAreaBuildingInfo buildingInfo : allBuildingInfo) {
                    if (!building.getId().equals(buildingInfo.getCompanyAreaId())) continue;
                    building.setBuildingInfo(buildingInfo);
                    continue block0;
                }
            }
        }
        PageInfo pageInfo = new PageInfo(buildingList);
        return pageInfo;
    }

    @Transactional(readOnly=false)
    public void deleteAreaByCid(Long cid, Long loginStaffId) {
        CompanyArea area = new CompanyArea();
        area.setIsValid(Boolean.valueOf(false));
        super.setUpdateInfo(area, loginStaffId);
        Example example = new Example(CompanyArea.class);
        example.createCriteria().andEqualTo("cid", (Object)cid);
        ((CompanyAreaMapper)this.dao).updateByExampleSelective(area, example);
    }

    @Override
    @Transactional
    public void delete(CompanyArea entity, Long loginStaffId) {
        if (entity == null) {
            return;
        }
        if ((entity = (CompanyArea)super.getById(entity.getId())) == null) {
            return;
        }
        super.delete(entity, loginStaffId);
        Example example = new Example(CompanyArea.class);
        example.createCriteria().andLike("treePath", (String)(StringUtils.isEmpty((CharSequence)entity.getTreePath()) ? "" : entity.getTreePath() + ",") + entity.getId() + "%");
        List subList = ((CompanyAreaMapper)this.dao).selectByExample(example);
        for (CompanyArea c : subList) {
            super.delete(c, loginStaffId);
        }
    }

    public Integer getBuildingCount(Long cid) {
        if (cid == null) {
            return 0;
        }
        CompanyArea record = new CompanyArea();
        record.setIsValid(Boolean.valueOf(true));
        record.setCid(cid);
        record.setLevel(Constants.BUILDING_LEVEL);
        return ((CompanyAreaMapper)this.dao).selectCount(record);
    }

    public String getAreaNamesByAreaIds(String areaIds) {
        if (StringUtils.isEmpty((CharSequence)areaIds)) {
            return "";
        }
        String[] ids = areaIds.split(",");
        StringBuffer names = new StringBuffer("");
        for (String id : ids) {
            CompanyArea area;
            if (!StringUtils.isNumber((String)id) || (area = (CompanyArea)super.getById(Long.valueOf(id))) == null || !StringUtils.isNotEmpty((String)area.getAreaName())) continue;
            if (!area.getIsValid().booleanValue()) {
                names.append("(\u5df2\u5220\u9664)");
            }
            names.append(this.getTreePathNameByTreePath(area.getTreePath()) + area.getAreaName());
            names.append(",");
        }
        if (names.length() > 0) {
            names.deleteCharAt(names.lastIndexOf(","));
        }
        return names.toString();
    }

    public CompanyArea getAreaByName(String name, Long cid) {
        Example example = new Example(CompanyArea.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("areaName", (Object)name).andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        if (list.size() > 0) {
            return (CompanyArea)list.get(0);
        }
        return null;
    }

    public CompanyArea getAreaByNameAndPid(String name, Long pid, Long cid) {
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("areaName", (Object)name).andEqualTo("isValid", (Object)Global.TRUE);
        if (pid == null) {
            criteria.andIsNull("pid");
        } else {
            criteria.andEqualTo("pid", (Object)pid);
        }
        List list = this.getListByExample(example);
        if (list != null && !list.isEmpty()) {
            return (CompanyArea)list.get(0);
        }
        return null;
    }

    public List<CompanyArea> searchArea(String areaName, Long cid) {
        if (StringUtils.isBlank((CharSequence)areaName) || cid == null) {
            return Collections.emptyList();
        }
        List<CompanyArea> all = this.getListByCid(cid);
        ArrayList<CompanyArea> list = new ArrayList<CompanyArea>();
        for (CompanyArea area : all) {
            if (area.getAreaName().indexOf(areaName) <= -1) continue;
            list.add(area);
        }
        return list;
    }

    public String getTreePathNameByAreaId(Long areaId) {
        if (areaId == null) {
            return "";
        }
        CompanyArea area = (CompanyArea)super.getById(areaId);
        if (area == null || StringUtils.isEmpty((CharSequence)area.getTreePath())) {
            return "";
        }
        return this.getTreePathNameByTreePath(area.getTreePath());
    }

    public String getAreaFullName(Long areaId) {
        if (areaId == null) {
            return "";
        }
        CompanyArea area = (CompanyArea)super.getById(areaId);
        if (area == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)area.getTreePath())) {
            return area.getAreaName();
        }
        return this.getTreePathNameByTreePath(area.getTreePath()) + area.getAreaName();
    }

    public String getTreePathNameByTreePath(String treePath) {
        if (StringUtils.isEmpty((CharSequence)treePath)) {
            return "";
        }
        String[] ids = treePath.split(",");
        if (ids == null || ids.length < 1) {
            return "";
        }
        StringBuffer treePathName = new StringBuffer();
        for (String id : ids) {
            CompanyArea area;
            if (!StringUtils.isNumber((String)id) || (area = (CompanyArea)super.getById(Long.valueOf(id))) == null || StringUtils.isEmpty((CharSequence)area.getAreaName())) continue;
            treePathName.append(area.getAreaName());
            treePathName.append("\uff1e");
        }
        if (treePathName.length() > 0) {
            return treePathName.toString();
        }
        return "";
    }

    public Integer getAreaCountByCid(Long cid) {
        if (cid == null) {
            return 0;
        }
        CompanyArea record = new CompanyArea();
        record.setIsValid(Boolean.valueOf(true));
        record.setCid(cid);
        return ((CompanyAreaMapper)this.dao).selectCount(record);
    }

    @Transactional
    public CompanyArea cloneArea(Long id, String name, Long loginStaffId, Long cid) {
        CompanyArea area = this.getById(id);
        if (area == null) {
            return null;
        }
        area.setAreaName(name);
        area = this.clone(area, loginStaffId, cid);
        return area;
    }

    private CompanyArea clone(CompanyArea area, Long loginStaffId, Long cid) {
        List<CompanyArea> list = this.getChildListByPid(area.getId());
        CompanyAreaBuildingInfo buildingInfo = this.buildingServcie.getBuildingInfoByBuildingId(area.getId());
        area.setId(null);
        area.setSort(Integer.valueOf(this.getMinSortUnused(area.getPid(), cid)));
        area = super.add(area, loginStaffId, cid);
        if (buildingInfo != null) {
            buildingInfo.setCompanyAreaId(area.getId());
            buildingInfo.setId(null);
            this.buildingServcie.add((Object)buildingInfo, loginStaffId, cid);
        }
        if (list != null && !list.isEmpty()) {
            for (CompanyArea a : list) {
                a.setPid(area.getId());
                a = this.setAttendInfo(area, a);
                area.getChild().add(this.clone(a, loginStaffId, cid));
            }
        }
        return area;
    }

    public boolean hasName(Long pid, Long cid, String name, Long thisId) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return true;
        }
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andEqualTo("areaName", (Object)name);
        if (thisId != null) {
            criteria.andNotEqualTo("id", (Object)thisId);
        }
        if (pid == null) {
            if (cid == null) {
                return true;
            }
            criteria.andIsNull("pid");
            criteria.andEqualTo("cid", (Object)cid);
        } else {
            criteria.andEqualTo("pid", (Object)pid);
        }
        int count = ((CompanyAreaMapper)this.dao).selectCountByExample(example);
        return count > 0;
    }

    private int getMinSortUnused(Long pid, Long cid) {
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true);
        if (pid == null) {
            criteria.andEqualTo("cid", (Object)cid).andIsNull("pid");
        } else {
            criteria.andEqualTo("pid", (Object)pid);
        }
        example.setOrderByClause("sort desc");
        CompanyArea area = (CompanyArea)super.getOneByExample(example);
        if (area == null) {
            return 0;
        }
        if (area.getSort() == null) {
            return 1;
        }
        return area.getSort() + 1;
    }

    @Transactional
    public ResponseData<String> drag(Long areaId, Long targetId, String moveType, Long loginStaffId) {
        int targetSort;
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        if (areaId == null) {
            data.setContent("\u9700\u8981\u62d6\u52a8\u7684\u533a\u57df\u4e22\u5931");
            return data;
        }
        if (targetId == null) {
            data.setContent("\u76ee\u6807\u533a\u57df\u4e22\u5931");
            return data;
        }
        CompanyArea area = (CompanyArea)super.getById(areaId);
        if (area == null) {
            data.setContent("\u9700\u8981\u62d6\u52a8\u7684\u533a\u57df\u4e0d\u5b58\u5728");
            return data;
        }
        CompanyArea targetArea = (CompanyArea)super.getById(targetId);
        if (targetArea == null) {
            data.setContent("\u76ee\u6807\u533a\u57df\u4e0d\u5b58\u5728");
            return data;
        }
        int num = 0;
        int n = targetSort = targetArea.getSort() == null ? 0 : targetArea.getSort();
        if (StringUtils.isBlank((CharSequence)moveType)) {
            data.setContent("\u6392\u5e8f\u4f4d\u7f6e\u4e22\u5931");
            return data;
        }
        if (!"next".equals(moveType) && !"prev".equals(moveType)) {
            data.setContent("\u6392\u5e8f\u4f4d\u7f6e\u4e22\u5931");
            return data;
        }
        int minSort = 0;
        int maxSort = 0;
        if (area.getSort() > targetArea.getSort()) {
            num = 1;
            maxSort = area.getSort();
            minSort = targetArea.getSort();
            if ("prev".equals(moveType)) {
                --minSort;
            } else {
                ++targetSort;
            }
        } else {
            num = -1;
            minSort = area.getSort();
            maxSort = targetArea.getSort();
            if ("prev".equals(moveType)) {
                --maxSort;
                --targetSort;
            }
        }
        ((CompanyAreaMapper)this.dao).updateSort(num, area.getPid(), area.getCid(), minSort, maxSort);
        area.setSort(Integer.valueOf(targetSort));
        super.update(area, loginStaffId);
        data.setState(ResponseStateEnum.success);
        return data;
    }

    public List<CompanyArea> getExportCompanyArea(long cid) {
        Example example = new Example(CompanyArea.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("sort asc");
        List list = ((CompanyAreaMapper)this.dao).selectByExample(example);
        for (CompanyArea companyArea : list) {
            String treeName = CompanyArea.createTreeName((List)list, (Long)companyArea.getId());
            companyArea.setTreePathName(treeName);
            companyArea.setSortNo(CompanyArea.creteAreaSortNo((List)list, (Long)companyArea.getId()));
        }
        list.sort(Comparator.comparing(CompanyArea::getSortNo));
        return list;
    }

    public List<CompanyArea> getExportCompanyAreaByPid(long pid) {
        CompanyArea rootArea = this.getById(pid);
        ArrayList<CompanyArea> areas = new ArrayList<CompanyArea>();
        List<CompanyArea> all = this.getExportCompanyArea(rootArea.getCid());
        block0: for (CompanyArea companyArea : all) {
            CompanyArea current = CompanyArea.getById(all, (Long)companyArea.getId());
            while (current != null) {
                if (current.getId().equals(pid)) {
                    companyArea.setSortNo(CompanyArea.creteAreaSortNo(all, (Long)companyArea.getId()));
                    areas.add(companyArea);
                    continue block0;
                }
                current = CompanyArea.getById(all, (Long)current.getPid());
            }
        }
        areas.sort(Comparator.comparing(CompanyArea::getSortNo));
        return areas;
    }

    public PageInfo<AreaWorkInfoParseVo> getAreaWorkInfo(List<Long> areaIds, int pageNum, int pageSize) {
        if (areaIds == null || areaIds.isEmpty()) {
            return new PageInfo(new ArrayList());
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<AreaWorkInfoVo> list = this.companyAreaMapper.selectAreaWorkInfoList2(areaIds);
        LinkedList<Long> workIds = new LinkedList<Long>();
        for (AreaWorkInfoVo workInfoVo : list) {
            workIds.add(workInfoVo.getWorkId());
        }
        PageInfo pageInfo = new PageInfo(list);
        List<AreaWorkInfoParseVo> areaWorkInfoParseVos = this.parseAreaWorkInfo(list);
        List<Object> comNumList = new ArrayList();
        List<Object> thirdNumList = new ArrayList();
        if (!workIds.isEmpty()) {
            comNumList = this.companyAreaMapper.selectComNum(workIds);
            thirdNumList = this.companyAreaMapper.selectThirdNum(workIds);
        }
        HashMap<Long, Long> comNumMap = new HashMap<Long, Long>();
        HashMap<Long, Long> thirdNumMap = new HashMap<Long, Long>();
        for (AreaWorkInfo areaWorkInfo : comNumList) {
            comNumMap.put(areaWorkInfo.getWorkId(), areaWorkInfo.getComNum());
        }
        for (AreaWorkInfo areaWorkInfo : thirdNumList) {
            thirdNumMap.put(areaWorkInfo.getWorkId(), areaWorkInfo.getThirdNum());
        }
        for (AreaWorkInfoParseVo areaWorkInfoParseVo : areaWorkInfoParseVos) {
            areaWorkInfoParseVo.setComNum((Long)comNumMap.get(areaWorkInfoParseVo.getWorkId()));
            areaWorkInfoParseVo.setThirdNum((Long)thirdNumMap.get(areaWorkInfoParseVo.getWorkId()));
        }
        PageInfo pageInfo1 = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfo1);
        pageInfo1.setList(areaWorkInfoParseVos);
        return pageInfo1;
    }

    @Transactional(readOnly=false)
    public void sortArea(String areaIds, String sortNums) {
        if (areaIds != null && areaIds.contains(",")) {
            String[] ids = areaIds.split(",");
            String[] nums = sortNums.split(",");
            for (int i = 0; i < ids.length; ++i) {
                this.companyAreaMapper.updateSortV2_10(ids[i], nums[i]);
            }
        }
    }

    private void addChildrenToList(List<CompanyArea> list, CompanyArea parent) {
        List<CompanyArea> childrenListByPid = this.getChildListByPid(parent.getId());
        for (CompanyArea area : childrenListByPid) {
            area.setAreaName(parent.getAreaName() + ">" + area.getAreaName());
            list.add(area);
            this.addChildrenToList(list, area);
        }
    }

    private List<AreaWorkInfoParseVo> parseAreaWorkInfo(List<AreaWorkInfoVo> list) {
        ArrayList<AreaWorkInfoParseVo> rList = new ArrayList<AreaWorkInfoParseVo>();
        if (list == null || list.isEmpty()) {
            return rList;
        }
        LinkedList<Long> workIds = new LinkedList<Long>();
        for (AreaWorkInfoVo info : list) {
            workIds.add(info.getWorkId());
        }
        List<AreaWorkInfoVo> shields = this.companyAreaMapper.selectShieldByWorkIds(workIds);
        List<AreaWorkInfoVo> devices = this.companyAreaMapper.selectDeviceByWorkIds(workIds);
        AreaWorkInfoParseVo vo = null;
        for (AreaWorkInfoVo info : list) {
            vo = new AreaWorkInfoParseVo();
            vo.setAreaIds(info.getAreaIds());
            vo.setNum(info.getNum());
            vo.setWorkName(info.getWorkName());
            vo.setWorkId(info.getWorkId());
            vo.setShieldList(new ArrayList());
            vo.setDeviceList(new ArrayList());
            for (AreaWorkInfoVo shield : shields) {
                if (!shield.getWorkId().equals(info.getWorkId())) continue;
                AreaWorkInfoParseVo.AreaShield s = new AreaWorkInfoParseVo.AreaShield();
                s.setShieldId(shield.getShieldId());
                s.setShieldName(shield.getShieldName());
                vo.getShieldList().add(s);
            }
            for (AreaWorkInfoVo device : devices) {
                if (!device.getWorkId().equals(info.getWorkId())) continue;
                AreaWorkInfoParseVo.AreaDevice d = new AreaWorkInfoParseVo.AreaDevice();
                d.setDeviceId(device.getDeviceId());
                d.setDeviceName(device.getDeviceName());
                vo.getDeviceList().add(d);
            }
            rList.add(vo);
        }
        return rList;
    }

    public Long parseAreaName(String areaName, String separator, Long cid) {
        if (StringUtils.isBlank((CharSequence)areaName)) {
            return null;
        }
        Object[] areaNameArr = StringUtils.splitByWholeSeparator((String)(areaName = StringUtils.toDBC((String)areaName)), (String)separator);
        if (ArrayUtils.isNotEmpty((Object[])areaNameArr)) {
            int length = areaNameArr.length;
            ArrayList<Long> orgIdList = new ArrayList<Long>();
            for (int i = 0; i < length; ++i) {
                Object careaName = areaNameArr[i];
                CompanyArea area = this.getCompanyAreaByNameAndTreePath((String)careaName, StringUtils.join(orgIdList, (String)","), cid);
                if (area != null) {
                    orgIdList.add(area.getId());
                    if (i != length - 1) continue;
                    return area.getId();
                }
                return null;
            }
        }
        return null;
    }

    public CompanyArea getCompanyAreaByNameAndTreePath(String areaName, String treePath, Long cid) {
        List companyAreas;
        if (StringUtils.isEmpty((CharSequence)areaName) || cid == null) {
            return null;
        }
        Example e = new Example(CompanyArea.class);
        Example.Criteria c = e.createCriteria().andEqualTo("areaName", (Object)areaName.trim()).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        if (StringUtils.isNotBlank((CharSequence)treePath)) {
            c.andEqualTo("treePath", (Object)treePath);
        }
        if ((companyAreas = ((CompanyAreaMapper)this.dao).selectByExample(e)) != null && companyAreas.size() > 0) {
            return (CompanyArea)companyAreas.get(0);
        }
        return null;
    }
}

