/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.busilog.RecordOperationLogVo;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyNoteSearchParam;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.health.bind.entity.SysUserBind;
import cn.smarthse.modules.health.bind.model.ConfirmAccountParam;
import cn.smarthse.modules.health.dao.base.CompanyMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.reform.vo.RiskListItemDataVo;
import cn.smarthse.modules.health.enums.sysParam.SysParamGroupEnum;
import cn.smarthse.modules.health.newcompliance.enums.NewComplianceCodeEnum;
import cn.smarthse.modules.health.newcompliance.service.INewBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISysParamService;
import cn.smarthse.modules.health.supervise.entity.statistics.CompanyGradeAreaModel;
import cn.smarthse.modules.health.vo.base.company.CompanyArchiveVo;
import cn.smarthse.modules.health.vo.note.CompanyRiskListVo;
import cn.smarthse.modules.health.vo.note.SysAreaPushCountVo;
import cn.smarthse.modules.platform.model.CorpInfoModel;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3ListVo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class CompanyServiceImpl
extends BaseServiceImpl<CompanyMapper, Company>
implements ICompanyService {
    @Autowired
    private CompanyMapper companyMapper;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private ICompanyFunctionalOrganizationService companyFunctionalOrganizationService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaService;
    @Autowired
    ISysParamService sysParamService;
    @DubboReference(version="1.0.0")
    ISysParamProvideService sysParamProvideService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    ICompanyProvideService companyProvideService;
    @DubboReference
    private INewBusinessDataUpdateRefreshService newBusinessDataUpdateRefreshService;

    @Override
    public Company getById(Long id) {
        return this.getDataCentreCompanyById(id);
    }

    @Transactional
    public Company saveOrUpdateCompany(Company company, Long loginStaffId, Long cid) throws Exception {
        if (company == null) {
            throw new Exception("company \u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company oldEntity = null;
        company.setIsValid(Boolean.valueOf(true));
        if (company.getId() == null) {
            return this.add(company, loginStaffId, cid);
        }
        company.setUpdateBy(loginStaffId);
        company.setUpdateDate(new Date());
        this.companyMapper.updateByPrimaryKey(company);
        oldEntity = this.getById(company.getId());
        return company;
    }

    @Transactional(readOnly=true)
    public Company getCompanyById(Long id) throws Exception {
        if (id == null) {
            throw new Exception("id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (Company)this.companyMapper.selectByPrimaryKey(id);
    }

    public Company addCompanyByCorpInfoModel(CorpInfoModel corpInfo) {
        Company company = new Company();
        company.setName(corpInfo.getFullname());
        company.setShortName(corpInfo.getShortname());
        company.setUnifiedSocialCc(corpInfo.getCorpCc());
        company.setAreaId(corpInfo.getCorpAreaId());
        company.setCompanyContactTel(corpInfo.getCorpTel());
        company.setCompanyContactEmail(corpInfo.getCorpEmail());
        if (corpInfo.getCorpAreaId() != null) {
            String address = this.sysAreaService.getFullName(corpInfo.getCorpAreaId(), "") + corpInfo.getCorpAddress();
            company.setCompanyPostalAdress(address);
            company.setWorkAddress(address);
            company.setRegisterAddress(address);
        }
        company.setCreateDate(new Date());
        company.setUpdateDate(new Date());
        company.setIsValid(Global.TRUE);
        this.add(company);
        return company;
    }

    public CompanyArchiveVo getCompanyArchiveInfo(Long cid) {
        Company company = this.getDataCentreCompanyById(cid);
        if (company != null) {
            CompanyArchiveVo vo = new CompanyArchiveVo();
            vo.setName(company.getName());
            CompanyFunctionalOrganization org = this.companyFunctionalOrganizationService.getFunOrgEHS(cid);
            if (org != null) {
                StaffInfo occLeaderStaff = this.staffInfoService.getStaffInfoWithStaffBasicWorkById(org.getDirector());
                if (occLeaderStaff != null && occLeaderStaff.getStaffBasicInfo() != null) {
                    vo.setOccLeaderEmail(occLeaderStaff.getStaffBasicInfo().getEmail());
                    vo.setOccLeaderName(occLeaderStaff.getStaffBasicInfo().getRealName());
                }
                vo.setOccLeaderTel(org.getTelephone());
            }
            return vo;
        }
        return null;
    }

    private Company getDataCentreCompanyById(Long id) {
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(id);
        Company company = new Company();
        company.setId(id);
        if (companyBaseInfoModel == null) {
            return company;
        }
        try {
            BeanUtils.copyProperties((Object)company, (Object)companyBaseInfoModel);
            company.setRegionId(companyBaseInfoModel.getAreaDetailId());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return company;
    }

    public CompanyArchiveVo getCompanyArchiveInfo(Long cid, int year) {
        Company company = this.getDataCentreCompanyById(cid);
        if (company != null) {
            CompanyArchiveVo vo = new CompanyArchiveVo();
            vo.setName(company.getName());
            CompanyFunctionalOrganization org = this.companyFunctionalOrganizationService.getFunOrgEHS(cid, year);
            if (org != null) {
                Calendar c = Calendar.getInstance();
                c.set(year + 1, 0, 0, 0, 0, 0);
                StaffBasicInfo sb = this.staffInfoService.getHistroyStaffBasicInfoByIdAndYear(org.getDirector(), c.getTime());
                if (sb != null) {
                    vo.setOccLeaderEmail(sb.getEmail());
                    vo.setOccLeaderName(sb.getRealName());
                }
                vo.setOccLeaderTel(org.getTelephone());
            }
            return vo;
        }
        return null;
    }

    @Transactional
    public void updateCompanyByCorpInfoModel(CorpInfoModel corpInfo, Long cid) {
        Company company = new Company();
        company.setId(cid);
        company.setName(corpInfo.getFullname());
        company.setShortName(corpInfo.getShortname());
        company.setUnifiedSocialCc(corpInfo.getCorpCc());
        company.setUpdateDate(new Date());
        this.update(company);
    }

    public List<CompanySuperviseModel> listSuperviseCompanyData() {
        return this.companyProvideByHSEService.listSuperviseCompanyData();
    }

    @Transactional(readOnly=false)
    public void updateReport() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        ArrayList<Integer> cellNum = new ArrayList<Integer>();
        cellNum.add(9);
        ExcelUtil excel = ExcelUtil.getInstance();
        List content = excel.getContent("C:\\zx.xls", cellNum);
        List national_econ_typeList = this.sysParamService.getListByGroup(SysParamGroupEnum.national_econ_type);
        List register_typeList = this.sysParamService.getListByGroup(SysParamGroupEnum.register_type);
        for (List list1 : content) {
            for (List list2 : list1) {
                String register;
                String national;
                if (!StringUtils.isNumber((String)((String)list2.get(0)))) continue;
                Company company = new Company();
                company.setId(Long.valueOf((String)list2.get(0)));
                if (company.getId() == null) continue;
                String companySize = (String)list2.get(4);
                if (!StringUtils.isBlank((CharSequence)companySize)) {
                    if ("\u5fae".equals(companySize)) {
                        company.setScale("4");
                    } else if ("\u5c0f".equals(companySize)) {
                        company.setScale("3");
                    } else if ("\u4e2d".equals(companySize)) {
                        company.setScale("2");
                    } else if ("\u5927".equals(companySize)) {
                        company.setScale("1");
                    }
                }
                if ((national = (String)list2.get(5)) == null) {
                    national = "";
                }
                if ((register = (String)list2.get(6)) == null) {
                    register = "";
                }
                String finalNational = national;
                national_econ_typeList.forEach(model -> {
                    if (finalNational.equals(model.getParamValue())) {
                        company.setIndustryCategory(model.getId());
                    }
                });
                String finalRegister = register;
                register_typeList.forEach(model -> {
                    if (finalRegister.equals(model.getParamValue())) {
                        company.setRegisterType(model.getId());
                    }
                });
                System.out.println("\u66f4\u65b0\uff1a" + company.getId() + ",\u6ce8\u518c\u7c7b\u578b\uff1a\u300b" + company.getRegisterType() + ",\u884c\u4e1a\u7c7b\u522b\uff1a\u300b" + company.getIndustryCategory() + ",\u4f01\u4e1a\u89c4\u6a21\uff1a\u300b" + company.getScale());
                this.update(company, null);
            }
        }
    }

    public Integer countSuperviseCompanyData() {
        return this.companyProvideByHSEService.countSuperviseCompanyData();
    }

    public List<CompanySuperviseModel> listSuperviseCompanyData(int page, int pageSize) {
        return this.companyProvideByHSEService.listSuperviseCompanyData(page, pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Company getByName(String companyName, String isActualize) {
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getByName(companyName);
        Company company = new Company();
        try {
            BeanUtils.copyProperties((Object)company, (Object)companyBaseInfoModel);
            company.setId(companyBaseInfoModel.getCid());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        finally {
            return company;
        }
    }

    public List<String> getUnifiedSocialCcsList(int pageNum, int pageSize, String unifiedSocialCcs) {
        pageNum = (pageNum - 1) * pageSize;
        return ((CompanyMapper)this.dao).getByUnifiedSocialCcsList(pageNum, pageSize, unifiedSocialCcs);
    }

    public Map<String, Company> getUnifiedSocialCcsAndCidMap(int pageNum, int pageSize, String unifiedSocialCcs) {
        pageNum = (pageNum - 1) * pageSize;
        return ((CompanyMapper)this.dao).getUnifiedSocialCcsAndCidMap(pageNum, pageSize, unifiedSocialCcs);
    }

    public List<Long> judgeIsJcAndJk(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((CompanyMapper)this.dao).judgeIsJcAndJK(cidList);
    }

    public List<Long> judgeIsCompanyTrainingBase(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((CompanyMapper)this.dao).judgeIsCompanyTrainingBase(cidList);
    }

    public List<Long> judgeIsCurrentYearUseThroughTrain(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((CompanyMapper)this.dao).judgeIsCurrentYearUseThroughTrain(cidList);
    }

    public List<Long> judgeIsCurrentYearActivelyDoAssistantWork(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        return ((CompanyMapper)this.dao).judgeIsCurrentYearActivelyDoAssistantWork(cidList);
    }

    public PageInfo<RecordOperationLogVo> getIndustryHisList(JqGridParam pageParam, Long cid) {
        PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<RecordOperationLogVo> list = ((CompanyMapper)this.dao).getIndustryHisList(cid);
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> beforeList = list.stream().map(RecordOperationLogVo::getBeforeInfo).filter(Objects::nonNull).map(Long::parseLong).collect(Collectors.toList());
            List afterList = list.stream().map(RecordOperationLogVo::getAfterInfo).filter(Objects::nonNull).map(Long::parseLong).collect(Collectors.toList());
            beforeList.addAll(afterList);
            Map<Long, SysParamModel> irMap = this.batchGetIndustryRegister(beforeList);
            for (RecordOperationLogVo vo : list) {
                String realName = vo.getRealName();
                if (StringUtils.isNotEmpty((String)realName)) {
                    vo.setOperator(realName);
                }
                String beforeStr = Objects.equals(vo.getBeforeInfo(), "null") ? "-" : irMap.get(Long.valueOf(vo.getBeforeInfo())).getParamCode() + "-" + irMap.get(Long.valueOf(vo.getBeforeInfo())).getParamValue();
                String afterStr = Objects.equals(vo.getAfterInfo(), "null") ? "-" : irMap.get(Long.valueOf(vo.getAfterInfo())).getParamCode() + "-" + irMap.get(Long.valueOf(vo.getAfterInfo())).getParamValue();
                vo.setBeforeInfo(beforeStr);
                vo.setAfterInfo(afterStr);
            }
        }
        return new PageInfo(list);
    }

    public List<Company> getListByUnifiedSocialCc(List<String> againCodeList) {
        if (CollectionUtils.isEmpty(againCodeList)) {
            return new ArrayList<Company>();
        }
        return ((CompanyMapper)this.dao).selectListByUnifiedSocialCc(againCodeList);
    }

    public PageInfo<CompanyGradeAreaModel> statisticCompanyGradeListPage(SearchParam searchParam) {
        Boolean isCounty;
        Byte level = searchParam.getLevel();
        if (ObjectUtil.isNotNull((Object)level) && level > 3) {
            return new PageInfo();
        }
        if (ObjectUtil.isNotNull((Object)level) && level.equals(new Byte("2")) && ObjectUtil.isNull((Object)searchParam.getCompanyType())) {
            searchParam.setContainCompanyType(Boolean.valueOf(true));
        }
        if (ObjectUtil.isNotNull((Object)(isCounty = searchParam.getIsCounty())) && isCounty.booleanValue()) {
            searchParam.setOnlyThisLevel(Boolean.valueOf(true));
        }
        PageHelper.startPage((int)searchParam.getPageNum(), (int)searchParam.getPageSize());
        return new PageInfo(((CompanyMapper)this.dao).statisticCompanyGradeListData(searchParam));
    }

    public CompanyGradeAreaModel statisticCompanyGradeHeadData(SearchParam searchParam) {
        CompanyGradeAreaModel companyGradeAreaModel = ((CompanyMapper)this.dao).statisticCompanyGradeHeadData(searchParam);
        return companyGradeAreaModel;
    }

    public List<CompanyGradeAreaModel> statisticCompanyGradeList(SearchParam param) {
        Boolean isCounty;
        Byte level = param.getLevel();
        if (ObjectUtil.isNotNull((Object)level) && level.equals(new Byte("2")) && ObjectUtil.isNull((Object)param.getCompanyType())) {
            param.setContainCompanyType(Boolean.valueOf(true));
        }
        if (ObjectUtil.isNotNull((Object)(isCounty = param.getIsCounty())) && isCounty.booleanValue()) {
            param.setOnlyThisLevel(Boolean.valueOf(true));
        }
        return ((CompanyMapper)this.dao).statisticCompanyGradeListData(param);
    }

    private Map<Long, SysParamModel> batchGetIndustryRegister(List<Long> industryRegisterIdList) {
        Map<Long, SysParamModel> irMap = new HashMap<Long, SysParamModel>();
        if (CollectionUtils.isNotEmpty(industryRegisterIdList)) {
            String industryRegisterIds = industryRegisterIdList.stream().map(Object::toString).collect(Collectors.joining(","));
            List industryRegisterList = this.sysParamProvideService.getListByIds(industryRegisterIds);
            irMap = industryRegisterList.stream().collect(Collectors.toMap(SysParamModel::getId, r -> r, (a, b) -> a));
        }
        return irMap;
    }

    public List<Long> getCids() {
        return ((CompanyMapper)this.dao).getCids();
    }

    public List<Long> getNewCreateCids() {
        return ((CompanyMapper)this.dao).getNewCreateCids();
    }

    @Transactional
    public void updateCompanyCase(Long cid, Boolean companyCase) {
        if (cid == null || companyCase == null) {
            throw new HealthException("\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5");
        }
        Company company = ((CompanyMapper)this.dao).selectBycid(cid);
        int count = ((CompanyMapper)this.dao).selectCompanyCase(cid);
        if (count == 0 && companyCase.booleanValue()) {
            ((CompanyMapper)this.dao).insertCompanyCase(company);
        } else if (count > 0 && !companyCase.booleanValue()) {
            ((CompanyMapper)this.dao).deleteComapnyCase(company);
        }
        this.continueMaintainCompanyBaseInfo(cid, companyCase);
    }

    private void continueMaintainCompanyBaseInfo(Long cid, Boolean companyCase) {
        if (cid == null || companyCase == null) {
            return;
        }
        ((CompanyMapper)this.dao).processCompanyCreditSuperviseFlag(cid, companyCase);
        this.newBusinessDataUpdateRefreshService.addBusinessDataUpdateMsg(cid, null, new NewComplianceCodeEnum[]{NewComplianceCodeEnum.CODE15, NewComplianceCodeEnum.CODE15, NewComplianceCodeEnum.CODE15});
    }

    public PageInfo<CompanyRiskListVo> selectCompanyNote(JqGridParam param, CompanyNoteSearchParam searchParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)false);
        List<CompanyRiskListVo> companyRiskListVos = ((CompanyMapper)this.dao).selectCompanyNote(searchParam);
        PageInfo page = new PageInfo(companyRiskListVos);
        for (CompanyRiskListVo companyRiskListVo : companyRiskListVos) {
            this.changeRisk(companyRiskListVo);
            Byte warningStatus = companyRiskListVo.getRiskVoList().stream().map(RiskListItemDataVo::getWarningState).filter(Objects::nonNull).max(Byte::compareTo).orElse((byte)0);
            companyRiskListVo.setMaxWarningStatus(warningStatus);
        }
        return page;
    }

    public PageInfo<CompanyRiskListVo> selectCompanyNoteYcq(JqGridParam param, CompanyNoteSearchParam searchParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)false);
        List<CompanyRiskListVo> companyRiskListVos = ((CompanyMapper)this.dao).selectCompanyNoteYcq(searchParam);
        PageInfo page = new PageInfo(companyRiskListVos);
        for (CompanyRiskListVo companyRiskListVo : companyRiskListVos) {
            this.changeRisk(companyRiskListVo);
        }
        return page;
    }

    public Integer selectCountYcq(CompanyNoteSearchParam searchParam) {
        return ((CompanyMapper)this.dao).selectBySearchParamYcq(searchParam);
    }

    public SysUserBind confirmAccountByUsernameOrCode(ConfirmAccountParam param) {
        this.logger.error("\u4f01\u4e1a\u9a8c\u8bc1\u65b9\u6cd52\uff0c\u53c2\u6570{}", (Object)param);
        if (param.getUsername() != null || param.getUnifiedSocialCc() != null) {
            return ((CompanyMapper)this.dao).confirmAccountByUsernameOrCode(param);
        }
        throw new HealthException("\u7528\u6237\u540d\u6216\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a");
    }

    public Integer selectCount(CompanyNoteSearchParam searchParam) {
        return ((CompanyMapper)this.dao).selectBySearchParam(searchParam);
    }

    private void changeRisk(CompanyRiskListVo vo) {
        List riskVoList = vo.getRiskVoList();
        Map.Entry[] entryArray = new Map.Entry[13];
        entryArray[0] = Map.entry(() -> ((CompanyRiskListVo)vo).getDeclareWs(), (byte)12);
        entryArray[1] = Map.entry(() -> ((CompanyRiskListVo)vo).getPhysicalWs(), (byte)10);
        entryArray[2] = Map.entry(() -> ((CompanyRiskListVo)vo).getCheckWs(), (byte)14);
        entryArray[3] = Map.entry(() -> ((CompanyRiskListVo)vo).getThreeSimultaneousWs(), (byte)13);
        entryArray[4] = Map.entry(() -> ((CompanyRiskListVo)vo).getProtectEquipWs(), (byte)15);
        entryArray[5] = Map.entry(() -> ((CompanyRiskListVo)vo).getWarnSignManageWs(), (byte)16);
        entryArray[6] = Map.entry(() -> ((CompanyRiskListVo)vo).getTrainingWs(), (byte)17);
        entryArray[7] = Map.entry(() -> ((CompanyRiskListVo)vo).getHealthManageFilesWs(), (byte)18);
        entryArray[8] = Map.entry(() -> ((CompanyRiskListVo)vo).getJccbWs(), (byte)3);
        entryArray[9] = Map.entry(() -> ((CompanyRiskListVo)vo).getJjzWs(), (byte)4);
        entryArray[10] = Map.entry(() -> ((CompanyRiskListVo)vo).getYszybWs(), (byte)5);
        entryArray[11] = Map.entry(() -> ((CompanyRiskListVo)vo).getPersonDoseWs(), (byte)11);
        entryArray[12] = Map.entry(() -> ((CompanyRiskListVo)vo).getPersonDoseCbWs(), (byte)24);
        Map<Supplier, Byte> riskMappings = Map.ofEntries(entryArray);
        riskMappings.forEach((getter, source) -> {
            byte state = (Byte)getter.get();
            if (state != 0) {
                RiskListItemDataVo item = new RiskListItemDataVo();
                item.setGenerationSource(source);
                item.setWarningState(Byte.valueOf(state));
                riskVoList.add(item);
            }
        });
    }

    public List<SysAreaPushCountVo> countByAreaId(List<SysAreaV3ListVo> data) {
        ArrayList<SysAreaPushCountVo> result = new ArrayList<SysAreaPushCountVo>();
        for (SysAreaV3ListVo area : data) {
            CompanyNoteSearchParam searchParam = new CompanyNoteSearchParam();
            searchParam.setSearchAreaLevel(area.getLevel());
            searchParam.setAreaId(area.getId());
            searchParam.setYear(Integer.valueOf(LocalDateTime.now().getYear()));
            Integer i = ((CompanyMapper)this.dao).selectBySearchParam(searchParam);
            SysAreaPushCountVo sysAreaPushCountVo = new SysAreaPushCountVo();
            if (i == null) {
                i = 0;
            }
            sysAreaPushCountVo.setAreaId(area.getId());
            sysAreaPushCountVo.setPushCount(i);
            result.add(sysAreaPushCountVo);
        }
        return result;
    }
}

