/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.base.impl;

import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.generator.IdGen;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.dao.base.BusinessNoMapper;
import cn.smarthse.modules.health.entity.base.BusinessNo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFilePersonal;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class BusinessNoServiceImpl
extends BaseServiceImpl<BusinessNoMapper, BusinessNo>
implements IBusinessNoService {
    @Autowired
    BusinessNoMapper businessNoMapper;
    @Autowired
    RedisClient redisClient;
    private static final String BUSINESS_NO_CACHENAME = "BusinessNo:";

    public List<BusinessNo> list(Long cid, String businessType, String day) {
        if (StringUtils.isEmpty((CharSequence)businessType) || cid == null) {
            return null;
        }
        Example example = new Example(BusinessNo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("cid", (Object)cid).andEqualTo("business", (Object)businessType).andEqualTo("day", (Object)day);
        example.setOrderByClause(" create_time desc");
        return ((BusinessNoMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public String getBusinessNo(Long cid, String businessType) {
        String today = DateUtils.DateToString((Date)new Date(), (String)"YYYYMMdd");
        if (cid == null) {
            return "LC" + today + "0000" + IdGen.randomBase62((int)4);
        }
        if (StringUtils.isEmpty((CharSequence)businessType)) {
            return "LT" + today + "0000" + IdGen.randomBase62((int)4);
        }
        BusinessNo no = null;
        List<BusinessNo> list = this.list(cid, businessType, today);
        if (list == null || list.size() == 0) {
            no = new BusinessNo();
            no.setCid(cid);
            no.setBusiness(businessType);
            no.setDay(today);
            no.setNo(Integer.valueOf(10000));
            no.setCreateTime(new Date());
            no.setId(Long.valueOf(this.idworker.nextId()));
            ((BusinessNoMapper)this.dao).insertSelective(no);
        } else {
            no = list.get(0);
            no.setNo(Integer.valueOf(no.getNo() + 1));
            no.setCreateTime(new Date());
            ((BusinessNoMapper)this.dao).updateByPrimaryKeySelective(no);
        }
        return this.generateBusinessNo(no, today);
    }

    private String generateBusinessNo(BusinessNo no, String today) {
        try {
            String nextNo = this.getNext(no.getNo());
            return no.getBusiness() + no.getDay() + nextNo + IdGen.randomBase62((int)4);
        }
        catch (Exception e) {
            return "GE" + today + "0000" + IdGen.randomBase62((int)4);
        }
    }

    private String getNext(Integer no) {
        return String.valueOf(no).substring(1, 5);
    }

    @Transactional(readOnly=false)
    public String getDocNo(Long cid, String businessType, String year) {
        String today = year != null && !"".equals(year) ? year : DateUtils.getYear();
        if (cid == null) {
            return "LC" + today + "0000" + IdGen.randomBase62((int)4);
        }
        if (StringUtils.isEmpty((CharSequence)businessType)) {
            return "LT" + today + "0000" + IdGen.randomBase62((int)4);
        }
        BusinessNo no = null;
        List<BusinessNo> list = this.list(cid, businessType, today);
        if (list == null || list.size() == 0) {
            no = new BusinessNo();
            no.setCid(cid);
            no.setBusiness(businessType);
            no.setDay(today);
            no.setNo(Integer.valueOf(1));
            no.setCreateTime(new Date());
            no.setId(Long.valueOf(this.idworker.nextId()));
            ((BusinessNoMapper)this.dao).insertSelective(no);
        } else {
            no = list.get(0);
            no.setNo(Integer.valueOf(no.getNo() + 1));
            no.setCreateTime(new Date());
            ((BusinessNoMapper)this.dao).updateByPrimaryKeySelective(no);
        }
        return this.docNo(no, today);
    }

    public String getNewDocNo(Long cid, String businessType, String year) {
        String today = year != null && !"".equals(year) ? year : DateUtils.getYear();
        if (cid == null) {
            return "LC" + today + "0000" + IdGen.randomBase62((int)4);
        }
        if (StringUtils.isEmpty((CharSequence)businessType)) {
            return "LT" + today + "0000" + IdGen.randomBase62((int)4);
        }
        String archiveNoCache = cid + businessType + year;
        Long decr = this.redisClient.incr(BUSINESS_NO_CACHENAME + archiveNoCache, 1L);
        String s = StringUtils.leftPad((String)("" + decr), (int)5, (String)"0");
        return businessType + "-" + today + "-" + s;
    }

    private String docNo(BusinessNo no, String today) {
        try {
            String nextNo = String.valueOf(no.getNo());
            nextNo = this.nextNo(nextNo);
            return no.getBusiness() + "-" + no.getDay() + "-" + nextNo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "DOC-" + today + "-0000";
        }
    }

    private String nextNo(String nextNo) {
        int si = nextNo.length();
        switch (si) {
            case 1: {
                return "000" + nextNo;
            }
            case 2: {
                return "00" + nextNo;
            }
            case 3: {
                return "0" + nextNo;
            }
        }
        return nextNo;
    }

    @Transactional
    public List<LiteArchiveFilePersonal> getPersonalDocNo(List<LiteArchiveFilePersonal> personalList) {
        if (CollectionUtils.isEmpty(personalList)) {
            return Collections.emptyList();
        }
        String businessType = "ZYJK";
        String today = DateUtils.getYear();
        Date date = new Date();
        Map<Long, List<LiteArchiveFilePersonal>> cidAndPersonalList = personalList.stream().collect(Collectors.groupingBy(LiteArchiveFilePersonal::getCid));
        Set<Long> cidList = cidAndPersonalList.keySet();
        Example example = new Example(BusinessNo.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("cid", cidList).andEqualTo("business", (Object)businessType).andEqualTo("day", (Object)today);
        Map cidAndBusinessNoMap = ((BusinessNoMapper)this.dao).selectByExample(example).stream().filter(Objects::nonNull).collect(Collectors.toMap(BusinessNo::getCid, Function.identity(), (v1, v2) -> v1.getCreateTime().getTime() >= v2.getCreateTime().getTime() ? v1 : v2));
        for (LiteArchiveFilePersonal personal : personalList) {
            if (personal == null) continue;
            Long cid = personal.getCid();
            BusinessNo no = (BusinessNo)cidAndBusinessNoMap.get(cid);
            if (no == null) {
                no = new BusinessNo();
                no.setCid(cid);
                no.setBusiness(businessType);
                no.setDay(today);
                no.setNo(Integer.valueOf(1));
                no.setCreateTime(date);
                cidAndBusinessNoMap.put(cid, no);
            } else {
                no.setNo(Integer.valueOf(no.getNo() + 1));
                no.setCreateTime(new Date());
            }
            personal.setDocNo(this.docNo(no, today));
        }
        ArrayList<BusinessNo> allList = new ArrayList<BusinessNo>(cidAndBusinessNoMap.values());
        List updatelist = allList.stream().filter(obj -> Objects.nonNull(obj) && obj.getId() != null).collect(Collectors.toList());
        allList.removeAll(updatelist);
        if (CollectionUtils.isNotEmpty(allList)) {
            allList.forEach(businessNo -> businessNo.setId(Long.valueOf(this.idworker.nextId())));
            ((BusinessNoMapper)this.dao).insertList2(allList);
        }
        if (CollectionUtils.isNotEmpty(updatelist)) {
            this.batchUpdateOrInsert(updatelist, BusinessNoMapper.class, (item, mapper) -> mapper.updateByPrimaryKeySelective(item));
        }
        return personalList;
    }
}

