/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.enums.FilesTypeEnum;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.thirdtime.TsProjectMapper;
import cn.smarthse.modules.health.entity.work.evaluate.EvaluateOtherfile;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProject;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectOtherfile;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectTypeEnum;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.vo.base.company.CompanyArchiveVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TsProjectArchiveService
extends BaseServiceImpl<TsProjectMapper, TsProject>
implements IDocDataService {
    @Autowired
    TsProjectMapper tsProjectMapper;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    OssClientBean ossClienBean;
    @DubboReference
    private ISysFileProvideService fileService;

    public Map<String, Object> getDocData(Long cid, String docParamValue) {
        Long tsid = NumberUtil.toLong((String)docParamValue);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        CompanyArchiveVo company = this.companyService.getCompanyArchiveInfo(cid);
        dataMap.put("company", company);
        TsProject project = (TsProject)this.getById(tsid);
        dataMap.put("project", project);
        dataMap.put("projectNo", project.getProjectNo());
        String projectType = TsProjectTypeEnum.getNameByCode((Byte)project.getProjectType());
        dataMap.put("projectType", projectType);
        return dataMap;
    }

    public String getAllPaperLocation(List<TsProjectOtherfile> tsOfList, Byte cate) {
        StringBuffer paperLocationSB = new StringBuffer();
        if (tsOfList != null && tsOfList.size() > 0) {
            for (TsProjectOtherfile of : tsOfList) {
                if (!of.getCategory().equals(cate)) continue;
                if (StringUtils.isNotBlank((CharSequence)paperLocationSB.toString())) {
                    paperLocationSB.append(",");
                }
                if (of.getPaperLocation() == null) continue;
                paperLocationSB.append(of.getPaperLocation());
            }
        }
        return paperLocationSB == null ? "" : paperLocationSB.toString();
    }

    public String getEAllPaperLocation(List<EvaluateOtherfile> tsOfList, Byte cate) {
        StringBuffer paperLocationSB = new StringBuffer();
        if (tsOfList != null && tsOfList.size() > 0) {
            for (EvaluateOtherfile of : tsOfList) {
                if (!of.getCategory().equals(cate)) continue;
                if (StringUtils.isNotBlank((CharSequence)paperLocationSB.toString())) {
                    paperLocationSB.append(",");
                }
                paperLocationSB.append(of.getPaperLocation());
            }
        }
        return paperLocationSB.toString();
    }

    public List<SysFileModel> getAllFiles(List<TsProjectOtherfile> tsOfList, Byte cate) {
        StringBuffer paperLocationSB = new StringBuffer();
        if (tsOfList != null && tsOfList.size() > 0) {
            for (TsProjectOtherfile of : tsOfList) {
                if (!of.getCategory().equals(cate)) continue;
                if (StringUtils.isNotBlank((CharSequence)paperLocationSB.toString())) {
                    paperLocationSB.append(",");
                }
                paperLocationSB.append(of.getAttachmentFid());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)paperLocationSB.toString())) {
            return this.getFiles(paperLocationSB.toString());
        }
        return null;
    }

    public List<SysFileModel> getEAllFiles(List<EvaluateOtherfile> tsOfList, Byte cate) {
        StringBuffer paperLocationSB = new StringBuffer();
        if (tsOfList != null && tsOfList.size() > 0) {
            for (EvaluateOtherfile of : tsOfList) {
                if (!of.getCategory().equals(cate)) continue;
                if (StringUtils.isNotBlank((CharSequence)paperLocationSB.toString())) {
                    paperLocationSB.append(",");
                }
                paperLocationSB.append(of.getAttachmentFid());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)paperLocationSB.toString())) {
            return this.getFiles(paperLocationSB.toString());
        }
        return null;
    }

    public List<SysFileModel> getFiles(String files) {
        Object[] filess;
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{files}) && (filess = StringUtils.split((String)files, (String)",")) != null && filess.length > 0) {
            List sfList = this.fileService.getListByIds(StringUtils.join((Object[])filess, (String)","));
            return sfList;
        }
        return null;
    }

    public TsProjectOtherfile getTsProjectOtherfile(List<TsProjectOtherfile> tsOfList, Byte cate) {
        if (tsOfList != null && tsOfList.size() > 0) {
            for (TsProjectOtherfile of : tsOfList) {
                if (!of.getCategory().equals(cate)) continue;
                return of;
            }
        }
        return new TsProjectOtherfile();
    }

    public void addBlankValue(Map<String, Object> dataMap, String key) {
        boolean hasAdd = false;
        if (!dataMap.containsKey(key)) {
            hasAdd = true;
        } else {
            List list = (List)dataMap.get(key);
            if (list == null || list.size() == 0) {
                hasAdd = true;
            }
        }
        if (hasAdd) {
            ArrayList<SysFileModel> approvalDocumentsFileList = new ArrayList<SysFileModel>();
            SysFileModel sf = new SysFileModel();
            sf.setId(Long.valueOf(-1L));
            approvalDocumentsFileList.add(sf);
            dataMap.put(key, approvalDocumentsFileList);
        }
    }

    public String getPaperLocation(List<TsProjectOtherfile> tsOfList, Byte cate) {
        if (tsOfList != null && tsOfList.size() > 0) {
            for (TsProjectOtherfile of : tsOfList) {
                if (!of.getCategory().equals(cate)) continue;
                return of.getPaperLocation();
            }
        }
        return "";
    }

    public String getEPaperLocation(List<EvaluateOtherfile> tsOfList, Byte cate) {
        EvaluateOtherfile eof = this.getEvaluateOtherFile(tsOfList, cate);
        if (eof != null) {
            return eof.getPaperLocation();
        }
        return "";
    }

    public EvaluateOtherfile getEvaluateOtherFile(List<EvaluateOtherfile> tsOfList, Byte cate) {
        if (tsOfList != null && tsOfList.size() > 0) {
            for (EvaluateOtherfile of : tsOfList) {
                if (!of.getCategory().equals(cate)) continue;
                return of;
            }
        }
        return new EvaluateOtherfile();
    }

    public Map<String, Object> getCheckData(Long cid, String docParamValue) {
        Long tsid = NumberUtil.toLong((String)docParamValue);
        if (tsid == null) {
            throw new HealthException("\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u540e\u9762\u64cd\u4f5c");
        }
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        resultData.put("34-099", "1");
        resultData.put("34-099.1", "1");
        resultData.put("34-099.2", "1");
        resultData.put("34-099.3", "1");
        resultData.put("34-100", "1");
        resultData.put("34-101.1", "1");
        resultData.put("34-101.2", "1");
        resultData.put("34-102", "1");
        resultData.put("34-103.1", "1");
        resultData.put("34-103.2", "1");
        resultData.put("34-104.1", "1");
        resultData.put("34-104.2", "1");
        resultData.put("34-104.3", "1");
        resultData.put("34-105.1", "1");
        resultData.put("34-105.2", "1");
        resultData.put("34-105.3", "1");
        resultData.put("34-106", "0");
        resultData.put("34-146.1", "1");
        resultData.put("34-146.2", "1");
        resultData.put("34-146.3", "1");
        resultData.put("34-146.4", "1");
        resultData.put("34-146.5", "1");
        resultData.put("34-146.6", "1");
        resultData.put("34-146.7", "1");
        TsProject tsProject = (TsProject)this.getById(tsid);
        if (tsProject == null) {
            throw new HealthException("\u4f20\u5165\u53c2\u6570\u9519\u8bef,\u627e\u4e0d\u5230\u5bf9\u5e94\u6570\u636e");
        }
        if (tsProject.getIsFinish() != null && tsProject.getIsFinish().booleanValue()) {
            return resultData;
        }
        return resultData;
    }

    public Map<String, Object> generatorArchive(String archiveTargetDir, String docNo, Long cid, String docParamValue) {
        Map<String, Object> dataMap = this.getDocData(cid, docParamValue);
        String targetFileNameFormat = FilesTypeEnum.sts.getTargetFilenameFormat();
        String[] targetDirs = FilesTypeEnum.sts.getDirs();
        String projectNo = (String)dataMap.get("projectNo");
        String destFileDir = String.format("\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u536b\u751f\u201c\u4e09\u540c\u65f6\u201d\u6863\u6848\uff08%s\uff09", projectNo);
        String destFileName = String.format(targetFileNameFormat, projectNo);
        String destFilePath = archiveTargetDir + "/" + destFileDir + "/";
        dataMap.put("archive_doc__filename", destFileDir);
        this.downLoadFile(dataMap.get("approvalDocumentsFileList"), destFilePath + targetDirs[0]);
        this.downLoadFile(dataMap.get("occPreReportFileList"), destFilePath + targetDirs[1] + "/\u804c\u4e1a\u75c5\u5371\u5bb3\u9884\u8bc4\u4ef7\u62a5\u544a");
        this.downLoadFile(dataMap.get("occPreProxyFileList"), destFilePath + targetDirs[1] + "/\u804c\u4e1a\u75c5\u5371\u5bb3\u9884\u8bc4\u4ef7\u59d4\u6258\u4e66");
        this.downLoadFile(dataMap.get("occShieldFileList"), destFilePath + targetDirs[2]);
        this.downLoadFile(dataMap.get("occControllEffectFileList"), destFilePath + targetDirs[3] + "/\u804c\u4e1a\u75c5\u5371\u5bb3\u63a7\u5236\u6548\u679c\u8bc4\u4ef7\u62a5\u544a");
        this.downLoadFile(dataMap.get("occControlProxyFileList"), destFilePath + targetDirs[3] + "/\u804c\u4e1a\u75c5\u5371\u5bb3\u63a7\u5236\u6548\u679c\u8bc4\u4ef7\u59d4\u6258\u4e66");
        this.downLoadFile(dataMap.get("occPreEffectReportFileList"), destFilePath + targetDirs[4] + "/\u804c\u4e1a\u75c5\u5371\u5bb3\u9884\u8bc4\u4ef7\u62a5\u544a\u8bc4\u5ba1\u610f\u89c1");
        this.downLoadFile(dataMap.get("occShieldOfDesignFileList"), destFilePath + targetDirs[4] + "/\u804c\u4e1a\u75c5\u9632\u62a4\u8bbe\u65bd\u8bbe\u8ba1\u4e13\u7bc7\u8bc4\u5ba1\u610f\u89c1");
        this.downLoadFile(dataMap.get("occPreControllEffectFileList"), destFilePath + targetDirs[4] + "/\u804c\u4e1a\u75c5\u5371\u5bb3\u63a7\u5236\u6548\u679c\u8bc4\u4ef7\u62a5\u544a\u8bc4\u5ba1\u610f\u89c1");
        this.downLoadFile(dataMap.get("completeDrawFileList"), destFilePath + targetDirs[5] + "/\u9879\u76ee\u7ae3\u5de5\u56fe\u7eb8");
        this.downLoadFile(dataMap.get("completeCheckReportFileList"), destFilePath + targetDirs[5] + "/\u9879\u76ee\u7ae3\u5de5\u9a8c\u6536\u62a5\u544a");
        this.downLoadFile(dataMap.get("completeSummaryFileList"), destFilePath + targetDirs[5] + "/\u9879\u76ee\u7ae3\u5de5\u603b\u7ed3");
        this.downLoadFile(dataMap.get("allBuildModifyFileList"), destFilePath + targetDirs[6]);
        List otFileList = (List)dataMap.get("otFileList");
        for (TsProjectOtherfile otf : otFileList) {
            this.downLoadFile(otf.getAttachmentSfList(), destFilePath + "11 \u5176\u4ed6\u9644\u4ef6");
        }
        this.handleHtml(dataMap);
        Java2WordGeneratorTemp.createDoc(dataMap, (String)"doc1sts/sts.ftl", (String)(destFilePath + destFileName));
        return dataMap;
    }

    public void downLoadFile(Object fileObject, String destFilePath) {
        try {
            List sysFileList;
            if (fileObject == null) {
                return;
            }
            File fileParent = new File(destFilePath);
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            if ((sysFileList = (List)fileObject).size() > 0) {
                for (SysFileModel sf : sysFileList) {
                    if (!StringUtils.isNotEmpty((CharSequence)sf.getOssUrl())) continue;
                    this.ossClienBean.downloadFile(sf.getOssUrl(), destFilePath, sf.getFileName());
                }
            }
        }
        catch (IOException e) {
            this.logger.error("\u6267\u884c\u7f51\u7edc\u62f7\u8d1d\u52a8\u4f5c\u53d1\u751f\u9519\u8bef:" + e.getMessage());
        }
    }

    public void handleHtml(Map<String, Object> dataMap) {
        if (dataMap != null) {
            Set<String> strs = dataMap.keySet();
            for (String key : strs) {
                Object entry = dataMap.get(key);
                if (entry == null) continue;
                if (entry instanceof List) {
                    List entryList = (List)entry;
                    String entryJson = JSONArray.toJSONString((Object)entry);
                    entryJson = StringEscapeUtils.unescapeHtml((String)entryJson);
                    try {
                        Class c = this.getClassInList(entryList);
                        if (c == null) continue;
                        List entry2 = JSONArray.parseArray((String)entryJson, (Class)c);
                        dataMap.put(key, entry2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String entryJson = JSON.toJSONString((Object)entry);
                entryJson = StringEscapeUtils.unescapeHtml((String)entryJson);
                Object entry2 = JSON.parseObject((String)entryJson, entry.getClass());
                dataMap.put(key, entry2);
            }
        }
    }

    public Class getClassInList(List list) {
        if (list != null && list.size() > 0) {
            Object o = list.get(0);
            return o.getClass();
        }
        return null;
    }
}

