/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.enums.FilesTypeEnum;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.thirdtime.TsProjectMapper;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProject;
import cn.smarthse.modules.health.entity.work.train.TrainPaperFile;
import cn.smarthse.modules.health.entity.work.train.TrainPlan;
import cn.smarthse.modules.health.entity.work.train.TrainSummarize;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.work.train.ITrainArchiveService;
import cn.smarthse.modules.health.vo.base.company.CompanyArchiveVo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TrainPlanArchiveService
extends BaseServiceImpl<TsProjectMapper, TsProject>
implements IDocDataService {
    @Autowired
    private ITrainArchiveService trainArchiveService;
    @Autowired
    private ICompanyService companyService;
    @DubboReference
    private ISysFileProvideService fileService;
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    ICompanyFunctionalOrganizationService companyFunctionalOrganizationService;

    public Map<String, Object> getDocData(Long cid, String docParamValue) {
        if (cid == null && docParamValue == null) {
            throw new HealthException("\u4f20\u5165\u53c2\u6570\u9519\u8bef,\u627e\u4e0d\u5230\u5bf9\u5e94\u6570\u636e");
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        List planList = this.trainArchiveService.getOccHealthTrainPlanByYear(cid, Integer.valueOf(docParamValue));
        List trainPlanList = this.trainArchiveService.getOccHealthTrainByYear(cid, Integer.valueOf(docParamValue));
        List certificateStaffDetailList = this.trainArchiveService.getManagerCertByYear(cid, Integer.valueOf(docParamValue));
        List trainSummarizeList = this.trainArchiveService.getTrainSummarizeByYear(cid, Integer.valueOf(docParamValue));
        dataMap.put("planList", planList);
        dataMap.put("trainPlanList", trainPlanList);
        dataMap.put("certificateStaffDetailList", certificateStaffDetailList);
        dataMap.put("trainSummarizeList", trainSummarizeList);
        return dataMap;
    }

    public Map<String, Object> getCheckData(Long cid, String docParamValue) {
        List trainPlanList;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Map<String, Object> map = this.getDocData(cid, docParamValue);
        if (map.get("planList") != null) {
            trainPlanList = (List)map.get("planList");
            dataMap.put("34-122", trainPlanList.size());
        } else {
            dataMap.put("34-122", 0);
        }
        if (map.get("trainPlanList") != null) {
            trainPlanList = (List)map.get("trainPlanList");
            dataMap.put("34-124", trainPlanList.size());
        } else {
            dataMap.put("34-124", 0);
        }
        if (map.get("certificateStaffDetailList") != null) {
            List certificateStaffDetailList = (List)map.get("certificateStaffDetailList");
            dataMap.put("34-123", certificateStaffDetailList.size());
        } else {
            dataMap.put("34-123", 0);
        }
        if (map.get("trainSummarizeList") != null) {
            List trainSummarizeList = (List)map.get("trainSummarizeList");
            dataMap.put("34-125", trainSummarizeList.size());
        } else {
            dataMap.put("34-125", 0);
        }
        return dataMap;
    }

    public Map<String, Object> generatorArchive(String archiveTargetDir, String docNo, Long cid, String docParamValue) {
        if (archiveTargetDir != null && cid != null && docParamValue != null) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            Integer year = Integer.valueOf(docParamValue);
            String number = docNo;
            String targetFileNameFormat = FilesTypeEnum.xcpx.getTargetFilenameFormat();
            String destFileDir = String.format("\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u6863\u6848\uff08%s\uff09", number);
            String destFileName = String.format(targetFileNameFormat, number);
            String destFilePath = archiveTargetDir + "/" + destFileDir + "/";
            dataMap.put("archive_doc__filename", destFileDir);
            CompanyArchiveVo company = this.companyService.getCompanyArchiveInfo(cid, year.intValue());
            String companyName = company.getName();
            company.setName(this.addString(company.getName()));
            company.setCompanyContactTel(company.getOccLeaderTel());
            company.setCompanyContactEmail(company.getOccLeaderEmail());
            String staffName = "";
            if (company.getOccLeaderName() != null) {
                staffName = this.addString(company.getOccLeaderName());
            }
            List planList = this.trainArchiveService.getOccHealthTrainPlanByYear(cid, year);
            List trainPlanList = this.trainArchiveService.getOccHealthTrainByYear(cid, year);
            List certificateStaffDetailList = this.trainArchiveService.getManagerCertByYear(cid, year);
            List trainSummarizeList = this.trainArchiveService.getTrainSummarizeByYear(cid, year);
            File fdir = null;
            for (String attrDir : FilesTypeEnum.xcpx.getDirs()) {
                if (attrDir.equals("4 \u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5de5\u4f5c\u603b\u7ed3(%s\u5e74\u5ea6)")) {
                    attrDir = String.format(attrDir, year);
                }
                fdir = new File(destFilePath + File.separator + attrDir);
                String path = fdir.getPath();
                try {
                    fdir.mkdirs();
                    if (attrDir.equals("2 \u7528\u4eba\u5355\u4f4d\u8d1f\u8d23\u4eba\u3001\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u8bc1\u660e") && certificateStaffDetailList != null) {
                        for (CertificateStaffDetail certificateUser : certificateStaffDetailList) {
                            fdir = null;
                            fdir = new File(path + File.separator + certificateUser.getStaffName());
                            fdir.mkdirs();
                            if (certificateUser.getFiles() == null) continue;
                            List files = certificateUser.getFiles();
                            for (CertificateFiles certificateFiles : files) {
                                this.ossClientBean.downloadFile(certificateFiles.getFileUrl(), fdir.getPath(), certificateFiles.getFileName());
                            }
                        }
                    } else if (attrDir.equals("3 \u52b3\u52a8\u8005\u804c\u4e1a\u536b\u751f\u5ba3\u4f20\u57f9\u8bad\u5217\u8868") && trainPlanList != null) {
                        for (TrainPlan trainPlan : trainPlanList) {
                            String pxdjName;
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                            String planTime = dateFormat.format(trainPlan.getRegisterTime());
                            fdir = null;
                            fdir = new File(path + File.separator + planTime + " " + trainPlan.getName());
                            String paths = fdir.getPath();
                            fdir.mkdirs();
                            Object fileName = "";
                            String booksName = "";
                            String examsName = "";
                            Object signName = "";
                            Object scoreName = "";
                            Object medioName = "";
                            if (trainPlan.getSignFiles() != null && trainPlan.getSignFiles().size() > 0) {
                                fdir = null;
                                fdir = new File(paths + File.separator + "\u57f9\u8bad\u7b7e\u5230\u5355");
                                fdir.mkdirs();
                                List signFiles = trainPlan.getSignFiles();
                                for (TrainPaperFile trainPaperFile : signFiles) {
                                    signName = (String)signName + trainPaperFile.getFileName() + ",";
                                    this.ossClientBean.downloadFile(trainPaperFile.getFileUrl(), fdir.getPath(), trainPaperFile.getFileName());
                                }
                            }
                            if (trainPlan.getScoreFiles() != null && trainPlan.getScoreFiles().size() > 0) {
                                fdir = null;
                                fdir = new File(paths + File.separator + "\u57f9\u8bad\u6210\u7ee9\u5355");
                                fdir.mkdirs();
                                List scoreFiles = trainPlan.getScoreFiles();
                                for (TrainPaperFile trainPaperFile : scoreFiles) {
                                    scoreName = (String)scoreName + trainPaperFile.getFileName() + ",";
                                    this.ossClientBean.downloadFile(trainPaperFile.getFileUrl(), fdir.getPath(), trainPaperFile.getFileName());
                                }
                            }
                            if (trainPlan.getMedioFiles() != null && trainPlan.getMedioFiles().size() > 0) {
                                fdir = null;
                                fdir = new File(paths + File.separator + "\u57f9\u8bad\u5f71\u50cf\u8d44\u6599");
                                fdir.mkdirs();
                                List medioFiles = trainPlan.getMedioFiles();
                                for (TrainPaperFile trainPaperFile : medioFiles) {
                                    medioName = (String)medioName + trainPaperFile.getFileName() + ",";
                                    this.ossClientBean.downloadFile(trainPaperFile.getFileUrl(), fdir.getPath(), trainPaperFile.getFileName());
                                }
                            }
                            if ((fileName = (pxdjName = "\u57f9\u8bad\u767b\u8bb0\u8868(" + planTime + " " + trainPlan.getName() + ").doc") + booksName + examsName + (String)signName + (String)scoreName + (String)medioName) != "" && ((String)fileName).length() > 0) {
                                fileName = ((String)fileName).substring(0, ((String)fileName).length() - 1);
                            }
                            trainPlan.setFileName((String)fileName);
                            if (booksName != "") {
                                booksName = booksName.substring(0, booksName.length() - 1);
                            }
                            if (examsName != "") {
                                examsName = examsName.substring(0, examsName.length() - 1);
                            }
                            if (signName != "") {
                                signName = ((String)signName).substring(0, ((String)signName).length() - 1);
                            }
                            if (scoreName != "") {
                                scoreName = ((String)scoreName).substring(0, ((String)scoreName).length() - 1);
                            }
                            if (medioName != "") {
                                medioName = ((String)medioName).substring(0, ((String)medioName).length() - 1);
                            }
                            dataMap.put("companyName", companyName);
                            dataMap.put("trainPlan", trainPlan);
                            dataMap.put("booksName", booksName);
                            dataMap.put("examsName", examsName);
                            dataMap.put("signName", signName);
                            dataMap.put("scoreName", scoreName);
                            dataMap.put("medioName", medioName);
                            Java2WordGeneratorTemp.createDoc(dataMap, (String)"doc3xcpx/pxdj.ftl", (String)(paths + File.separator + "\u57f9\u8bad\u767b\u8bb0\u8868(" + planTime + " " + trainPlan.getName() + ").doc"));
                        }
                    } else if (attrDir.equals("4 \u5e74\u5ea6\u804c\u4e1a\u536b\u751f\u57f9\u8bad\u5de5\u4f5c\u603b\u7ed3(" + year + "\u5e74\u5ea6)") && trainSummarizeList != null) {
                        for (TrainSummarize trainSummarize : trainSummarizeList) {
                            Object fileName = "";
                            fdir = null;
                            fdir = new File(path + File.separator + trainSummarize.getName());
                            fdir.mkdirs();
                            if (trainSummarize.getFileList() != null) {
                                List fileList = trainSummarize.getFileList();
                                for (TrainPaperFile trainPaperFile : fileList) {
                                    fileName = (String)fileName + trainPaperFile.getFileName() + ",";
                                    this.ossClientBean.downloadFile(trainPaperFile.getFileUrl(), fdir.getPath(), trainPaperFile.getFileName());
                                }
                            }
                            if (fileName != "") {
                                fileName = ((String)fileName).substring(0, ((String)fileName).length() - 1);
                            }
                            trainSummarize.setFileName((String)fileName);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
                fdir = null;
            }
            dataMap.put("year", year);
            dataMap.put("number", number);
            dataMap.put("company", company);
            dataMap.put("staffName", staffName);
            dataMap.put("planList", planList);
            dataMap.put("trainPlanList", trainPlanList);
            dataMap.put("certificateStaffDetailList", certificateStaffDetailList);
            dataMap.put("trainSummarizeList", trainSummarizeList);
            Java2WordGeneratorTemp.createDoc(dataMap, (String)"doc3xcpx/xcpx.ftl", (String)(destFilePath + destFileName));
            return dataMap;
        }
        return null;
    }

    public String addString(String str) {
        if (str == null) {
            str = "";
        }
        int len = StringUtils.getStringLength((String)str);
        StringBuffer sb = new StringBuffer();
        sb.append(str);
        if (len <= 20) {
            for (int i = len; i <= 20; ++i) {
                sb.append("_");
            }
        }
        return sb.toString();
    }
}

