/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.enums.FilesTypeEnum;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.work.check.PhcPhysicalCompanyMapper;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffhealthDocVo;
import cn.smarthse.modules.health.entity.litearchive.LiteArchive;
import cn.smarthse.modules.health.entity.work.accident.EmeAccident;
import cn.smarthse.modules.health.entity.work.check.PhcDiseaserReport;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserReportQuery;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheck;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.doc.CompanyInfo;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc5Table1;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc5Table3;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc5Table3_2;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc5Table3_2_Detail;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc5Table3_2_Staff;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc5Table4Staff;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc5Table4_1;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc5Table4_2;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkDiseaseVo;
import cn.smarthse.modules.health.enums.archive.ArchiveFilteItemDataStateEnum;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.check.DealTypeEnum;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveFileItemService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.accident.IEmeAccidentService;
import cn.smarthse.modules.health.service.work.check.IPhcDiseaserReportService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.check.doc.IPhcPhysicalCompanyService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.vo.base.company.CompanyArchiveVo;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@DubboService
@Transactional(readOnly=true)
public class PhcPhysicalCompanyServiceImpl
implements IPhcPhysicalCompanyService,
IDocDataService {
    @Autowired
    PhcPhysicalCompanyMapper dao;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @DubboReference
    private ISysFileProvideService sysFileService;
    @Autowired
    private IPhcPhysicalCheckDataResultService resultService;
    @Autowired
    private IPhcDiseaserReportService reportService;
    @Autowired
    private IEmeAccidentService accidentService;
    @Autowired
    private IHarmfactorWorkService harmService;
    @Autowired
    OssClientBean ossClienBean;
    @Autowired
    ICompanyFunctionalOrganizationService companyFunctionalOrganizationService;
    @Autowired
    IOccupationalRiskFactorsService riskService;
    @DubboReference
    ISysFileProvideService fileService;
    @Autowired(required=false)
    @Lazy
    ILiteArchiveFileItemService fileItemService;
    @Autowired
    ILiteArchiveService archiveService;
    @Value(value="${isActualize}")
    private String isActualize;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;

    public CompanyInfo setCompanyPhcInfo1(Long cid) {
        CompanyInfo info = new CompanyInfo();
        if (cid == null) {
            return info;
        }
        Company company = (Company)this.companyService.getById(cid);
        if (company == null) {
            return info;
        }
        String companyName = company.getName();
        info.setCompanyName(companyName);
        CompanyFunctionalOrganization cfo = this.companyFunctionalOrganizationService.getFunOrgEHS(cid);
        if (cfo == null) {
            return info;
        }
        info.setOccLeaderMobile(cfo.getTelephone());
        info.setOccLeaderName(cfo.getDirectorName());
        Long occLeaderSid = cfo.getDirector();
        if (occLeaderSid == null) {
            return info;
        }
        StaffInfo occLeaderStaff = this.staffInfoService.getStaffInfoWithStaffBasicWorkById(occLeaderSid);
        if (occLeaderStaff == null || occLeaderStaff.getStaffBasicInfo() == null) {
            return info;
        }
        StaffBasicInfo staffBasicInfo = occLeaderStaff.getStaffBasicInfo();
        info.setOccLeaderEmail(staffBasicInfo.getEmail());
        return info;
    }

    public CompanyInfo setCompanyPhcInfo(Long cid) {
        CompanyInfo info = new CompanyInfo();
        if (cid == null) {
            return info;
        }
        CompanyArchiveVo company = this.companyService.getCompanyArchiveInfo(cid);
        if (company == null) {
            return info;
        }
        info.setCompanyName(company.getName());
        info.setOccLeaderMobile(company.getOccLeaderTel());
        info.setOccLeaderName(company.getOccLeaderName());
        info.setOccLeaderEmail(company.getOccLeaderEmail());
        return info;
    }

    public List<Doc5Table1> doc5Table1(Long cid, Map<String, Object> result) {
        ArrayList<Doc5Table1> checkCompanies = new ArrayList<Doc5Table1>();
        return checkCompanies;
    }

    public List<PhcPhysicalQueryCheckInfo> doc5Table2(PhcPhysicalQueryCheck query) {
        List<PhcPhysicalQueryCheckInfo> infos = null;
        infos = "true".equals(this.isActualize) ? this.dao.queryCheck(query) : this.dao.queryCheckLite(query);
        this.resultService.countCheck(infos);
        return infos;
    }

    public List<Doc5Table3> doc5Table3(PhcPhysicalQueryCheck query) {
        return this.dao.doc5Table3(query);
    }

    public List<Doc5Table3_2> doc5Table3_2(PhcPhysicalQueryCheck query) {
        List<Doc5Table3_2_Detail> details = this.dao.doc5Table3_2_Detail(query);
        ArrayList<Doc5Table3_2> doc5Table3_2s = new ArrayList<Doc5Table3_2>();
        if (details == null) {
            return doc5Table3_2s;
        }
        HashMap<CallSite, Doc5Table3_2> doc5Table3_2Map = new HashMap<CallSite, Doc5Table3_2>();
        for (Doc5Table3_2_Detail doc5Table3_2_Detail : details) {
            List staffs;
            Doc5Table3_2_Staff staff;
            doc5Table3_2_Detail.setCheckResultInfo(this.getResultInfo(ExamResultEnum.getName((String)doc5Table3_2_Detail.getCheckResult()), doc5Table3_2_Detail.getCheckAdvice()));
            doc5Table3_2_Detail.setDealTypeInfo(this.getResultInfo(DealTypeEnum.getName((String)doc5Table3_2_Detail.getDealType()), doc5Table3_2_Detail.getInfoDesc()));
            this.setIsSure(doc5Table3_2_Detail);
            String key = doc5Table3_2_Detail.getCheckId() + "_" + doc5Table3_2_Detail.getCheckType() + "_" + doc5Table3_2_Detail.getDeptId();
            Doc5Table3_2 doc5Table3_2 = (Doc5Table3_2)doc5Table3_2Map.get(key);
            if (doc5Table3_2 == null) {
                doc5Table3_2 = this.createDoc5Table3_2(doc5Table3_2_Detail, query);
            }
            if ((staff = this.getStaff(staffs = doc5Table3_2.getStaffs(), doc5Table3_2_Detail)) == null) {
                staff = this.createDoc5Table3_2_Staff(doc5Table3_2_Detail, query);
                staffs.add(staff);
            }
            staff.getDetails().add(doc5Table3_2_Detail);
            doc5Table3_2Map.put((CallSite)((Object)key), doc5Table3_2);
        }
        for (Map.Entry entry : doc5Table3_2Map.entrySet()) {
            doc5Table3_2s.add((Doc5Table3_2)entry.getValue());
        }
        return doc5Table3_2s;
    }

    private String getResultInfo(String str1, String str2) {
        Object result = "";
        if (StringUtils.isNotBlank((CharSequence)str1) && StringUtils.isNotBlank((CharSequence)str2)) {
            result = str1 + "\uff1b" + str2;
        } else if (StringUtils.isNotBlank((CharSequence)str1)) {
            result = str1;
        } else if (StringUtils.isNotBlank((CharSequence)str2)) {
            result = str2;
        }
        return result;
    }

    private Doc5Table3_2_Staff getStaff(List<Doc5Table3_2_Staff> staffs, Doc5Table3_2_Detail detail) {
        Doc5Table3_2_Staff staff = null;
        for (Doc5Table3_2_Staff s : staffs) {
            String key2;
            String key1 = s.getCheckId() + "_" + s.getCheckType() + "_" + s.getDeptId() + "_" + s.getStaffId();
            if (!key1.equals(key2 = detail.getCheckId() + "_" + detail.getCheckType() + "_" + detail.getDeptId() + "_" + detail.getStaffId())) continue;
            staff = s;
            break;
        }
        return staff;
    }

    private Doc5Table3_2_Staff createDoc5Table3_2_Staff(Doc5Table3_2_Detail detail, PhcPhysicalQueryCheck query) {
        Long cid = query.getCid();
        Doc5Table3_2_Staff staff = new Doc5Table3_2_Staff();
        staff.setCheckId(detail.getCheckId());
        staff.setDeptId(detail.getDeptId());
        staff.setCheckType(detail.getCheckType());
        staff.setStaffId(detail.getStaffId());
        staff.setStaffName(detail.getStaffName());
        staff.setGender(this.getGenderName(detail.getGender()));
        staff.setBirthday(detail.getBirthday());
        staff.setWorkName(detail.getWorkName());
        this.setHistoryHarmsAndDiseases(cid, detail.getWorkId(), staff, detail.getBeginTime());
        if (!"true".equals(this.isActualize)) {
            this.setLiteHarms(staff, detail);
        }
        staff.setDetails(new ArrayList());
        return staff;
    }

    private void setLiteHarms(Doc5Table3_2_Staff staff, Doc5Table3_2_Detail detail) {
        String ids = detail.getHarmFactorIds();
        if (ids == null || ids.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        List harms = this.riskService.getListByIds(ids);
        harms.forEach(harm -> {
            sb.append(harm.getNameCh());
            sb.append(",");
        });
        if (sb.length() > 0) {
            staff.setHarms(sb.substring(0, sb.length() - 1));
        }
    }

    private void setHistoryHarmsAndDiseases(Long cid, Long workId, Doc5Table3_2_Staff staff, Date date) {
        List vos = this.harmService.getArchiveHarmfactorByWork(cid, workId, date);
        if (vos == null) {
            return;
        }
        ArrayList<Long> harmIds = new ArrayList<Long>();
        for (HarmfactorWorkSource vo : vos) {
            Long harmId = vo.getHarmId();
            if (harmId == null) continue;
            harmIds.add(vo.getHarmId());
        }
        List harmInfos = this.riskService.getHarmfactorAndDieaseListByHarmIds(harmIds);
        if (harmInfos == null || harmInfos.isEmpty()) {
            return;
        }
        Object harms = "";
        Object diseases = "";
        for (HarmfactorWorkDiseaseVo vo : harmInfos) {
            String nameCH = vo.getNameCH();
            String disease = vo.getOccupationalDisease();
            if (StringUtils.isNotEmpty((String)nameCH)) {
                harms = (String)harms + nameCH + "\uff1b";
            }
            if (!StringUtils.isNotEmpty((String)disease) || disease.equals("/")) continue;
            diseases = (String)diseases + disease + "\uff1b";
        }
        staff.setHarms((String)(((String)harms).length() > 0 ? ((String)harms).substring(0, ((String)harms).length() - 1) : harms));
        staff.setDiseases((String)(((String)diseases).length() > 0 ? ((String)diseases).substring(0, ((String)diseases).length() - 1) : diseases));
    }

    private void setHarmsAndDiseases(Long cid, Long workId, Doc5Table3_2_Staff staff) {
        List vos = this.harmService.getHarmfactorAndDieaseListByWork(cid, workId);
        if (vos == null) {
            return;
        }
        Object harms = "";
        Object diseases = "";
        for (HarmfactorWorkDiseaseVo vo : vos) {
            String nameCH = vo.getNameCH();
            String disease = vo.getOccupationalDisease();
            if (StringUtils.isNotEmpty((String)nameCH)) {
                harms = (String)harms + nameCH + "\uff1b";
            }
            if (!StringUtils.isNotEmpty((String)disease)) continue;
            diseases = (String)diseases + disease + "\uff1b";
        }
        staff.setHarms((String)harms);
        staff.setDiseases((String)diseases);
    }

    private Doc5Table3_2 createDoc5Table3_2(Doc5Table3_2_Detail detail, PhcPhysicalQueryCheck query) {
        Doc5Table3_2 result = new Doc5Table3_2();
        result.setBeginTime(detail.getBeginTime());
        result.setCheckId(detail.getCheckId());
        result.setCheckTypeName(CheckTypeEnum.getName((String)detail.getCheckType()));
        result.setEndTime(detail.getEndTime());
        result.setStaffDeptId(detail.getDeptId());
        result.setStaffDeptName(detail.getDeptName());
        ArrayList<Doc5Table3_2_Staff> staffs = new ArrayList<Doc5Table3_2_Staff>();
        Doc5Table3_2_Staff staff = this.createDoc5Table3_2_Staff(detail, query);
        staffs.add(staff);
        result.setStaffs(staffs);
        return result;
    }

    private void setIsSure(Doc5Table3_2_Detail detail) {
        String isSure = "";
        if (DealTypeEnum.recheck.getCode().equals(detail.getDealType())) {
            isSure = String.valueOf(1).equals(String.valueOf(detail.getRecheckStatus())) ? "\u662f" : "\u5426";
        } else if (DealTypeEnum.change.getCode().equals(detail.getDealType())) {
            isSure = detail.getIsExchange() != null && detail.getIsExchange() != false ? "\u662f" : "\u5426";
        } else if (DealTypeEnum.diagnose.getCode().equals(detail.getDealType())) {
            isSure = detail.getIsDiagnosed() != null && detail.getIsDiagnosed() != false ? "\u662f" : "\u5426";
        }
        detail.setIsSure(isSure);
    }

    public List<Doc5Table4_1> doc5Table4_1(PhcPhysicalQueryCheck query) {
        return this.dao.doc5Table4_1(query);
    }

    public List<Doc5Table4Staff> doc5Table4_1Staffs(PhcPhysicalQueryCheck query, Map<String, Object> result) {
        List<Doc5Table4_1> docInfos = this.doc5Table4_1(query);
        List<Doc5Table4Staff> staffDocInfos = null;
        ArrayList<SysFileModel> doc5Table4_1Files = new ArrayList<SysFileModel>();
        if (docInfos == null || docInfos.size() == 0) {
            return staffDocInfos;
        }
        HashMap<Long, Doc5Table4Staff> staffInfoMap = new HashMap<Long, Doc5Table4Staff>();
        for (Doc5Table4_1 info : docInfos) {
            Long key;
            Doc5Table4Staff mapInfo;
            List<SysFileModel> certs = this.getFiles(info.getCertUrl());
            info.setCerts(certs);
            if (certs != null && certs.size() > 0) {
                for (SysFileModel file : certs) {
                    file.setDestPath(info.getStaffName());
                }
                doc5Table4_1Files.addAll(certs);
            }
            if ((mapInfo = (Doc5Table4Staff)staffInfoMap.get(key = info.getStaffId())) == null) {
                mapInfo = new Doc5Table4Staff();
                mapInfo.setBirthday(info.getBirthday());
                mapInfo.setGender(this.getGenderName(String.valueOf(info.getGender())));
                mapInfo.setStaffId(info.getStaffId());
                mapInfo.setStaffName(info.getStaffName());
            }
            mapInfo.getDieasers().add(info);
            staffInfoMap.put(key, mapInfo);
        }
        staffDocInfos = this.convertMapToList(staffInfoMap);
        result.put("doc5Table4_1Files", doc5Table4_1Files);
        return staffDocInfos;
    }

    private List<SysFileModel> getFiles(String ids) {
        ArrayList<SysFileModel> files = new ArrayList<SysFileModel>();
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return files;
        }
        List fileIds = StringUtils.parseToLongList((String)ids, (String)",");
        for (Long fileId : fileIds) {
            SysFileModel file = this.sysFileService.getFileById(fileId);
            files.add(file);
        }
        return files;
    }

    public List<Doc5Table4_2> doc5Table4_2(PhcPhysicalQueryCheck query) {
        return this.dao.doc5Table4_2(query);
    }

    public List<Doc5Table4Staff> doc5Table4_2Staffs(PhcPhysicalQueryCheck query) {
        List<Doc5Table4_2> docInfos = this.doc5Table4_2(query);
        List<Doc5Table4Staff> staffDocInfos = null;
        if (docInfos == null || docInfos.size() == 0) {
            return staffDocInfos;
        }
        HashMap<Long, Doc5Table4Staff> staffInfoMap = new HashMap<Long, Doc5Table4Staff>();
        for (Doc5Table4_2 info : docInfos) {
            info.setDealTypeInfo(DealTypeEnum.getName((String)info.getDealType()));
            Long key = info.getStaffId();
            Doc5Table4Staff mapInfo = (Doc5Table4Staff)staffInfoMap.get(key);
            if (mapInfo == null) {
                mapInfo = new Doc5Table4Staff();
                mapInfo.setBirthday(info.getBirthday());
                mapInfo.setGender(this.getGenderName(String.valueOf(info.getGender())));
                mapInfo.setStaffId(info.getStaffId());
                mapInfo.setStaffName(info.getStaffName());
            }
            mapInfo.getSuspectedDieasers().add(info);
            staffInfoMap.put(key, mapInfo);
        }
        staffDocInfos = this.convertMapToList(staffInfoMap);
        return staffDocInfos;
    }

    private List<Doc5Table4Staff> convertMapToList(Map<Long, Doc5Table4Staff> map) {
        ArrayList<Doc5Table4Staff> results = new ArrayList<Doc5Table4Staff>();
        for (Doc5Table4Staff value : map.values()) {
            results.add(value);
        }
        return results;
    }

    public List<PhcDiseaserReport> doc5Table5(PhcPhysicalQueryCheck query, Map<String, Object> result) {
        PhcDiseaserReportQuery reportQuery = new PhcDiseaserReportQuery();
        reportQuery.setCid(query.getCid());
        reportQuery.setStatus(Byte.valueOf((byte)1));
        reportQuery.setReportBeginTime(query.getBeginTime());
        reportQuery.setReportEndTime(query.getEndTime());
        List reports = this.reportService.listDetails(reportQuery);
        if (reports == null) {
            return reports;
        }
        ArrayList<SysFileModel> doc5Table5Files = new ArrayList<SysFileModel>();
        for (PhcDiseaserReport report : reports) {
            List<SysFileModel> files = this.getFiles(report.getReportFileUrl());
            report.setReportFiles(files);
            if (files == null || files.size() <= 0) continue;
            for (SysFileModel file : files) {
                file.setDestPath(DateUtils.format((Date)report.getReportTime(), (String)"yyyyMMdd"));
            }
            doc5Table5Files.addAll(files);
        }
        result.put("doc5Table5Files", doc5Table5Files);
        return reports;
    }

    public List<EmeAccident> doc5Table6(PhcPhysicalQueryCheck query, Map<String, Object> result) {
        EmeAccident accidentQuery = new EmeAccident();
        accidentQuery.setCid(query.getCid());
        accidentQuery.setStatus(Byte.valueOf((byte)1));
        accidentQuery.setBeginTime(query.getBeginTime());
        accidentQuery.setEndTime(query.getEndTime());
        return this.accidentService.listAndFiles(accidentQuery, result);
    }

    public List<StaffhealthDocVo> doc5Table7(Long cid) {
        return this.staffInfoService.getStaffhealthDocVoDatasByCid(cid);
    }

    public Map<String, Object> getDoc5Data(Long cid, String docParamValue) {
        return this.getDocData(cid, docParamValue);
    }

    private String getGenderName(String gender) {
        if ("1".equals(gender)) {
            return "\u7537";
        }
        if ("0".equals(gender)) {
            return "\u5973";
        }
        return "";
    }

    private PhcPhysicalQueryCheck getDocParam(Long cid, String year) {
        PhcPhysicalQueryCheck query = new PhcPhysicalQueryCheck();
        query.setCid(cid);
        if (StringUtils.isNotEmpty((String)year)) {
            String beginDateStr = year + "-01-01 00:00:00";
            String endDateStr = year + "-12-31 23:59:59";
            query.setBeginTime(DateUtils.parseDate((Object)beginDateStr));
            query.setEndTime(DateUtils.parseDate((Object)endDateStr));
        }
        return query;
    }

    private PhcPhysicalQueryCheck getArchiveDocParam(Long cid, String year) {
        PhcPhysicalQueryCheck query = new PhcPhysicalQueryCheck();
        query.setCid(cid);
        query.setDocYear(year);
        return query;
    }

    public Map<String, Object> getDocData(Long cid, String docParamValue) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (cid == null) {
            return result;
        }
        PhcPhysicalQueryCheck query = this.getArchiveDocParam(cid, docParamValue);
        CompanyInfo company = this.setCompanyPhcInfo(cid);
        List<Doc5Table1> table1 = this.doc5Table1(cid, result);
        List<PhcPhysicalQueryCheckInfo> table2 = this.doc5Table2(query);
        List<Doc5Table3> table3 = this.doc5Table3(query);
        List<Doc5Table3_2> table3_2 = this.doc5Table3_2(query);
        List<Doc5Table4Staff> table4_1 = this.doc5Table4_1Staffs(query, result);
        List<Doc5Table4Staff> table4_2 = this.doc5Table4_2Staffs(query);
        List<PhcDiseaserReport> table5 = this.doc5Table5(query, result);
        List<EmeAccident> table6 = this.doc5Table6(query, result);
        List<StaffhealthDocVo> table7 = this.doc5Table7(cid);
        result.put("company", company);
        result.put("doc5Table1", table1);
        result.put("doc5Table2", table2);
        result.put("doc5Table3", table3);
        result.put("doc5Table3_2", table3_2);
        result.put("doc5Table4_1", table4_1);
        result.put("doc5Table4_2", table4_2);
        result.put("doc5Table5", table5);
        result.put("doc5Table6", table6);
        result.put("doc5Table7", table7);
        return result;
    }

    public Map<String, Object> getLiteDocData(Long cid, String docParamValue) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (cid == null) {
            return result;
        }
        PhcPhysicalQueryCheck query = this.getArchiveDocParam(cid, docParamValue);
        List<PhcPhysicalQueryCheckInfo> table2 = this.doc5Table2(query);
        List<Doc5Table3> table3 = this.doc5Table3(query);
        List<Doc5Table3_2> table3_2 = this.doc5Table3_2(query);
        List<Doc5Table4Staff> table4_1 = this.doc5Table4_1Staffs(query, result);
        List<Doc5Table4Staff> table4_2 = this.doc5Table4_2Staffs(query);
        result.put("doc5Table2", table2);
        result.put("doc5Table3", table3);
        result.put("doc5Table3_2", table3_2);
        result.put("doc5Table4_1", table4_1);
        result.put("doc5Table4_2", table4_2);
        return result;
    }

    public Map<String, Object> getCheckData(Long cid, String docParamValue) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (cid == null) {
            return result;
        }
        PhcPhysicalQueryCheck query = this.getDocParam(cid, docParamValue);
        List<Doc5Table1> table1 = this.doc5Table1(cid, result);
        List<PhcPhysicalQueryCheckInfo> table2 = this.doc5Table2(query);
        List<StaffhealthDocVo> table7 = this.doc5Table7(cid);
        result.put("doc5Table1", table1 == null ? 0 : table1.size());
        result.put("doc5Table2", table2 == null ? 0 : table2.size());
        result.put("doc5Table7", table7 == null ? 0 : table7.size());
        return result;
    }

    public Map<String, Object> generatorArchive(String archiveTargetDir, String docNo, Long cid, String docParamValue) {
        Map<String, Object> dataMap = this.getDocData(cid, docParamValue);
        dataMap.put("docNo", docNo);
        String targetFileNameFormat = FilesTypeEnum.companyPhc.getTargetFilenameFormat();
        String[] targetDirs = FilesTypeEnum.companyPhc.getDirs();
        String destFileDir = String.format("\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u7ba1\u7406\u6863\u6848\uff08%s\uff09", docNo);
        String destFileName = String.format(targetFileNameFormat, docNo);
        String destFilePath = archiveTargetDir + File.separator + destFileDir + File.separator;
        dataMap.put("archive_doc__filename", destFileDir);
        Java2WordGeneratorTemp.createDoc(dataMap, (String)"doc5/doc5.ftl", (String)(destFilePath + destFileName));
        this.downLoadFile(dataMap.get("doc5Table1Files"), destFilePath + targetDirs[0]);
        this.downLoadFile(dataMap.get("doc5Table4_1Files"), destFilePath + targetDirs[1]);
        this.downLoadFile(dataMap.get("doc5Table5Files"), destFilePath + targetDirs[2]);
        this.downLoadFile(dataMap.get("doc5Table6Files"), destFilePath + targetDirs[3]);
        return dataMap;
    }

    @Transactional(readOnly=false)
    public Map<String, Object> generatorLiteArchive(LiteArchive archive, String fileNameIds) {
        this.logger.info("\u6863\u6848\u9644\u4ef6\u751f\u6210:\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u7ba1\u7406\u6863\u6848\u5f00\u59cb");
        PhcPhysicalCheckSearchVo vo = new PhcPhysicalCheckSearchVo();
        vo.setCid(archive.getCid());
        vo.setYear(Integer.valueOf(0));
        StopWatch sw = new StopWatch();
        sw.start("\u6863\u6848\u9644\u4ef6\u751f\u6210:\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u7ba1\u7406\u6863\u6848\uff0c\u6863\u6848id:" + archive.getId());
        PhcPhysicalStatisticsModel model = this.phcPhysicalCheckV3221Service.getStatisticsModel(vo);
        this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(502L), null, null, model.getNumberOfCheck() > 0 ? ArchiveFilteItemDataStateEnum.FULL : ArchiveFilteItemDataStateEnum.UNFULL);
        this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(504L), null, null, model.getNumberOfCheck() > 0 ? ArchiveFilteItemDataStateEnum.FULL : ArchiveFilteItemDataStateEnum.UNFULL);
        this.fileItemService.appendFilesNotUpdateState(archive.getId(), Long.valueOf(505L), null, null, model.getNumberOfYszyb() > 0 ? ArchiveFilteItemDataStateEnum.FULL : ArchiveFilteItemDataStateEnum.UNFULL);
        sw.stop();
        this.logger.info("\u6863\u6848\u9644\u4ef6\u751f\u6210:\u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u7ba1\u7406\u6863\u6848\u7ed3\u675f");
        sw.start("\u5237\u65b0\u6863\u6848\u72b6\u6001\uff0c\u6863\u6848id:" + archive.getId());
        this.archiveService.updateStatus(archive.getId());
        sw.stop();
        this.logger.info(sw.prettyPrint());
        this.logger.info("\u6863\u68485\u751f\u6210\u603b\u8017\u65f6\uff1a{}s", (Object)sw.getTotalTimeSeconds());
        return null;
    }

    public void downLoadFile(Object fileObject, String destFilePath) {
        try {
            if (fileObject == null) {
                return;
            }
            List sysFileList = (List)fileObject;
            if (sysFileList.size() > 0) {
                for (SysFileModel sf : sysFileList) {
                    String ownPath = destFilePath + File.separator + sf.getDestPath();
                    File copyPath = new File(ownPath);
                    if (!copyPath.exists()) {
                        copyPath.mkdirs();
                    }
                    if (!StringUtils.isNotEmpty((String)sf.getOssUrl())) continue;
                    this.ossClienBean.downloadFile(sf.getOssUrl(), ownPath, sf.getFileName());
                }
            }
        }
        catch (IOException e) {
            this.logger.error("\u6267\u884c\u7f51\u7edc\u62f7\u8d1d\u52a8\u4f5c\u53d1\u751f\u9519\u8bef:" + e.getMessage());
        }
    }
}

