/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.enums.FilesTypeEnum;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffDocInfoVo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffOccupationAndHarmHistoryVo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.doc.Doc6Table4_2;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldWorkRelation;
import cn.smarthse.modules.health.enums.archive.PersonalHarmFactorArchiveDataMapKeyEnum;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleService;
import cn.smarthse.modules.health.vo.archive.Doc6WorkPlaceHarmFactor;
import cn.smarthse.modules.health.vo.archive.Doc6WorkPlaceHarmFactorCheckPlan;
import cn.smarthse.modules.health.vo.archive.Doc6WorkPlaceHarmFactorResult;
import cn.smarthse.modules.health.vo.archive.Doc6WorkPlaceHarmFactorResultValue;
import cn.smarthse.modules.health.vo.archive.Doc6WorkPlaceHarmFactorValue;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.result.ResultUtils;
import cn.smarthse.services.hfi.api.pojo.vo.HarmFactorCheckResultVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PersonalPHCArhiveService
implements IDocDataService {
    @Autowired
    private IPhcPhysicalCheckCountService phcPhysicalCheckCountService;
    @Autowired
    private IPhcPhysicalCheckService phcPhysicalCheckService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IPhcPhysicalCheckDataResultService phcCheckDataResultService;
    @Autowired
    ICompanyService companyService;
    @Value(value="${isActualize}")
    private String isActualize;
    @Autowired
    OssClientBean ossClienBean;
    @Autowired
    private IHarmfactorWorkService harmfactorWorkService;
    @Autowired
    private IShieldEquipRuleService shieldEquipRuleService;
    @Autowired
    private IStaffWorkRoleService staffWorkRoleService;
    @DubboReference
    ICheckPlanService checkPlanService;
    @DubboReference
    ICheckResultService checkResultService;
    @Autowired
    IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @DubboReference
    ISysFileProvideService sysFileProvideService;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public Map<String, Object> getDocData(Long cid, String docParamValue) {
        try {
            if (!StringUtils.isNumber((String)docParamValue)) {
                throw new HealthException("\u5458\u5de5id\u9519\u8bef");
            }
            Long staffId = Long.valueOf(docParamValue);
            Map<String, Object> dataMap = this.getArchiveData(staffId, cid);
            return dataMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HealthException(e.getMessage());
        }
    }

    public Map<String, Object> getCheckData(Long cid, String docParamValue) {
        try {
            if (StringUtils.isEmpty((CharSequence)docParamValue) || !StringUtils.isNumber((String)docParamValue)) {
                throw new HealthException("\u8bf7\u9009\u62e9\u5f85\u9a8c\u8bc1\u7684\u5458\u5de5");
            }
            Long staffId = Long.valueOf(docParamValue);
            ArrayList<Long> staffIdList = new ArrayList<Long>();
            staffIdList.add(staffId);
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            PhcPhysicalCheckParam param = new PhcPhysicalCheckParam();
            param.setCid(cid);
            param.setUncheckStaffs(staffIdList);
            Integer checkedCount = this.phcPhysicalCheckService.getStaffCheckCount(param);
            dataMap.put("achive6_noPhc", checkedCount);
            Integer unCheckedWorkCount = this.staffInfoService.getNoWorkCheckStaffIdsByCidAndStaffIds(cid, staffId);
            dataMap.put("achive6_noWorkTest", unCheckedWorkCount);
            return dataMap;
        }
        catch (Exception e) {
            throw new HealthException("\u8bf7\u9009\u62e9\u5f85\u9a8c\u8bc1\u7684\u5458\u5de5");
        }
    }

    public Map<String, Object> generatorArchive(String archiveTargetDir, String docNo, Long cid, String docParamValue) {
        Map<String, Object> dataMap = this.getDocData(cid, docParamValue);
        dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.docNo.name(), docNo);
        String targetFileNameFormat = FilesTypeEnum.phc.getTargetFilenameFormat();
        String[] targetDirs = FilesTypeEnum.phc.getDirs();
        StaffDocInfoVo staffVo = (StaffDocInfoVo)dataMap.get(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name());
        String destFileDir = String.format("\u52b3\u52a8\u8005\u4e2a\u4eba\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u6863\u6848\uff08%s%s\uff09", staffVo.getRealName() == null ? "" : staffVo.getRealName(), staffVo.getDocNumber() == null ? "" : staffVo.getDocNumber());
        String name = (staffVo.getRealName() == null ? "" : staffVo.getRealName()) + (staffVo.getDocNumber() == null ? "" : staffVo.getDocNumber());
        String destFileName = String.format(targetFileNameFormat, name);
        String destFilePath = archiveTargetDir + "/" + destFileDir + "/";
        dataMap.put("archive_doc__filename", destFileDir);
        File file = Java2WordGeneratorTemp.createDoc(dataMap, (String)"doc6phc/phcFile.ftl", (String)(destFilePath + destFileName));
        ArrayList testProveBookHistoryFileList = new ArrayList();
        List testProveBookHistoryList = (List)dataMap.get(PersonalHarmFactorArchiveDataMapKeyEnum.testProveBookHistory.name());
        this.downLoadFile(testProveBookHistoryFileList, destFilePath + targetDirs[0], testProveBookHistoryList);
        this.downLoadFile((List)dataMap.get(PersonalHarmFactorArchiveDataMapKeyEnum.harmFactorTestResultHistoryPersonReportFiles.name()), destFilePath + targetDirs[1]);
        return dataMap;
    }

    public void downLoadFile(List<SysFileModel> files, String destFilePath) {
        try {
            if (files == null || files.size() == 0) {
                return;
            }
            File fileParent = new File(destFilePath);
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            for (SysFileModel sf : files) {
                if (!StringUtils.isNotEmpty((String)sf.getOssUrl())) continue;
                String subFolder = destFilePath;
                File subFolderFile = new File(subFolder);
                if (!subFolderFile.exists()) {
                    subFolderFile.mkdirs();
                }
                this.ossClienBean.downloadFile(sf.getOssUrl(), subFolder, sf.getFileName());
            }
        }
        catch (IOException e) {
            this.logger.error("\u6267\u884c\u7f51\u7edc\u62f7\u8d1d\u52a8\u4f5c\u53d1\u751f\u9519\u8bef:" + e.getMessage());
        }
    }

    public void downLoadFile(Object fileObject, String destFilePath, List<Doc6Table4_2> testProveBookHistoryList) {
        try {
            if (fileObject == null) {
                return;
            }
            File fileParent = new File(destFilePath);
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            if (testProveBookHistoryList != null) {
                for (Doc6Table4_2 d : testProveBookHistoryList) {
                    if (d.getCerts() == null) continue;
                    for (SysFileModel sf : d.getCerts()) {
                        if (!StringUtils.isNotEmpty((String)sf.getOssUrl())) continue;
                        String subFolder = destFilePath + "/" + d.getDiagnosedTimeStr();
                        File subFolderFile = new File(subFolder);
                        if (!subFolderFile.exists()) {
                            subFolderFile.mkdirs();
                        }
                        this.ossClienBean.downloadFile(sf.getOssUrl(), subFolder, sf.getFileName());
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error("\u6267\u884c\u7f51\u7edc\u62f7\u8d1d\u52a8\u4f5c\u53d1\u751f\u9519\u8bef:" + e.getMessage());
        }
    }

    private void setResultMaxMinCSTEL(Doc6WorkPlaceHarmFactorResultValue result, String cstel1, String cstel2, String cstel3) {
        BigDecimal num;
        if (StringUtils.isBlank((CharSequence)cstel2) && StringUtils.isBlank((CharSequence)cstel3)) {
            return;
        }
        String beforChar = null;
        if (Integer.valueOf(NumberUtil.toInt((String)cstel1.trim())) == 1) {
            beforChar = "\uff1c";
        } else if (Integer.valueOf(NumberUtil.toInt((String)cstel1.trim())) == 2) {
            beforChar = "\u2264";
        }
        if (StringUtils.isNumber((String)cstel2)) {
            num = new BigDecimal(cstel2);
            if (result.getMin() == null || num.compareTo(result.getMin()) < 0) {
                result.setMin(num);
                result.setMinBeforChar(beforChar);
            }
            if (result.getMax() == null || num.compareTo(result.getMax()) > 0) {
                result.setMax(num);
                result.setMinBeforChar(beforChar);
            }
        }
        if (StringUtils.isNumber((String)cstel3)) {
            num = new BigDecimal(cstel3);
            if (result.getMin() == null || num.compareTo(result.getMin()) < 0) {
                result.setMin(num);
            }
            if (result.getMax() == null || num.compareTo(result.getMax()) > 0) {
                result.setMax(num);
            }
        }
    }

    private void setResultMaxMinCmacCtwa(Doc6WorkPlaceHarmFactorResultValue result, String resultStr) {
        if (StringUtils.isBlank((CharSequence)resultStr)) {
            return;
        }
        String resultNum = null;
        boolean beforCharIsNum = false;
        String beforChar = resultStr.substring(0, 1);
        if (StringUtils.isInteger((String)beforChar)) {
            beforCharIsNum = true;
            resultNum = resultStr;
        } else {
            resultNum = resultStr.substring(1);
        }
        if (StringUtils.isNumber((String)resultNum)) {
            BigDecimal num = new BigDecimal(resultNum);
            if (result.getMax() == null || num.compareTo(result.getMax()) > 0) {
                result.setMax(num);
                if (beforCharIsNum) {
                    result.setMaxBeforChar(null);
                } else {
                    result.setMaxBeforChar(beforChar);
                }
            }
        }
    }

    private Map<String, Object> getArchiveData(Long staffId, Long cid) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Company companyInfo = (Company)this.companyService.getById(cid);
        if (companyInfo != null) {
            dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.companyInfo.name(), companyInfo.getName());
        } else {
            dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.companyInfo.name(), "");
        }
        StaffDocInfoVo staffVo = this.staffInfoService.getStaffDocInfoVoByStaffId(staffId);
        staffVo.setPhcdiseaserconfirmedlist(this.phcPhysicalCheckCountService.getDiseaserListByQuery(staffId, null));
        for (StaffOccupationAndHarmHistoryVo vo : staffVo.getStaffOccupationAndHarmHistoryVo()) {
            Company company = (Company)this.companyService.getById(vo.getStaffWorkRole().getCid());
            if (company == null) continue;
            vo.setCompanyName(company.getName());
        }
        dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name(), staffVo);
        List workVoList = this.staffInfoService.getStaffCurrentWorkVoByStaffId(staffId);
        dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.workPlaceHarmFactorTestResult.name() + "1", this.getDoc6WorkPlaceTestResult(staffId));
        List harmFactorTestResultHistory = this.phcCheckDataResultService.doc6Table3(staffId);
        dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.harmFactorTestResultHistory.name(), harmFactorTestResultHistory);
        ArrayList reportFiles = new ArrayList();
        harmFactorTestResultHistory.stream().map(s -> s.getReportFiles()).collect(Collectors.toList()).forEach(s -> {
            if (StringUtils.isNotEmpty((String)s)) {
                reportFiles.addAll(Arrays.stream(s.split(",")).filter(s1 -> StringUtils.isNotEmpty((String)s1)).map(s1 -> Long.valueOf(s1)).collect(Collectors.toList()));
            }
        });
        List disReportFiles = reportFiles.stream().distinct().collect(Collectors.toList());
        if (disReportFiles != null && disReportFiles.size() > 0) {
            List sysFileModels = this.sysFileProvideService.getListByIds(disReportFiles);
            dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.harmFactorTestResultHistoryPersonReportFiles.name(), sysFileModels);
        }
        List personalHistoryConclusion = this.phcCheckDataResultService.doc6Table4_1(staffId);
        dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.personalHistoryConclusion.name(), personalHistoryConclusion);
        List testProveBookHistory = this.phcPhysicalCheckCountService.doc6Table4_2(staffId);
        dataMap.put(PersonalHarmFactorArchiveDataMapKeyEnum.testProveBookHistory.name(), testProveBookHistory);
        return dataMap;
    }

    private List<Doc6WorkPlaceHarmFactor> getDoc6WorkPlaceTestResult(Long staffId) {
        ArrayList vos = new ArrayList();
        ArrayList<Doc6WorkPlaceHarmFactor> list = new ArrayList<Doc6WorkPlaceHarmFactor>();
        List localHistories = this.staffWorkRoleService.getLocalStaffWorkRolesByStaffIdOrderByBeginTime(staffId);
        for (StaffWorkRole role : localHistories) {
            if (role.getWorkRoleId() == null) continue;
            Doc6WorkPlaceHarmFactor data = new Doc6WorkPlaceHarmFactor();
            data.setWorkPlace(role.getWorkRoleInfo().getWorkName());
            Object protectiveArticles = "";
            List infos = this.shieldEquipRuleService.getHistoryShieldInfosByWorkId(role.getWorkRoleInfo().getId(), role.getCid(), role.getLeaveTime());
            if (infos != null && !infos.isEmpty()) {
                for (int i = 0; i < infos.size(); ++i) {
                    protectiveArticles = (String)protectiveArticles + ((ShieldWorkRelation)infos.get(i)).getDetailName();
                    if (StringUtils.isNotEmpty((String)((ShieldWorkRelation)infos.get(i)).getShieldDesc())) {
                        protectiveArticles = (String)protectiveArticles + "\u2014" + ((ShieldWorkRelation)infos.get(i)).getShieldDesc();
                    }
                    if (i == infos.size() - 1) continue;
                    protectiveArticles = (String)protectiveArticles + ",";
                }
            }
            data.setProtectiveArticles((String)protectiveArticles);
            if (role.getLeaveTime() == null) {
                role.setLeaveTime(new Date());
            }
            List factorList = new ArrayList();
            factorList = "true".equals(this.isActualize) ? this.harmfactorWorkService.getActualizeArchiveHarmfactorByWork(role.getCid(), role.getWorkRoleId(), role.getLeaveTime()) : this.harmfactorWorkService.getArchiveHarmfactorByWork(role.getCid(), role.getWorkRoleId(), role.getLeaveTime());
            if (factorList != null && factorList.size() > 0) {
                HashMap hcMap = new HashMap();
                HashMap hcHarmSourcesMap = new HashMap();
                for (HarmfactorWorkSource harm : factorList) {
                    if (hcMap.get(harm.getCheckPlanId()) == null) {
                        hcMap.put(harm.getCheckPlanId(), new ArrayList());
                    }
                    if (hcHarmSourcesMap.get(harm.getCheckPlanId()) == null) {
                        hcHarmSourcesMap.put(harm.getCheckPlanId(), new ArrayList());
                    }
                    ((List)hcMap.get(harm.getCheckPlanId())).add(harm.getHarmId());
                    ((List)hcHarmSourcesMap.get(harm.getCheckPlanId())).add(harm.getHazardSource());
                }
                int lineNum = 0;
                ArrayList<Doc6WorkPlaceHarmFactorCheckPlan> checkPlanList = new ArrayList<Doc6WorkPlaceHarmFactorCheckPlan>();
                for (Long key : hcMap.keySet()) {
                    if (key == null) continue;
                    ++lineNum;
                    List harms = (List)hcMap.get(key);
                    List source = (List)hcHarmSourcesMap.get(key);
                    Doc6WorkPlaceHarmFactorCheckPlan plan = new Doc6WorkPlaceHarmFactorCheckPlan();
                    plan.setCheckPlanId(key);
                    CheckPlan check = this.checkPlanService.getDetailById(key);
                    if (check != null) {
                        Long thirdOrgId;
                        plan.setTestOrganization(check.getThirdOrgName());
                        if (check.getThirdOrgName() != null || check.getCheckFrom() == null || !check.getCheckFrom().equals(1) || (thirdOrgId = check.getThirdOrgId()) != null) {
                            // empty if block
                        }
                        if (check.getCheckDateBegin() != null && check.getCheckDateEnd() != null) {
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            plan.setTestTime(check.getCheckDateBegin().format(formatter) + "\u5230" + check.getCheckDateEnd().format(formatter));
                        }
                    }
                    ArrayList<Doc6WorkPlaceHarmFactorResult> resultList = new ArrayList<Doc6WorkPlaceHarmFactorResult>();
                    List harmList = this.checkResultService.queryHarmFactorByCheckAndHarms(key, harms, source);
                    if (harmList != null && harmList.size() > 0) {
                        plan.setLineNum(Integer.valueOf(harmList.size()));
                        for (HarmFactorCheckResultVo vo : harmList) {
                            Doc6WorkPlaceHarmFactorResult result = new Doc6WorkPlaceHarmFactorResult();
                            Long harmId = Long.parseLong(vo.getCheckValue());
                            result.setHarmFactorName(((OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(harmId)).getNameCh());
                            ArrayList<Doc6WorkPlaceHarmFactorValue> values = new ArrayList<Doc6WorkPlaceHarmFactorValue>();
                            List valueList = this.checkResultService.queryHarmFactorByResultNo(vo.getResultNo());
                            for (HarmFactorCheckResultVo value : valueList) {
                                Doc6WorkPlaceHarmFactorValue harmData = new Doc6WorkPlaceHarmFactorValue();
                                if (value.getCheckValueType() == 1) {
                                    harmData.setResult(value.getCheckValue());
                                    if (value.getUnit() != null) {
                                        harmData.setUnit(value.getTargetName() + "(" + value.getUnit() + ")");
                                    } else {
                                        harmData.setUnit(value.getTargetName());
                                    }
                                } else {
                                    String range = ResultUtils.getRange((Integer)value.getCheckValueRangeType(), (String)value.getCheckValueMin(), (String)value.getCheckValueMax());
                                    harmData.setResult(range);
                                    if (value.getUnit() != null) {
                                        harmData.setUnit(value.getTargetName() + "(" + value.getUnit() + ")");
                                    } else {
                                        harmData.setUnit(value.getTargetName());
                                    }
                                }
                                values.add(harmData);
                            }
                            result.setList(values);
                            resultList.add(result);
                        }
                    }
                    plan.setLineNum(Integer.valueOf(resultList.size()));
                    plan.setResultList(resultList);
                    checkPlanList.add(plan);
                }
                data.setLineNum(Integer.valueOf(lineNum));
                data.setCheckPlanList(checkPlanList);
            } else {
                data.setLineNum(Integer.valueOf(0));
            }
            list.add(data);
        }
        return list;
    }
}

