/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.enums.FilesTypeEnum;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganization;
import cn.smarthse.modules.health.entity.base.device.DeviceListView;
import cn.smarthse.modules.health.entity.base.device.DeviceMaintenanceFenceView;
import cn.smarthse.modules.health.entity.base.ms.MsEmergencyPlan;
import cn.smarthse.modules.health.entity.base.ms.MsInfo;
import cn.smarthse.modules.health.entity.base.ms.MsPohop;
import cn.smarthse.modules.health.entity.base.wmbase.WmBaseListView;
import cn.smarthse.modules.health.entity.sys.legal.SysLegal;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckFile;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserConfirmedDetail;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserConfirmedStaff;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckConfiredInfo;
import cn.smarthse.modules.health.entity.work.harmFactorDeclare.HarmFactorDeclare;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckAttachment;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcResultCertificateVo;
import cn.smarthse.modules.health.entity.work.informmanager.vo.ContractInformDocVo;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearExpend;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.scene.SceneInspection;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchase;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchaseFile;
import cn.smarthse.modules.health.entity.work.shield.ShieldSend;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendFile;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecord;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecordDetail;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.base.device.IDeviceListViewService;
import cn.smarthse.modules.health.service.base.device.IDeviceMaintenanceFenceViewService;
import cn.smarthse.modules.health.service.base.ms.IMsEmergencyPlanService;
import cn.smarthse.modules.health.service.base.ms.IMsInfoService;
import cn.smarthse.modules.health.service.base.ms.IMsPohopService;
import cn.smarthse.modules.health.service.base.wmbase.IWmBaseListViewService;
import cn.smarthse.modules.health.service.sys.legal.ISysLegalService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.harmFactorDeclare.IHarmFactorDeclareService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearExpendService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionService;
import cn.smarthse.modules.health.service.work.shield.IShieldPurchaseService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendService;
import cn.smarthse.modules.health.vo.base.company.CompanyArchiveVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OccHealthArchiveService
implements IDocDataService {
    private Logger logger = LoggerFactory.getLogger(OccHealthArchiveService.class);
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ICompanyFunctionalOrganizationService cfOrgService;
    @Autowired
    private ISysLegalService sysLegalService;
    @Autowired
    private IPlanYearDetailService planYearDetailService;
    @Autowired
    private IPlanYearExpendService planYearExpendService;
    @Autowired
    private IHarmFactorDeclareService harmFactorDeclareService;
    @Autowired
    private IMsInfoService msInfoService;
    @Autowired
    private IDeviceListViewService deviceListViewService;
    @Autowired
    private IDeviceMaintenanceFenceViewService deviceMaintenanceService;
    @Autowired
    private IShieldSendService shieldSendService;
    @Autowired
    private IShieldPurchaseService shieldPurchaseService;
    @Autowired
    private IWmBaseListViewService wmBaseListViewService;
    @Autowired
    private IContractInformService contractInfomService;
    @Autowired
    private IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;
    @Autowired
    private IMsEmergencyPlanService msEmergencyPlanService;
    @Autowired
    ISceneInspectionService sceneInspectionService;
    @Autowired
    IMsPohopService msPohopService;
    @Autowired
    IPhcPhysicalCheckCountService phcCheckCountService;
    @DubboReference
    private ISysFileProvideService fileService;
    @Autowired
    private IHcCheckPlanService hcCheckPlanService;
    @Autowired
    OssClientBean ossClienBean;

    public Map<String, Object> getDocData(Long cid, String docParamValue) {
        ShieldSendRecordDetail detail;
        Integer year = Integer.parseInt(docParamValue);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("year", "" + year);
        CompanyArchiveVo company = this.companyService.getCompanyArchiveInfo(cid, year.intValue());
        dataMap.put("company", company);
        ArrayList<SysLegal> sysLegalList = this.sysLegalService.getSysLegalListByCidAndYear(cid, year);
        if (sysLegalList == null || sysLegalList.size() == 0) {
            sysLegalList = new ArrayList<SysLegal>();
            SysLegal sl = new SysLegal();
            sl.setId(Long.valueOf(-1L));
            sysLegalList.add(sl);
        }
        dataMap.put("sysLegalList", sysLegalList);
        CompanyFunctionalOrganization comFunctionalOrg = this.cfOrgService.getFunOrgEHS(cid, year.intValue());
        if (comFunctionalOrg == null) {
            comFunctionalOrg = new CompanyFunctionalOrganization();
            comFunctionalOrg.setId(Long.valueOf(-1L));
        } else {
            List establishFileList = comFunctionalOrg.getEstablishFileList();
            dataMap.put("establishFileList", establishFileList);
        }
        dataMap.put("comFunctionalOrg", comFunctionalOrg);
        List planYearDetailList = this.planYearDetailService.getPlanYearDetailListByCidAndYear(cid, year);
        if (planYearDetailList.size() == 0) {
            PlanYearDetail sl = new PlanYearDetail();
            sl.setId(Long.valueOf(-1L));
            planYearDetailList.add(sl);
        }
        dataMap.put("planYearDetailList", planYearDetailList);
        List msInfoList = this.msInfoService.getMsInfoListByCid(cid, year);
        if (msInfoList.size() == 0) {
            MsInfo sl = new MsInfo();
            sl.setId(Long.valueOf(-1L));
            msInfoList.add(sl);
        } else {
            for (MsInfo msInfo : msInfoList) {
                String infoName = msInfo.getInfoName();
                infoName = infoName.replace("\u201c", "");
                infoName = infoName.replace("\u201d", "");
                infoName = infoName.replace("\u3001", "");
                dataMap.put(infoName, this.parsemsInfoList(msInfo.getFileNames()));
                dataMap.put(infoName + "files", StringUtils.join((Iterable)msInfo.getFileIds(), (String)","));
            }
        }
        dataMap.put("msInfoList", msInfoList);
        List msPohopList = this.msPohopService.getMsPohopListByCid(cid, year);
        if (msPohopList.size() == 0) {
            MsPohop sl = new MsPohop();
            sl.setId(Long.valueOf(-1L));
            msPohopList.add(sl);
        }
        dataMap.put("msPohopList", msPohopList);
        List harmFactorDeclareList = this.harmFactorDeclareService.getHarmFactorDeclareByYear(cid, year);
        if (harmFactorDeclareList.size() == 0) {
            HarmFactorDeclare sl = new HarmFactorDeclare();
            sl.setId(Long.valueOf(-1L));
            harmFactorDeclareList.add(sl);
        } else {
            for (HarmFactorDeclare hd : harmFactorDeclareList) {
                hd.setDeclareFileName(this.parseFileNameByFileIds(hd.getDeclareFile()));
                hd.setFeedbackFileName(this.parseFileNameByFileIds(hd.getFeedbackFile()));
            }
        }
        dataMap.put("harmFactorDeclareList", harmFactorDeclareList);
        List planYearList = this.planYearExpendService.getPlanYearListForDoc2ByCidAndYear(cid, year);
        if (planYearList.size() == 0) {
            PlanYear sl = new PlanYear();
            sl.setId(Long.valueOf(-1L));
            planYearList.add(sl);
            PlanYearExpend sle = new PlanYearExpend();
            sle.setId(Long.valueOf(-1L));
            ArrayList<PlanYearExpend> planYearExpends = new ArrayList<PlanYearExpend>();
            planYearExpends.add(sle);
            sl.setPlanYearExpendList(planYearExpends);
        } else {
            for (PlanYear planYear : planYearList) {
                if (!CommonUtil.listIsEmpty((List)planYear.getPlanYearExpendList())) continue;
                PlanYearExpend sle = new PlanYearExpend();
                sle.setId(Long.valueOf(-1L));
                ArrayList<PlanYearExpend> planYearExpends = new ArrayList<PlanYearExpend>();
                planYearExpends.add(sle);
                planYear.setPlanYearExpendList(planYearExpends);
            }
        }
        dataMap.put("planYearList", planYearList);
        List deviceviewList = this.deviceListViewService.getDeviceList(cid, "" + year);
        if (deviceviewList.size() == 0) {
            DeviceListView sl = new DeviceListView();
            sl.setId(Long.valueOf(-1L));
            deviceviewList.add(sl);
        }
        dataMap.put("deviceviewList", deviceviewList);
        List deviceviewMainanceList = this.deviceMaintenanceService.getListByCid(cid, "" + year);
        if (deviceviewMainanceList.size() == 0) {
            DeviceMaintenanceFenceView sl = new DeviceMaintenanceFenceView();
            sl.setDeviceId(Long.valueOf(-1L));
            deviceviewMainanceList.add(sl);
        }
        dataMap.put("deviceviewMainanceList", deviceviewMainanceList);
        List shieldSendList = this.shieldSendService.doc2Table11(cid, year);
        if (shieldSendList.size() == 0) {
            ShieldSend sl = new ShieldSend();
            sl.setId(Long.valueOf(-1L));
            ArrayList<ShieldSendRecord> records = new ArrayList<ShieldSendRecord>();
            ShieldSendRecordDetail detail2 = new ShieldSendRecordDetail();
            ArrayList<ShieldSendRecordDetail> detailsList = new ArrayList<ShieldSendRecordDetail>();
            detailsList.add(detail2);
            ShieldSendRecord record = new ShieldSendRecord();
            record.setDetails(detailsList);
            records.add(record);
            sl.setRecords(records);
            shieldSendList.add(sl);
        } else {
            for (ShieldSend ss : shieldSendList) {
                List ssr = ss.getRecords();
                if (ssr == null || ssr.size() == 0) {
                    ShieldSendRecordDetail detail3 = new ShieldSendRecordDetail();
                    ArrayList<Object> detailsList = new ArrayList<Object>();
                    detailsList.add(detail3);
                    ShieldSendRecord record = new ShieldSendRecord();
                    record.setDetails(detailsList);
                    ArrayList<ShieldSendRecord> records = new ArrayList<ShieldSendRecord>();
                    records.add(record);
                    ss.setRecords(records);
                    continue;
                }
                for (ShieldSendRecord ssrf : ssr) {
                    List detailsList = ssrf.getDetails();
                    if (detailsList != null && detailsList.size() != 0) continue;
                    detail = new ShieldSendRecordDetail();
                    ArrayList<ShieldSendRecordDetail> detailsList2 = new ArrayList<ShieldSendRecordDetail>();
                    detailsList2.add(detail);
                    ssrf.setDetails(detailsList2);
                }
            }
        }
        dataMap.put("shieldSendList", shieldSendList);
        List shieldPurchaseList = this.shieldPurchaseService.doc2Table12(cid, year);
        if (shieldPurchaseList.size() == 0) {
            ShieldPurchase sl = new ShieldPurchase();
            sl.setId(Long.valueOf(-1L));
            shieldPurchaseList.add(sl);
        }
        dataMap.put("shieldPurchaseList", shieldPurchaseList);
        List wmBaseListViewList = this.wmBaseListViewService.getWmbaseListByCidAndYear(cid, year);
        if (wmBaseListViewList.size() == 0) {
            WmBaseListView sl = new WmBaseListView();
            sl.setId(Long.valueOf(-1L));
            wmBaseListViewList.add(sl);
        }
        dataMap.put("wmBaseListViewList", wmBaseListViewList);
        List contractInfomDocVoList = this.contractInfomService.getContractInformDocVoByCidAndYear("" + year, cid);
        if (contractInfomDocVoList.size() == 0) {
            ContractInformDocVo sl = new ContractInformDocVo();
            sl.setWorkId(Long.valueOf(-1L));
            contractInfomDocVoList.add(sl);
        }
        dataMap.put("contractInfomDocVoList", contractInfomDocVoList);
        ArrayList<PhcPhysicalCheckConfiredInfo> phcCheckConfiredInfoList = this.phcPhysicalCheckDataResultService.getConfirmedCheckList(cid, year);
        if (phcCheckConfiredInfoList.size() == 0) {
            phcCheckConfiredInfoList = new ArrayList<PhcPhysicalCheckConfiredInfo>();
            PhcPhysicalCheckConfiredInfo sl = new PhcPhysicalCheckConfiredInfo();
            sl.setCheckId(Long.valueOf(-1L));
            phcCheckConfiredInfoList.add(sl);
        }
        dataMap.put("phcCheckConfiredInfoList", phcCheckConfiredInfoList);
        List phcDisConfirmedStaffList = this.phcCheckCountService.getConfirmedListByQuery(cid, year);
        if (phcDisConfirmedStaffList.size() == 0) {
            PhcDiseaserConfirmedStaff sl = new PhcDiseaserConfirmedStaff();
            detail = new PhcDiseaserConfirmedDetail();
            detail.setStaffId(Long.valueOf(-1L));
            sl.getDetails().add(detail);
            phcDisConfirmedStaffList.add(sl);
        }
        dataMap.put("phcDisConfirmedStaffList", phcDisConfirmedStaffList);
        List hcResultCertificateVoList = this.hcCheckPlanService.getHcResultCertificateVosByYearNew(cid, "" + year);
        if (hcResultCertificateVoList.size() == 0) {
            HcResultCertificateVo sl = new HcResultCertificateVo();
            sl.setCheckTypeName("-1");
            hcResultCertificateVoList.add(sl);
        }
        dataMap.put("hcResultCertificateVoList", hcResultCertificateVoList);
        List msEmergencyPlanList = this.msEmergencyPlanService.getMsEmergencyPlanListByCid(cid, year);
        if (msEmergencyPlanList.size() == 0) {
            MsEmergencyPlan sl = new MsEmergencyPlan();
            sl.setId(Long.valueOf(-1L));
            msEmergencyPlanList.add(sl);
        }
        dataMap.put("msEmergencyPlanList", msEmergencyPlanList);
        List sceneInspectionList = this.sceneInspectionService.getListCompanyInspection(cid, year.intValue());
        if (sceneInspectionList.size() == 0) {
            SceneInspection sl = new SceneInspection();
            sl.setId(Long.valueOf(-1L));
            sceneInspectionList.add(sl);
        }
        dataMap.put("sceneInspectionList", sceneInspectionList);
        List sceneInspectionList2 = this.sceneInspectionService.getSupperInspectionInfo(cid, year.intValue());
        if (sceneInspectionList2.size() == 0) {
            SceneInspection sl = new SceneInspection();
            sl.setId(Long.valueOf(-1L));
            sceneInspectionList2.add(sl);
        } else {
            for (SceneInspection si : sceneInspectionList2) {
                String supervisoryOpinionFiles = si.getSupervisoryOpinionFiles();
                supervisoryOpinionFiles = this.parseFileNameByFileIds(supervisoryOpinionFiles);
                si.setSupervisoryOpinionFilesName(supervisoryOpinionFiles);
            }
        }
        dataMap.put("sceneInspectionList2", sceneInspectionList2);
        return dataMap;
    }

    public String parsemsInfoList(List<String> msInfoUploadFile) {
        if (msInfoUploadFile == null || msInfoUploadFile.size() == 0) {
            return "\u7a7a\u767d";
        }
        StringBuffer sb = new StringBuffer();
        for (String msif : msInfoUploadFile) {
            if (StringUtils.isNotEmpty((CharSequence)sb.toString())) {
                sb.append(",");
            }
            sb.append(msif);
        }
        return sb.toString();
    }

    public Map<String, Object> getCheckData(Long cid, String docParamValue) {
        List sceneInspectionList2;
        List sceneInspectionList;
        List msEmergencyPlanList;
        List contractInfomDocVoList;
        List wmBaseListView;
        List shieldPurchaseList;
        List shieldSendList;
        List deviceviewMainanceList;
        List deviceviewList;
        List planYearExpendList;
        List harmFactorDeclareList;
        List msPohopList;
        List msInfoList;
        Integer year = Integer.parseInt(docParamValue);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("34-108", 1);
        dataMap.put("34-109", 1);
        dataMap.put("34-110.1", 1);
        dataMap.put("34-110.2", 1);
        dataMap.put("34-110.3", 1);
        dataMap.put("34-110.4", 1);
        dataMap.put("34-110.5", 1);
        dataMap.put("34-110.6", 1);
        dataMap.put("34-110.7", 1);
        dataMap.put("34-110.8", 1);
        dataMap.put("34-110.9", 1);
        dataMap.put("34-110.10", 1);
        dataMap.put("34-110.11", 1);
        dataMap.put("34-110.12", 1);
        dataMap.put("34-111", 1);
        dataMap.put("34-112", 1);
        dataMap.put("34-113", 1);
        dataMap.put("34-114", 1);
        dataMap.put("34-115", 1);
        dataMap.put("34-116.1", 1);
        dataMap.put("34-116.2", 1);
        dataMap.put("34-117.1", 1);
        dataMap.put("34-117.2", 1);
        dataMap.put("34-118", 1);
        dataMap.put("34-119", 1);
        dataMap.put("34-120", 1);
        CompanyFunctionalOrganization comFunctionalOrg = this.cfOrgService.getFunOrgEHS(cid, year.intValue());
        if (comFunctionalOrg == null) {
            dataMap.put("34-108", 0);
        } else {
            List establishFileList = comFunctionalOrg.getEstablishFileList();
            if (establishFileList == null || establishFileList.size() == 0) {
                dataMap.put("34-108", 0);
            }
        }
        List planYearDetailList = this.planYearDetailService.getPlanYearDetailListByCidAndYear(cid, year);
        if (planYearDetailList == null || planYearDetailList.size() == 0) {
            dataMap.put("34-109", 0);
        }
        if ((msInfoList = this.msInfoService.getMsInfoListByCid(cid, year)) != null && msInfoList.size() > 0) {
            for (MsInfo msInfo : msInfoList) {
                if ("\u804c\u4e1a\u75c5\u5371\u5bb3\u9632\u6cbb\u8d23\u4efb\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.1", 0);
                    continue;
                }
                if ("\u804c\u4e1a\u75c5\u5371\u5bb3\u8b66\u793a\u4e0e\u544a\u77e5\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.2", 0);
                    continue;
                }
                if ("\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.3", 0);
                    continue;
                }
                if ("\u804c\u4e1a\u75c5\u9632\u6cbb\u5ba3\u4f20\u6559\u80b2\u57f9\u8bad\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.4", 0);
                    continue;
                }
                if ("\u804c\u4e1a\u75c5\u9632\u62a4\u8bbe\u65bd\u7ef4\u62a4\u68c0\u4fee\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.5", 0);
                    continue;
                }
                if ("\u804c\u4e1a\u75c5\u9632\u62a4\u7528\u54c1\u7ba1\u7406\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.6", 0);
                    continue;
                }
                if ("\u804c\u4e1a\u75c5\u5371\u5bb3\u76d1\u6d4b\u53ca\u8bc4\u4ef7\u7ba1\u7406\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.7", 0);
                    continue;
                }
                if ("\u5efa\u8bbe\u9879\u76ee\u804c\u4e1a\u536b\u751f\u201c\u4e09\u540c\u65f6\u201d\u7ba1\u7406\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.8", 0);
                    continue;
                }
                if ("\u52b3\u52a8\u8005\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u53ca\u5176\u6863\u6848\u7ba1\u7406\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.9", 0);
                    continue;
                }
                if ("\u804c\u4e1a\u75c5\u5371\u5bb3\u4e8b\u6545\u5904\u7f6e\u4e0e\u62a5\u544a\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.10", 0);
                    continue;
                }
                if ("\u804c\u4e1a\u75c5\u5371\u5bb3\u5e94\u6025\u6551\u63f4\u4e0e\u7ba1\u7406\u5236\u5ea6".equals(msInfo.getInfoName())) {
                    if (msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                    dataMap.put("34-110.11", 0);
                    continue;
                }
                if (!"\u6cd5\u5f8b\u3001\u6cd5\u89c4\u3001\u89c4\u7ae0\u89c4\u5b9a\u7684\u5176\u4ed6\u804c\u4e1a\u75c5\u9632\u6cbb\u5236\u5ea6".equals(msInfo.getInfoName()) || msInfo.getFileIds() != null && msInfo.getFileIds().size() != 0) continue;
                dataMap.put("34-110.12", 0);
            }
        }
        if ((msPohopList = this.msPohopService.getMsPohopListByCid(cid, year)) == null || msPohopList.size() == 0) {
            dataMap.put("34-111", 0);
        }
        if ((harmFactorDeclareList = this.harmFactorDeclareService.getHarmFactorDeclareByYear(cid, year)) == null || harmFactorDeclareList.size() == 0) {
            dataMap.put("34-112", 0);
        }
        if ((planYearExpendList = this.planYearExpendService.getPlanYearExpendListByCidAndYear(cid, year)) == null || planYearExpendList.size() == 0) {
            dataMap.put("34-113", 0);
        }
        if ((deviceviewList = this.deviceListViewService.getDeviceList(cid, "" + year)) == null || deviceviewList.size() == 0) {
            dataMap.put("34-114", 0);
        }
        if ((deviceviewMainanceList = this.deviceMaintenanceService.getListByCid(cid, "" + year)) == null || deviceviewMainanceList.size() == 0) {
            dataMap.put("34-115", 0);
        }
        if ((shieldSendList = this.shieldSendService.doc2Table11(cid, year)) == null || shieldSendList.size() == 0) {
            dataMap.put("34-116.1", 0);
        }
        if ((shieldPurchaseList = this.shieldPurchaseService.doc2Table12(cid, year)) == null || shieldPurchaseList.size() == 0) {
            dataMap.put("34-116.2", 0);
        }
        if ((wmBaseListView = this.wmBaseListViewService.getWmbaseListByCid(cid)) == null || wmBaseListView.size() == 0) {
            dataMap.put("34-117.1", 0);
        }
        if ((contractInfomDocVoList = this.contractInfomService.getContractInformDocVoByCidAndYear("" + year, cid)) == null || contractInfomDocVoList.size() == 0) {
            dataMap.put("34-117.2", 0);
        }
        if ((msEmergencyPlanList = this.msEmergencyPlanService.getMsEmergencyPlanListByCid(cid, year)) == null || msEmergencyPlanList.size() == 0) {
            dataMap.put("34-118", 0);
        }
        if ((sceneInspectionList = this.sceneInspectionService.getListCompanyInspection(cid, year.intValue())) == null || sceneInspectionList.size() == 0) {
            dataMap.put("34-119", 0);
        }
        if ((sceneInspectionList2 = this.sceneInspectionService.getSupperInspectionInfo(cid, year.intValue())) == null || sceneInspectionList2.size() == 0) {
            dataMap.put("34-120", 0);
        }
        return dataMap;
    }

    public Map<String, Object> generatorArchive(String archiveTargetDir, String docNo, Long cid, String docParamValue) {
        List hcResultCertificateVoList;
        List phcDisConfirmedStaffList;
        List shieldPurchaseList;
        Map<String, Object> dataMap = this.getDocData(cid, docParamValue);
        String targetFileNameFormat = FilesTypeEnum.zwgl.getTargetFilenameFormat();
        String[] targetDirs = FilesTypeEnum.zwgl.getDirs();
        String destFileDir = String.format("\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u6863\u6848\uff08%s\uff09", docNo);
        String destFileName = String.format(targetFileNameFormat, docNo);
        String destFilePath = archiveTargetDir + "/" + destFileDir + "/";
        dataMap.put("archive_doc__filename", destFileDir);
        dataMap.put("docNo", docNo);
        this.downLoadFile(dataMap.get("establishFileList"), destFilePath + "2 \u804c\u4e1a\u75c5\u9632\u6cbb\u9886\u5bfc\u673a\u6784\u53ca\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u673a\u6784\u6210\u7acb\u6587\u4ef6/");
        List harmFactorDeclareList = (List)dataMap.get("harmFactorDeclareList");
        String folder5 = "5 \u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u8868\u53ca\u56de\u6267";
        this.downLoadFile(this.getFiles(""), destFilePath + folder5 + "/");
        if (harmFactorDeclareList != null && harmFactorDeclareList.size() > 0) {
            for (HarmFactorDeclare hfD : harmFactorDeclareList) {
                String workName = hfD.getWorkName();
                this.downLoadFile(this.getFiles(hfD.getDeclareFile()), destFilePath + folder5 + "/" + workName + "/");
                Date declareDate = hfD.getDeclareDate();
                String sdeclareDate = DateUtils.format((Date)declareDate, (String)"yyyyMMdd");
                String declareDatePath = sdeclareDate + " " + workName;
                this.downLoadFile(this.getFiles(hfD.getFeedbackFile()), destFilePath + folder5 + "/" + declareDatePath + "/");
            }
        }
        List deviceviewMainanceList = (List)dataMap.get("deviceviewMainanceList");
        String folder8 = "8 \u804c\u4e1a\u75c5\u9632\u62a4\u8bbe\u65bd\u7ef4\u62a4\u548c\u68c0\u4fee\u8bb0\u5f55";
        if (deviceviewMainanceList != null && deviceviewMainanceList.size() > 0) {
            HashSet<String> fileidsSet = new HashSet<String>();
            for (Object deviceMaintenancef : deviceviewMainanceList) {
                String fileids = deviceMaintenancef.getFileIds();
                if (fileidsSet.contains(fileids)) continue;
                fileidsSet.add(fileids);
                Date mainteTime = deviceMaintenancef.getMainteTime();
                String workName = deviceMaintenancef.getMainteReason();
                String smainteTime = DateUtils.format((Date)mainteTime, (String)"yyyyMMdd");
                String maintePath = smainteTime + " " + workName;
                this.downLoadFile(this.getFiles(fileids), destFilePath + folder8 + "/" + (String)maintePath + "/");
            }
        }
        List shieldSendList = (List)dataMap.get("shieldSendList");
        String folder9 = "9 \u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u7684\u8d2d\u4e70\u3001\u53d1\u653e\u4f7f\u7528\u8bb0\u5f55";
        this.downLoadFile(this.getFiles(""), destFilePath + folder9 + "/");
        if (shieldSendList != null && shieldSendList.size() > 0) {
            for (Object ssd : shieldSendList) {
                Date sendTime = ssd.getSendTime();
                String ssendTime = DateUtils.format((Date)sendTime, (String)"yyyyMMdd") + ssd.getWorkName();
                List ssfList = ssd.getFiles1();
                if (ssfList == null || ssfList.size() <= 0) continue;
                for (ShieldSendFile ssf : ssfList) {
                    this.downLoadFile(this.getFiles("" + ssf.getFileId()), destFilePath + folder9 + "/\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u53d1\u653e\u8bb0\u5f55/" + ssendTime + "/");
                }
            }
        }
        if ((shieldPurchaseList = (List)dataMap.get("shieldPurchaseList")) != null && shieldPurchaseList.size() > 0) {
            for (ShieldPurchase sp : shieldPurchaseList) {
                List spFileList3;
                List spFileList2;
                Date buyDate = sp.getBuyDate();
                String ssendTime = DateUtils.format((Date)buyDate, (String)"yyyyMMdd");
                String workName = sp.getBuyName();
                String sdPath = ssendTime + " " + workName;
                List spFileList = sp.getFiles1();
                if (spFileList != null && spFileList.size() > 0) {
                    for (ShieldPurchaseFile spFile : spFileList) {
                        this.downLoadFile(this.getFiles("" + spFile.getFileId()), destFilePath + folder9 + "/\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u91c7\u8d2d\u8bb0\u5f55/" + sdPath + "/");
                    }
                }
                if ((spFileList2 = sp.getFiles2()) != null && spFileList2.size() > 0) {
                    ShieldPurchaseFile spFile;
                    spFile = spFileList2.iterator();
                    while (spFile.hasNext()) {
                        ShieldPurchaseFile spFile2 = (ShieldPurchaseFile)spFile.next();
                        this.downLoadFile(this.getFiles("" + spFile2.getFileId()), destFilePath + folder9 + "/\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u91c7\u8d2d\u8bb0\u5f55/" + sdPath + "/");
                    }
                }
                if ((spFileList3 = sp.getFiles3()) == null || spFileList3.size() <= 0) continue;
                for (ShieldPurchaseFile spFile : spFileList3) {
                    this.downLoadFile(this.getFiles("" + spFile.getFileId()), destFilePath + folder9 + "/\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u91c7\u8d2d\u8bb0\u5f55/" + sdPath + "/");
                }
            }
        }
        List contractInfomDocVoList = (List)dataMap.get("contractInfomDocVoList");
        String folder10 = "10 \u8b66\u793a\u6807\u8bc6\u4e0e\u804c\u4e1a\u75c5\u5371\u5bb3\u544a\u77e5";
        if (contractInfomDocVoList != null && contractInfomDocVoList.size() > 0) {
            for (Object cinfoDoc : contractInfomDocVoList) {
                ArrayList<SysFileModel> sfList = new ArrayList<SysFileModel>();
                SysFileModel sf = cinfoDoc.getAttachment();
                sfList.add(sf);
                String name = cinfoDoc.getRealName();
                String workName = cinfoDoc.getWorkName();
                Iterator sdPath = name + " " + workName;
                this.downLoadFile(sfList, destFilePath + folder10 + "/\u5408\u540c\u544a\u77e5\u6e05\u5355/" + (String)((Object)sdPath) + "/");
            }
        }
        List phcCheckConfiredInfoList = (List)dataMap.get("phcCheckConfiredInfoList");
        this.downLoadFile(this.getFiles(""), destFilePath + folder10 + "/");
        if (phcCheckConfiredInfoList != null && phcCheckConfiredInfoList.size() > 0) {
            for (Object phcCheckInfo : phcCheckConfiredInfoList) {
                String workName = phcCheckInfo.getCheckName();
                String sdPath = phcCheckInfo.getCheckDate() + " " + workName;
                List files = phcCheckInfo.getFiles();
                if (files == null || files.size() <= 0) continue;
                for (PhcPhysicalCheckFile file : files) {
                    this.downLoadFile(this.getFiles("" + file.getFileId()), destFilePath + folder10 + "/\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u7ed3\u679c\u544a\u77e5\u6e05\u5355/" + sdPath + "/");
                }
            }
        }
        if ((phcDisConfirmedStaffList = (List)dataMap.get("phcDisConfirmedStaffList")) != null && phcDisConfirmedStaffList.size() > 0) {
            for (Object phcConfirmStaff : phcDisConfirmedStaffList) {
                String staffName = phcConfirmStaff.getStaffName();
                List details = phcConfirmStaff.getDetails();
                if (details == null || details.size() <= 0) continue;
                for (PhcDiseaserConfirmedDetail detail : details) {
                    String workName = detail.getStaffWorkName();
                    String sdPath = staffName + workName;
                    this.downLoadFile(detail.getCredenceFiles(), destFilePath + folder10 + "/\u804c\u4e1a\u75c5\u8bca\u65ad\u7ed3\u679c\u544a\u77e5\u6e05\u5355/" + (String)sdPath + "/");
                }
            }
        }
        if ((hcResultCertificateVoList = (List)dataMap.get("hcResultCertificateVoList")) != null && hcResultCertificateVoList.size() > 0) {
            for (HcResultCertificateVo hcrcVo : hcResultCertificateVoList) {
                String checkTime = hcrcVo.getCheckTime();
                String workName = hcrcVo.getCheckWorkName();
                String sdPath = (String)checkTime + workName;
                List hcCheckAttachList = hcrcVo.getAttachments();
                if (hcCheckAttachList == null || hcCheckAttachList.size() <= 0) continue;
                for (HcCheckAttachment hcCheckAttach : hcCheckAttachList) {
                    this.downLoadFile(this.getFiles("" + hcCheckAttach.getFileId()), destFilePath + folder10 + "/\u4f5c\u4e1a\u573a\u6240\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u8bc4\u4ef7\u7ed3\u679c\u544a\u77e5\u6e05\u5355/" + sdPath + "/");
                }
            }
        }
        List sceneInspectionList = (List)dataMap.get("sceneInspectionList");
        String folder12 = "12 \u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u536b\u751f\u68c0\u67e5\u548c\u5904\u7406\u8bb0\u5f55";
        this.downLoadFile(this.getFiles(""), destFilePath + folder12 + "/");
        if (sceneInspectionList != null && sceneInspectionList.size() > 0) {
            for (SceneInspection sit : sceneInspectionList) {
                Date checkTime = sit.getInspectionActualTime();
                String scheckTime = DateUtils.format((Date)checkTime, (String)"yyyyMMdd");
                String workName = sit.getWorkName();
                String sdPath = scheckTime + " " + workName;
                if (!StringUtils.isNotBlank((CharSequence)workName) || !StringUtils.isNotBlank((CharSequence)scheckTime)) continue;
                String fname = "\u804c\u4e1a\u536b\u751f\u68c0\u67e5\u548c\u5904\u7406\u8bb0\u5f55\u8868\uff08" + sdPath + "\uff09.doc";
                if (sit.getReformList() == null || sit.getReformList().size() == 0) {
                    ArrayList<ReformItemBasic> reformList = new ArrayList<ReformItemBasic>();
                    ReformItemBasic rb = new ReformItemBasic();
                    rb.setId(Long.valueOf(-1L));
                    rb.setFinishInfo("");
                    reformList.add(rb);
                    sit.setReformList(reformList);
                }
                HashMap<String, Object> sitMap = new HashMap<String, Object>();
                sitMap.put("sit", sit);
                this.handleHtml(sitMap);
                Java2WordGeneratorTemp.createDoc(sitMap, (String)"doc2zwgl/12-1.ftl", (String)(destFilePath + "12 \u7528\u4eba\u5355\u4f4d\u804c\u4e1a\u536b\u751f\u68c0\u67e5\u548c\u5904\u7406\u8bb0\u5f55/" + fname));
                String ofnames = this.parseFileNameByFileIds(sit.getOtherFiles());
                sit.setOtherFiles(fname + "\u3001" + (ofnames == null ? "" : ofnames));
            }
        }
        List sceneInspectionList2 = (List)dataMap.get("sceneInspectionList2");
        String folder13 = "13 \u804c\u4e1a\u536b\u751f\u76d1\u7ba1\u610f\u89c1\u548c\u843d\u5b9e\u60c5\u51b5\u8d44\u6599";
        this.downLoadFile(this.getFiles(""), destFilePath + folder13 + "/");
        if (sceneInspectionList2 != null && sceneInspectionList2.size() > 0) {
            for (SceneInspection sit : sceneInspectionList2) {
                Date checkTime = sit.getInspectionActualTime();
                String scheckTime = DateUtils.format((Date)checkTime, (String)"yyyyMMdd");
                String workName = sit.getWorkName();
                if (!StringUtils.isNotBlank((CharSequence)workName) || !StringUtils.isNotBlank((CharSequence)scheckTime)) continue;
                String sdPath = scheckTime + " " + workName;
                this.downLoadFile(this.getFiles(sit.getSupervisoryOpinionFiles()), destFilePath + folder13 + "/" + sdPath + "/\u804c\u4e1a\u536b\u751f\u76d1\u7ba1\u610f\u89c1\u8d44\u6599/");
                if (sit.getReformList() == null || sit.getReformList().isEmpty()) {
                    ArrayList<ReformItemBasic> ribList = new ArrayList<ReformItemBasic>();
                    ReformItemBasic rib = new ReformItemBasic();
                    rib.setId(Long.valueOf(-1L));
                    rib.setFinishInfo("");
                    ribList.add(rib);
                    sit.setReformList(ribList);
                }
                HashMap<String, Object> sitMap = new HashMap<String, Object>();
                sitMap.put("sit", sit);
                String fname = "\u804c\u4e1a\u536b\u751f\u76d1\u7ba1\u610f\u89c1\u548c\u843d\u5b9e\u60c5\u51b5\u8bb0\u5f55\u8868(" + sdPath + ").doc";
                this.handleHtml(sitMap);
                Java2WordGeneratorTemp.createDoc(sitMap, (String)"doc2zwgl/13-1.ftl", (String)(destFilePath + folder13 + "/" + sdPath + "/" + fname));
                sit.setSupervisoryOpinionFilesName(fname + "\u3001" + (sit.getSupervisoryOpinionFilesName() == null ? "" : sit.getSupervisoryOpinionFilesName()));
            }
        }
        this.handleHtml(dataMap);
        Java2WordGeneratorTemp.createDoc(dataMap, (String)"doc2zwgl/zwgl.ftl", (String)(destFilePath + destFileName));
        return dataMap;
    }

    public List<SysFileModel> getFiles(String files) {
        String[] filess;
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{files}) && (filess = StringUtils.split((String)files, (String)",")) != null && filess.length > 0) {
            ArrayList<SysFileModel> sfList = new ArrayList<SysFileModel>();
            for (String file : filess) {
                if (!StringUtils.isNumeric((CharSequence)file)) continue;
                Long f = Long.parseLong(file);
                SysFileModel sf = this.fileService.getFileById(f);
                sfList.add(sf);
            }
            return sfList;
        }
        return null;
    }

    public void downLoadFile(Object fileObject, String destFilePath) {
        File fileParent = new File(destFilePath);
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        if (fileObject == null) {
            return;
        }
        List sysFileList = (List)fileObject;
        this.downLoadFile(sysFileList, destFilePath);
    }

    public void downLoadFile(List<SysFileModel> sysFileList, String destFilePath) {
        try {
            File fileParent = new File(destFilePath);
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            if (sysFileList != null && sysFileList.size() > 0) {
                for (SysFileModel sf : sysFileList) {
                    if (sf == null || !StringUtils.isNotEmpty((CharSequence)sf.getOssUrl())) continue;
                    this.ossClienBean.downloadFile(sf.getOssUrl(), destFilePath, sf.getFileName());
                }
            }
        }
        catch (IOException e) {
            throw new HealthException("IO\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public Class getClassInList(List list) {
        if (list != null && list.size() > 0) {
            Object o = list.get(0);
            return o.getClass();
        }
        return null;
    }

    public String parseFileNameByFileIds(String fileIds) {
        List sfList;
        if (StringUtils.isNotEmpty((CharSequence)fileIds) && (sfList = this.fileService.getListByIds(fileIds)) != null && sfList.size() > 0) {
            StringBuffer sb = new StringBuffer("");
            for (SysFileModel sf : sfList) {
                if (StringUtils.isNotEmpty((CharSequence)sb.toString())) {
                    sb.append(", ");
                }
                if (sf == null) continue;
                sb.append(sf.getFileName());
            }
            return sb.toString();
        }
        return "";
    }

    public void handleHtml(Map<String, Object> dataMap) {
        if (dataMap != null) {
            Set<String> strs = dataMap.keySet();
            for (String key : strs) {
                Object entry = dataMap.get(key);
                if (entry == null) continue;
                if (entry instanceof List) {
                    List entryList = (List)entry;
                    String entryJson = JSONArray.toJSONString((Object)entry);
                    entryJson = StringEscapeUtils.unescapeHtml((String)entryJson);
                    try {
                        Class c = this.getClassInList(entryList);
                        if (c == null) continue;
                        List entry2 = JSONArray.parseArray((String)entryJson, (Class)c);
                        dataMap.put(key, entry2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String entryJson = JSON.toJSONString((Object)entry);
                entryJson = StringEscapeUtils.unescapeHtml((String)entryJson);
                Object entry2 = JSON.parseObject((String)entryJson, entry.getClass());
                dataMap.put(key, entry2);
            }
        }
    }
}

