/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.archive.LiteArchiveLastdateCollectorMapper;
import cn.smarthse.modules.health.entity.archive.LiteArchiveLastdateCollector;
import cn.smarthse.modules.health.model.litearchive.AddLiteArchiveModel;
import cn.smarthse.modules.health.model.litearchive.LiteArchiveLastdateCollectorModel;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.service.archive.ILiteArchiveLastdateCollectorService;
import com.xxl.job.core.context.XxlJobHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class LiteArchiveLastdateCollectorServiceImpl
extends BaseServiceImpl<LiteArchiveLastdateCollectorMapper, LiteArchiveLastdateCollector>
implements ILiteArchiveLastdateCollectorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteArchiveLastdateCollectorServiceImpl.class);
    @Autowired
    @Lazy
    private ILiteArchiveLastdateCollectorService self;
    @DubboReference
    private INewComplianceCompanyInfoService compliance;

    @Transactional(readOnly=false)
    public void resetliteArchiveLastdateCollector() {
        ((LiteArchiveLastdateCollectorMapper)this.dao).deleteByExample(null);
        List<LiteArchiveLastdateCollector> liteArchiveLastdateCollectors = ((LiteArchiveLastdateCollectorMapper)this.dao).selectCompanyList();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectors)) {
            liteArchiveLastdateCollectors.forEach(cl -> cl.setId(Long.valueOf(this.idworker.nextId())));
            ListUtil.partition(liteArchiveLastdateCollectors, (int)1000).forEach(clist -> ((LiteArchiveLastdateCollectorMapper)this.dao).insertList2((List)clist));
        }
    }

    @Transactional(readOnly=false)
    public void updateLiteArchiveLastdateCollector(List<LiteArchiveLastdateCollector> liteArchiveLastdateCollectors) {
        if (CollectionUtils.isEmpty(liteArchiveLastdateCollectors)) {
            return;
        }
        this.self.batchUpdateOrInsert(liteArchiveLastdateCollectors, LiteArchiveLastdateCollectorMapper.class, (liteArchiveLastdateCollector, liteArchiveLastdateCollectorMapper) -> {
            Example example = new Example(LiteArchiveLastdateCollector.class);
            example.createCriteria().andEqualTo("cid", (Object)liteArchiveLastdateCollector.getCid());
            liteArchiveLastdateCollectorMapper.updateByExampleSelective(liteArchiveLastdateCollector, example);
            return 1;
        });
    }

    @Transactional(readOnly=false)
    public void processArchive201() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive201();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL201(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive201, \u66f4\u65b0\u6570\u636e\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchive202() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive202();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL202(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive202, \u66f4\u65b0\u6570\u636e\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchive204() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive204();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL204(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive204 , \u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchive206() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive206();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL206(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive206 , \u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchive210() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive210();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL210(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive210 , \u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchive211() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive211();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL211(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive211 , \u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchive216() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive216();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL216(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive216 , \u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchive302() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive302();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL302(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive302 , \u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchive303() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive303();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL303(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive303 , \u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchive404() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchive404();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setL404(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            XxlJobHelper.log((String)"processArchive404 , \u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object[])new Object[]{collectors.size()});
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processComplianceUpdate() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectComplianceUpdate();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setComplianceUpdate(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    @Transactional(readOnly=false)
    public void processArchiveLastDate() {
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchiveLastDate();
        if (CollectionUtils.isNotEmpty(liteArchiveLastdateCollectorModels)) {
            List collectors = liteArchiveLastdateCollectorModels.stream().map(m -> {
                LiteArchiveLastdateCollector liteArchiveLastdateCollector = new LiteArchiveLastdateCollector();
                liteArchiveLastdateCollector.setCid(m.getCid());
                liteArchiveLastdateCollector.setArchiveLastUpdate(m.getLastUpdateDate());
                return liteArchiveLastdateCollector;
            }).collect(Collectors.toList());
            this.self.updateLiteArchiveLastdateCollector(collectors);
        }
    }

    private int compareDate(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return -1;
        }
        return DateUtil.compare((Date)date1, (Date)date2);
    }

    private Date getArchiveUpdateDate(Map<Long, Map<Integer, Map<String, List<LiteArchiveLastdateCollectorModel>>>> cidTypeTitleMap, Long cid, Integer archiveType, String title) {
        Map<Integer, Map<String, List<LiteArchiveLastdateCollectorModel>>> integerMapMap = cidTypeTitleMap.get(cid);
        if (integerMapMap == null) {
            return null;
        }
        Map<String, List<LiteArchiveLastdateCollectorModel>> stringListMap = integerMapMap.get(archiveType);
        if (stringListMap == null) {
            return null;
        }
        List<LiteArchiveLastdateCollectorModel> liteArchiveLastdateCollectorModels = stringListMap.get(title);
        if (CollectionUtils.isEmpty(liteArchiveLastdateCollectorModels)) {
            return null;
        }
        return DateUtil.beginOfDay((Date)liteArchiveLastdateCollectorModels.get(0).getLastUpdateDate());
    }

    @Transactional(readOnly=false)
    public void processRefreshArchive() {
        List collectors = ((LiteArchiveLastdateCollectorMapper)this.dao).selectByExample(null);
        if (CollectionUtils.isEmpty((Collection)collectors)) {
            return;
        }
        ((LiteArchiveLastdateCollectorMapper)this.dao).deleteRefreshCollector();
        List<LiteArchiveLastdateCollectorModel> archiveUpadteCollectors = ((LiteArchiveLastdateCollectorMapper)this.dao).selectArchiveLastDate();
        HashMap<Long, Map<Integer, Map<String, List<LiteArchiveLastdateCollectorModel>>>> cidTypeTitleMap = new HashMap();
        if (CollectionUtils.isNotEmpty(archiveUpadteCollectors)) {
            cidTypeTitleMap = archiveUpadteCollectors.stream().filter(f -> f.getCid() != null).collect(Collectors.groupingBy(LiteArchiveLastdateCollectorModel::getCid, Collectors.groupingBy(LiteArchiveLastdateCollectorModel::getArchiveType, Collectors.groupingBy(LiteArchiveLastdateCollectorModel::getTitle))));
        }
        ArrayList<LiteArchiveLastdateCollectorModel> models = new ArrayList<LiteArchiveLastdateCollectorModel>();
        List<String> titles = Arrays.asList(String.valueOf(DateUtils.getThisYear() - 2), String.valueOf(DateUtils.getThisYear() - 1), String.valueOf(DateUtils.getYear()));
        for (LiteArchiveLastdateCollector collector : collectors) {
            Long cid = collector.getCid();
            Date complianceUpdate = collector.getComplianceUpdate();
            Integer isCompliance = collector.getIsCompliance();
            Date l201 = collector.getL201();
            Date l202 = collector.getL202();
            Date l204 = collector.getL204();
            Date l206 = collector.getL206();
            Date l210 = collector.getL210();
            Date l211 = collector.getL211();
            Date l216 = collector.getL216();
            Date l302 = collector.getL302();
            Date l303 = collector.getL303();
            Date l404 = collector.getL404();
            for (String title : titles) {
                LiteArchiveLastdateCollectorModel refresh;
                LiteArchiveLastdateCollectorModel refresh2;
                Date maxDate;
                Date archive2LastUpdate = this.getArchiveUpdateDate(cidTypeTitleMap, cid, 2, title);
                Date archive3LastUpdate = this.getArchiveUpdateDate(cidTypeTitleMap, cid, 3, title);
                Date archive4LastUpdate = this.getArchiveUpdateDate(cidTypeTitleMap, cid, 4, title);
                if (Objects.equals(isCompliance, 1)) {
                    if (this.compareDate(l202, archive2LastUpdate) > 0 || this.compareDate(l204, archive2LastUpdate) > 0 || this.compareDate(l206, archive2LastUpdate) > 0 || this.compareDate(l210, archive2LastUpdate) > 0 || this.compareDate(l211, archive2LastUpdate) > 0 || this.compareDate(l216, archive2LastUpdate) > 0) {
                        maxDate = DateUtils.getMaxDate((Date[])new Date[]{l202, l204, l206, l210, l211, l216});
                        refresh2 = new LiteArchiveLastdateCollectorModel();
                        refresh2.setId(Long.valueOf(this.idworker.nextId()));
                        refresh2.setCid(cid);
                        refresh2.setArchiveType(Integer.valueOf(2));
                        refresh2.setTitle(title);
                        refresh2.setArchiveLastUpdateDate(archive2LastUpdate);
                        refresh2.setLastUpdateDate(maxDate);
                        models.add(refresh2);
                    }
                    if (this.compareDate(l302, archive3LastUpdate) > 0 || this.compareDate(l303, archive3LastUpdate) > 0) {
                        maxDate = DateUtils.getMaxDate((Date[])new Date[]{l302, l303});
                        refresh2 = new LiteArchiveLastdateCollectorModel();
                        refresh2.setId(Long.valueOf(this.idworker.nextId()));
                        refresh2.setCid(cid);
                        refresh2.setArchiveType(Integer.valueOf(3));
                        refresh2.setTitle(title);
                        refresh2.setArchiveLastUpdateDate(archive3LastUpdate);
                        refresh2.setLastUpdateDate(maxDate);
                        models.add(refresh2);
                    }
                    if (this.compareDate(l404, archive4LastUpdate) <= 0 && this.compareDate(l210, archive4LastUpdate) <= 0) continue;
                    maxDate = DateUtils.getMaxDate((Date[])new Date[]{l404, l210});
                    refresh2 = new LiteArchiveLastdateCollectorModel();
                    refresh2.setId(Long.valueOf(this.idworker.nextId()));
                    refresh2.setCid(cid);
                    refresh2.setArchiveType(Integer.valueOf(4));
                    refresh2.setTitle(title);
                    refresh2.setArchiveLastUpdateDate(archive4LastUpdate);
                    refresh2.setLastUpdateDate(maxDate);
                    models.add(refresh2);
                    continue;
                }
                if (Objects.equals(title, String.valueOf(DateUtils.getThisYear() - 2))) continue;
                if (this.compareDate(l206, archive2LastUpdate) > 0 || this.compareDate(l210, archive2LastUpdate) > 0 || this.compareDate(l211, archive2LastUpdate) > 0) {
                    maxDate = DateUtils.getMaxDate((Date[])new Date[]{l206, l210, l211});
                    refresh2 = new LiteArchiveLastdateCollectorModel();
                    refresh2.setId(Long.valueOf(this.idworker.nextId()));
                    refresh2.setCid(cid);
                    refresh2.setArchiveType(Integer.valueOf(2));
                    refresh2.setTitle(title);
                    refresh2.setArchiveLastUpdateDate(archive2LastUpdate);
                    refresh2.setLastUpdateDate(maxDate);
                    models.add(refresh2);
                }
                if (this.compareDate(l302, archive3LastUpdate) > 0) {
                    refresh = new LiteArchiveLastdateCollectorModel();
                    refresh.setId(Long.valueOf(this.idworker.nextId()));
                    refresh.setCid(cid);
                    refresh.setArchiveType(Integer.valueOf(3));
                    refresh.setTitle(title);
                    refresh.setArchiveLastUpdateDate(archive3LastUpdate);
                    refresh.setLastUpdateDate(l302);
                    models.add(refresh);
                }
                if (this.compareDate(l404, archive4LastUpdate) <= 0) continue;
                refresh = new LiteArchiveLastdateCollectorModel();
                refresh.setId(Long.valueOf(this.idworker.nextId()));
                refresh.setCid(cid);
                refresh.setArchiveType(Integer.valueOf(4));
                refresh.setTitle(title);
                refresh.setArchiveLastUpdateDate(archive4LastUpdate);
                refresh.setLastUpdateDate(archive4LastUpdate);
                models.add(refresh);
            }
        }
        for (List liteArchiveLastdateCollectorModels : ListUtil.partition(models, (int)1000)) {
            XxlJobHelper.log((String)"\u5904\u7406\u9700\u66f4\u65b0\u7684\u6863\u6848\u6570\uff1a{}", (Object[])new Object[]{liteArchiveLastdateCollectorModels.size()});
            ((LiteArchiveLastdateCollectorMapper)this.dao).insertRefreshCollector(liteArchiveLastdateCollectorModels);
        }
    }

    public List<LiteArchiveLastdateCollectorModel> selectRefreshCollector(List<String> titles) {
        return ((LiteArchiveLastdateCollectorMapper)this.dao).selectRefreshCollector(titles);
    }

    public List<AddLiteArchiveModel> selectAddLiteArchiveModel(String currYear, List<Long> cids) {
        if (StringUtils.isBlank((CharSequence)currYear)) {
            return null;
        }
        return ((LiteArchiveLastdateCollectorMapper)this.dao).selectAddLiteArchiveModel(currYear, cids);
    }
}

