/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.enums.FilesTypeEnum;
import cn.smarthse.common.framework.enums.HtmlEntityEnum;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.Java2WordGeneratorTemp;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.device.DeviceListView;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffDocInfoVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorArea;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckResultReport;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectBiologicalFactorV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectChemicalV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectDustV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectEhighFrequencyV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectFreshAirrateV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectHandTransmittedVibrationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectHighTemperatureV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectIlluminationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectIonizingradiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectLaserRadiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectMicroclimateV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectMicrowaveradiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectNoiseV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectPowerFrequencyElectricFieldV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectUhfRadiationV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectUltravioletlightV;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCollectWindSpeedV;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckAttachment;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckEvaluateOrCheckFileVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckEvaluateReportVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckPointMapVo;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldWorkRelation;
import cn.smarthse.modules.health.enums.archive.HarmFactorResultCollectSpecialCharacterEnum;
import cn.smarthse.modules.health.enums.archive.HarmFactorTestArchiveCheckDataMapKeyEnum;
import cn.smarthse.modules.health.enums.archive.HarmFactorTestArchiveDataMapKeyEnum;
import cn.smarthse.modules.health.enums.archive.PersonalHarmFactorArchiveDataMapKeyEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckServiceTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcQuarterEnum;
import cn.smarthse.modules.health.enums.hccheckplan.ResultCollectTypeEnum;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.device.IDeviceListViewService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.standard.IStandardService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleService;
import cn.smarthse.modules.health.service.work.shield.IShieldInfoService;
import cn.smarthse.modules.health.vo.archive.DownloadFile;
import cn.smarthse.modules.health.vo.archive.HarmFactorTestQuarterSummaryCheckPlanVO;
import cn.smarthse.modules.health.vo.archive.HarmFactorTestQuarterSummaryDataVO;
import cn.smarthse.modules.health.vo.archive.HarmFactorTestQuarterSummaryResultVO;
import cn.smarthse.modules.health.vo.archive.HarmFactorTestQuarterSummaryVO;
import cn.smarthse.modules.health.vo.archive.ResultAttributeName;
import cn.smarthse.modules.health.vo.archive.ResultAttributeNameBefore;
import cn.smarthse.modules.health.vo.archive.ResultCollectType;
import cn.smarthse.modules.health.vo.archive.WorkRoleHarmFactorShieldEquipVO;
import cn.smarthse.modules.health.vo.base.company.CompanyArchiveVo;
import cn.smarthse.services.hfi.api.model.doc.Doc4CheckFile;
import cn.smarthse.services.hfi.api.pojo.vo.CheckFileVo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckRecordFileService;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class HarmFactorTestArchiveService
implements IDocDataService {
    @Value(value="${isActualize}")
    private String isActualize;
    @Autowired
    private ICompanyService companyService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @Autowired
    private IDeviceListViewService deviceListViewService;
    @Autowired
    private IHarmfactorWorkService harmFactorWorkService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @Autowired
    private IShieldEquipRuleService shielEquipRuleService;
    @Autowired
    private IShieldInfoService shieldInfoService;
    @DubboReference
    private ISysFileProvideService fileService;
    @Autowired
    private IOccupationalRiskFactorsService occRFService;
    @Autowired
    private IHarmfactorAreaService harmFactorAreaService;
    @Autowired
    private IOccupationalRiskFactorsService occRiskFactorsService;
    @Autowired
    private IStandardService standService;
    @Autowired
    OssClientBean ossClienBean;
    @Autowired
    private ICompanyOrganizationService companyOrganizationService;
    private String erroStr = "0";
    private String okStr = "1";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference
    private ICheckRecordFileService checkRecordFileService;

    public Map<String, Object> getDocData(Long cid, String docParamValue) {
        try {
            if (!StringUtils.isNumber((String)docParamValue)) {
                throw new HealthException("\u5e74\u4efd\u9519\u8bef");
            }
            return this.getArchiveData(cid, Integer.valueOf(docParamValue));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HealthException(e.getMessage());
        }
    }

    public Map<String, Object> getCheckData(Long cid, String docParamValue) {
        HashMap<String, Object> dataCheckMap = new HashMap<String, Object>();
        Map<String, Object> dataMap = this.getDocData(cid, docParamValue);
        if (dataMap != null && !dataMap.isEmpty()) {
            List deviceList = (List)dataMap.get(HarmFactorTestArchiveDataMapKeyEnum.deviceList.name());
            String achive4_lackDevice = this.okStr;
            if (deviceList == null || deviceList.isEmpty()) {
                achive4_lackDevice = this.erroStr;
            }
            dataCheckMap.put(HarmFactorTestArchiveCheckDataMapKeyEnum.achive4_lackDevice.name(), achive4_lackDevice);
            List workRoleHarmFactorShieldList = (List)dataMap.get(HarmFactorTestArchiveDataMapKeyEnum.touchSummary.name());
            String achive4_lackHarmFactorName = this.okStr;
            for (WorkRoleHarmFactorShieldEquipVO vo : workRoleHarmFactorShieldList) {
                if (vo.getHarmFactorWork() == null || vo.getHarmFactorWork().getWorkId() == null) continue;
                List shieldWorkList = this.shieldInfoService.getShieldInfosByWorkId(vo.getHarmFactorWork().getWorkId(), cid);
                Boolean hasErrorShield = false;
                List shieldList = vo.getShieldList();
                if (shieldList == null || shieldList.isEmpty()) continue;
                for (ShieldWorkRelation shield : vo.getShieldList()) {
                    if (shield == null || shield.getShieldId() == null) continue;
                    boolean errorShield = true;
                    if (shieldWorkList == null || shieldWorkList.isEmpty()) continue;
                    for (ShieldWorkRelation s : shieldWorkList) {
                        if (!shield.getShieldId().equals(s.getShieldId())) continue;
                        errorShield = false;
                        break;
                    }
                    if (!errorShield) continue;
                    hasErrorShield = true;
                    break;
                }
                if (!hasErrorShield.booleanValue()) continue;
                achive4_lackHarmFactorName = this.erroStr;
                break;
            }
            dataCheckMap.put(HarmFactorTestArchiveCheckDataMapKeyEnum.achive4_lackShield.name(), this.okStr);
            dataCheckMap.put(HarmFactorTestArchiveCheckDataMapKeyEnum.achive4_lackDeviceType.name(), this.okStr);
            dataCheckMap.put(HarmFactorTestArchiveCheckDataMapKeyEnum.achive4_lackHarmFactorName.name(), achive4_lackHarmFactorName);
            List firstQuarter = (List)dataMap.get(HarmFactorTestArchiveDataMapKeyEnum.quarterSummaryFirst.name());
            String achive4_lackHarmFactorTest = this.erroStr;
            if (firstQuarter != null && !firstQuarter.isEmpty()) {
                achive4_lackHarmFactorTest = this.okStr;
            } else {
                List secondQuarter = (List)dataMap.get(HarmFactorTestArchiveDataMapKeyEnum.quarterSummarySecond.name());
                if (secondQuarter != null && !secondQuarter.isEmpty()) {
                    achive4_lackHarmFactorTest = this.okStr;
                } else {
                    List thirdQuarter = (List)dataMap.get(HarmFactorTestArchiveDataMapKeyEnum.quarterSummaryThird.name());
                    if (thirdQuarter != null && !thirdQuarter.isEmpty()) {
                        achive4_lackHarmFactorTest = this.okStr;
                    } else {
                        List fourthQuarter = (List)dataMap.get(HarmFactorTestArchiveDataMapKeyEnum.quarterSummaryFourth.name());
                        if (fourthQuarter != null && !fourthQuarter.isEmpty()) {
                            achive4_lackHarmFactorTest = this.okStr;
                        }
                    }
                }
            }
            dataCheckMap.put(HarmFactorTestArchiveCheckDataMapKeyEnum.achive4_lackHarmFactorTest.name(), achive4_lackHarmFactorTest);
        }
        return dataCheckMap;
    }

    private Map<String, Object> getArchiveData(Long cid, int year) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.year.name(), "" + year);
        CompanyArchiveVo company = this.companyService.getCompanyArchiveInfo(cid, year);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.companyInfo.name(), company);
        List<HcCheckPointMapVo> checkPointMapList = this.getHcCheckPointMapVosByCid(cid, year);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.checkPointMap.name(), checkPointMapList);
        List deviceList = this.deviceListViewService.getDeviceByIsHarmList(cid, String.valueOf(year));
        if (deviceList != null) {
            HtmlEntityEnum[] htmls = HtmlEntityEnum.values();
            for (DeviceListView device : deviceList) {
                if (device == null || StringUtils.isEmpty((CharSequence)device.getDeviceModel())) continue;
                for (HtmlEntityEnum h : htmls) {
                    device.setDeviceModel(device.getDeviceModel().replaceAll(h.getCode(), h.getCode()));
                }
            }
        }
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.deviceList.name(), deviceList);
        Calendar calendar = Calendar.getInstance();
        calendar.set(year + 1, 0, 0, 0, 0, 0);
        List harmFactorWorkList = new ArrayList();
        harmFactorWorkList = "true".equals(this.isActualize) ? this.harmFactorWorkService.getActualizeArchiveHarmfactor(cid, calendar.getTime()) : this.harmFactorWorkService.getArchiveHarmfactor(cid, calendar.getTime());
        ArrayList<WorkRoleHarmFactorShieldEquipVO> WorkRoleHarmFactorShieldList = new ArrayList<WorkRoleHarmFactorShieldEquipVO>();
        if (harmFactorWorkList != null && !harmFactorWorkList.isEmpty()) {
            for (HarmfactorWork hfw : harmFactorWorkList) {
                StringBuffer harmFactorNames = new StringBuffer("\uff1b");
                StringBuffer source = new StringBuffer("\uff1b");
                if (hfw.getHarmfactorWorkSourceList() != null) {
                    for (HarmfactorWorkSource h : hfw.getHarmfactorWorkSourceList()) {
                        if (h.getHarm() != null && StringUtils.isNotEmpty((String)h.getHarm().getNameCh()) && harmFactorNames.indexOf("\uff1b" + h.getHarm().getNameCh() + "\uff1b") < 0) {
                            harmFactorNames.append(h.getHarm().getNameCh());
                            harmFactorNames.append("\uff1b");
                        }
                        if (!StringUtils.isNotEmpty((String)h.getHazardSource()) || source.indexOf("\uff1b" + h.getHazardSource() + "\uff1b") >= 0) continue;
                        source.append(h.getHazardSource());
                        source.append("\uff1b");
                    }
                }
                harmFactorNames.deleteCharAt(0);
                if (harmFactorNames.length() > 0) {
                    harmFactorNames.deleteCharAt(harmFactorNames.lastIndexOf("\uff1b"));
                }
                source.deleteCharAt(0);
                if (source.length() > 0) {
                    source.deleteCharAt(source.lastIndexOf("\uff1b"));
                }
                WorkRoleHarmFactorShieldEquipVO vo = new WorkRoleHarmFactorShieldEquipVO();
                WorkRoleInfo workRoleInfo = hfw.getWork();
                StringBuffer workName = new StringBuffer();
                if (workRoleInfo != null) {
                    workName.append(workRoleInfo.getWorkName());
                    if (StringUtils.isNotBlank((CharSequence)workRoleInfo.getOrgName())) {
                        workName.append("/");
                        workName.append(workRoleInfo.getOrgName());
                    }
                }
                vo.setWorkName(workName.toString());
                vo.setHarmFactorWork(hfw);
                vo.setHarmFactorNames(harmFactorNames.toString());
                vo.setHarmFactorSource(source.toString());
                vo.setWorkRoleUserCount(this.staffInfoService.getHistoryBasicStaffCountByWork(hfw.getWorkId(), cid, DateUtils.getYearLastDay((int)year)));
                Integer femaleStaffCount = this.staffInfoService.getHistoryBasicFemaleStaffCountByWork(hfw.getWorkId(), cid, DateUtils.getYearLastDay((int)year));
                vo.setWorkRoleFemaleCount(Integer.valueOf(femaleStaffCount == null ? 0 : femaleStaffCount));
                List shieldInfos = this.shielEquipRuleService.getHistoryShieldInfosByWorkId(hfw.getWorkId(), cid, calendar.getTime());
                vo.setShieldList(shieldInfos);
                List deviceListByWorkId = this.deviceListViewService.getDeviceByWorkId(cid, hfw.getWorkId());
                StringBuffer deviceName = new StringBuffer(",");
                if (deviceListByWorkId != null && deviceListByWorkId.size() > 0) {
                    for (DeviceListView device : deviceListByWorkId) {
                        if (device == null || StringUtils.isBlank((CharSequence)device.getDeviceName()) || deviceName.indexOf("," + device.getDeviceName() + ",") != -1) continue;
                        deviceName.append(device.getDeviceName());
                        deviceName.append(",");
                    }
                }
                deviceName.deleteCharAt(deviceName.lastIndexOf(","));
                if (deviceName.length() > 0) {
                    deviceName.deleteCharAt(deviceName.indexOf(","));
                }
                vo.setDeviceName(deviceName.toString());
                vo.setDeviceList(deviceListByWorkId);
                WorkRoleHarmFactorShieldList.add(vo);
            }
        }
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.touchSummary.name(), WorkRoleHarmFactorShieldList);
        List<CheckFileVo> firstQuarterDataList = this.getDaliyCheckByDateRange(HcQuarterEnum.FIRST, cid, year);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.quarterSummaryFirst.name(), firstQuarterDataList);
        List<CheckFileVo> secondQuarterDataList = this.getDaliyCheckByDateRange(HcQuarterEnum.SECEND, cid, year);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.quarterSummarySecond.name(), secondQuarterDataList);
        List<CheckFileVo> thirdQuarterDataList = this.getDaliyCheckByDateRange(HcQuarterEnum.THIRD, cid, year);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.quarterSummaryThird.name(), thirdQuarterDataList);
        List<CheckFileVo> fourthQuarterDataList = this.getDaliyCheckByDateRange(HcQuarterEnum.FOURTH, cid, year);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.quarterSummaryFourth.name(), fourthQuarterDataList);
        List<HcCheckEvaluateOrCheckFileVo> testContractList = this.getHcCheckEvaluateOrCheckFileVos(cid, year);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.testContract.name(), testContractList);
        List<HcCheckEvaluateReportVo> testReportList = this.getHcCheckEvaluateReportVos(cid, year);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.testReportList.name(), testReportList);
        List<HcCheckResultReport> testResultReport = this.getHcCheckResultReportsBycid(cid, year);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.testResultReport.name(), testResultReport);
        return dataMap;
    }

    private List<CheckFileVo> getDaliyCheckByDateRange(HcQuarterEnum quarterEnum, Long cid, Integer year) {
        try {
            LocalDateTime dateBegin = DateUtil.getFromDate((Date)DateUtil.parseDate((String)(year + "-" + quarterEnum.getStartTime()), (String)"yyyy-MM-dd HH:mm:ss"));
            LocalDateTime dateEnd = DateUtil.getFromDate((Date)DateUtil.parseDate((String)(year + "-" + quarterEnum.getEndTime()), (String)"yyyy-MM-dd HH:mm:ss"));
            List vos = this.checkRecordFileService.queryCheckFileVos(cid, dateBegin, dateEnd);
            return vos;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<HcCheckEvaluateOrCheckFileVo> getHcCheckEvaluateOrCheckFileVos(Long cid, Integer year) {
        List doc4CheckFiles = this.checkPlanService.getDoc4CheckFiles(cid, year);
        ArrayList<HcCheckEvaluateOrCheckFileVo> voList = new ArrayList<HcCheckEvaluateOrCheckFileVo>();
        for (Doc4CheckFile h : doc4CheckFiles) {
            if (h.getCheckType() == null || h.getCheckType() == 3) continue;
            HcCheckEvaluateOrCheckFileVo vo = new HcCheckEvaluateOrCheckFileVo();
            vo.setCheckWorkName(h.getCheckWorkName());
            vo.setCheckTypeName(h.getCheckTypeName());
            vo.setCheckTime(DateUtils.formatCheckTime((Date)h.getCheckDateBegin(), (Date)h.getCheckDateEnd(), (String)"\u81f3"));
            if (h.getCheckServiceType() != HcCheckServiceTypeEnum.THIRD.getValue() || h.getThirdOrgId() != null) {
                // empty if block
            }
            if (h.getCheckServiceType() == HcCheckServiceTypeEnum.SELF.getValue()) {
                vo.setCheckOrgName(this.companyOrganizationService.getHistoryOrgNameByOrgIdAndYear(h.getThirdOrgId(), DateUtils.getYearLastDay((int)year)));
            }
            if (h.getEvaluateId() == null || h.getCheckType() == null || h.getCheckType().longValue() != HcCheckTypeEnum.PRESENT.getValue().longValue() && (long)h.getCheckType().intValue() != HcCheckTypeEnum.CONTROLASSESSMENT.getValue()) {
                vo.setEvaluateOrCheckLocation(h.getContractLocation());
                if (StringUtils.isNotEmpty((String)h.getContractFileIds())) {
                    String[] strs = h.getContractFileIds().split(",");
                    Object fileNameStr = "";
                    for (String str : strs) {
                        SysFileModel sysFile;
                        if (!StringUtils.isNumber((String)str) || (sysFile = this.fileService.getFileById(Long.valueOf(str))) == null) continue;
                        fileNameStr = (String)fileNameStr + sysFile.getFileName() + "  ";
                    }
                    vo.setEvaluateOrCheckFile((String)fileNameStr);
                }
            }
            voList.add(vo);
        }
        return voList;
    }

    private List<HcCheckEvaluateReportVo> getHcCheckEvaluateReportVos(Long cid, int year) {
        List doc4CheckFiles = this.checkPlanService.getDoc4CheckFiles(cid, Integer.valueOf(year));
        ArrayList<HcCheckEvaluateReportVo> voList = new ArrayList<HcCheckEvaluateReportVo>();
        for (Doc4CheckFile h : doc4CheckFiles) {
            SysFileModel sysFile;
            Object fileNameStr;
            String[] strs;
            HcCheckEvaluateReportVo vo = new HcCheckEvaluateReportVo();
            vo.setCheckWorkName(h.getCheckWorkName());
            if (h.getCheckType() != null && h.getCheckType() == 3) {
                h.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            vo.setCheckTypeName(h.getCheckTypeName());
            vo.setCheckTime(DateUtils.formatCheckTime((Date)h.getCheckDateBegin(), (Date)h.getCheckDateEnd(), (String)"\u81f3"));
            if (h.getEvaluateId() == null || h.getCheckType() == null || h.getCheckType().longValue() != HcCheckTypeEnum.PRESENT.getValue().longValue() && h.getCheckType().longValue() != HcCheckTypeEnum.CONTROLASSESSMENT.getValue().longValue()) {
                vo.setCheckEvaluateReportLocation(h.getCheckEvaluationReportLocation());
                if (StringUtils.isNotEmpty((String)h.getCheckEvaluationReportFileIds())) {
                    strs = h.getCheckEvaluationReportFileIds().split(",");
                    fileNameStr = "";
                    for (String str : strs) {
                        if (!StringUtils.isNumber((String)str) || (sysFile = this.fileService.getFileById(Long.valueOf(str))) == null) continue;
                        fileNameStr = (String)fileNameStr + sysFile.getFileName() + "  ";
                    }
                    vo.setCheckEvaluateReportName((String)fileNameStr);
                }
            }
            vo.setCheckReportLocation(h.getCheckReportLocation());
            if (StringUtils.isNotEmpty((String)h.getCheckReportFileIds())) {
                strs = h.getCheckReportFileIds().split(",");
                fileNameStr = "";
                for (String str : strs) {
                    if (!StringUtils.isNumber((String)str) || (sysFile = this.fileService.getFileById(Long.valueOf(str))) == null) continue;
                    fileNameStr = (String)fileNameStr + sysFile.getFileName() + "  ";
                }
                vo.setCheckReportName((String)fileNameStr);
            }
            voList.add(vo);
        }
        return voList;
    }

    private List<HcCheckResultReport> getHcCheckResultReportsBycid(Long cid, int year) {
        List doc4CheckFiles = this.checkPlanService.getDoc4CheckFiles(cid, Integer.valueOf(year));
        ArrayList<HcCheckResultReport> newList = new ArrayList<HcCheckResultReport>();
        for (Doc4CheckFile h : doc4CheckFiles) {
            if (h.getReportStatus() == null || h.getReportStatus() != 2) continue;
            HcCheckResultReport hr = new HcCheckResultReport();
            HcCheckPlan hp = new HcCheckPlan();
            hp.setCheckWorkName(h.getCheckWorkName());
            hr.setCheckDate(DateUtils.formatCheckTime((Date)h.getCheckDateBegin(), (Date)h.getCheckDateEnd(), (String)"\u81f3"));
            hr.setCheckTypeName(h.getCheckTypeName());
            hr.setHcCheckPlan(hp);
            hr.setReportDate(h.getReportDate());
            hr.setFilesStorageLocation(h.getCheckReportLocation());
            if (StringUtils.isNotEmpty((String)h.getCheckReportFileIds())) {
                String[] fileIds;
                ArrayList<HcCheckAttachment> attachments = new ArrayList<HcCheckAttachment>();
                for (String fileId : fileIds = h.getCheckReportFileIds().split(",")) {
                    HcCheckAttachment attachment = new HcCheckAttachment();
                    attachment.setFileId(Long.valueOf(fileId));
                    SysFileModel sysFile = this.fileService.getFileById(Long.valueOf(fileId));
                    if (sysFile != null) {
                        attachment.setAttachmentName(sysFile.getFileName());
                        attachment.setOssUrl(sysFile.getOssUrl());
                        attachment.setSysFile(sysFile);
                    }
                    attachments.add(attachment);
                }
                hr.setAttachments(attachments);
            }
            newList.add(hr);
        }
        return newList;
    }

    private List<HcCheckPointMapVo> getHcCheckPointMapVosByCid(Long cid, int year) {
        List doc4CheckFiles = this.checkPlanService.getDoc4CheckFiles(cid, Integer.valueOf(year));
        ArrayList<HcCheckPointMapVo> vos = new ArrayList<HcCheckPointMapVo>();
        for (Doc4CheckFile h : doc4CheckFiles) {
            if (StringUtils.isEmpty((CharSequence)h.getCheckPointMapFileIds())) continue;
            HcCheckPointMapVo vo = new HcCheckPointMapVo();
            vo.setCheckWorkName(h.getCheckWorkName());
            vo.setCheckTypeName(h.getCheckTypeName());
            vo.setCheckTime(DateUtils.formatCheckTime((Date)h.getCheckDateBegin(), (Date)h.getCheckDateEnd(), (String)"\u81f3"));
            if (StringUtils.isNotEmpty((String)h.getCheckPointMapFileIds())) {
                String[] fileIds;
                ArrayList<HcCheckAttachment> attachments = new ArrayList<HcCheckAttachment>();
                for (String fileId : fileIds = h.getCheckPointMapFileIds().split(",")) {
                    if (!StringUtils.isNumber((String)fileId)) continue;
                    HcCheckAttachment attachment = new HcCheckAttachment();
                    attachment.setFileId(Long.valueOf(fileId));
                    SysFileModel sysFile = this.fileService.getFileById(Long.valueOf(fileId));
                    if (sysFile == null) continue;
                    attachment.setAttachmentName(sysFile.getFileName());
                    attachment.setOssUrl(sysFile.getOssUrl());
                    attachment.setSysFile(sysFile);
                    attachments.add(attachment);
                }
                vo.setAttachments(attachments);
            }
            if (vo.getAttachments() == null || vo.getAttachments().isEmpty()) continue;
            vos.add(vo);
        }
        return vos;
    }

    private void getHarmFactorCheckDailyByHarmFactorId(HarmFactorTestQuarterSummaryDataVO result, Long harmFactorId, Long cid, int year) {
        List harmFactorAreaList = this.harmFactorAreaService.getArchiveHarmfactorAreaList(cid, harmFactorId, DateUtils.getYearLastDay((int)year));
        if (harmFactorAreaList == null || harmFactorAreaList.isEmpty()) {
            return;
        }
        for (HarmfactorArea hfa : harmFactorAreaList) {
            if (hfa.getCheckCycle() == null) continue;
            if (result.getCheckCycleMin() == null) {
                result.setCheckCycleMin(hfa.getCheckCycle());
            } else if (result.getCheckCycleMin().compareTo(hfa.getCheckCycle()) > 0) {
                result.setCheckCycleMin(hfa.getCheckCycle());
            }
            if (result.getCheckCycleMax() == null) {
                result.setCheckCycleMax(hfa.getCheckCycle());
                continue;
            }
            if (result.getCheckCycleMax().compareTo(hfa.getCheckCycle()) >= 0) continue;
            result.setCheckCycleMax(hfa.getCheckCycle());
        }
    }

    private Long getHarmFactorId(String paramCode) {
        OccupationalRiskFactors occRF = this.occRFService.getOneOccupationalRiskFactorsByParamCode(paramCode);
        return occRF == null ? null : occRF.getId();
    }

    private List<HarmFactorTestQuarterSummaryVO> arrangeQuarterDataObject(List<HarmFactorTestQuarterSummaryVO> list) {
        ArrayList<HarmFactorTestQuarterSummaryVO> returnList = new ArrayList<HarmFactorTestQuarterSummaryVO>();
        for (HarmFactorTestQuarterSummaryVO vo : list) {
            if (StringUtils.isEmpty((CharSequence)vo.getObject())) continue;
            boolean hasSameObject = false;
            for (HarmFactorTestQuarterSummaryVO returnVo : returnList) {
                if (!vo.getObject().equals(returnVo.getObject())) continue;
                returnVo.getDataList().addAll(vo.getDataList());
                hasSameObject = true;
                break;
            }
            if (hasSameObject) continue;
            returnList.add(vo);
        }
        return this.cleanHarmFactor(returnList);
    }

    private List<HarmFactorTestQuarterSummaryVO> cleanHarmFactor(List<HarmFactorTestQuarterSummaryVO> list) {
        for (HarmFactorTestQuarterSummaryVO vo : list) {
            ArrayList<HarmFactorTestQuarterSummaryDataVO> dataVoList = new ArrayList<HarmFactorTestQuarterSummaryDataVO>();
            for (HarmFactorTestQuarterSummaryDataVO dataVo : vo.getDataList()) {
                if (StringUtils.isEmpty((CharSequence)dataVo.getHarmFactorName())) continue;
                boolean alreadyHas = false;
                for (HarmFactorTestQuarterSummaryDataVO dVo : dataVoList) {
                    if (!StringUtils.equals((CharSequence)dataVo.getHarmFactorName(), (CharSequence)dVo.getHarmFactorName()) || !StringUtils.equals((CharSequence)dataVo.getResultText(), (CharSequence)dVo.getResultText())) continue;
                    dVo.getResultList().addAll(dataVo.getResultList());
                    alreadyHas = true;
                }
                if (alreadyHas) continue;
                dataVoList.add(dataVo);
            }
            vo.setDataList(dataVoList);
        }
        return this.cleanResult(list);
    }

    private List<HarmFactorTestQuarterSummaryVO> cleanResult(List<HarmFactorTestQuarterSummaryVO> list) {
        for (HarmFactorTestQuarterSummaryVO vo : list) {
            for (HarmFactorTestQuarterSummaryDataVO dataVo : vo.getDataList()) {
                ArrayList<HarmFactorTestQuarterSummaryResultVO> newResultVoList = new ArrayList<HarmFactorTestQuarterSummaryResultVO>();
                for (HarmFactorTestQuarterSummaryResultVO resultVo : dataVo.getResultList()) {
                    if (resultVo.getAttribute() == null) continue;
                    boolean alreadyHas = false;
                    for (HarmFactorTestQuarterSummaryResultVO newResultVo : newResultVoList) {
                        if (!resultVo.getAttribute().name().equals(newResultVo.getAttribute().name())) continue;
                        alreadyHas = true;
                        newResultVo.merge(resultVo);
                        break;
                    }
                    if (alreadyHas) continue;
                    newResultVoList.add(resultVo);
                }
                dataVo.setResultList(newResultVoList);
            }
        }
        return list;
    }

    private String getRealNumberResult(HarmFactorTestQuarterSummaryResultVO result, String resultStr) {
        if (resultStr == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)(resultStr = resultStr.trim()))) {
            return "";
        }
        if (resultStr.length() > 1) {
            String firstChar = resultStr.substring(0, 1);
            if (StringUtils.isNumber((String)firstChar)) {
                if (resultStr.contains("~")) {
                    int index = resultStr.indexOf("~");
                    String right = resultStr.substring(index + 1);
                    return right;
                }
                return resultStr;
            }
            if (StringUtils.isEmpty((CharSequence)result.getMinResuoltBefore())) {
                result.setMinResuoltBefore(firstChar);
            } else {
                result.setMinResuoltBefore(result.getMinResuoltBefore() + firstChar);
            }
            return this.getRealNumberResult(result, resultStr.substring(1));
        }
        return resultStr;
    }

    private void setChemicalResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectChemicalV obj = (HcCollectChemicalV)result;
        if (StringUtils.isNotEmpty((String)obj.getCmac())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal cmacData = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCmac()));
                cleanReault.setResultNumber(cmacData);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HealthException("\u5316\u5b66\u7269\u8d28CME\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.chemmical_cmac, resultData.getHarmFactorId());
            try {
                if (obj.getHcCheckPlan() != null && obj.getHcCheckPlan().getCheckTimeBegin() != null && DateUtils.isBefore((Date)obj.getHcCheckPlan().getCheckTimeBegin(), (Date)DateUtils.parseDate((String)"2020-04-01", (String[])new String[]{"yyyy-MM-dd"}))) {
                    cleanReault.setUnit(ResultAttributeNameBefore.chemmical_cmac.getRealUnit(null));
                    cleanReault.setTouchLimitUnit(ResultAttributeNameBefore.chemmical_cmac.getLimitUnit());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getCtwa())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal ctwa = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCtwa()));
                cleanReault.setResultNumber(ctwa);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HealthException("\u5316\u5b66\u7269\u8d28CME\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.chemical_ctwa, resultData.getHarmFactorId());
            if (obj.getHcCheckPlan() != null && (obj.getHcCheckPlan().getCreateDate() == null || DateUtils.getYear((Date)obj.getHcCheckPlan().getCreateDate()) < 2020)) {
                cleanReault.setUnit(ResultAttributeNameBefore.chemical_ctwa.getRealUnit(null));
                cleanReault.setTouchLimitUnit(ResultAttributeNameBefore.chemical_ctwa.getLimitUnit());
            }
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getCstel2())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                if (StringUtils.isNotEmpty((String)obj.getCstel2())) {
                    BigDecimal cstel2Data = new BigDecimal(obj.getCstel2());
                    cleanReault.setResultNumber(cstel2Data);
                }
                if (StringUtils.isNotEmpty((String)obj.getCstel3())) {
                    BigDecimal cstel3Data = new BigDecimal(obj.getCstel3());
                    cleanReault.setResultNumber(cstel3Data);
                }
            }
            catch (Exception e) {
                throw new HealthException("\u5316\u5b66\u7269\u8d28CSTE\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.chemical_cstel1, resultData.getHarmFactorId());
            cleanReault.setMinResuoltBefore(HarmFactorResultCollectSpecialCharacterEnum.getCharByCodeStr((String)obj.getCstel1()));
            try {
                if (obj.getHcCheckPlan() != null && obj.getHcCheckPlan().getCheckTimeBegin() != null && DateUtils.isBefore((Date)obj.getHcCheckPlan().getCheckTimeBegin(), (Date)DateUtils.parseDate((String)"2020-04-01", (String[])new String[]{"yyyy-MM-dd"}))) {
                    cleanReault.setUnit(ResultAttributeNameBefore.chemical_cstel1.getRealUnit(null));
                    cleanReault.setTouchLimitUnit(ResultAttributeNameBefore.chemical_cstel1.getLimitUnit());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getTimes())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal time = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getTimes()));
                cleanReault.setResultNumber(time);
            }
            catch (Exception e) {
                throw new HealthException("\u5316\u5b66\u7269\u8d28\u8d85\u9650\u500d\u6570\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.chemical_times, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
            try {
                if (obj.getHcCheckPlan() != null && obj.getHcCheckPlan().getCheckTimeBegin() != null && DateUtils.isBefore((Date)obj.getHcCheckPlan().getCheckTimeBegin(), (Date)DateUtils.parseDate((String)"2020-04-01", (String[])new String[]{"yyyy-MM-dd"}))) {
                    cleanReault.setUnit(ResultAttributeNameBefore.chemical_times.getRealUnit(null));
                    cleanReault.setTouchLimitUnit(ResultAttributeNameBefore.chemical_times.getLimitUnit());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty((String)obj.getPeakcontactconcentration())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal peakcontactconcentration = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getPeakcontactconcentration()));
                cleanReault.setResultNumber(peakcontactconcentration);
            }
            catch (Exception e) {
                throw new HealthException("\u5cf0\u63a5\u89e6\u6d53\u5ea6\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.chemical_peakcontactconcentration, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setBiologicalResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectBiologicalFactorV obj = (HcCollectBiologicalFactorV)result;
        if (StringUtils.isNotEmpty((String)obj.getCmac1())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal cmac = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCmac1()));
                cleanReault.setResultNumber(cmac);
            }
            catch (Exception e) {
                throw new HealthException("\u751f\u7269\u56e0\u7d20CME\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            cleanReault.setUnit(obj.getCmac2());
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.biological_cmac1, resultData.getHarmFactorId());
            try {
                if (obj.getHcCheckPlan() != null && obj.getHcCheckPlan().getCheckTimeBegin() != null && DateUtils.isBefore((Date)obj.getHcCheckPlan().getCheckTimeBegin(), (Date)DateUtils.parseDate((String)"2020-04-01", (String[])new String[]{"yyyy-MM-dd"}))) {
                    cleanReault.setUnit(ResultAttributeNameBefore.biological_cmac1.getRealUnit(null));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getCtwa1())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal ctwa = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCtwa1()));
                cleanReault.setResultNumber(ctwa);
            }
            catch (Exception e) {
                throw new HealthException("\u751f\u7269\u56e0\u7d20CTWA\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            cleanReault.setUnit(obj.getCtwa2());
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.biological_ctwa1, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getCstel2())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                if (StringUtils.isNotEmpty((String)obj.getCstel2())) {
                    BigDecimal cstel2Data = new BigDecimal(obj.getCstel2());
                    cleanReault.setResultNumber(cstel2Data);
                }
                if (StringUtils.isNotEmpty((String)obj.getCstel3())) {
                    BigDecimal cstel3Data = new BigDecimal(obj.getCstel3());
                    cleanReault.setResultNumber(cstel3Data);
                }
            }
            catch (Exception e) {
                throw new HealthException("\u751f\u7269\u56e0\u7d20CSTE\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            cleanReault.setUnit(obj.getCstel4());
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.biological_cstel1, resultData.getHarmFactorId());
            cleanReault.setMinResuoltBefore(HarmFactorResultCollectSpecialCharacterEnum.getCharByCodeStr((String)obj.getCstel1()));
            try {
                if (obj.getHcCheckPlan() != null && obj.getHcCheckPlan().getCheckTimeBegin() != null && DateUtils.isBefore((Date)obj.getHcCheckPlan().getCheckTimeBegin(), (Date)DateUtils.parseDate((String)"2020-04-01", (String[])new String[]{"yyyy-MM-dd"}))) {
                    cleanReault.setUnit(ResultAttributeNameBefore.biological_cstel1.getRealUnit(null));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getTimes())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal time = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getTimes()));
                cleanReault.setResultNumber(time);
            }
            catch (Exception e) {
                throw new HealthException("\u751f\u7269\u56e0\u7d20\u8d85\u9650\u500d\u6570\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.biological_times, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setDustResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        BigDecimal ctwa;
        BigDecimal time;
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectDustV obj = (HcCollectDustV)result;
        if (StringUtils.isNotEmpty((String)obj.getTimes1())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                time = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getTimes1()));
                cleanReault.setResultNumber(time);
            }
            catch (Exception e) {
                throw new HealthException("\u7c89\u5c18\uff08\u603b\u5c18\uff09\u8d85\u9650\u500d\u6570\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.dust_times1, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getTimes2())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                time = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getTimes2()));
                cleanReault.setResultNumber(time);
            }
            catch (Exception e) {
                throw new HealthException("\u7c89\u5c18\uff08\u547c\u5c18\uff09\u8d85\u9650\u500d\u6570\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.dust_times2, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getCtwa1())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                ctwa = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCtwa1()));
                cleanReault.setResultNumber(ctwa);
            }
            catch (Exception e) {
                throw new HealthException("\u7c89\u5c18CTWA\u603b\u5c18\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.dust_ctwa1, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getCtwa2())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                ctwa = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCtwa2()));
                cleanReault.setResultNumber(ctwa);
            }
            catch (Exception e) {
                throw new HealthException("\u7c89\u5c18CTWA\u547c\u5c18\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.dust_ctwa2, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getPeakcontactconcentration1())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal eakcontactconcentration1 = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getPeakcontactconcentration1()));
                cleanReault.setResultNumber(eakcontactconcentration1);
            }
            catch (Exception e) {
                throw new HealthException("\u5cf0\u63a5\u89e6\u6d53\u5ea6\uff08\u603b\u5c18\uff09\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.dust_peakcontactconcentration1, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getPeakcontactconcentration2())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal peakcontactconcentration2 = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getPeakcontactconcentration2()));
                cleanReault.setResultNumber(peakcontactconcentration2);
            }
            catch (Exception e) {
                throw new HealthException("\u5cf0\u63a5\u89e6\u6d53\u5ea6\uff08\u547c\u5c18\uff09\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.dust_peakcontactconcentration2, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setNoiseResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        BigDecimal value;
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectNoiseV obj = (HcCollectNoiseV)result;
        if (StringUtils.isNotEmpty((String)obj.getEqualLevel())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getEqualLevel()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u566a\u58f0\u7b49\u6548\u58f0\u7ea7\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.noise_equallevel, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getMaxNoise())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getMaxNoise()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u566a\u58f0\u58f0\u538b\u7ea7\u5cf0\u503c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.noise_maxnoise, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setHightemperatueResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        HcCollectHighTemperatureV obj = (HcCollectHighTemperatureV)result;
        if (StringUtils.isNotEmpty((String)obj.getCheckResult())) {
            HarmFactorTestQuarterSummaryResultVO cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCheckResult()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u9ad8\u6e29\u68c0\u6d4b\u6570\u503c\u7ed3\u679c\u4e0d\u662f\u6570\u5b57");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.highTemperature_checkresult, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setPowerFrequencyResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        HcCollectPowerFrequencyElectricFieldV obj = (HcCollectPowerFrequencyElectricFieldV)result;
        if (StringUtils.isNotEmpty((String)obj.getPower())) {
            HarmFactorTestQuarterSummaryResultVO cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getPower()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u5de5\u9891\u7535\u573a\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.powerFrequency_power, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setIonizingradiationResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        HcCollectIonizingradiationV obj = (HcCollectIonizingradiationV)result;
        if (StringUtils.isNotEmpty((String)obj.getCheckresult1())) {
            HarmFactorTestQuarterSummaryResultVO cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal value1 = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCheckresult1()));
                cleanReault.setResultNumber(value1);
                BigDecimal value2 = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCheckresult2()));
                cleanReault.setResultNumber(value2);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HealthException("\u7535\u79bb\u8f90\u5c04\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.ionizingRadiation_checkresult1, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setUltraHighFrequencyRadiationResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        BigDecimal value;
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectUhfRadiationV obj = (HcCollectUhfRadiationV)result;
        if (StringUtils.isNotEmpty((String)obj.getPower())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getPower()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u8d85\u9ad8\u9891\u8f90\u5c04\u529f\u7387\u5bc6\u5ea6\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.ultraHighFrequencyRadiation_power, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getElectric())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getElectric()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u8d85\u9ad8\u9891\u8f90\u5c04\u7535\u573a\u5f3a\u5ea6\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.ultraHighFrequencyRadiation_electric, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setHighFrequencyResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        BigDecimal value;
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectEhighFrequencyV obj = (HcCollectEhighFrequencyV)result;
        if (StringUtils.isNotEmpty((String)obj.getEstrong())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getEstrong()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u8d85\u9ad8\u9891\u8f90\u5c04\u7535\u573a\u5f3a\u5ea6\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.highFrequency_estrong, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getMstrong())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getMstrong()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u8d85\u9ad8\u9891\u8f90\u5c04\u78c1\u573a\u5f3a\u5ea6\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.highFrequency_mstrong, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setLaserRadiationResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        BigDecimal max;
        BigDecimal value2;
        BigDecimal min;
        Integer power1;
        BigDecimal value1;
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectLaserRadiationV obj = (HcCollectLaserRadiationV)result;
        try {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            if (StringUtils.isNotEmpty((String)obj.getExposure1())) {
                value1 = new BigDecimal(obj.getExposure1());
                power1 = Integer.valueOf(StringUtils.isNotEmpty((String)obj.getExposure2()) ? obj.getExposure2() : "0");
                min = null;
                min = power1 < 0 ? value1.divide(new BigDecimal(10).pow(Math.abs(power1))) : value1.multiply(new BigDecimal(10).pow(power1));
                cleanReault.setResultNumber(min);
                cleanReault.setResultMinStr(obj.getExposure1());
                cleanReault.setResultMinPower(power1);
            }
            if (StringUtils.isNotEmpty((String)obj.getExposure3())) {
                value2 = new BigDecimal(obj.getExposure3());
                Integer power2 = Integer.valueOf(StringUtils.isNotEmpty((String)obj.getExposure4()) ? obj.getExposure4() : "0");
                max = value2.multiply(new BigDecimal(10).pow(power2));
                cleanReault.setResultNumber(max);
                cleanReault.setResultMaxStr(obj.getExposure3());
                cleanReault.setResultMaxPower(power2);
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.laserRadiation_exposure1, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HealthException("\u6fc0\u5149\u7167\u5c04\u91cf\u7ed3\u679c\u6709\u8bef");
        }
        try {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            if (StringUtils.isNotEmpty((String)obj.getIrradiance1())) {
                value1 = new BigDecimal(obj.getIrradiance1());
                power1 = Integer.valueOf(StringUtils.isNotEmpty((String)obj.getIrradiance2()) ? obj.getIrradiance2() : "0");
                min = value1.multiply(new BigDecimal(10).pow(power1));
                cleanReault.setResultNumber(min);
                cleanReault.setResultMinStr(obj.getIrradiance1());
                cleanReault.setResultMinPower(power1);
            }
            if (StringUtils.isNotEmpty((String)obj.getIrradiance3())) {
                value2 = new BigDecimal(obj.getIrradiance3());
                Integer power4 = Integer.valueOf(StringUtils.isNotEmpty((String)obj.getIrradiance4()) ? obj.getIrradiance4() : "0");
                max = value2.multiply(new BigDecimal(10).pow(power4));
                cleanReault.setResultNumber(max);
                cleanReault.setResultMaxStr(obj.getIrradiance3());
                cleanReault.setResultMaxPower(power4);
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.laserRadiation_irradiance1, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HealthException("\u6fc0\u5149\u8f90\u7167\u5ea6\u7ed3\u679c\u6709\u8bef");
        }
    }

    private void setMicroWaveRadiationResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        BigDecimal value;
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectMicrowaveradiationV obj = (HcCollectMicrowaveradiationV)result;
        if (StringUtils.isNotEmpty((String)obj.getPowerDensity())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getPowerDensity()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u5fae\u6ce2\u8f90\u5c04\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.microWaverAdiation_powerdensity, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getAmount())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getAmount()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u5fae\u6ce2\u8f90\u5c04\u65e5\u5242\u91cf\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.microWaverAdiation_amount, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getAvgDensity())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getAvgDensity()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u5fae\u6ce2\u8f90\u5c04\u5e73\u5747\u529f\u7387\u5bc6\u5ea6\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.microWaverAdiation_avgdensity, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setUltraVioletlightResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        BigDecimal value;
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectUltravioletlightV obj = (HcCollectUltravioletlightV)result;
        if (StringUtils.isNotEmpty((String)obj.getIrradiance())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getIrradiance()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u7d2b\u5916\u8f90\u5c04\u8f90\u7167\u5ea6\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.ultravioletRadiation_irradiance, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getExposure())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getExposure()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u7d2b\u5916\u8f90\u5c04\u7167\u5c04\u91cf\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.ultravioletRadiation_exposure, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setHandTransmitedResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        HcCollectHandTransmittedVibrationV obj = (HcCollectHandTransmittedVibrationV)result;
        if (StringUtils.isNotEmpty((String)obj.getSpeed())) {
            HarmFactorTestQuarterSummaryResultVO cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getSpeed()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("4h\u7b49\u80fd\u91cf\u9891\u7387\u8ba1\u6743\u632f\u52a8\u52a0\u901f\u5ea6\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.handTransmitted_speed, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setIlluminancyResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        HcCollectIlluminationV obj = (HcCollectIlluminationV)result;
        if (StringUtils.isNotEmpty((String)obj.getCheckResult())) {
            HarmFactorTestQuarterSummaryResultVO cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCheckResult()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u7167\u5ea6\u68c0\u6d4b\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.illuminancy_checkresult, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setWindspeedResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        HcCollectWindSpeedV obj = (HcCollectWindSpeedV)result;
        if (StringUtils.isNotEmpty((String)obj.getCheckResult())) {
            HarmFactorTestQuarterSummaryResultVO cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCheckResult()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u98ce\u901f\u68c0\u6d4b\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.windSpeed_checkresult, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setFreshairrateResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        HcCollectFreshAirrateV obj = (HcCollectFreshAirrateV)result;
        if (StringUtils.isNotEmpty((String)obj.getCheckResult())) {
            HarmFactorTestQuarterSummaryResultVO cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                BigDecimal value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCheckResult()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u65b0\u98ce\u91cf\u68c0\u6d4b\u7ed3\u679c\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.freshAirRate_checkresult, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setMicroClimateResult(Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        BigDecimal value;
        HarmFactorTestQuarterSummaryResultVO cleanReault;
        HcCollectMicroclimateV obj = (HcCollectMicroclimateV)result;
        if (StringUtils.isNotEmpty((String)obj.getCheckResult1())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCheckResult1()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u65b0\u98ce\u91cf\u6e29\u5ea6\u6709\u8bef");
            }
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.microClimate_checkresult1, resultData.getHarmFactorId());
            cleanReault.setResultText(obj.getResultName1());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getCheckResult2())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCheckResult2()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u65b0\u98ce\u91cf\u98ce\u901f\u6709\u8bef");
            }
            cleanReault.setResultText(obj.getResultName2());
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.microClimate_checkresult2, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
        if (StringUtils.isNotEmpty((String)obj.getCheckResult3())) {
            cleanReault = new HarmFactorTestQuarterSummaryResultVO();
            try {
                value = new BigDecimal(this.getRealNumberResult(cleanReault, obj.getCheckResult3()));
                cleanReault.setResultNumber(value);
            }
            catch (Exception e) {
                throw new HealthException("\u65b0\u98ce\u91cf\u76f8\u5bf9\u6e7f\u5ea6\u6709\u8bef");
            }
            cleanReault.setResultText(obj.getResultName3());
            this.setAttributeAndUnit(cleanReault, ResultAttributeName.microClimate_checkresult3, resultData.getHarmFactorId());
            resultData.getResultList().add(cleanReault);
        }
    }

    private void setAttributeAndUnit(HarmFactorTestQuarterSummaryResultVO cleanReault, ResultAttributeName attribute, Long harmFactorId) {
        cleanReault.setUnit(attribute.getRealUnit(cleanReault.getUnit()));
        cleanReault.setAttribute(attribute);
        cleanReault.setTouchLimitUnit(attribute.getLimitUnit());
        if (StringUtils.isEmpty((CharSequence)attribute.getLimitValue())) {
            cleanReault.setTouchLimit(this.getLimitValue(harmFactorId, attribute));
        } else {
            cleanReault.setTouchLimit(attribute.getLimitValue());
        }
    }

    private void setResult(ResultCollectType type, Object result, HarmFactorTestQuarterSummaryDataVO resultData) {
        if (type == null || result == null) {
            return;
        }
        if (ResultCollectType.CHEMICAL.name().equals(type.name())) {
            this.setChemicalResult(result, resultData);
        } else if (ResultCollectType.DUST.name().equals(type.name())) {
            this.setDustResult(result, resultData);
        } else if (ResultCollectType.BIOLOGICAL.name().equals(type.name())) {
            this.setBiologicalResult(result, resultData);
        } else if (ResultCollectType.NOISE.name().equals(type.name())) {
            this.setNoiseResult(result, resultData);
        } else if (ResultCollectType.HIGHTEMPERATURE.name().equals(type.name())) {
            this.setHightemperatueResult(result, resultData);
        } else if (ResultCollectType.POWERFREQUENCY.name().equals(type.name())) {
            this.setPowerFrequencyResult(result, resultData);
        } else if (ResultCollectType.IONIZINGRADIATION.name().equals(type.name())) {
            this.setIonizingradiationResult(result, resultData);
        } else if (ResultCollectType.ULTRAHIGHFREQUENCYRADIATION.name().equals(type.name())) {
            this.setUltraHighFrequencyRadiationResult(result, resultData);
        } else if (ResultCollectType.HIGHFREQUENCY.name().equals(type.name())) {
            this.setHighFrequencyResult(result, resultData);
        } else if (ResultCollectType.LASERRADIATION.name().equals(type.name())) {
            this.setLaserRadiationResult(result, resultData);
        } else if (ResultCollectType.MICROWAVERADIATION.name().equals(type.name())) {
            this.setMicroWaveRadiationResult(result, resultData);
        } else if (ResultCollectType.ULTRAVIOLETLIGHT.name().equals(type.name())) {
            this.setUltraVioletlightResult(result, resultData);
        } else if (ResultCollectType.HANDTRANSMITTED.name().equals(type.name())) {
            this.setHandTransmitedResult(result, resultData);
        } else if (ResultCollectType.ILLUMINANCY.name().equals(type.name())) {
            this.setIlluminancyResult(result, resultData);
        } else if (ResultCollectType.WINDSPEED.name().equals(type.name())) {
            this.setWindspeedResult(result, resultData);
        } else if (ResultCollectType.FRESHAIRRATE.name().equals(type.name())) {
            this.setFreshairrateResult(result, resultData);
        } else if (ResultCollectType.MICROCLIMATE.name().equals(type.name())) {
            this.setMicroClimateResult(result, resultData);
        }
    }

    private void setResultNormal(Object v, String resultText, ResultCollectTypeEnum type, ResultCollectType type2, Long cid, List<HarmFactorTestQuarterSummaryVO> voList, String reportName, int year) {
        HarmFactorTestQuarterSummaryDataVO resultData = new HarmFactorTestQuarterSummaryDataVO();
        HarmFactorTestQuarterSummaryVO result = new HarmFactorTestQuarterSummaryVO();
        result.setObject(reportName);
        resultData.setHarmFactorId(this.getHarmFactorId(type.getParamCode()));
        resultData.setHarmFactorName(type.getName());
        resultData.setResultText(resultText);
        this.setResult(type2, v, resultData);
        if (type == null || !ResultCollectType.ILLUMINANCY.getName().equals(type2.getName()) && !ResultCollectType.MICROCLIMATE.getName().equals(type2.getName()) && !ResultCollectType.WINDSPEED.getName().equals(type2.getName()) && !ResultCollectType.FRESHAIRRATE.getName().equals(type2.getName())) {
            this.getHarmFactorCheckDailyByHarmFactorId(resultData, resultData.getHarmFactorId(), cid, year);
        }
        if (resultData.getResultList() != null && resultData.getResultList().size() >= 0) {
            result.getDataList().add(resultData);
            voList.add(result);
        }
    }

    private List<HarmFactorTestQuarterSummaryCheckPlanVO> sortCheckPlanList(List<HarmFactorTestQuarterSummaryCheckPlanVO> checkPlanList) {
        if (checkPlanList == null || checkPlanList.isEmpty()) {
            return null;
        }
        Iterator<HarmFactorTestQuarterSummaryCheckPlanVO> checkPlanItorator = checkPlanList.iterator();
        while (checkPlanItorator.hasNext()) {
            HarmFactorTestQuarterSummaryCheckPlanVO checkPlan = checkPlanItorator.next();
            if (checkPlan.getSummaryList() == null || checkPlan.getSummaryList().isEmpty()) {
                checkPlanItorator.remove();
                continue;
            }
            Collections.sort(checkPlan.getSummaryList(), new Comparator<HarmFactorTestQuarterSummaryVO>(){

                @Override
                public int compare(HarmFactorTestQuarterSummaryVO o1, HarmFactorTestQuarterSummaryVO o2) {
                    return o1.getObject().compareTo(o2.getObject());
                }
            });
            Iterator itorator = checkPlan.getSummaryList().iterator();
            HarmFactorTestQuarterSummaryVO summary0 = null;
            while (itorator.hasNext()) {
                HarmFactorTestQuarterSummaryVO summary1 = (HarmFactorTestQuarterSummaryVO)itorator.next();
                if (summary0 == null) {
                    summary0 = summary1;
                    continue;
                }
                if (summary0.getObject().equals(summary1.getObject())) {
                    summary0.getDataList().addAll(summary1.getDataList());
                    itorator.remove();
                    continue;
                }
                summary0 = summary1;
            }
        }
        return checkPlanList;
    }

    private String getLimitValue(Long harmFactorId, ResultAttributeName attribute) {
        if (harmFactorId == null) {
            return null;
        }
        OccupationalRiskFactors riskFactor = (OccupationalRiskFactors)this.occRiskFactorsService.getById(harmFactorId);
        if (riskFactor == null) {
            return null;
        }
        return this.standService.getLimitValueByHarmfactorParamCodeAndAttribute(riskFactor.getParamcode(), attribute);
    }

    public Map<String, Object> generatorArchive(String archiveTargetDir, String docNo, Long cid, String docParamValue) {
        DownloadFile chekPointFiles;
        Map<String, Object> dataMap = this.getDocData(cid, docParamValue);
        dataMap.put(HarmFactorTestArchiveDataMapKeyEnum.archiveNo.name(), docNo);
        String targetFileNameFormat = FilesTypeEnum.harmFactorCheck.getTargetFilenameFormat();
        String[] targetDirs = FilesTypeEnum.harmFactorCheck.getDirs();
        StaffDocInfoVo staffVo = (StaffDocInfoVo)dataMap.get(PersonalHarmFactorArchiveDataMapKeyEnum.staffInfo.name());
        String destFileDir = String.format("\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u76d1\u6d4b\u4e0e\u68c0\u6d4b\u8bc4\u4ef7\u6863\u6848\uff08%s\uff09", docNo);
        String destFileName = String.format(targetFileNameFormat, docNo);
        String destFilePath = archiveTargetDir + File.separatorChar + destFileDir + File.separatorChar;
        dataMap.put("archive_doc__filename", destFileDir);
        try {
            Java2WordGeneratorTemp.createDoc(dataMap, (String)"doc4harmFactorTest/harmFactor.ftl", (String)(destFilePath + destFileName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean hasFile = false;
        ArrayList<DownloadFile> downloadFile = new ArrayList<DownloadFile>();
        if (!hasFile) {
            DownloadFile chekPointFiles2 = new DownloadFile();
            chekPointFiles2.setFolderPath(destFilePath + targetDirs[0]);
            downloadFile.add(chekPointFiles2);
        }
        hasFile = false;
        List checkPointMapList = (List)dataMap.get(HarmFactorTestArchiveDataMapKeyEnum.checkPointMap.name());
        if (checkPointMapList != null) {
            for (Object c : checkPointMapList) {
                DownloadFile chekPointFiles3 = new DownloadFile();
                StringBuffer path = new StringBuffer();
                path.append(destFilePath);
                path.append(targetDirs[1]);
                path.append(File.separatorChar);
                path.append(StringUtils.getFileNameStr((String)c.getCheckTime()));
                if (StringUtils.isNotEmpty((String)c.getCheckWorkName())) {
                    path.append(" ");
                    path.append(StringUtils.getFileNameStr((String)c.getCheckWorkName()));
                }
                chekPointFiles3.setFolderPath(path.toString());
                if (c.getAttachments() != null) {
                    for (HcCheckAttachment a : c.getAttachments()) {
                        if (a.getSysFile() == null) continue;
                        chekPointFiles3.getFile().add(a.getSysFile());
                    }
                }
                hasFile = true;
                downloadFile.add(chekPointFiles3);
            }
        }
        if (!hasFile) {
            chekPointFiles = new DownloadFile();
            chekPointFiles.setFolderPath(destFilePath + targetDirs[1]);
            downloadFile.add(chekPointFiles);
        }
        if (!(hasFile = false)) {
            chekPointFiles = new DownloadFile();
            chekPointFiles.setFolderPath(destFilePath + targetDirs[2]);
            downloadFile.add(chekPointFiles);
        }
        if (!(hasFile = false)) {
            chekPointFiles = new DownloadFile();
            chekPointFiles.setFolderPath(destFilePath + targetDirs[3]);
            downloadFile.add(chekPointFiles);
        }
        if (!(hasFile = false)) {
            chekPointFiles = new DownloadFile();
            chekPointFiles.setFolderPath(destFilePath + targetDirs[4]);
            downloadFile.add(chekPointFiles);
        }
        if (!(hasFile = false)) {
            chekPointFiles = new DownloadFile();
            chekPointFiles.setFolderPath(destFilePath + targetDirs[5]);
            downloadFile.add(chekPointFiles);
        }
        hasFile = false;
        List testResultReportList = (List)dataMap.get(HarmFactorTestArchiveDataMapKeyEnum.testResultReport.name());
        if (testResultReportList != null) {
            for (HcCheckResultReport m : testResultReportList) {
                DownloadFile testResultReportFiles = new DownloadFile();
                StringBuffer path = new StringBuffer();
                path.append(destFilePath + targetDirs[7]);
                path.append(File.separatorChar);
                path.append(StringUtils.getFileNameStr((String)m.getCheckDate()));
                if (m.getHcCheckPlan() != null && StringUtils.isNotEmpty((String)m.getHcCheckPlan().getCheckWorkName())) {
                    path.append(" ");
                    path.append(StringUtils.getFileNameStr((String)m.getHcCheckPlan().getCheckWorkName()));
                }
                testResultReportFiles.setFolderPath(path.toString());
                if (m.getAttachments() != null && !m.getAttachments().isEmpty()) {
                    for (HcCheckAttachment a : m.getAttachments()) {
                        testResultReportFiles.getFile().add(a.getSysFile());
                    }
                }
                downloadFile.add(testResultReportFiles);
                hasFile = true;
            }
        }
        if (!hasFile) {
            DownloadFile chekPointFiles4 = new DownloadFile();
            chekPointFiles4.setFolderPath(destFilePath + targetDirs[7]);
            downloadFile.add(chekPointFiles4);
        }
        this.downLoadFile(downloadFile);
        return dataMap;
    }

    public void downLoadFile(List<DownloadFile> files) {
        try {
            if (files == null || files.isEmpty()) {
                return;
            }
            for (DownloadFile df : files) {
                if (StringUtils.isEmpty((CharSequence)df.getFolderPath())) continue;
                df.setFolderPath(StringUtils.replaceHtml((String)HtmlEntityEnum.replaceAllCode((String)df.getFolderPath())));
                File fileParent = new File(df.getFolderPath());
                if (!fileParent.exists()) {
                    fileParent.mkdirs();
                }
                if (df.getFile() == null || df.getFile().isEmpty()) continue;
                for (SysFileModel sf : df.getFile()) {
                    if (!StringUtils.isNotEmpty((String)sf.getOssUrl()) || !StringUtils.isNotEmpty((String)sf.getFileName())) continue;
                    this.ossClienBean.downloadFile(sf.getOssUrl(), df.getFolderPath(), sf.getFileName());
                }
            }
        }
        catch (IOException e) {
            this.logger.error("\u6267\u884c\u7f51\u7edc\u62f7\u8d1d\u52a8\u4f5c\u53d1\u751f\u9519\u8bef:" + e.getMessage());
        }
    }
}

