/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.archive.ArchiveYearMapper;
import cn.smarthse.modules.health.entity.archive.Archive;
import cn.smarthse.modules.health.entity.archive.ArchiveCheck;
import cn.smarthse.modules.health.entity.archive.ArchiveFiles;
import cn.smarthse.modules.health.entity.archive.ArchiveYear;
import cn.smarthse.modules.health.enums.archive.ArchiveType;
import cn.smarthse.modules.health.service.archive.IArchiveCheckService;
import cn.smarthse.modules.health.service.archive.IArchiveFilesService;
import cn.smarthse.modules.health.service.archive.IArchiveService;
import cn.smarthse.modules.health.service.archive.IArchiveYearService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Calendar;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ArchiveYearServiceImpl
extends BaseServiceImpl<ArchiveYearMapper, ArchiveYear>
implements IArchiveYearService {
    @Autowired
    ArchiveYearMapper archiveYearMapper;
    @Autowired
    IArchiveFilesService archiveFilesService;
    @Autowired
    IArchiveCheckService archiveCheckService;
    @Autowired
    IArchiveService archiveService;
    private static final String NEWEST_YEAR = "newestYearArchive";

    public List<ArchiveYear> getArchiveByDocType(Long cid, ArchiveType type) {
        return this.archiveYearMapper.selectArchiveByDocType(cid, type.getType());
    }

    @Transactional(readOnly=false)
    private void checkAndUpdateNewestYearArchive() {
        Object oldYear = null;
        Calendar calendar = Calendar.getInstance();
        String year = "" + calendar.get(1);
        if (year.equals(oldYear)) {
            return;
        }
        Example example = new Example(ArchiveYear.class);
        example.createCriteria().andEqualTo("docParamValue", (Object)year).andEqualTo("isValid", (Object)true);
        List list = ((ArchiveYearMapper)this.dao).selectByExample(example);
        if (list == null || list.isEmpty()) {
            for (ArchiveType archiveType : ArchiveType.getArchiveListHasYear()) {
                ArchiveYear entity = new ArchiveYear();
                entity.setId(Long.valueOf(archiveType.getType() + year));
                entity.setDocType(Byte.valueOf(archiveType.getType()));
                entity.setTitleYear(year + "\u5e74");
                entity.setDocParamValue(year);
                super.add(entity, null, null);
            }
        }
    }

    @Transactional(readOnly=false)
    public PageInfo<ArchiveYear> getArchiveYearList(JqGridParam param, ArchiveType type) {
        this.checkAndUpdateNewestYearArchive();
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ArchiveYear> list = this.getArchiveByDocType(param.getCid(), type);
        for (ArchiveYear year : list) {
            List fileList = this.archiveFilesService.getArchiveFilesByArchiveId(param.getCid(), year.getArchiveId());
            year.setFileSize(Integer.valueOf(fileList.size()));
            if (fileList.size() <= 0) continue;
            year.setFileId(((ArchiveFiles)fileList.get(0)).getDocFileId());
            year.setArchiveFilesId(((ArchiveFiles)fileList.get(0)).getId());
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public PageInfo<ArchiveYear> getArchiveYearDoc5List(JqGridParam param) {
        this.checkAndUpdateNewestYearArchive();
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Example example = new Example(ArchiveYear.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("docType", (Object)ArchiveType.Archive5.getType());
        example.setOrderByClause("title_year desc");
        List list = ((ArchiveYearMapper)this.dao).selectByExample(example);
        Archive archive = this.archiveService.getArchiveByCid(param.getCid(), ArchiveType.Archive5.getType());
        Integer checkNum = this.archiveCheckService.getDocCheckContent(param.getCid(), ArchiveType.Archive5.getType());
        for (ArchiveYear year : list) {
            year.setCheckNum(checkNum);
            if (archive == null) continue;
            ArchiveCheck check = this.archiveCheckService.getCheckByArchiveId(archive.getId(), year.getDocParamValue());
            if (check != null) {
                year.setDocCheckId(check.getId());
                year.setDocCheckDate(check.getDocCheckDate());
                year.setDocCheckPercent(check.getDocCheckPercent());
                year.setDocCheckState(check.getDocCheckState());
            }
            year.setArchiveId(archive.getId());
            year.setDocGeneratorState(archive.getDocGeneratorState());
            year.setDocGeneratorDate(archive.getDocGeneratorDate());
            List fileList = this.archiveFilesService.getListByArchiveId(archive.getId(), param.getCid(), year.getDocParamValue(), year.getDocType());
            year.setFileSize(Integer.valueOf(fileList.size()));
            if (fileList.size() <= 0) continue;
            year.setFileId(((ArchiveFiles)fileList.get(0)).getDocFileId());
            year.setArchiveFilesId(((ArchiveFiles)fileList.get(0)).getId());
        }
        return new PageInfo(list);
    }
}

