/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.health.dao.archive.ArchiveViewMapper;
import cn.smarthse.modules.health.entity.archive.view.ArchiveView;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.scene.SceneInspection;
import cn.smarthse.modules.health.service.archive.ArchiveViewService;
import cn.smarthse.modules.health.service.archive.IArchiveCheckService;
import cn.smarthse.modules.health.service.archive.IArchiveFilesService;
import cn.smarthse.modules.health.service.archive.IArchiveGeneratorService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionService;
import cn.smarthse.modules.health.service.work.train.ITrainArchiveService;
import cn.smarthse.modules.health.vo.archive.ArchiveJobCount;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ArchiveViewServiceImpl
implements ArchiveViewService {
    @Autowired
    ArchiveViewMapper archiveViewMapper;
    @Autowired
    IArchiveCheckService archiveCheckService;
    @Autowired
    IArchiveGeneratorService archiveGeneratorService;
    @Autowired
    IArchiveFilesService archiveFilesService;
    @Resource(name="occHealthArchiveService")
    IDocDataService occHealthArchiveService;
    @Autowired
    IReformItemBasicService reformService;
    @Resource(name="personalPHCArhiveService")
    IDocDataService personalPHCArhiveService;
    @Resource(name="harmFactorTestArchiveService")
    IDocDataService harmFactorTestArchiveService;
    @Autowired
    ITrainArchiveService trainArchiveService;
    @Autowired
    ISceneInspectionService sceneInspectionService;

    public PageInfo<ArchiveView> getDoc1(JqGridParam gparam) {
        if (gparam == null) {
            return new PageInfo();
        }
        if (gparam.getCid() == null || gparam.getCid() == 0L) {
            return new PageInfo();
        }
        String keyword = null;
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                if (!sField.getSearchField().equals("keyword")) continue;
                keyword = sField.getSearchValue();
            }
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<ArchiveView> list = this.archiveViewMapper.selectDoc1(gparam.getCid(), keyword);
        return new PageInfo(list);
    }

    public ArchiveJobCount getArchiveJobCount(Long cid) {
        ArchiveJobCount archiveJobCount = new ArchiveJobCount();
        archiveJobCount.setCheckJobCount(this.archiveCheckService.getArchiveCheckCount(cid));
        archiveJobCount.setGeneratorJobCount(this.archiveGeneratorService.getArchiveGeneratorCount(cid));
        return archiveJobCount;
    }

    public Map<String, Object> getDoc2Data(Long cid, String docParamValue) {
        List sceneInspectionList2;
        Map dataMap = this.occHealthArchiveService.getDocData(cid, docParamValue);
        StringBuffer sb = new StringBuffer();
        List sceneInspectionList = (List)dataMap.get("sceneInspectionList");
        if (sceneInspectionList != null && sceneInspectionList.size() > 0) {
            for (SceneInspection sit : sceneInspectionList) {
                Date checkTime = sit.getInspectionActualTime();
                String scheckTime = DateUtils.format((Date)checkTime, (String)"yyyyMMdd");
                String workName = sit.getWorkName();
                String sdPath = scheckTime + " " + workName;
                if (!StringUtils.isNotBlank((CharSequence)workName) || !StringUtils.isNotBlank((CharSequence)scheckTime)) continue;
                String fname = "\u804c\u4e1a\u536b\u751f\u68c0\u67e5\u548c\u5904\u7406\u8bb0\u5f55\u8868\uff08" + sdPath + "\uff09.doc";
                sit.setInspectionNo(fname);
            }
        }
        if ((sceneInspectionList2 = (List)dataMap.get("sceneInspectionList2")) != null && sceneInspectionList2.size() > 0) {
            for (SceneInspection sit : sceneInspectionList2) {
                Date checkTime = sit.getInspectionActualTime();
                String scheckTime = DateUtils.format((Date)checkTime, (String)"yyyyMMdd");
                String workName = sit.getWorkName();
                String sdPath = scheckTime + " " + workName;
                if (!StringUtils.isNotBlank((CharSequence)workName) || !StringUtils.isNotBlank((CharSequence)scheckTime)) continue;
                String fname = "\u804c\u4e1a\u536b\u751f\u76d1\u7ba1\u610f\u89c1\u548c\u843d\u5b9e\u60c5\u51b5\u8bb0\u5f55\u8868\uff08" + sdPath + "\uff09.doc";
                sit.setInspectionNo(fname);
            }
        }
        return dataMap;
    }

    public Map<String, Object> getListCompanyInspection(Long cid, long inspectionId) {
        SceneInspection sit = (SceneInspection)this.sceneInspectionService.getById(Long.valueOf(inspectionId));
        if (sit != null) {
            Date checkTime = sit.getInspectionActualTime();
            String scheckTime = DateUtils.format((Date)checkTime, (String)"yyyyMMdd");
            String workName = sit.getWorkName();
            String sdPath = scheckTime + " " + workName;
            if (StringUtils.isNotBlank((CharSequence)workName) && StringUtils.isNotBlank((CharSequence)scheckTime)) {
                String fname = "\u804c\u4e1a\u536b\u751f\u68c0\u67e5\u548c\u5904\u7406\u8bb0\u5f55\u8868\uff08" + sdPath + "\uff09.doc";
                sit.setOtherFiles(fname);
                sit.setReformList(this.reformService.getReformListBySourceId(sit.getId()));
                if (sit.getReformList() == null || sit.getReformList().size() == 0) {
                    ArrayList<ReformItemBasic> reformList = new ArrayList<ReformItemBasic>();
                    ReformItemBasic rb = new ReformItemBasic();
                    rb.setId(Long.valueOf(-1L));
                    rb.setFinishInfo("");
                    reformList.add(rb);
                    sit.setReformList(reformList);
                }
                HashMap<String, Object> sitMap = new HashMap<String, Object>();
                sitMap.put("sit", sit);
                this.handleHtml(sitMap);
                return sitMap;
            }
        }
        return null;
    }

    public void handleHtml(Map<String, Object> dataMap) {
        if (dataMap != null) {
            Set<String> strs = dataMap.keySet();
            for (String key : strs) {
                Object entry = dataMap.get(key);
                if (entry == null) continue;
                if (entry instanceof List) {
                    List entryList = (List)entry;
                    String entryJson = JSONArray.toJSONString((Object)entry);
                    entryJson = StringEscapeUtils.unescapeHtml((String)entryJson);
                    try {
                        Class c = this.getClassInList(entryList);
                        if (c == null) continue;
                        List entry2 = JSONArray.parseArray((String)entryJson, (Class)c);
                        dataMap.put(key, entry2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String entryJson = JSON.toJSONString((Object)entry);
                entryJson = StringEscapeUtils.unescapeHtml((String)entryJson);
                Object entry2 = JSON.parseObject((String)entryJson, entry.getClass());
                dataMap.put(key, entry2);
            }
        }
    }

    public Class getClassInList(List list) {
        if (list != null && list.size() > 0) {
            Object o = list.get(0);
            return o.getClass();
        }
        return null;
    }

    public Map<String, Object> getDoc3Data(Long cid, String docParamValue) {
        if (cid == null && docParamValue == null) {
            throw new HealthException("\u4f20\u5165\u53c2\u6570\u9519\u8bef,\u627e\u4e0d\u5230\u5bf9\u5e94\u6570\u636e");
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        List planList = this.trainArchiveService.getOccHealthTrainPlanByYear(cid, Integer.valueOf(docParamValue));
        List trainPlanList = this.trainArchiveService.getOccHealthTrainByYearPre(cid, Integer.valueOf(docParamValue));
        List certificateStaffDetailList = this.trainArchiveService.getManagerCertByYear(cid, Integer.valueOf(docParamValue));
        List trainSummarizeList = this.trainArchiveService.getTrainSummarizeByYear(cid, Integer.valueOf(docParamValue));
        dataMap.put("year", docParamValue);
        dataMap.put("planList", planList);
        dataMap.put("trainPlanList", trainPlanList);
        dataMap.put("certificateStaffDetailList", certificateStaffDetailList);
        dataMap.put("trainSummarizeList", trainSummarizeList);
        return dataMap;
    }

    public Map<String, Object> getDoc6Data(Long cid, String docParamValue) {
        return this.personalPHCArhiveService.getDocData(cid, docParamValue);
    }

    public Map<String, Object> getDoc4Data(Long cid, String docParamValue) {
        return this.harmFactorTestArchiveService.getDocData(cid, docParamValue);
    }
}

