/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.archive.ArchiveMapper;
import cn.smarthse.modules.health.entity.archive.Archive;
import cn.smarthse.modules.health.entity.archive.ArchiveCheck;
import cn.smarthse.modules.health.entity.archive.ArchiveFiles;
import cn.smarthse.modules.health.entity.archive.ArchiveGenerator;
import cn.smarthse.modules.health.enums.archive.ArchiveType;
import cn.smarthse.modules.health.service.archive.IArchiveFilesService;
import cn.smarthse.modules.health.service.archive.IArchiveService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ArchiveServiceImpl
extends BaseServiceImpl<ArchiveMapper, Archive>
implements IArchiveService {
    @Autowired
    IArchiveFilesService archiveFilesService;

    public Archive getArchiveByCheck(ArchiveCheck archiveCheck) {
        Example example = new Example(Archive.class);
        example.createCriteria().andEqualTo("docCheckId", (Object)archiveCheck.getId()).andEqualTo("isValid", (Object)Global.TRUE);
        return (Archive)this.getOneByExample(example);
    }

    @Transactional(readOnly=false)
    public Archive updateArchive(ArchiveCheck archiveCheck, byte checkState, Integer docCheckPercent, boolean cumsumCount) {
        Archive archive = null;
        archive = archiveCheck.getArchiveId() != null ? (Archive)this.getById(archiveCheck.getArchiveId()) : this.getArchiveByCheck(archiveCheck);
        if (archive == null) {
            throw new HealthException("\u6863\u6848\u4fe1\u606f\u5f02\u5e38!");
        }
        if (cumsumCount) {
            archive.setDocVersion(Integer.valueOf(archive.getDocVersion() + 1));
        }
        archive.setDocCheckId(archiveCheck.getId());
        archive.setDocCheckState(Byte.valueOf(checkState));
        archive.setDocCheckDate(new Date());
        archive.setDocCheckPercent(docCheckPercent);
        archive.setUpdateDate(new Date());
        this.update(archive);
        return archive;
    }

    @Transactional(readOnly=false)
    public Archive updateArchiveGenerator(ArchiveGenerator archiveGen, byte generatorState) {
        Archive archive = null;
        if (archiveGen.getArchiveId() != null) {
            archive = (Archive)this.getById(archiveGen.getArchiveId());
        }
        if (archive == null) {
            throw new HealthException("\u6863\u6848\u4fe1\u606f\u5f02\u5e38!");
        }
        archive.setDocGeneratorState(Byte.valueOf(generatorState));
        archive.setDocGeneratorDate(new Date());
        archive.setUpdateDate(new Date());
        this.update(archive);
        return archive;
    }

    public Archive getArchive(Long cid, byte docType, String docParamValue) {
        Example example = new Example(Archive.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("docType", (Object)docType).andEqualTo("docParamValue", (Object)docParamValue).andEqualTo("isValid", (Object)Global.TRUE);
        return (Archive)this.getOneByExample(example);
    }

    public Archive addArchive(Long cid, byte docType, String docParamValue, Long createBy) {
        Archive archive = new Archive();
        archive.setCid(cid);
        archive.setDocParamValue(docParamValue);
        archive.setDocType(Byte.valueOf(docType));
        archive.setDocVersion(Integer.valueOf(1));
        archive.setDownloadCount(Integer.valueOf(0));
        archive.setIsValid(Global.TRUE);
        archive.setCreateBy(createBy);
        archive.setCreateDate(new Date());
        archive.setUpdateBy(createBy);
        archive.setUpdateDate(new Date());
        archive = this.add(archive);
        return archive;
    }

    public PageInfo<Archive> getArchiveByDocType(JqGridParam param, ArchiveType type) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        String keyword = null;
        if (param.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : param.getPostDatas()) {
                if (!sField.getSearchField().equals("keyword")) continue;
                keyword = sField.getSearchValue();
            }
        }
        List<Archive> list = ((ArchiveMapper)this.dao).selectListByKeyword(param.getCid(), type.getType(), keyword);
        for (Archive archive : list) {
            if (!"".equals(archive.getDocTitle()) && null != archive.getDocTitle()) {
                Object title = archive.getDocTitle();
                if (((String)title).length() > 15) {
                    title = ((String)title).substring(0, 15) + "......";
                }
                archive.setTitle((String)title);
            }
            archive.setArchiveId(archive.getId());
            List fileList = this.archiveFilesService.getListByArchiveId(archive.getId(), param.getCid(), archive.getDocParamValue(), archive.getDocType());
            if (fileList.size() <= 0) continue;
            archive.setFileId(((ArchiveFiles)fileList.get(0)).getDocFileId());
            archive.setArchiveFilesId(((ArchiveFiles)fileList.get(0)).getId());
        }
        return new PageInfo(list);
    }

    public Archive getArchiveByCid(Long cid, byte docType) {
        Example example = new Example(Archive.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("docType", (Object)docType).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("create_date desc");
        return (Archive)this.getOneByExample(example);
    }
}

