/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.ZipCompressorUtil;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.dao.archive.ArchiveGeneratorMapper;
import cn.smarthse.modules.health.entity.archive.Archive;
import cn.smarthse.modules.health.entity.archive.ArchiveFiles;
import cn.smarthse.modules.health.entity.archive.ArchiveFilesDetail;
import cn.smarthse.modules.health.entity.archive.ArchiveGenerator;
import cn.smarthse.modules.health.enums.archive.ArchiveCheckState;
import cn.smarthse.modules.health.enums.archive.ArchiveGeneratorState;
import cn.smarthse.modules.health.service.archive.IArchiveFilesDetailService;
import cn.smarthse.modules.health.service.archive.IArchiveFilesService;
import cn.smarthse.modules.health.service.archive.IArchiveGeneratorService;
import cn.smarthse.modules.health.service.archive.IArchiveService;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ArchiveGeneratorServiceImpl
extends BaseServiceImpl<ArchiveGeneratorMapper, ArchiveGenerator>
implements IArchiveGeneratorService {
    Log log = LogFactory.getLog(this.getClass());
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;
    @Autowired
    IArchiveService archiveService;
    @Autowired
    IBusinessNoService businessNoService;
    @Autowired
    IArchiveFilesService archiveFilesService;
    @Autowired
    IArchiveFilesDetailService archiveFilesDetailService;
    @Autowired
    private OssClientBean ossClientBean;
    @DubboReference
    ISysFileProvideService fileService;

    public ArchiveGenerator getArchiveGenerator() {
        Example example = new Example(ArchiveGenerator.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("generatorState", (Object)ArchiveGeneratorState.generat.getValue());
        return (ArchiveGenerator)this.getOneByExample(example);
    }

    public int getArchiveGeneratorCount(Long cid) {
        Example example = new Example(ArchiveGenerator.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("generatorState", (Object)ArchiveGeneratorState.generat.getValue());
        return this.getCountByExample(example);
    }

    public boolean existGeneratorJob(Long cid, byte docType, String docParamValue) {
        Example example = new Example(ArchiveGenerator.class);
        ArrayList<Byte> docCheckStateList = new ArrayList<Byte>();
        docCheckStateList.add(ArchiveGeneratorState.generat.getValue());
        docCheckStateList.add(ArchiveGeneratorState.generating.getValue());
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("docType", (Object)docType).andEqualTo("docParamValue", (Object)docParamValue).andEqualTo("isValid", (Object)Global.TRUE).andIn("generatorState", docCheckStateList);
        return this.getOneByExample(example) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(readOnly=false)
    public void updateGeneratorState(ArchiveGenerator archiveGen, byte generatorState, String generatorDes) {
        if (archiveGen == null) {
            return;
        }
        TransactionStatus status = null;
        if (this.transactionManager != null) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            status = this.transactionManager.getTransaction((TransactionDefinition)def);
        }
        try {
            Archive archive = this.archiveService.updateArchiveGenerator(archiveGen, generatorState);
            ArchiveGenerator save = new ArchiveGenerator();
            save.setId(archiveGen.getId());
            save.setGeneratorDate(new Date());
            save.setGeneratorState(Byte.valueOf(generatorState));
            save.setGeneratorDes(generatorDes);
            save.setUpdateDate(new Date());
            this.update(save);
            if (status == null) return;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (status != null) {
                    this.transactionManager.rollback(status);
                }
                if (status == null) return;
            }
            catch (Throwable throwable) {
                if (status == null) throw throwable;
                this.transactionManager.commit(status);
                throw throwable;
            }
            this.transactionManager.commit(status);
            return;
        }
        this.transactionManager.commit(status);
        return;
    }

    @Transactional(readOnly=false)
    public ArchiveGenerator createGeneratorJob(Long cid, byte docType, String docParamValue, Long createBy, String title, String archiveId) {
        if (!StringUtils.isBlank((CharSequence)title) && ((String)title).length() > 64) {
            title = ((String)title).substring(0, 60);
            title = ((String)title).substring(0, ((String)title).lastIndexOf("/")) + "\u7b49\u7b49";
        }
        Archive archive = null;
        archive = archiveId != null && !"".equals(archiveId) ? (Archive)this.archiveService.getById(Long.valueOf(archiveId)) : this.archiveService.getArchive(cid, docType, docParamValue);
        if (archive == null) {
            archive = this.archiveService.addArchive(cid, docType, docParamValue, createBy);
        }
        ArchiveGenerator generator = new ArchiveGenerator();
        generator.setArchiveId(archive.getId());
        generator.setCid(cid);
        generator.setDocType(Byte.valueOf(docType));
        generator.setDocParamValue(docParamValue);
        generator.setGeneratorState(Byte.valueOf(ArchiveGeneratorState.generat.getValue()));
        String docNo = "";
        switch (docType) {
            case 1: {
                docNo = this.businessNoService.getDocNo(cid, "doc1", null);
                break;
            }
            case 2: {
                docNo = this.businessNoService.getDocNo(cid, "ZW-GLDA", docParamValue);
                break;
            }
            case 3: {
                docNo = this.businessNoService.getDocNo(cid, "ZW-XCPX", docParamValue);
                break;
            }
            case 4: {
                docNo = this.businessNoService.getDocNo(cid, "ZW-JCPJ", docParamValue);
                break;
            }
            case 5: {
                docNo = this.businessNoService.getDocNo(cid, "ZW-DWJH", null);
                break;
            }
            case 6: {
                docNo = this.businessNoService.getDocNo(cid, "doc6", null);
                break;
            }
        }
        generator.setDocNo(docNo);
        generator.setCreateBy(createBy);
        generator.setCreateDate(new Date());
        generator.setUpdateBy(createBy);
        generator.setUpdateDate(new Date());
        generator.setIsValid(Global.TRUE);
        this.add(generator);
        archive.setDocGeneratorState(Byte.valueOf(ArchiveGeneratorState.generat.getValue()));
        archive.setDocGeneratorDate(new Date());
        archive.setDocTitle((String)title);
        archive.setDocNo(docNo);
        this.archiveService.update((Object)archive);
        return generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void multipleArchive(ArchiveGenerator archiveGen, IDocDataService dataService, String ossPath, String targetDir, String[] docParamValueList, Integer filesVersion) {
        File zipDir = new File(targetDir);
        File zipFile = null;
        try {
            ArchiveFiles afile = new ArchiveFiles();
            afile.setArchiveGeneratorId(archiveGen.getId());
            afile.setArchiveId(archiveGen.getArchiveId());
            afile.setCid(archiveGen.getCid());
            afile.setDocParamValue(archiveGen.getDocParamValue());
            afile.setDocType(archiveGen.getDocType());
            String[] stringArray = filesVersion;
            filesVersion = (Integer)filesVersion + 1;
            afile.setDocVersion((Integer)stringArray);
            this.archiveFilesService.addArchiveFile(afile, null);
            for (String docParamValue : docParamValueList) {
                this.logger.info("\u6863\u6848{}, docParamValue={}", (Object)archiveGen.getDocType(), (Object)docParamValue);
                Map dataMap = dataService.generatorArchive(targetDir, archiveGen.getDocNo(), archiveGen.getCid(), docParamValue);
                if (dataMap == null) {
                    this.updateGeneratorState(archiveGen, ArchiveCheckState.check_fail.getValue(), "dataService\u672a\u8fd4\u56de\u6570\u636e\u5305!");
                    return;
                }
                String ossFileFullname = dataMap.get("archive_doc__filename") != null ? dataMap.get("archive_doc__filename") : archiveGen.getDocNo();
                String subTargetDir = targetDir + "/" + ossFileFullname;
                File sub_zipDir = new File(subTargetDir);
                String zip = subTargetDir + ".zip";
                ZipCompressorUtil zipCompressorUtil = new ZipCompressorUtil(zip);
                zipCompressorUtil.compressExe(subTargetDir);
                File sub_zipFile = new File(zip);
                Object ossUrl = this.ossClientBean.isAsynch() ? this.uploadOss(sub_zipFile, ossPath, ossFileFullname + ".zip") : ossPath + File.separatorChar + ossFileFullname + ".zip";
                SysFileModel file = this.fileService.addFile(archiveGen.getCid(), ossFileFullname + ".zip", sub_zipFile, (String)ossUrl);
                if (file == null) {
                    this.updateGeneratorState(archiveGen, ArchiveCheckState.check_fail.getValue(), "\u65e0\u6cd5\u4fdd\u5b58\u5230\u9644\u4ef6\u8868!");
                    return;
                }
                String dataJson = JsonMapper.toJsonString((Object)dataMap);
                ArchiveFilesDetail detail = new ArchiveFilesDetail();
                detail.setArchiveFilesId(afile.getId());
                detail.setArchiveGeneratorId(archiveGen.getId());
                detail.setArchiveId(archiveGen.getArchiveId());
                detail.setCid(archiveGen.getCid());
                detail.setDocFileId(file.getId());
                detail.setDocParamValue(docParamValue);
                detail.setDocTitle(ossFileFullname);
                detail.setDocType(archiveGen.getDocType());
                this.archiveFilesDetailService.addArchiveFileDetail(detail, dataJson);
                try {
                    if (sub_zipDir == null) continue;
                    FileUtils.deleteDirectory((File)sub_zipDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String zip = targetDir + ".zip";
            ZipCompressorUtil zipCompressorUtil = new ZipCompressorUtil(zip);
            zipCompressorUtil.compressExe(targetDir);
            zipFile = new File(zip);
            String ossUrl = this.uploadOss(zipFile, ossPath, archiveGen.getDocNo() + ".zip");
            SysFileModel file = this.fileService.addFile(archiveGen.getCid(), archiveGen.getDocNo(), zipFile, ossUrl);
            afile.setDocFileId(file.getId());
            afile.setUpdateDate(new Date());
            this.archiveFilesService.update((Object)afile);
            this.updateGeneratorState(archiveGen, ArchiveCheckState.check_success.getValue(), "");
            return;
        }
        finally {
            try {
                if (this.ossClientBean.isAsynch() && zipDir != null) {
                    FileUtils.deleteDirectory((File)zipDir);
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void singleArchive(ArchiveGenerator archiveGen, IDocDataService dataService, String ossPath, String targetDir, Integer filesVersion) {
        File zipDir = new File(targetDir);
        File zipFile = null;
        Map dataMap = dataService.generatorArchive(targetDir, archiveGen.getDocNo(), archiveGen.getCid(), archiveGen.getDocParamValue());
        if (dataMap == null) {
            throw new HealthException("dataService\u672a\u8fd4\u56de\u6570\u636e\u5305!");
        }
        String zip = targetDir + ".zip";
        ZipCompressorUtil zipCompressorUtil = new ZipCompressorUtil(zip);
        zipCompressorUtil.compressExe(targetDir);
        zipFile = new File(zip);
        String ossFileFullname = dataMap.get("archive_doc__filename") != null ? dataMap.get("archive_doc__filename") : archiveGen.getDocNo();
        String ossUrl = this.uploadOss(zipFile, ossPath, ossFileFullname + ".zip");
        SysFileModel file = this.fileService.addFile(archiveGen.getCid(), archiveGen.getDocNo() + ".zip", zipFile, ossUrl);
        String dataJson = JsonMapper.toJsonString((Object)dataMap);
        ArchiveFiles afile = new ArchiveFiles();
        afile.setArchiveGeneratorId(archiveGen.getId());
        afile.setArchiveId(archiveGen.getArchiveId());
        afile.setCid(archiveGen.getCid());
        afile.setDocFileId(file.getId());
        afile.setDocParamValue(archiveGen.getDocParamValue());
        afile.setDocType(archiveGen.getDocType());
        afile.setDocVersion(Integer.valueOf(filesVersion + 1));
        this.archiveFilesService.addArchiveFile(afile, dataJson);
        try {
            if (zipDir != null) {
                FileUtils.deleteDirectory((File)zipDir);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String uploadOss(File zip, String ossPath, String fileName) {
        if (this.ossClientBean != null && this.ossClientBean.isAsynch()) {
            String oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + ".zip", zip, ossPath, fileName, null);
            return oss;
        }
        return ossPath + ".zip";
    }

    public ArchiveGenerator getGeneratorByArchiveId(Long archiveId) {
        Example example = new Example(ArchiveGenerator.class);
        example.createCriteria().andEqualTo("archiveId", (Object)archiveId).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("create_date desc");
        List list = this.getListByExample(example);
        if (list.size() > 0) {
            return (ArchiveGenerator)list.get(0);
        }
        return null;
    }
}

