/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.archive.ArchiveFilesDataMapper;
import cn.smarthse.modules.health.dao.archive.ArchiveFilesMapper;
import cn.smarthse.modules.health.entity.archive.ArchiveFiles;
import cn.smarthse.modules.health.entity.archive.ArchiveFilesData;
import cn.smarthse.modules.health.entity.archive.ArchiveGenerator;
import cn.smarthse.modules.health.service.archive.IArchiveFilesService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ArchiveFilesServiceImpl
extends BaseServiceImpl<ArchiveFilesMapper, ArchiveFiles>
implements IArchiveFilesService {
    @Autowired
    ArchiveFilesDataMapper archiveFilesDataMapper;

    public List<ArchiveFiles> getListByArchiveId(Long archiveId, Long cid, String paramValue, Byte type) {
        Example example = new Example(ArchiveFiles.class);
        example.createCriteria().andEqualTo("archiveId", (Object)archiveId).andEqualTo("docParamValue", (Object)paramValue).andEqualTo("cid", (Object)cid).andEqualTo("docType", (Object)type);
        example.setOrderByClause("create_date desc ");
        return ((ArchiveFilesMapper)this.dao).selectByExample(example);
    }

    public PageInfo<ArchiveFiles> getArchiveFilesList(JqGridParam param, Long archiveId) {
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ArchiveFiles> list = ((ArchiveFilesMapper)this.dao).selectListByArchiveId(param.getCid(), archiveId);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void addArchiveFile(ArchiveFiles afile, String dataJson) {
        Date today = new Date();
        afile.setIsValid(Global.TRUE);
        afile.setCreateDate(today);
        afile.setUpdateDate(today);
        this.add(afile);
        if (StringUtils.isNotEmpty((String)dataJson)) {
            ArchiveFilesData fileData = new ArchiveFilesData();
            fileData.setArchiveFilesId(afile.getId());
            fileData.setCid(afile.getCid());
            fileData.setDocJson(dataJson);
            fileData.setIsValid(Global.TRUE);
            fileData.setCreateDate(today);
            fileData.setUpdateDate(today);
            fileData.setId(Long.valueOf(this.idworker.nextId()));
            this.archiveFilesDataMapper.insertSelective(fileData);
        }
    }

    public List<ArchiveFiles> getArchiveFilesByArchiveId(Long cid, Long archiveId) {
        Example example = new Example(ArchiveFiles.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("archiveId", (Object)archiveId);
        example.setOrderByClause("create_date desc ");
        List list = ((ArchiveFilesMapper)this.dao).selectByExample(example);
        return list;
    }

    public Integer getByValue(Long cid, Long archiveId, String value) {
        ArchiveFiles file = new ArchiveFiles();
        file.setCid(cid);
        file.setArchiveId(archiveId);
        file.setDocParamValue(value);
        file.setIsValid(Global.TRUE);
        return ((ArchiveFilesMapper)this.dao).selectCount(file);
    }

    public List<ArchiveFiles> getListByFileIds(List<String> fileIds) {
        return ((ArchiveFilesMapper)this.dao).selectListById(fileIds);
    }

    public List<ArchiveFiles> getListByCid(Long cid, String type) {
        Example example = new Example(ArchiveFiles.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("docType", (Object)type);
        return this.getListByExample(example);
    }

    public List<ArchiveFiles> getListByGenId(Long archiveId, Long genId) {
        Example example = new Example(ArchiveFiles.class);
        example.createCriteria().andEqualTo("archiveId", (Object)archiveId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("archiveGeneratorId", (Object)genId);
        return this.getListByExample(example);
    }

    public int getCountArchiveFiles(ArchiveGenerator archiveGen) {
        ArchiveFiles file = new ArchiveFiles();
        file.setCid(archiveGen.getCid());
        file.setArchiveId(archiveGen.getArchiveId());
        return ((ArchiveFilesMapper)this.dao).selectCount(file);
    }
}

