/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.dao.archive.ArchiveFilesDetailViewMapper;
import cn.smarthse.modules.health.entity.archive.ArchiveGenerator;
import cn.smarthse.modules.health.entity.archive.view.ArchiveFilesDetailView;
import cn.smarthse.modules.health.service.archive.IArchiveFilesDetailViewService;
import cn.smarthse.modules.health.service.archive.IArchiveGeneratorService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class ArchiveFilesDetailViewServiceImpl
extends BaseServiceImpl<ArchiveFilesDetailViewMapper, ArchiveFilesDetailView>
implements IArchiveFilesDetailViewService {
    @Autowired
    ArchiveFilesDetailViewMapper archiveFilesDetailViewMapper;
    @Autowired
    IArchiveGeneratorService archiveGeneratorService;

    public Integer getByCidConat(Long cid, Long archiveId) {
        ArchiveFilesDetailView view = new ArchiveFilesDetailView();
        view.setCid(cid);
        view.setArchiveId(archiveId);
        return this.archiveFilesDetailViewMapper.selectCount(view);
    }

    public PageInfo<ArchiveFilesDetailView> getFilesList(JqGridParam param, Long archiveId) {
        ArchiveGenerator gener;
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        String keyword = null;
        if (param.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : param.getPostDatas()) {
                if (!sField.getSearchField().equals("keyword")) continue;
                keyword = sField.getSearchValue();
            }
        }
        if ((gener = this.archiveGeneratorService.getGeneratorByArchiveId(archiveId)) == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ArchiveFilesDetailView> list = this.archiveFilesDetailViewMapper.selectByCid(param.getCid(), archiveId, keyword, gener.getId().toString());
        return new PageInfo(list);
    }

    public PageInfo<ArchiveFilesDetailView> getFileList(JqGridParam param, Long archiveId, String value) {
        ArchiveGenerator gener;
        if (param == null) {
            return new PageInfo();
        }
        if (param.getCid() == null || param.getCid() == 0L) {
            return new PageInfo();
        }
        String keyword = null;
        if (param.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : param.getPostDatas()) {
                if (!sField.getSearchField().equals("keyword")) continue;
                keyword = sField.getSearchValue();
            }
        }
        if ((gener = this.archiveGeneratorService.getGeneratorByArchiveId(archiveId)) == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<ArchiveFilesDetailView> list = this.archiveFilesDetailViewMapper.selectByValue(param.getCid(), archiveId, keyword, value, gener.getId().toString());
        return new PageInfo(list);
    }
}

