/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.archive.ArchiveFilesDetailDataMapper;
import cn.smarthse.modules.health.dao.archive.ArchiveFilesDetailMapper;
import cn.smarthse.modules.health.entity.archive.ArchiveFilesDetail;
import cn.smarthse.modules.health.entity.archive.ArchiveFilesDetailData;
import cn.smarthse.modules.health.service.archive.IArchiveFilesDetailService;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ArchiveFilesDetailServiceImpl
extends BaseServiceImpl<ArchiveFilesDetailMapper, ArchiveFilesDetail>
implements IArchiveFilesDetailService {
    @Autowired
    ArchiveFilesDetailDataMapper archiveFilesDetailDataMapper;

    @Transactional(readOnly=false)
    public void addArchiveFileDetail(ArchiveFilesDetail detail, String dataJson) {
        Date today = new Date();
        detail.setCreateDate(today);
        detail.setUpdateDate(today);
        detail.setIsValid(Global.TRUE);
        this.add(detail);
        if (StringUtils.isNotEmpty((String)dataJson)) {
            ArchiveFilesDetailData archiveFilesDetailData = new ArchiveFilesDetailData();
            archiveFilesDetailData.setArchiveFilesDetailId(detail.getId());
            archiveFilesDetailData.setCid(detail.getCid());
            archiveFilesDetailData.setDocJson(dataJson);
            archiveFilesDetailData.setIsValid(Global.TRUE);
            archiveFilesDetailData.setCreateDate(today);
            archiveFilesDetailData.setUpdateDate(today);
            archiveFilesDetailData.setId(Long.valueOf(this.idworker.nextId()));
            this.archiveFilesDetailDataMapper.insertSelective(archiveFilesDetailData);
        }
    }

    public List<ArchiveFilesDetail> getListByIds(List<String> idList) {
        return ((ArchiveFilesDetailMapper)this.dao).selectListById(idList);
    }

    public List<ArchiveFilesDetail> getListByArchiveId(Long archiveId, Long genId) {
        Example example = new Example(ArchiveFilesDetail.class);
        example.createCriteria().andEqualTo("archiveId", (Object)archiveId).andEqualTo("archiveGeneratorId", (Object)genId).andEqualTo("isValid", (Object)Global.TRUE);
        return ((ArchiveFilesDetailMapper)this.dao).selectByExample(example);
    }
}

