/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.archive.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.common.IDocDataService;
import cn.smarthse.modules.health.dao.archive.ArchiveCheckMapper;
import cn.smarthse.modules.health.entity.archive.Archive;
import cn.smarthse.modules.health.entity.archive.ArchiveCheck;
import cn.smarthse.modules.health.entity.archive.ArchiveCheckDetail;
import cn.smarthse.modules.health.entity.archive.ArchiveCheckItem;
import cn.smarthse.modules.health.enums.archive.ArchiveCheckState;
import cn.smarthse.modules.health.enums.archive.ArchiveType;
import cn.smarthse.modules.health.service.archive.IArchiveCheckDetailService;
import cn.smarthse.modules.health.service.archive.IArchiveCheckItemService;
import cn.smarthse.modules.health.service.archive.IArchiveCheckService;
import cn.smarthse.modules.health.service.archive.IArchiveService;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ArchiveCheckServiceImpl
extends BaseServiceImpl<ArchiveCheckMapper, ArchiveCheck>
implements IArchiveCheckService {
    @Autowired(required=false)
    DataSourceTransactionManager transactionManager;
    @Autowired
    IArchiveService archiveService;
    @Autowired
    IArchiveCheckItemService archiveCheckItemService;
    @Autowired
    IArchiveCheckDetailService archiveCheckDetailService;

    public ArchiveCheck getArchiveCheck() {
        Example example = new Example(ArchiveCheck.class);
        example.createCriteria().andEqualTo("docCheckState", (Object)ArchiveCheckState.check.getValue()).andEqualTo("isValid", (Object)Global.TRUE);
        return (ArchiveCheck)this.getOneByExample(example);
    }

    public int getArchiveCheckCount(Long cid) {
        Example example = new Example(ArchiveCheck.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("docCheckState", (Object)ArchiveCheckState.check.getValue()).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getCountByExample(example);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(readOnly=false)
    public void updateCheckState(ArchiveCheck archiveCheck, byte checkState, String checkResult, Integer docCheckPercent, boolean cumsumCount) {
        TransactionStatus status = null;
        if (this.transactionManager != null) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            status = this.transactionManager.getTransaction((TransactionDefinition)def);
        }
        try {
            Archive archive = this.archiveService.updateArchive(archiveCheck, checkState, docCheckPercent, cumsumCount);
            ArchiveCheck save = new ArchiveCheck();
            save.setId(archiveCheck.getId());
            save.setDocCheckState(Byte.valueOf(checkState));
            save.setDocCheckPercent(docCheckPercent);
            save.setDocCheckDate(new Date());
            save.setDocCheckDes(checkResult);
            save.setUpdateDate(new Date());
            this.update(save);
            if (status == null) return;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (status != null) {
                    this.transactionManager.rollback(status);
                }
                if (status == null) return;
            }
            catch (Throwable throwable) {
                if (status == null) throw throwable;
                this.transactionManager.commit(status);
                throw throwable;
            }
            this.transactionManager.commit(status);
            return;
        }
        this.transactionManager.commit(status);
        return;
    }

    private int checkData(IDocDataService dataService, ArchiveCheck archiveCheck, ArchiveType archiveType, String docParamValue) {
        int docCheckPercent = 0;
        docCheckPercent = archiveType == ArchiveType.Archive6 ? this.check6DataItem(dataService, archiveCheck, archiveType, docParamValue) : this.checkDataItem(dataService, archiveCheck, archiveType, docParamValue);
        return docCheckPercent;
    }

    private int check6DataItem(IDocDataService dataService, ArchiveCheck archiveCheck, ArchiveType archiveType, String docParamValue) {
        String[] docParamValueIds;
        int docCheckPercent = 0;
        int docCheckCount = 0;
        for (String docParamValueId : docParamValueIds = docParamValue.split(",")) {
            if (!StringUtils.isNotEmpty((String)docParamValueId)) continue;
            ++docCheckCount;
            docCheckPercent += this.checkDataItem(dataService, archiveCheck, archiveType, docParamValueId);
        }
        if (docCheckCount == 0) {
            docCheckCount = 1;
        }
        docCheckPercent = (docCheckPercent = Math.round((float)docCheckPercent / 100.0f / (float)docCheckCount * 100.0f)) > 100 ? 100 : docCheckPercent;
        return docCheckPercent;
    }

    private int checkDataItem(IDocDataService dataService, ArchiveCheck archiveCheck, ArchiveType archiveType, String docParamValueId) {
        int docCheckPercent = 0;
        int qualifiedCount = 0;
        int yesQualifiedCount = 0;
        List checkItemList = this.archiveCheckItemService.getItemListByType(archiveType.getType());
        Map dataMap = dataService.getCheckData(archiveCheck.getCid(), docParamValueId);
        for (ArchiveCheckItem checkItem : checkItemList) {
            ArchiveCheckDetail itemDetail = new ArchiveCheckDetail();
            itemDetail.setDocCheckId(archiveCheck.getId());
            itemDetail.setDocType(Byte.valueOf(archiveType.getType()));
            itemDetail.setDocCheckItemId(checkItem.getId());
            int checkQualifiedCount = checkItem.getDocCheckQualifiedCount();
            itemDetail.setDocCheckQualifiedCount(Integer.valueOf(checkQualifiedCount));
            int checkResultCount = NumberUtil.getValueByMap((Map)dataMap, (String)checkItem.getDocCheckDataKey(), (int)0);
            itemDetail.setDocCheckResultCount(Integer.valueOf(checkResultCount));
            boolean resultQualified = checkResultCount >= checkQualifiedCount;
            itemDetail.setDocCheckResultQualified(Boolean.valueOf(resultQualified));
            itemDetail.setDocParamValue(docParamValueId);
            itemDetail.setCid(archiveCheck.getCid());
            itemDetail.setCreateDate(new Date());
            itemDetail.setIsValid(Global.TRUE);
            itemDetail.setUpdateDate(new Date());
            this.archiveCheckDetailService.add((Object)itemDetail);
            qualifiedCount += checkQualifiedCount;
            if ("34-106".equals(checkItem.getDocCheckDataKey())) {
                ++yesQualifiedCount;
                continue;
            }
            yesQualifiedCount += resultQualified ? 1 : 0;
        }
        if (qualifiedCount == 0) {
            qualifiedCount = 1;
        }
        docCheckPercent = (docCheckPercent = Math.round((float)yesQualifiedCount / (float)qualifiedCount * 100.0f)) > 100 ? 100 : docCheckPercent;
        return docCheckPercent;
    }

    @Transactional(readOnly=false)
    public synchronized void checkArchive() {
        ArchiveCheck archiveCheck = this.getArchiveCheck();
        if (archiveCheck == null) {
            return;
        }
        if (archiveCheck.getDocCheckState().byteValue() != ArchiveCheckState.check.getValue()) {
            return;
        }
        int docCheckPercent = 0;
        ArchiveType archiveType = ArchiveType.getArchiveType((byte)archiveCheck.getDocType());
        if (archiveType == null) {
            this.updateCheckState(archiveCheck, ArchiveCheckState.check_fail.getValue(), "\u627e\u4e0d\u5230\u81ea\u68c0\u7c7b\u578b!", docCheckPercent, Global.FALSE);
            return;
        }
        if (StringUtil.isEmpty((String)archiveType.getServiceBean())) {
            this.updateCheckState(archiveCheck, ArchiveCheckState.check_fail.getValue(), "\u627e\u4e0d\u5230\u81ea\u68c0Service!", docCheckPercent, Global.FALSE);
            return;
        }
        IDocDataService dataService = (IDocDataService)SpringContextHolder.getBean((String)archiveType.getServiceBean());
        if (dataService == null) {
            this.updateCheckState(archiveCheck, ArchiveCheckState.check_fail.getValue(), "\u627e\u4e0d\u5230\u81ea\u68c0Service\u5b9a\u4e49!", docCheckPercent, Global.FALSE);
            return;
        }
        String docParamValue = archiveCheck.getDocParamValue();
        if (StringUtil.isEmpty((String)archiveCheck.getDocParamValue())) {
            this.updateCheckState(archiveCheck, ArchiveCheckState.check_fail.getValue(), "\u81ea\u68c0\u53c2\u6570\u9519\u8bef!", docCheckPercent, Global.FALSE);
            return;
        }
        try {
            docCheckPercent = this.checkData(dataService, archiveCheck, archiveType, docParamValue);
            this.updateCheckState(archiveCheck, ArchiveCheckState.check_success.getValue(), null, docCheckPercent, Global.TRUE);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.updateCheckState(archiveCheck, ArchiveCheckState.check_fail.getValue(), "\u81ea\u68c0\u5f02\u5e38!", docCheckPercent, Global.FALSE);
            return;
        }
    }

    public boolean existCheckJob(Long cid, byte docType, String docParamValue) {
        Example example = new Example(ArchiveCheck.class);
        ArrayList<Byte> docCheckStateList = new ArrayList<Byte>();
        docCheckStateList.add(ArchiveCheckState.check.getValue());
        docCheckStateList.add(ArchiveCheckState.checking.getValue());
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("docType", (Object)docType).andEqualTo("docParamValue", (Object)docParamValue).andEqualTo("isValid", (Object)Global.TRUE).andIn("docCheckState", docCheckStateList);
        return this.getOneByExample(example) != null;
    }

    @Transactional(readOnly=false)
    public ArchiveCheck createCheckJob(Long cid, byte docType, String docParamValue, Long createBy, String title, String archiveId) {
        if (!StringUtils.isBlank((CharSequence)title) && ((String)title).length() > 64) {
            title = ((String)title).substring(0, 60);
            title = ((String)title).substring(0, ((String)title).lastIndexOf("/")) + "\u7b49\u7b49";
        }
        Archive archive = null;
        archive = archiveId != null && !"".equals(archiveId) && !"undefined".equals(archiveId) ? (Archive)this.archiveService.getById(Long.valueOf(archiveId)) : this.archiveService.getArchive(cid, docType, docParamValue);
        if (archive == null) {
            archive = this.archiveService.addArchive(cid, docType, docParamValue, createBy);
        }
        ArchiveCheck check = new ArchiveCheck();
        check.setArchiveId(archive.getId());
        check.setCid(cid);
        check.setDocType(Byte.valueOf(docType));
        check.setDocParamValue(docParamValue);
        check.setDocCheckState(Byte.valueOf(ArchiveCheckState.check.getValue()));
        check.setDocCheckDate(new Date());
        check.setCreateBy(createBy);
        check.setCreateDate(new Date());
        check.setUpdateBy(createBy);
        check.setUpdateDate(new Date());
        check.setIsValid(Global.TRUE);
        this.add(check);
        archive.setDocCheckId(check.getId());
        archive.setDocCheckDate(new Date());
        archive.setDocCheckState(Byte.valueOf(ArchiveCheckState.check.getValue()));
        archive.setDocTitle((String)title);
        this.archiveService.update((Object)archive);
        return check;
    }

    public ArchiveCheck getCheckByArchiveId(Long archiveId, String value) {
        Example example = new Example(ArchiveCheck.class);
        example.createCriteria().andEqualTo("archiveId", (Object)archiveId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("docParamValue", (Object)value);
        example.setOrderByClause("create_date desc");
        return (ArchiveCheck)this.getOneByExample(example);
    }

    public Integer getDocCheckContent(Long cid, byte docType) {
        return ((ArchiveCheckMapper)this.dao).selectConcatCheckNumByType(cid, docType);
    }

    public int getDocCheckFinishedCount(Long cid, ArchiveType docType) {
        if (cid == null || docType == null) {
            return 0;
        }
        ArrayList<Byte> checkStatusList = new ArrayList<Byte>();
        checkStatusList.add(ArchiveCheckState.check_success.getValue());
        checkStatusList.add(ArchiveCheckState.check_fail.getValue());
        Example example = new Example(ArchiveCheck.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true).andEqualTo("docType", (Object)docType.getType()).andIn("docCheckState", checkStatusList);
        return ((ArchiveCheckMapper)this.dao).selectCountByExample(example);
    }
}

