/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.app.serviceimp;

import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.dao.app.StaffMapper;
import cn.smarthse.modules.health.service.app.model.StaffIdModel;
import cn.smarthse.modules.health.service.app.service.IStaffService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class StaffServiceImp
implements IStaffService {
    @Autowired
    private StaffMapper staffMapper;

    public List<StaffIdModel> getStaffByIdCard(String idCard) {
        idCard = SpringEncryptUtils.encrypt((String)idCard);
        List<StaffIdModel> list = this.staffMapper.getStaffByIdCard(idCard);
        HashMap<Long, List> map = new HashMap<Long, List>();
        for (StaffIdModel staffIdModel : list) {
            List staffIdModels = map.computeIfAbsent(staffIdModel.getStaffId(), k -> new ArrayList());
            staffIdModels.add(staffIdModel);
        }
        ArrayList<StaffIdModel> rList = new ArrayList<StaffIdModel>();
        for (Map.Entry entry : map.entrySet()) {
            rList.add(this.getValidStaffIdModel((List)entry.getValue()));
        }
        return rList;
    }

    private StaffIdModel getValidStaffIdModel(List<StaffIdModel> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        StaffIdModel model = null;
        for (StaffIdModel staffIdModel : list) {
            if (!staffIdModel.getStatus().equals(2)) {
                return staffIdModel;
            }
            if (!staffIdModel.getStatus().equals(2) || model != null && (model.getLeaveTime() == null || staffIdModel.getLeaveTime() == null || model.getLeaveTime().compareTo(staffIdModel.getLeaveTime()) >= 0)) continue;
            model = staffIdModel;
        }
        return model;
    }
}

