/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.service.api;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.util.FileUtil;
import cn.smarthse.modules.datacentre.model.CompanyListModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.service.api.FieldCheckUtils;
import cn.smarthse.modules.health.service.api.ICheckPlanImportApiService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.vo.outdata.checkplan.CheckPlanImportParam;
import cn.smarthse.modules.health.vo.outdata.checkplan.CheckResultImportParam;
import cn.smarthse.modules.health.vo.outdata.checkplan.FileParam;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultImportService;
import cn.smarthse.util.common.JsonUtils;
import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.util.common.excel.model.ExcelModel;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class CheckPlanImportApiServiceImp
implements ICheckPlanImportApiService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private IThirdOrganizationService organizationService;
    @Autowired(required=false)
    protected OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private ICheckResultImportService checkResultImportService;
    private static Map<String, Integer> header = new HashMap<String, Integer>();

    public ResponseData<String> importCheckPlan(CheckPlanImportParam param) throws IOException {
        this.logger.info("\u68c0\u6d4b\u9879\u76ee\u5916\u90e8\u5bfc\u5165\u53c2\u6570:{}", (Object)JsonUtils.toJsonStringNoPretty((Object)param));
        ResponseData data = new ResponseData();
        try {
            FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"checkWorkNo", "checkWorkName", "comCode", "checkDateBeginStr", "checkDateEndStr", "thirdOrgName", "checkReportName", "giveReportDateStr"});
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            data.setContent(e.getMessage());
        }
        CheckPlan checkPlan = new CheckPlan();
        BeanUtils.copyProperties((Object)param, (Object)checkPlan);
        CheckPlan old = this.checkPlanService.getByWorkNo(param.getCheckWorkNo());
        checkPlan.setCreateBy(Long.valueOf(0L));
        checkPlan.setUpdateBy(Long.valueOf(0L));
        checkPlan.setUpdateDate(LocalDateTime.now());
        if (old != null) {
            checkPlan.setId(old.getId());
            checkPlan.setCreateDate(old.getCreateDate());
        } else {
            checkPlan.setCreateDate(LocalDateTime.now());
        }
        List coms = this.companyProvideBySuperviseService.getByUnifiedSocialCc(Arrays.asList(param.getComCode()));
        if (coms != null && !coms.isEmpty()) {
            if (((CompanyListModel)coms.get(0)).getSocialCcState() != null && ((CompanyListModel)coms.get(0)).getSocialCcState().equals(2)) {
                data.setState(ResponseStateEnum.fail);
                data.setContent("\u4fe1\u7528\u4ee3\u7801\u9519\u8bef");
                return data;
            }
            checkPlan.setCid(((CompanyListModel)coms.get(0)).getId());
        }
        checkPlan.setCheckDateBegin(DateUtils.parseDateTime((String)(param.getCheckDateBeginStr() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        checkPlan.setCheckDateEnd(DateUtils.parseDateTime((String)(param.getCheckDateEndStr() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        checkPlan.setTargetStandardId(Long.valueOf(2L));
        checkPlan.setCheckServiceType(Integer.valueOf(0));
        checkPlan.setCheckFrom(Integer.valueOf(2));
        ThirdOrganization org = this.organizationService.getByName(param.getThirdOrgName());
        if (org == null) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u68c0\u6d4b\u673a\u6784\u4e0d\u5b58\u5728");
            return data;
        }
        checkPlan.setThirdOrgId(org.getId());
        String reportId = this.getSysFile(param.getCheckReportFiles());
        checkPlan.setCheckReportFileIds(reportId);
        checkPlan.setContractFileIds(this.getSysFile(param.getContractFiles()));
        checkPlan.setCheckPointMapFileIds(this.getSysFile(param.getCheckPointMapFiles()));
        checkPlan.setCheckResultCertificateFileIds(this.getSysFile(param.getCheckResultCertificateFiles()));
        checkPlan.setCheckType(Long.valueOf(2L));
        checkPlan.setEditStatus(Integer.valueOf(2));
        checkPlan.setCheckPlanType(Integer.valueOf(1));
        checkPlan.setProjectName(checkPlan.getCheckWorkName());
        AreaModel area = this.sysAreaProvideService.getAreaByName(param.getProjectAreaName());
        if (area != null) {
            checkPlan.setProjectAreaId(area.getId());
        }
        checkPlan.setGiveReportDate(DateUtils.parseDateTime((String)(param.getGiveReportDateStr() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        checkPlan.setReportStatus(Integer.valueOf(2));
        checkPlan.setReportDate(LocalDateTime.now());
        this.checkPlanService.saveOrUpdate((Object)checkPlan);
        return data;
    }

    public ResponseData<String> importResult(String checkWorkNo, List<CheckResultImportParam> param) {
        ResponseData data = new ResponseData();
        CheckPlan plan = this.checkPlanService.getByWorkNo(checkWorkNo);
        if (plan == null) {
            data.setContent("\u68c0\u6d4b\u9879\u76ee\u4e0d\u5b58\u5728");
            data.setState(ResponseStateEnum.fail);
            return data;
        }
        ExcelModel excelModel = new ExcelModel();
        LinkedList<SheetModel> sheetModels = new LinkedList<SheetModel>();
        excelModel.setSheets(sheetModels);
        for (CheckResultImportParam resultImportParam : param) {
            SheetModel sheetModel = new SheetModel();
            sheetModels.add(sheetModel);
            sheetModel.setSheetName(resultImportParam.getItemName());
            LinkedList<RowModel> rowModels = new LinkedList<RowModel>();
            sheetModel.setRows(rowModels);
            for (int i = 0; i < header.get(resultImportParam.getItemName()) - 1; ++i) {
                rowModels.add(new RowModel());
            }
        }
        ImportCheckParamBo bo = new ImportCheckParamBo();
        bo.setCheckId(plan.getId());
        bo.setCid(plan.getCid());
        bo.setCreateUserId(Long.valueOf(0L));
        bo.setStandardId(plan.getTargetStandardId());
        try {
            this.checkResultImportService.importResult(excelModel, bo);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u68c0\u67e5\u7ed3\u679c\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            data.setState(ResponseStateEnum.fail);
            data.setContent(e.getMessage());
            data.setResult((Object)e.getMessage());
        }
        return data;
    }

    private String getSysFile(List<FileParam> fileParamList) throws IOException {
        if (fileParamList == null || fileParamList.isEmpty()) {
            return "";
        }
        StringBuilder ids = new StringBuilder();
        for (FileParam fileParam : fileParamList) {
            File file = FileUtil.getNetUrl((String)fileParam.getUrl());
            ids.append(this.uploadFile(file, "api/checkPlan", fileParam.getFileName()).getId()).append(",");
        }
        return ids.substring(0, ids.length() - 1);
    }

    private SysFileModel uploadFile(File obj, String ossPath, String fileName) throws IOException {
        SysFileModel file = new SysFileModel();
        String[] arr = fileName.split("\\=");
        String oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + "." + arr[arr.length - 1], obj, ossPath, fileName, null);
        file.setFileName(fileName);
        file.setResource(Integer.valueOf(FileResourceEnum.companyHealth_07.getValue()));
        file.setFileSize(FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)obj)));
        if (fileName.contains(".")) {
            file.setFileExt(fileName.substring(fileName.lastIndexOf(".") + 1));
        }
        file.setFileHash("" + FileUtils.checksumCRC32((File)obj));
        file.setOssUrl(oss);
        file.setDescription("");
        file = this.sysFileProvideService.addSysFile(file, Long.valueOf(0L));
        return file;
    }

    static {
        header.put("\u5316\u5b66\u56e0\u7d20", 3);
        header.put("\u7c89\u5c18", 3);
        header.put("\u566a\u58f0", 2);
        header.put("\u9ad8\u6e29", 2);
        header.put("\u5de5\u9891\u7535\u573a", 2);
        header.put("\u7167\u5ea6", 2);
        header.put("\u63a7\u5236\u98ce\u901f", 2);
        header.put("\u65b0\u98ce\u91cf", 2);
        header.put("\u5fae\u5c0f\u6c14\u5019", 2);
        header.put("\u7d2b\u5916\u8f90\u5c04", 3);
        header.put("\u624b\u4f20\u632f\u52a8", 2);
        header.put("\u8d85\u9ad8\u9891\u8f90\u5c04", 2);
        header.put("\u9ad8\u9891\u7535\u78c1\u573a", 2);
        header.put("\u6fc0\u5149\u8f90\u5c04", 2);
        header.put("\u5fae\u6ce2\u8f90\u5c04", 2);
        header.put("\u751f\u7269\u56e0\u7d20", 3);
        header.put("\u7535\u79bb\u8f90\u5c04-\u5c04\u7ebf\u88c5\u7f6e", 2);
        header.put("\u7535\u79bb\u8f90\u5c04-\u542b\u6e90\u88c5\u7f6e", 2);
    }
}

