/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.dao.sys;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dao.sys.SysMaterialMapper;
import cn.smarthse.modules.health.entity.sys.SysMaterial;
import cn.smarthse.modules.health.service.sys.ISysMaterialService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SysMaterialServiceImpl
extends BaseServiceImpl<SysMaterialMapper, SysMaterial>
implements ISysMaterialService {
    @Autowired
    SysMaterialMapper sysMaterialMapper;

    public List<SysMaterial> getByKeyword(String keyword) {
        return this.sysMaterialMapper.selectByKeyword(keyword);
    }

    public PageInfo<SysMaterial> getMatterItemList(JqGridParam param) {
        if (param == null) {
            return new PageInfo();
        }
        Example example = new Example(SysMaterial.class);
        Example.Criteria c = example.createCriteria();
        if (param.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : param.getPostDatas()) {
                if (sField.getSearchOper().equals(JqGridParam.operType.eq.toString())) {
                    c.andEqualTo(sField.getSearchField(), (Object)sField.getSearchValue());
                    continue;
                }
                if (!sField.getSearchOper().equals(JqGridParam.operType.like.toString())) continue;
                c.andLike(sField.getSearchField(), "%" + sField.getSearchValue() + "%");
            }
        }
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            if (param.getSidx().equals("nameCh")) {
                example.setOrderByClause("name_ch " + param.getSord());
            } else if (param.getSidx().equals("nicknameCh")) {
                example.setOrderByClause("nickname_ch " + param.getSord());
            } else if (param.getSidx().equals("casNo")) {
                example.setOrderByClause("cas_no " + param.getSord());
            } else if (param.getSidx().equals("isHazardous")) {
                example.setOrderByClause("is_hazardous " + param.getSord());
            } else if (param.getSidx().equals("isEtoxic")) {
                example.setOrderByClause("is_etoxic " + param.getSord());
            } else {
                example.setOrderByClause(param.getSidx() + " " + param.getSord());
            }
        } else {
            example.setOrderByClause("length(name_CH)");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(this.getListByExample(example));
    }

    public List<SysMaterial> getByCid(Long cid) {
        SysMaterial mat = new SysMaterial();
        mat.setCid(cid);
        mat.setIsValid(Boolean.valueOf(true));
        return this.sysMaterialMapper.select(mat);
    }
}

