/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.component.litearchive;

import cn.smarthse.common.framework.log.DebugUtils;
import cn.smarthse.common.util.date.DateUtil;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LiteArchiveFileDataDir {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteArchiveFileDataDir.class);
    @Value(value="${archivefiles.datadir:/tmp/archivefile}")
    private String archivePath;
    @Value(value="${archivefiles.periodMinu:3}")
    private int periodMinu;

    public String getArchivePath() {
        return this.archivePath;
    }

    @PostConstruct
    public void delfile() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            String targetPath = this.getArchivePath();
            LiteArchiveFileDataDir.delFile(targetPath, this.periodMinu);
            DebugUtils.error((String)"\u5b9a\u671f\u5220\u9664\u6863\u6848\u76ee\u5f55\uff1a{}", (Object[])new Object[]{targetPath});
        }, 0L, this.periodMinu, TimeUnit.MINUTES);
    }

    public static boolean expireMinu(File file, int minu) {
        long l = file.lastModified();
        LocalDateTime last = DateUtil.getFromDate((Date)new Date(l));
        long lastMinute = DateUtil.caculateMinutes((LocalDateTime)last, (LocalDateTime)LocalDateTime.now());
        return lastMinute > (long)minu;
    }

    public static void delFile(String targetPath, int periodMinu) {
        File index = new File(targetPath);
        if (index.isDirectory()) {
            Object[] files = index.listFiles();
            if (ArrayUtils.isEmpty((Object[])files)) {
                index.delete();
            }
            for (Object file : files) {
                if (((File)file).isDirectory()) {
                    LiteArchiveFileDataDir.delFile(((File)file).getAbsolutePath(), periodMinu);
                }
                if (!LiteArchiveFileDataDir.expireMinu((File)file, periodMinu)) continue;
                ((File)file).delete();
            }
        } else if (LiteArchiveFileDataDir.expireMinu(index, periodMinu)) {
            index.delete();
        }
    }
}

