/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.component;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OssUploadComponent {
    @DubboReference
    private ISysFileProvideService fileService;
    @Autowired(required=false)
    protected OssClientBean ossClientBean;

    public SysFileModel upload(File f, Long cid) {
        if (this.ossClientBean == null) {
            return null;
        }
        SysFileModel file = new SysFileModel();
        String fileName = f.getName();
        String extName = fileName.substring(fileName.lastIndexOf(".") + 1);
        String ossPath = cid + "/liteArchive";
        String ossdir = this.ossClientBean.getOssdir();
        if (StringUtils.isNotBlank((CharSequence)ossdir)) {
            ossPath = ossdir + "/" + ossPath;
        }
        String oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + "." + extName, f, ossPath, fileName, null);
        file.setFileName(fileName);
        file.setResource(Integer.valueOf(FileResourceEnum.companyHealth_07.getValue()));
        file.setFileSize(FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)f)));
        file.setFileExt(extName);
        try {
            file.setFileHash("" + FileUtils.checksumCRC32((File)f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file.setOssUrl(oss);
        file.setDescription("");
        file.setCid(cid);
        file = this.fileService.addSysFile(file, Long.valueOf(0L));
        return file;
    }

    public void downLoadFile(List<SysFileModel> sysFileList, String destFilePath) {
        try {
            if (CollectionUtils.isEmpty(sysFileList)) {
                return;
            }
            File fileParent = new File(destFilePath);
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            for (SysFileModel sf : sysFileList) {
                if (sf == null || !StringUtils.isNotEmpty((String)sf.getOssUrl())) continue;
                this.ossClientBean.downloadFile(sf.getOssUrl(), destFilePath, sf.getFileName());
            }
        }
        catch (IOException e) {
            throw new HealthException("IO\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

