/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.component;

import cn.smarthse.common.util.HexUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class AlarmDtuServer
implements ApplicationListener<ContextRefreshedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmDtuServer.class);
    public volatile boolean run = true;
    @Value(value="${dtuServerPort}")
    private Integer dtuServerPort;
    @Value(value="${startDtuServer}")
    private Boolean startDtuServer;
    private final Map<String, Socket> dtuIdToSocketMap = new ConcurrentHashMap<String, Socket>();

    private void startSocket() {
        log.info("AlarmDtuServer init...");
        if (Boolean.TRUE.equals(this.startDtuServer)) {
            try {
                log.info("\u542f\u52a8AlarmDtuServer");
                this.start();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("AlarmDtuServer\u542f\u52a8\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void start() throws IOException {
        ExecutorService newCachedThreadPool = Executors.newCachedThreadPool();
        try (ServerSocket server = new ServerSocket(this.dtuServerPort);){
            log.info("AlarmDtuServer TCP\u670d\u52a1\u5668\u542f\u52a8\uff0c\u7aef\u53e3:{}", (Object)this.dtuServerPort);
            while (this.run) {
                Socket socket = server.accept();
                log.info("\u65b0\u7684dtu\u5ba2\u6237\u7aef\uff01{}:{}", (Object)socket.getInetAddress(), (Object)socket.getPort());
                newCachedThreadPool.execute(() -> this.handler(socket));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handler(Socket socket) {
        String dtuId = "";
        try {
            int read;
            byte[] bytes = new byte[1024];
            InputStream inputStream = socket.getInputStream();
            while ((read = inputStream.read(bytes)) != -1) {
                String[] arr;
                String msg = new String(bytes, 0, read);
                log.info("\u6536\u5230\u6d88\u606f:{}", (Object)msg);
                if (msg.startsWith("id:") && (arr = msg.split(":")).length > 1) {
                    dtuId = arr[1];
                    this.dtuIdToSocketMap.put(dtuId, socket);
                    log.info("\u5f53\u524d\u8fde\u63a5\u7684dtu\u62a5\u8b66\u8bbe\u5907\u6570:{}", (Object)this.dtuIdToSocketMap.size());
                }
                socket.getOutputStream().write(bytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                log.info("socket\u5173\u95ed");
                socket.close();
                this.dtuIdToSocketMap.remove(dtuId);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String sendBytes(String dtuDeviceId, byte[] bytes) {
        Socket socket = this.dtuIdToSocketMap.get(dtuDeviceId);
        if (socket == null) {
            log.warn("\u8bbe\u5907\u672a\u4e0a\u7ebf:\u8bbe\u5907id:{}", (Object)dtuDeviceId);
            return "\u8bbe\u5907\u672a\u4e0a\u7ebf";
        }
        try {
            socket.getOutputStream().write(bytes);
            socket.getOutputStream().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u7ed9dtu\u53d1\u9001\u6570\u636e\u5931\u8d25", (Throwable)e);
            return "\u53d1\u9001\u5931\u8d25(io\u5f02\u5e38)";
        }
        return "\u53d1\u9001\u6210\u529f";
    }

    public String playSound(String deviceId, int index, boolean light) {
        log.info("\u64ad\u653e\u62a5\u8b66\u58f0\u97f3:{},{}", (Object)deviceId, (Object)index);
        if (light) {
            return this.sendBytes(deviceId, HexUtils.hexToByteArray((String)("7EFF063A000" + index + "00EF")));
        }
        return this.sendBytes(deviceId, HexUtils.hexToByteArray((String)("7EFF063A000" + index + "01EF")));
    }

    public String openLight(String deviceId) {
        return this.sendBytes(deviceId, HexUtils.hexToByteArray((String)"7EFF063A000000EF"));
    }

    public String closeLight(String deviceId) {
        return this.sendBytes(deviceId, HexUtils.hexToByteArray((String)"7EFF063A000001EF"));
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            new Thread(this::startSocket).start();
        }
    }
}

